/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetStubbedPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.relocated.javax.inject.Inject;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.LazyDeclarationResolver;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.kotlin.resolve.scopes.JetScope;

public class DeclarationScopeProviderImpl
implements DeclarationScopeProvider {
    private final LazyDeclarationResolver lazyDeclarationResolver;
    private FileScopeProvider fileScopeProvider;

    @Inject
    public void setFileScopeProvider(@NotNull FileScopeProvider fileScopeProvider) {
        if (fileScopeProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileScopeProvider", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "setFileScopeProvider"));
        }
        this.fileScopeProvider = fileScopeProvider;
    }

    public DeclarationScopeProviderImpl(@NotNull LazyDeclarationResolver lazyDeclarationResolver) {
        if (lazyDeclarationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lazyDeclarationResolver", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "<init>"));
        }
        this.lazyDeclarationResolver = lazyDeclarationResolver;
    }

    @Override
    @NotNull
    public JetScope getResolutionScopeForDeclaration(@NotNull PsiElement elementOfDeclaration) {
        if (elementOfDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementOfDeclaration", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "getResolutionScopeForDeclaration"));
        }
        JetDeclaration jetDeclaration = JetStubbedPsiUtil.getPsiOrStubParent(elementOfDeclaration, JetDeclaration.class, false);
        assert (!(elementOfDeclaration instanceof JetDeclaration) || jetDeclaration == elementOfDeclaration) : "For JetDeclaration element getParentOfType() should return itself.";
        assert (jetDeclaration != null) : "Should be contained inside declaration.";
        JetDeclaration parentDeclaration = JetStubbedPsiUtil.getContainingDeclaration(jetDeclaration);
        if (jetDeclaration instanceof JetPropertyAccessor) {
            parentDeclaration = JetStubbedPsiUtil.getContainingDeclaration(parentDeclaration, JetDeclaration.class);
        }
        if (parentDeclaration == null) {
            JetScope jetScope = this.fileScopeProvider.getFileScope((JetFile)elementOfDeclaration.getContainingFile());
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "getResolutionScopeForDeclaration"));
            }
            return jetScope;
        }
        if (parentDeclaration instanceof JetClassOrObject) {
            JetClassOrObject classOrObject = (JetClassOrObject)parentDeclaration;
            LazyClassDescriptor classDescriptor = (LazyClassDescriptor)this.lazyDeclarationResolver.getClassDescriptor(classOrObject);
            if (jetDeclaration instanceof JetClassInitializer || jetDeclaration instanceof JetProperty) {
                JetScope jetScope = classDescriptor.getScopeForInitializerResolution();
                if (jetScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "getResolutionScopeForDeclaration"));
                }
                return jetScope;
            }
            JetScope jetScope = classDescriptor.getScopeForMemberDeclarationResolution();
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "getResolutionScopeForDeclaration"));
            }
            return jetScope;
        }
        throw new IllegalStateException("Don't call this method for local declarations: " + jetDeclaration + "\n" + PsiUtilPackage.getElementTextWithContext(jetDeclaration));
    }

    @Override
    @NotNull
    public DataFlowInfo getOuterDataFlowInfoForDeclaration(@NotNull PsiElement elementOfDeclaration) {
        if (elementOfDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementOfDeclaration", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "getOuterDataFlowInfoForDeclaration"));
        }
        DataFlowInfo dataFlowInfo = DataFlowInfo.EMPTY;
        if (dataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "getOuterDataFlowInfoForDeclaration"));
        }
        return dataFlowInfo;
    }
}

