/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.descriptors;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.impl.AbstractLazyTypeParameterDescriptor;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetStubbedPsiUtil;
import org.jetbrains.kotlin.psi.JetTypeConstraint;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Sets;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.LazyClassContext;
import org.jetbrains.kotlin.resolve.lazy.LazyEntity;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.kotlin.resolve.source.SourcePackage;
import org.jetbrains.kotlin.types.JetType;

public class LazyTypeParameterDescriptor
extends AbstractLazyTypeParameterDescriptor
implements LazyEntity {
    private final LazyClassContext c;
    private final JetTypeParameter jetTypeParameter;

    public LazyTypeParameterDescriptor(@NotNull LazyClassContext c, @NotNull LazyClassDescriptor containingDeclaration, @NotNull JetTypeParameter jetTypeParameter, int index2) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyTypeParameterDescriptor", "<init>"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyTypeParameterDescriptor", "<init>"));
        }
        if (jetTypeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetTypeParameter", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyTypeParameterDescriptor", "<init>"));
        }
        super(c.getStorageManager(), containingDeclaration, jetTypeParameter.getNameAsSafeName(), jetTypeParameter.getVariance(), jetTypeParameter.hasModifier(JetTokens.REIFIED_KEYWORD), index2, SourcePackage.toSourceElement(jetTypeParameter));
        this.c = c;
        this.jetTypeParameter = jetTypeParameter;
        this.c.getTrace().record(BindingContext.TYPE_PARAMETER, jetTypeParameter, this);
    }

    @Override
    @NotNull
    protected Set<JetType> resolveUpperBounds() {
        LinkedHashSet<JetType> upperBounds = Sets.newLinkedHashSet();
        JetTypeParameter jetTypeParameter = this.jetTypeParameter;
        JetTypeReference extendsBound = jetTypeParameter.getExtendsBound();
        if (extendsBound != null) {
            upperBounds.add(this.resolveBoundType(extendsBound));
        }
        this.resolveUpperBoundsFromWhereClause(upperBounds);
        if (upperBounds.isEmpty()) {
            upperBounds.add(this.c.getModuleDescriptor().getBuiltIns().getDefaultBound());
        }
        LinkedHashSet<JetType> linkedHashSet = upperBounds;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyTypeParameterDescriptor", "resolveUpperBounds"));
        }
        return linkedHashSet;
    }

    private void resolveUpperBoundsFromWhereClause(Set<JetType> upperBounds) {
        JetClassOrObject classOrObject = JetStubbedPsiUtil.getPsiOrStubParent(this.jetTypeParameter, JetClassOrObject.class, true);
        if (classOrObject instanceof JetClass) {
            JetClass jetClass = (JetClass)classOrObject;
            for (JetTypeConstraint jetTypeConstraint : jetClass.getTypeConstraints()) {
                JetSimpleNameExpression constrainedParameterName = jetTypeConstraint.getSubjectTypeParameterName();
                if (constrainedParameterName == null || !this.getName().equals(constrainedParameterName.getReferencedNameAsName())) continue;
                this.c.getTrace().record(BindingContext.REFERENCE_TARGET, constrainedParameterName, this);
                JetTypeReference boundTypeReference = jetTypeConstraint.getBoundTypeReference();
                if (boundTypeReference == null) continue;
                JetType boundType = this.resolveBoundType(boundTypeReference);
                upperBounds.add(boundType);
            }
        }
    }

    private JetType resolveBoundType(@NotNull JetTypeReference boundTypeReference) {
        if (boundTypeReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boundTypeReference", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyTypeParameterDescriptor", "resolveBoundType"));
        }
        return this.c.getTypeResolver().resolveType(this.getContainingDeclaration().getScopeForClassHeaderResolution(), boundTypeReference, this.c.getTrace(), false);
    }

    @Override
    @NotNull
    public LazyClassDescriptor getContainingDeclaration() {
        LazyClassDescriptor lazyClassDescriptor = (LazyClassDescriptor)super.getContainingDeclaration();
        if (lazyClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyTypeParameterDescriptor", "getContainingDeclaration"));
        }
        return lazyClassDescriptor;
    }

    @Override
    public void forceResolveAllContents() {
        ForceResolveUtil.forceResolveAllContents(this.getAnnotations());
        this.getContainingDeclaration();
        this.getDefaultType();
        this.getIndex();
        ForceResolveUtil.forceResolveAllContents(this.getLowerBounds());
        this.getOriginal();
        ForceResolveUtil.forceResolveAllContents(this.getTypeConstructor());
        ForceResolveUtil.forceResolveAllContents(this.getUpperBounds());
        this.getUpperBoundsAsType();
        this.getVariance();
    }
}

