/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.Library;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.TypeMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.Buffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;

public final class Native {
    private static String nativeLibraryPath;
    private static Map typeMappers;
    private static Map alignments;
    private static Map options;
    private static Map libraries;
    private static final Callback.UncaughtExceptionHandler DEFAULT_HANDLER;
    private static Callback.UncaughtExceptionHandler callbackExceptionHandler;
    public static final int POINTER_SIZE;
    public static final int LONG_SIZE;
    public static final int WCHAR_SIZE;
    public static final int SIZE_T_SIZE;
    private static final Object finalizer;
    private static final ThreadLocal lastError;
    private static Map registeredClasses;
    private static Map registeredLibraries;
    private static Object unloader;
    static /* synthetic */ Class class$com$sun$jna$Library;
    static /* synthetic */ Class class$com$sun$jna$Callback;
    static /* synthetic */ Class class$com$sun$jna$TypeMapper;
    static /* synthetic */ Class class$com$sun$jna$Native;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$com$sun$jna$Structure;
    static /* synthetic */ Class class$com$sun$jna$Structure$ByReference;
    static /* synthetic */ Class class$com$sun$jna$NativeMapped;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$com$sun$jna$Structure$ByValue;
    static /* synthetic */ Class class$com$sun$jna$Pointer;
    static /* synthetic */ Class class$com$sun$jna$WString;
    static /* synthetic */ Class class$java$nio$Buffer;

    private static void dispose() {
        NativeLibrary.disposeAll();
        nativeLibraryPath = null;
    }

    private static boolean deleteNativeLibrary(String path) {
        File flib = new File(path);
        if (flib.delete()) {
            return true;
        }
        Native.markTemporaryFile(flib);
        return false;
    }

    private Native() {
    }

    private static native void initIDs();

    public static synchronized native void setProtected(boolean var0);

    public static synchronized native void setPreserveLastError(boolean var0);

    public static Pointer getDirectBufferPointer(Buffer b) {
        long peer = Native._getDirectBufferPointer(b);
        return peer == 0L ? null : new Pointer(peer);
    }

    private static native long _getDirectBufferPointer(Buffer var0);

    public static Object loadLibrary(String name, Class interfaceClass) {
        return Native.loadLibrary(name, interfaceClass, Collections.EMPTY_MAP);
    }

    public static Object loadLibrary(String name, Class interfaceClass, Map options) {
        Library.Handler handler2 = new Library.Handler(name, interfaceClass, options);
        ClassLoader loader = interfaceClass.getClassLoader();
        Library proxy = (Library)Proxy.newProxyInstance(loader, new Class[]{interfaceClass}, (InvocationHandler)handler2);
        Native.cacheOptions(interfaceClass, options, proxy);
        return proxy;
    }

    private static void loadLibraryInstance(Class cls) {
        if (cls != null && !libraries.containsKey(cls)) {
            try {
                Field[] fields2 = cls.getFields();
                for (int i = 0; i < fields2.length; ++i) {
                    Field field = fields2[i];
                    if (field.getType() != cls || !Modifier.isStatic(field.getModifiers())) continue;
                    libraries.put(cls, new WeakReference<Object>(field.get(null)));
                    break;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(new StringBuffer().append("Could not access instance of ").append(cls).append(" (").append(e).append(")").toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class findEnclosingLibraryClass(Class cls) {
        Class<?> declaring;
        Class fromDeclaring;
        if (cls == null) {
            return null;
        }
        Map map2 = libraries;
        synchronized (map2) {
            if (options.containsKey(cls)) {
                return cls;
            }
        }
        if ((class$com$sun$jna$Library == null ? (class$com$sun$jna$Library = Native.class$("com.sun.jna.Library")) : class$com$sun$jna$Library).isAssignableFrom(cls)) {
            return cls;
        }
        if ((class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = Native.class$("com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(cls)) {
            cls = CallbackReference.findCallbackClass(cls);
        }
        if ((fromDeclaring = Native.findEnclosingLibraryClass(declaring = cls.getDeclaringClass())) != null) {
            return fromDeclaring;
        }
        return Native.findEnclosingLibraryClass(cls.getSuperclass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getLibraryOptions(Class type2) {
        Map map2 = libraries;
        synchronized (map2) {
            Class interfaceClass = Native.findEnclosingLibraryClass(type2);
            if (interfaceClass != null) {
                Native.loadLibraryInstance(interfaceClass);
            } else {
                interfaceClass = type2;
            }
            if (!options.containsKey(interfaceClass)) {
                try {
                    Field field = interfaceClass.getField("OPTIONS");
                    field.setAccessible(true);
                    options.put(interfaceClass, field.get(null));
                }
                catch (NoSuchFieldException field) {
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(new StringBuffer().append("OPTIONS must be a public field of type java.util.Map (").append(e).append("): ").append(interfaceClass).toString());
                }
            }
            return (Map)options.get(interfaceClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeMapper getTypeMapper(Class cls) {
        Map map2 = libraries;
        synchronized (map2) {
            Class interfaceClass = Native.findEnclosingLibraryClass(cls);
            if (interfaceClass != null) {
                Native.loadLibraryInstance(interfaceClass);
            } else {
                interfaceClass = cls;
            }
            if (!typeMappers.containsKey(interfaceClass)) {
                try {
                    Field field = interfaceClass.getField("TYPE_MAPPER");
                    field.setAccessible(true);
                    typeMappers.put(interfaceClass, field.get(null));
                }
                catch (NoSuchFieldException e) {
                    Map options = Native.getLibraryOptions(cls);
                    if (options != null && options.containsKey("type-mapper")) {
                        typeMappers.put(interfaceClass, options.get("type-mapper"));
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(new StringBuffer().append("TYPE_MAPPER must be a public field of type ").append((class$com$sun$jna$TypeMapper == null ? (class$com$sun$jna$TypeMapper = Native.class$("com.sun.jna.TypeMapper")) : class$com$sun$jna$TypeMapper).getName()).append(" (").append(e).append("): ").append(interfaceClass).toString());
                }
            }
            return (TypeMapper)typeMappers.get(interfaceClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getStructureAlignment(Class cls) {
        Map map2 = libraries;
        synchronized (map2) {
            Integer value;
            Class interfaceClass = Native.findEnclosingLibraryClass(cls);
            if (interfaceClass != null) {
                Native.loadLibraryInstance(interfaceClass);
            } else {
                interfaceClass = cls;
            }
            if (!alignments.containsKey(interfaceClass)) {
                try {
                    Field field = interfaceClass.getField("STRUCTURE_ALIGNMENT");
                    field.setAccessible(true);
                    alignments.put(interfaceClass, field.get(null));
                }
                catch (NoSuchFieldException e) {
                    Map options = Native.getLibraryOptions(interfaceClass);
                    if (options != null && options.containsKey("structure-alignment")) {
                        alignments.put(interfaceClass, options.get("structure-alignment"));
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(new StringBuffer().append("STRUCTURE_ALIGNMENT must be a public field of type int (").append(e).append("): ").append(interfaceClass).toString());
                }
            }
            int n = (value = (Integer)alignments.get(interfaceClass)) != null ? value : 0;
            return n;
        }
    }

    static byte[] getBytes(String s) {
        try {
            return Native.getBytes(s, System.getProperty("jna.encoding"));
        }
        catch (UnsupportedEncodingException e) {
            return s.getBytes();
        }
    }

    static byte[] getBytes(String s, String encoding) throws UnsupportedEncodingException {
        if (encoding != null) {
            return s.getBytes(encoding);
        }
        return s.getBytes();
    }

    static String getNativeLibraryResourcePath(int osType, String arch, String name) {
        String osPrefix;
        if ("powerpc".equals(arch = arch.toLowerCase())) {
            arch = "ppc";
        } else if ("powerpc64".equals(arch)) {
            arch = "ppc64";
        }
        switch (osType) {
            case 2: {
                if ("i386".equals(arch)) {
                    arch = "x86";
                }
                osPrefix = new StringBuffer().append("win32-").append(arch).toString();
                break;
            }
            case 6: {
                osPrefix = new StringBuffer().append("w32ce-").append(arch).toString();
                break;
            }
            case 0: {
                osPrefix = "darwin";
                break;
            }
            case 1: {
                if ("x86".equals(arch)) {
                    arch = "i386";
                } else if ("x86_64".equals(arch)) {
                    arch = "amd64";
                }
                osPrefix = new StringBuffer().append("linux-").append(arch).toString();
                break;
            }
            case 3: {
                osPrefix = new StringBuffer().append("sunos-").append(arch).toString();
                break;
            }
            default: {
                int space;
                osPrefix = name.toLowerCase();
                if ("x86".equals(arch)) {
                    arch = "i386";
                }
                if ("x86_64".equals(arch)) {
                    arch = "amd64";
                }
                if ((space = osPrefix.indexOf(" ")) != -1) {
                    osPrefix = osPrefix.substring(0, space);
                }
                osPrefix = new StringBuffer().append(osPrefix).append("-").append(arch).toString();
            }
        }
        return new StringBuffer().append("/com/sun/jna/").append(osPrefix).toString();
    }

    private static void loadNativeLibrary() {
        block13: {
            Native.removeTemporaryFiles();
            String libName = System.getProperty("jna.boot.library.name", "jnidispatch");
            String bootPath = System.getProperty("jna.boot.library.path");
            if (bootPath != null) {
                StringTokenizer dirs = new StringTokenizer(bootPath, File.pathSeparator);
                while (dirs.hasMoreTokens()) {
                    String ext;
                    String orig;
                    String dir = dirs.nextToken();
                    File file = new File(new File(dir), System.mapLibraryName(libName));
                    String path = file.getAbsolutePath();
                    if (file.exists()) {
                        try {
                            System.load(path);
                            nativeLibraryPath = path;
                            return;
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                            // empty catch block
                        }
                    }
                    if (!Platform.isMac()) continue;
                    if (path.endsWith("dylib")) {
                        orig = "dylib";
                        ext = "jnilib";
                    } else {
                        orig = "jnilib";
                        ext = "dylib";
                    }
                    if (!new File(path = new StringBuffer().append(path.substring(0, path.lastIndexOf(orig))).append(ext).toString()).exists()) continue;
                    try {
                        System.load(path);
                        nativeLibraryPath = path;
                        return;
                    }
                    catch (UnsatisfiedLinkError ex) {
                        System.err.println(new StringBuffer().append("File found at ").append(path).append(" but not loadable: ").append(ex.getMessage()).toString());
                    }
                }
            }
            try {
                if (!Boolean.getBoolean("jna.nosys")) {
                    System.loadLibrary(libName);
                    return;
                }
            }
            catch (UnsatisfiedLinkError e) {
                if (!Boolean.getBoolean("jna.nounpack")) break block13;
                throw e;
            }
        }
        if (!Boolean.getBoolean("jna.nounpack")) {
            Native.loadNativeLibraryFromJar();
            return;
        }
        throw new UnsatisfiedLinkError("Native jnidispatch library not found");
    }

    private static void loadNativeLibraryFromJar() {
        String libname = System.mapLibraryName("jnidispatch");
        String arch = System.getProperty("os.arch");
        String name = System.getProperty("os.name");
        String resourceName = new StringBuffer().append(Native.getNativeLibraryResourcePath(Platform.getOSType(), arch, name)).append("/").append(libname).toString();
        URL url = (class$com$sun$jna$Native == null ? (class$com$sun$jna$Native = Native.class$("com.sun.jna.Native")) : class$com$sun$jna$Native).getResource(resourceName);
        boolean unpacked = false;
        if (url == null && Platform.isMac() && resourceName.endsWith(".dylib")) {
            resourceName = new StringBuffer().append(resourceName.substring(0, resourceName.lastIndexOf(".dylib"))).append(".jnilib").toString();
            url = (class$com$sun$jna$Native == null ? (class$com$sun$jna$Native = Native.class$("com.sun.jna.Native")) : class$com$sun$jna$Native).getResource(resourceName);
        }
        if (url == null) {
            throw new UnsatisfiedLinkError(new StringBuffer().append("jnidispatch (").append(resourceName).append(") not found in resource path").toString());
        }
        File lib = null;
        if (url.getProtocol().toLowerCase().equals("file")) {
            try {
                lib = new File(new URI(url.toString()));
            }
            catch (URISyntaxException e) {
                lib = new File(url.getPath());
            }
            if (!lib.exists()) {
                throw new Error(new StringBuffer().append("File URL ").append(url).append(" could not be properly decoded").toString());
            }
        } else {
            InputStream is = (class$com$sun$jna$Native == null ? (class$com$sun$jna$Native = Native.class$("com.sun.jna.Native")) : class$com$sun$jna$Native).getResourceAsStream(resourceName);
            if (is == null) {
                throw new Error("Can't obtain jnidispatch InputStream");
            }
            FileOutputStream fos = null;
            try {
                int count;
                File dir = Native.getTempDir();
                lib = File.createTempFile("jna", Platform.isWindows() ? ".dll" : null, dir);
                lib.deleteOnExit();
                fos = new FileOutputStream(lib);
                byte[] buf = new byte[1024];
                while ((count = is.read(buf, 0, buf.length)) > 0) {
                    fos.write(buf, 0, count);
                }
                unpacked = true;
            }
            catch (IOException e) {
                throw new Error(new StringBuffer().append("Failed to create temporary file for jnidispatch library: ").append(e).toString());
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        System.load(lib.getAbsolutePath());
        nativeLibraryPath = lib.getAbsolutePath();
        if (unpacked) {
            Native.deleteNativeLibrary(lib.getAbsolutePath());
        }
    }

    private static native int sizeof(int var0);

    private static native String getNativeVersion();

    public static int getLastError() {
        return (Integer)lastError.get();
    }

    public static String getWebStartLibraryPath(String libName) {
        if (System.getProperty("javawebstart.version") == null) {
            return null;
        }
        try {
            ClassLoader cl = (class$com$sun$jna$Native == null ? (class$com$sun$jna$Native = Native.class$("com.sun.jna.Native")) : class$com$sun$jna$Native).getClassLoader();
            Method m = (Method)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Method m = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Native.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredMethod("findLibrary", class$java$lang$String == null ? (class$java$lang$String = Native.class$("java.lang.String")) : class$java$lang$String);
                        m.setAccessible(true);
                        return m;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
            String libpath = (String)m.invoke((Object)cl, libName);
            if (libpath != null) {
                return new File(libpath).getParent();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    static void markTemporaryFile(File file) {
        try {
            File marker = new File(file.getParentFile(), new StringBuffer().append(file.getName()).append(".x").toString());
            marker.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static File getTempDir() {
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        File jnatmp = new File(tmp, "jna");
        jnatmp.mkdirs();
        return jnatmp.exists() ? jnatmp : tmp;
    }

    static void removeTemporaryFiles() {
        File dir = Native.getTempDir();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".x") && name.indexOf("jna") != -1;
            }
        };
        File[] files = dir.listFiles(filter);
        for (int i = 0; files != null && i < files.length; ++i) {
            File marker = files[i];
            String name = marker.getName();
            name = name.substring(0, name.length() - 2);
            File target = new File(marker.getParentFile(), name);
            if (target.exists() && !target.delete()) continue;
            marker.delete();
        }
    }

    public static int getNativeSize(Class type2, Object value) {
        if (type2.isArray()) {
            int len = Array.getLength(value);
            if (len > 0) {
                Object o = Array.get(value, 0);
                return len * Native.getNativeSize(type2.getComponentType(), o);
            }
            throw new IllegalArgumentException(new StringBuffer().append("Arrays of length zero not allowed: ").append(type2).toString());
        }
        if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Native.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(type2) && !(class$com$sun$jna$Structure$ByReference == null ? (class$com$sun$jna$Structure$ByReference = Native.class$("com.sun.jna.Structure$ByReference")) : class$com$sun$jna$Structure$ByReference).isAssignableFrom(type2)) {
            if (value == null) {
                value = Structure.newInstance(type2);
            }
            return ((Structure)value).size();
        }
        try {
            return Native.getNativeSize(type2);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(new StringBuffer().append("The type \"").append(type2.getName()).append("\" is not supported: ").append(e.getMessage()).toString());
        }
    }

    public static int getNativeSize(Class cls) {
        if ((class$com$sun$jna$NativeMapped == null ? (class$com$sun$jna$NativeMapped = Native.class$("com.sun.jna.NativeMapped")) : class$com$sun$jna$NativeMapped).isAssignableFrom(cls)) {
            cls = NativeMappedConverter.getInstance(cls).nativeType();
        }
        if (cls == Boolean.TYPE || cls == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Native.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return 4;
        }
        if (cls == Byte.TYPE || cls == (class$java$lang$Byte == null ? (class$java$lang$Byte = Native.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return 1;
        }
        if (cls == Short.TYPE || cls == (class$java$lang$Short == null ? (class$java$lang$Short = Native.class$("java.lang.Short")) : class$java$lang$Short)) {
            return 2;
        }
        if (cls == Character.TYPE || cls == (class$java$lang$Character == null ? (class$java$lang$Character = Native.class$("java.lang.Character")) : class$java$lang$Character)) {
            return WCHAR_SIZE;
        }
        if (cls == Integer.TYPE || cls == (class$java$lang$Integer == null ? (class$java$lang$Integer = Native.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return 4;
        }
        if (cls == Long.TYPE || cls == (class$java$lang$Long == null ? (class$java$lang$Long = Native.class$("java.lang.Long")) : class$java$lang$Long)) {
            return 8;
        }
        if (cls == Float.TYPE || cls == (class$java$lang$Float == null ? (class$java$lang$Float = Native.class$("java.lang.Float")) : class$java$lang$Float)) {
            return 4;
        }
        if (cls == Double.TYPE || cls == (class$java$lang$Double == null ? (class$java$lang$Double = Native.class$("java.lang.Double")) : class$java$lang$Double)) {
            return 8;
        }
        if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Native.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(cls)) {
            if ((class$com$sun$jna$Structure$ByValue == null ? (class$com$sun$jna$Structure$ByValue = Native.class$("com.sun.jna.Structure$ByValue")) : class$com$sun$jna$Structure$ByValue).isAssignableFrom(cls)) {
                return Structure.newInstance(cls).size();
            }
            return POINTER_SIZE;
        }
        if ((class$com$sun$jna$Pointer == null ? (class$com$sun$jna$Pointer = Native.class$("com.sun.jna.Pointer")) : class$com$sun$jna$Pointer).isAssignableFrom(cls) || Platform.HAS_BUFFERS && Buffers.isBuffer(cls) || (class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = Native.class$("com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(cls) || (class$java$lang$String == null ? (class$java$lang$String = Native.class$("java.lang.String")) : class$java$lang$String) == cls || (class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = Native.class$("com.sun.jna.WString")) : class$com$sun$jna$WString) == cls) {
            return POINTER_SIZE;
        }
        throw new IllegalArgumentException(new StringBuffer().append("Native size for type \"").append(cls.getName()).append("\" is unknown").toString());
    }

    public static boolean isSupportedNativeType(Class cls) {
        if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Native.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(cls)) {
            return true;
        }
        try {
            return Native.getNativeSize(cls) != 0;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static native void unregister(Class var0, long[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheOptions(Class cls, Map libOptions, Object proxy) {
        Map map2 = libraries;
        synchronized (map2) {
            if (!libOptions.isEmpty()) {
                options.put(cls, libOptions);
            }
            if (libOptions.containsKey("type-mapper")) {
                typeMappers.put(cls, libOptions.get("type-mapper"));
            }
            if (libOptions.containsKey("structure-alignment")) {
                alignments.put(cls, libOptions.get("structure-alignment"));
            }
            if (proxy != null) {
                libraries.put(cls, new WeakReference<Object>(proxy));
            }
            if (!cls.isInterface() && (class$com$sun$jna$Library == null ? (class$com$sun$jna$Library = Native.class$("com.sun.jna.Library")) : class$com$sun$jna$Library).isAssignableFrom(cls)) {
                Class<?>[] ifaces = cls.getInterfaces();
                for (int i = 0; i < ifaces.length; ++i) {
                    if (!(class$com$sun$jna$Library == null ? Native.class$("com.sun.jna.Library") : class$com$sun$jna$Library).isAssignableFrom(ifaces[i])) continue;
                    Native.cacheOptions(ifaces[i], libOptions, proxy);
                    break;
                }
            }
        }
    }

    static synchronized native void freeNativeCallback(long var0);

    static synchronized native long createNativeCallback(Callback var0, Method var1, Class[] var2, Class var3, int var4, boolean var5);

    static native int invokeInt(long var0, int var2, Object[] var3);

    static native long invokeLong(long var0, int var2, Object[] var3);

    static native void invokeVoid(long var0, int var2, Object[] var3);

    static native float invokeFloat(long var0, int var2, Object[] var3);

    static native double invokeDouble(long var0, int var2, Object[] var3);

    static native long invokePointer(long var0, int var2, Object[] var3);

    private static native void invokeStructure(long var0, int var2, Object[] var3, long var4, long var6);

    static Structure invokeStructure(long fp, int callFlags, Object[] args, Structure s) {
        Native.invokeStructure(fp, callFlags, args, s.getPointer().peer, s.getTypeInfo().peer);
        return s;
    }

    static native Object invokeObject(long var0, int var2, Object[] var3);

    static native long open(String var0);

    static native void close(long var0);

    static native long findSymbol(long var0, String var2);

    static native long indexOf(long var0, byte var2);

    static native void read(long var0, byte[] var2, int var3, int var4);

    static native void read(long var0, short[] var2, int var3, int var4);

    static native void read(long var0, char[] var2, int var3, int var4);

    static native void read(long var0, int[] var2, int var3, int var4);

    static native void read(long var0, long[] var2, int var3, int var4);

    static native void read(long var0, float[] var2, int var3, int var4);

    static native void read(long var0, double[] var2, int var3, int var4);

    static native void write(long var0, byte[] var2, int var3, int var4);

    static native void write(long var0, short[] var2, int var3, int var4);

    static native void write(long var0, char[] var2, int var3, int var4);

    static native void write(long var0, int[] var2, int var3, int var4);

    static native void write(long var0, long[] var2, int var3, int var4);

    static native void write(long var0, float[] var2, int var3, int var4);

    static native void write(long var0, double[] var2, int var3, int var4);

    static native byte getByte(long var0);

    static native char getChar(long var0);

    static native short getShort(long var0);

    static native int getInt(long var0);

    static native long getLong(long var0);

    static native float getFloat(long var0);

    static native double getDouble(long var0);

    static Pointer getPointer(long addr) {
        long peer = Native._getPointer(addr);
        return peer == 0L ? null : new Pointer(peer);
    }

    private static native long _getPointer(long var0);

    static native String getString(long var0, boolean var2);

    static native void setMemory(long var0, long var2, byte var4);

    static native void setByte(long var0, byte var2);

    static native void setShort(long var0, short var2);

    static native void setChar(long var0, char var2);

    static native void setInt(long var0, int var2);

    static native void setLong(long var0, long var2);

    static native void setFloat(long var0, float var2);

    static native void setDouble(long var0, double var2);

    static native void setPointer(long var0, long var2);

    static native void setString(long var0, String var2, boolean var3);

    public static native long malloc(long var0);

    public static native void free(long var0);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        String version;
        nativeLibraryPath = null;
        typeMappers = new WeakHashMap();
        alignments = new WeakHashMap();
        options = new WeakHashMap();
        libraries = new WeakHashMap();
        callbackExceptionHandler = DEFAULT_HANDLER = new Callback.UncaughtExceptionHandler(){};
        Native.loadNativeLibrary();
        POINTER_SIZE = Native.sizeof(0);
        LONG_SIZE = Native.sizeof(1);
        WCHAR_SIZE = Native.sizeof(2);
        SIZE_T_SIZE = Native.sizeof(3);
        Native.initIDs();
        if (Boolean.getBoolean("jna.protected")) {
            Native.setProtected(true);
        }
        if (!"3.4.0".equals(version = Native.getNativeVersion())) {
            String LS = System.getProperty("line.separator");
            throw new Error(new StringBuffer().append(LS).append(LS).append("There is an incompatible JNA native library installed on this system.").append(LS).append("To resolve this issue you may do one of the following:").append(LS).append(" - remove or uninstall the offending library").append(LS).append(" - set the system property jna.nosys=true").append(LS).append(" - set jna.boot.library.path to include the path to the version of the ").append(LS).append("   jnidispatch library included with the JNA jar file you are using").append(LS).toString());
        }
        Native.setPreserveLastError("true".equalsIgnoreCase(System.getProperty("jna.preserve_last_error", "true")));
        finalizer = new Object(){

            protected void finalize() {
                Native.dispose();
            }
        };
        lastError = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new Integer(0);
            }
        };
        registeredClasses = new HashMap();
        registeredLibraries = new HashMap();
        unloader = new Object(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() {
                Map map2 = registeredClasses;
                synchronized (map2) {
                    Iterator i = registeredClasses.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry e = i.next();
                        Native.unregister((Class)e.getKey(), (long[])e.getValue());
                        i.remove();
                    }
                }
            }
        };
    }

    private static class Buffers {
        static boolean isBuffer(Class cls) {
            return (class$java$nio$Buffer == null ? (class$java$nio$Buffer = Native.class$("java.nio.Buffer")) : class$java$nio$Buffer).isAssignableFrom(cls);
        }
    }
}

