/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util.collectionUtils;

import java.util.Collection;
import java.util.LinkedHashSet;
import kotlin.KotlinPackage;
import kotlin.inline;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.util.collectionUtils.CollectionUtilsPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CollectionUtilsPackage__ScopeUtilsKt {
    @Nullable
    public static final <T> Collection<T> concat(Collection<? extends T> $receiver, @NotNull Collection<? extends T> collection) {
        Intrinsics.checkParameterIsNotNull(collection, "collection");
        if (collection.isEmpty()) {
            return $receiver;
        }
        if ($receiver == null) {
            return collection;
        }
        if ($receiver instanceof LinkedHashSet) {
            ((LinkedHashSet)$receiver).addAll(collection);
            return $receiver;
        }
        LinkedHashSet<T> result2 = new LinkedHashSet<T>($receiver);
        result2.addAll(collection);
        return result2;
    }

    @NotNull
    public static final <T> Collection<T> concatInOrder(@Nullable Collection<? extends T> c1, @Nullable Collection<? extends T> c2) {
        Collection result2;
        Collection collection;
        Collection collection2;
        if (c1 == null || c1.isEmpty()) {
            collection2 = c2;
        } else if (c2 == null || c2.isEmpty()) {
            collection2 = c1;
        } else {
            LinkedHashSet<T> result3 = new LinkedHashSet<T>();
            result3.addAll(c1);
            result3.addAll(c2);
            collection2 = result3;
        }
        if ((collection = (result2 = collection2)) == null) {
            collection = KotlinPackage.emptySet();
        }
        return collection;
    }

    @inline
    @NotNull
    public static final <Scope, T> Collection<T> getFromAllScopes(@NotNull Scope[] scopes, @NotNull Function1<? super Scope, ? extends Collection<? extends T>> callback) {
        Intrinsics.checkParameterIsNotNull(scopes, "scopes");
        Intrinsics.checkParameterIsNotNull(callback, "callback");
        if (KotlinPackage.isEmpty(scopes)) {
            return KotlinPackage.emptySet();
        }
        Collection<T> result2 = null;
        for (int i = 0; i < scopes.length; ++i) {
            Scope scope2 = scopes[i];
            result2 = CollectionUtilsPackage.concat(result2, callback.invoke(scope2));
        }
        Collection<T> collection = result2;
        if (collection == null) {
            collection = KotlinPackage.emptySet();
        }
        return collection;
    }

    @inline
    @Nullable
    public static final <Scope, T> T getFirstMatch(@NotNull Scope[] scopes, @NotNull Function1<? super Scope, ? extends T> callback) {
        Intrinsics.checkParameterIsNotNull(scopes, "scopes");
        Intrinsics.checkParameterIsNotNull(callback, "callback");
        for (int i = 0; i < scopes.length; ++i) {
            Scope scope2 = scopes[i];
            T result2 = callback.invoke(scope2);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }
}

