/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.intrinsics;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.intrinsics.ArrayGet;
import org.jetbrains.kotlin.codegen.intrinsics.ArrayIterator;
import org.jetbrains.kotlin.codegen.intrinsics.ArraySet;
import org.jetbrains.kotlin.codegen.intrinsics.ArraySize;
import org.jetbrains.kotlin.codegen.intrinsics.BinaryOp;
import org.jetbrains.kotlin.codegen.intrinsics.Clone;
import org.jetbrains.kotlin.codegen.intrinsics.CompareTo;
import org.jetbrains.kotlin.codegen.intrinsics.Concat;
import org.jetbrains.kotlin.codegen.intrinsics.Equals;
import org.jetbrains.kotlin.codegen.intrinsics.HashCode;
import org.jetbrains.kotlin.codegen.intrinsics.IdentityEquals;
import org.jetbrains.kotlin.codegen.intrinsics.Increment;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicsMap;
import org.jetbrains.kotlin.codegen.intrinsics.Inv;
import org.jetbrains.kotlin.codegen.intrinsics.IteratorNext;
import org.jetbrains.kotlin.codegen.intrinsics.JavaClassArray;
import org.jetbrains.kotlin.codegen.intrinsics.JavaClassFunction;
import org.jetbrains.kotlin.codegen.intrinsics.JavaClassProperty;
import org.jetbrains.kotlin.codegen.intrinsics.KClassJavaProperty;
import org.jetbrains.kotlin.codegen.intrinsics.MonitorInstruction;
import org.jetbrains.kotlin.codegen.intrinsics.NewArray;
import org.jetbrains.kotlin.codegen.intrinsics.Not;
import org.jetbrains.kotlin.codegen.intrinsics.NumberCast;
import org.jetbrains.kotlin.codegen.intrinsics.RangeTo;
import org.jetbrains.kotlin.codegen.intrinsics.StringGetChar;
import org.jetbrains.kotlin.codegen.intrinsics.StringPlus;
import org.jetbrains.kotlin.codegen.intrinsics.ToString;
import org.jetbrains.kotlin.codegen.intrinsics.UnaryMinus;
import org.jetbrains.kotlin.codegen.intrinsics.UnaryPlus;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.relocated.com.google.common.collect.ImmutableList;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public class IntrinsicMethods {
    public static final String INTRINSICS_CLASS_NAME = "kotlin/jvm/internal/Intrinsics";
    private static final IntrinsicMethod UNARY_MINUS = new UnaryMinus();
    private static final IntrinsicMethod UNARY_PLUS = new UnaryPlus();
    private static final IntrinsicMethod NUMBER_CAST = new NumberCast();
    private static final IntrinsicMethod INV = new Inv();
    private static final IntrinsicMethod RANGE_TO = new RangeTo();
    private static final IntrinsicMethod INC = new Increment(1);
    private static final IntrinsicMethod DEC = new Increment(-1);
    private static final IntrinsicMethod HASH_CODE = new HashCode();
    private static final IntrinsicMethod ARRAY_SIZE = new ArraySize();
    private static final Equals EQUALS = new Equals();
    private static final IdentityEquals IDENTITY_EQUALS = new IdentityEquals();
    private static final IteratorNext ITERATOR_NEXT = new IteratorNext();
    private static final ArraySet ARRAY_SET = new ArraySet();
    private static final ArrayGet ARRAY_GET = new ArrayGet();
    private static final StringPlus STRING_PLUS = new StringPlus();
    private static final ToString TO_STRING = new ToString();
    private static final Clone CLONE = new Clone();
    private final Map<String, IntrinsicMethod> namedMethods = new HashMap<String, IntrinsicMethod>();
    private static final IntrinsicMethod ARRAY_ITERATOR = new ArrayIterator();
    private final IntrinsicsMap intrinsicsMap = new IntrinsicsMap();

    public IntrinsicMethods() {
        String typeName;
        this.namedMethods.put("kotlin.javaClass.function", new JavaClassFunction());
        this.namedMethods.put("kotlin.javaClass.property", new JavaClassProperty());
        this.namedMethods.put("kotlin.KClass.java.property", new KClassJavaProperty());
        this.namedMethods.put("kotlin.arrays.array", new JavaClassArray());
        this.namedMethods.put("kotlin.jvm.internal.unsafe.monitorEnter", MonitorInstruction.MONITOR_ENTER);
        this.namedMethods.put("kotlin.jvm.internal.unsafe.monitorExit", MonitorInstruction.MONITOR_EXIT);
        ImmutableList primitiveCastMethods = OperatorConventions.NUMBER_CONVERSIONS.asList();
        for (Name method : primitiveCastMethods) {
            String methodName = method.asString();
            this.declareIntrinsicFunction("Number", methodName, 0, NUMBER_CAST);
            for (PrimitiveType type2 : PrimitiveType.NUMBER_TYPES) {
                this.declareIntrinsicFunction(type2.getTypeName().asString(), methodName, 0, NUMBER_CAST);
            }
        }
        for (PrimitiveType type3 : PrimitiveType.NUMBER_TYPES) {
            String typeName2 = type3.getTypeName().asString();
            this.declareIntrinsicFunction(typeName2, "plus", 0, UNARY_PLUS);
            this.declareIntrinsicFunction(typeName2, "minus", 0, UNARY_MINUS);
            this.declareIntrinsicFunction(typeName2, "inv", 0, INV);
            this.declareIntrinsicFunction(typeName2, "rangeTo", 1, RANGE_TO);
            this.declareIntrinsicFunction(typeName2, "inc", 0, INC);
            this.declareIntrinsicFunction(typeName2, "dec", 0, DEC);
        }
        for (PrimitiveType type4 : PrimitiveType.values()) {
            typeName = type4.getTypeName().asString();
            this.declareIntrinsicFunction(typeName, "equals", 1, EQUALS);
            this.declareIntrinsicFunction(typeName, "hashCode", 0, HASH_CODE);
            this.declareIntrinsicFunction(typeName, "toString", 0, TO_STRING);
        }
        this.declareBinaryOp("plus", 96);
        this.declareBinaryOp("minus", 100);
        this.declareBinaryOp("times", 104);
        this.declareBinaryOp("div", 108);
        this.declareBinaryOp("mod", 112);
        this.declareBinaryOp("shl", 120);
        this.declareBinaryOp("shr", 122);
        this.declareBinaryOp("ushr", 124);
        this.declareBinaryOp("and", 126);
        this.declareBinaryOp("or", 128);
        this.declareBinaryOp("xor", 130);
        this.declareIntrinsicFunction("Boolean", "not", 0, new Not());
        this.declareIntrinsicFunction("String", "plus", 1, new Concat());
        this.declareIntrinsicFunction("String", "get", 1, new StringGetChar());
        this.declareIntrinsicFunction("Cloneable", "clone", 0, CLONE);
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, KotlinBuiltIns.FQ_NAMES.any, "toString", 0, TO_STRING);
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, KotlinBuiltIns.FQ_NAMES.any, "identityEquals", 1, IDENTITY_EQUALS);
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, KotlinBuiltIns.FQ_NAMES.string, "plus", 1, STRING_PLUS);
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, null, "arrayOfNulls", 1, new NewArray());
        for (PrimitiveType type4 : PrimitiveType.values()) {
            typeName = type4.getTypeName().asString();
            this.declareIntrinsicFunction(typeName, "compareTo", 1, new CompareTo());
            this.declareIntrinsicFunction(typeName + "Iterator", "next", 0, ITERATOR_NEXT);
        }
        this.declareArrayMethods();
    }

    private void declareArrayMethods() {
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            this.declareArrayMethodsForPrimitive(jvmPrimitiveType);
        }
        this.declareIntrinsicFunction("Array", "size", 0, ARRAY_SIZE);
        this.declareIntrinsicFunction("Array", "set", 2, ARRAY_SET);
        this.declareIntrinsicFunction("Array", "get", 1, ARRAY_GET);
        this.declareIntrinsicFunction("Array", "clone", 0, CLONE);
        this.declareIterator("Array");
    }

    private void declareArrayMethodsForPrimitive(@NotNull JvmPrimitiveType jvmPrimitiveType) {
        if (jvmPrimitiveType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmPrimitiveType", "org/jetbrains/kotlin/codegen/intrinsics/IntrinsicMethods", "declareArrayMethodsForPrimitive"));
        }
        String arrayTypeName = jvmPrimitiveType.getPrimitiveType().getArrayTypeName().asString();
        this.declareIntrinsicFunction(arrayTypeName, "size", 0, ARRAY_SIZE);
        this.declareIntrinsicFunction(arrayTypeName, "set", 2, ARRAY_SET);
        this.declareIntrinsicFunction(arrayTypeName, "get", 1, ARRAY_GET);
        this.declareIntrinsicFunction(arrayTypeName, "clone", 0, CLONE);
        this.declareIterator(arrayTypeName);
    }

    private void declareIterator(@NotNull String arrayClassName) {
        if (arrayClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayClassName", "org/jetbrains/kotlin/codegen/intrinsics/IntrinsicMethods", "declareIterator"));
        }
        this.declareIntrinsicFunction(arrayClassName, "iterator", 0, ARRAY_ITERATOR);
    }

    private void declareBinaryOp(@NotNull String methodName, int opcode) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "org/jetbrains/kotlin/codegen/intrinsics/IntrinsicMethods", "declareBinaryOp"));
        }
        BinaryOp op = new BinaryOp(opcode);
        for (PrimitiveType type2 : PrimitiveType.values()) {
            this.declareIntrinsicFunction(type2.getTypeName().asString(), methodName, 1, op);
        }
    }

    private void declareIntrinsicFunction(@NotNull String className, @NotNull String methodName, int arity, @NotNull IntrinsicMethod implementation) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/kotlin/codegen/intrinsics/IntrinsicMethods", "declareIntrinsicFunction"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "org/jetbrains/kotlin/codegen/intrinsics/IntrinsicMethods", "declareIntrinsicFunction"));
        }
        if (implementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implementation", "org/jetbrains/kotlin/codegen/intrinsics/IntrinsicMethods", "declareIntrinsicFunction"));
        }
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier(className)), null, methodName, arity, implementation);
    }

    @Nullable
    public IntrinsicMethod getIntrinsic(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/intrinsics/IntrinsicMethods", "getIntrinsic"));
        }
        IntrinsicMethod intrinsicMethod = this.intrinsicsMap.getIntrinsic(descriptor2);
        if (intrinsicMethod != null) {
            return intrinsicMethod;
        }
        String value = CompileTimeConstantUtils.getIntrinsicAnnotationArgument(descriptor2);
        if (value != null) {
            return this.namedMethods.get(value);
        }
        return null;
    }
}

