/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.initializer;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.ClassTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStringLiteral;

public final class InitializerUtils {
    private InitializerUtils() {
    }

    @NotNull
    public static JsStatement generateInitializerForProperty(@NotNull TranslationContext context, @NotNull PropertyDescriptor descriptor2, @NotNull JsExpression value) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/initializer/InitializerUtils", "generateInitializerForProperty"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/initializer/InitializerUtils", "generateInitializerForProperty"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/js/translate/initializer/InitializerUtils", "generateInitializerForProperty"));
        }
        JsStatement jsStatement = TranslationUtils.assignmentToBackingField(context, descriptor2, value).makeStmt();
        if (jsStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/InitializerUtils", "generateInitializerForProperty"));
        }
        return jsStatement;
    }

    @Nullable
    public static JsStatement generateInitializerForDelegate(@NotNull TranslationContext context, @NotNull JetProperty property) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/initializer/InitializerUtils", "generateInitializerForDelegate"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/js/translate/initializer/InitializerUtils", "generateInitializerForDelegate"));
        }
        JetExpression delegate2 = property.getDelegateExpression();
        if (delegate2 != null) {
            JsExpression value = Translation.translateAsExpression(delegate2, context);
            String name = property.getName();
            assert (name != null) : "Delegate property must have name";
            return JsAstUtils.defineSimpleProperty(Namer.getDelegateName(name), value);
        }
        return null;
    }

    public static void generateObjectInitializer(@NotNull JetObjectDeclaration declaration, @NotNull List<JsStatement> initializers, @NotNull TranslationContext context) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/js/translate/initializer/InitializerUtils", "generateObjectInitializer"));
        }
        if (initializers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializers", "org/jetbrains/kotlin/js/translate/initializer/InitializerUtils", "generateObjectInitializer"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/initializer/InitializerUtils", "generateObjectInitializer"));
        }
        JsExpression value = ClassTranslator.generateObjectLiteral(declaration, context);
        ClassDescriptor descriptor2 = BindingUtils.getClassDescriptor(context.bindingContext(), declaration);
        JsExpression expression = JsAstUtils.assignment(new JsNameRef(descriptor2.getName().asString(), (JsExpression)JsLiteral.THIS), value);
        initializers.add(expression.makeStmt());
    }

    public static JsPropertyInitializer createCompanionObjectInitializer(JsExpression value, TranslationContext context) {
        JsStringLiteral companionObjectInitStr = context.program().getStringLiteral(Namer.getNameForCompanionObjectInitializer());
        return new JsPropertyInitializer(companionObjectInitStr, value);
    }
}

