/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.FromNativeContext;
import com.sun.jna.NativeMapped;

public abstract class IntegerType
extends Number
implements NativeMapped {
    private int size;
    private Number number;
    private long value;

    public IntegerType(int size, long value) {
        this.size = size;
        this.setValue(value);
    }

    public void setValue(long value) {
        long truncated = value;
        this.value = value;
        switch (this.size) {
            case 1: {
                truncated = (byte)value;
                this.number = new Byte((byte)value);
                break;
            }
            case 2: {
                truncated = (short)value;
                this.number = new Short((short)value);
                break;
            }
            case 4: {
                truncated = (int)value;
                this.number = new Integer((int)value);
                break;
            }
            case 8: {
                this.number = new Long(value);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer().append("Unsupported size: ").append(this.size).toString());
            }
        }
        if (this.size < 8) {
            long mask = (1L << this.size * 8) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            if (value < 0L && truncated != value || value >= 0L && (mask & value) != 0L) {
                throw new IllegalArgumentException(new StringBuffer().append("Argument value 0x").append(Long.toHexString(value)).append(" exceeds native capacity (").append(this.size).append(" bytes) mask=0x").append(Long.toHexString(mask)).toString());
            }
        }
    }

    @Override
    public Object toNative() {
        return this.number;
    }

    @Override
    public Object fromNative(Object nativeValue, FromNativeContext context) {
        long value = nativeValue == null ? 0L : ((Number)nativeValue).longValue();
        try {
            IntegerType number = (IntegerType)this.getClass().newInstance();
            number.setValue(value);
            return number;
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(new StringBuffer().append("Can't instantiate ").append(this.getClass()).toString());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(new StringBuffer().append("Not allowed to instantiate ").append(this.getClass()).toString());
        }
    }

    @Override
    public Class nativeType() {
        return this.number.getClass();
    }

    @Override
    public int intValue() {
        return this.number.intValue();
    }

    @Override
    public long longValue() {
        return this.number.longValue();
    }

    @Override
    public float floatValue() {
        return this.number.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.number.doubleValue();
    }

    public boolean equals(Object rhs) {
        return rhs instanceof IntegerType && this.number.equals(((IntegerType)rhs).number);
    }

    public String toString() {
        return this.number.toString();
    }

    public int hashCode() {
        return this.number.hashCode();
    }
}

