/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.parser;

import com.intellij.openapi.util.text.StringUtil;

public enum KDocKnownTag {
    AUTHOR(false, false),
    THROWS(true, false),
    EXCEPTION(true, false),
    PARAM(true, false),
    RETURN(false, false),
    SEE(true, false),
    SINCE(false, false),
    CONSTRUCTOR(false, true),
    PROPERTY(true, true),
    SAMPLE(true, false);

    private final boolean takesReference;
    private final boolean startsSection;

    private KDocKnownTag(boolean takesReference, boolean startsSection) {
        this.takesReference = takesReference;
        this.startsSection = startsSection;
    }

    public boolean isReferenceRequired() {
        return this.takesReference;
    }

    public boolean isSectionStart() {
        return this.startsSection;
    }

    public static KDocKnownTag findByTagName(CharSequence tagName) {
        if (StringUtil.startsWith(tagName, "@")) {
            tagName = tagName.subSequence(1, tagName.length());
        }
        try {
            return KDocKnownTag.valueOf(((Object)tagName).toString().toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

