/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetPostfixExpression;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetRootPackageExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ScriptReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;

public class DataFlowValueFactory {
    private static final IdentifierInfo NO_IDENTIFIER_INFO = new IdentifierInfo(null, false, false, false){

        public String toString() {
            return "NO_IDENTIFIER_INFO";
        }
    };

    private DataFlowValueFactory() {
    }

    @NotNull
    public static DataFlowValue createDataFlowValue(@NotNull JetExpression expression, @NotNull JetType type2, @NotNull ResolutionContext resolutionContext) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (resolutionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression, type2, resolutionContext.trace.getBindingContext(), resolutionContext.scope.getOwnerDescriptor());
        if (dataFlowValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        return dataFlowValue;
    }

    @NotNull
    public static DataFlowValue createDataFlowValue(@NotNull JetExpression expression, @NotNull JetType type2, @NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor containingDeclarationOrModule) {
        JetConstantExpression constantExpression;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (containingDeclarationOrModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclarationOrModule", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (expression instanceof JetConstantExpression && (constantExpression = (JetConstantExpression)expression).getNode().getElementType() == JetNodeTypes.NULL) {
            DataFlowValue dataFlowValue = DataFlowValue.NULL;
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        if (type2.isError()) {
            DataFlowValue dataFlowValue = DataFlowValue.ERROR;
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        if (KotlinBuiltIns.isNullableNothing(type2)) {
            DataFlowValue dataFlowValue = DataFlowValue.NULL;
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        if (ExpressionTypingUtils.isExclExclExpression(JetPsiUtil.deparenthesize(expression))) {
            DataFlowValue dataFlowValue = new DataFlowValue(expression, type2, false, false, Nullability.NOT_NULL);
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        IdentifierInfo result2 = DataFlowValueFactory.getIdForStableIdentifier(expression, bindingContext, containingDeclarationOrModule);
        DataFlowValue dataFlowValue = new DataFlowValue(result2 == NO_IDENTIFIER_INFO ? expression : result2.id, type2, result2.isStable, result2.isLocal, DataFlowValueFactory.getImmanentNullability(type2));
        if (dataFlowValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        return dataFlowValue;
    }

    @NotNull
    public static DataFlowValue createDataFlowValue(@NotNull ThisReceiver receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        JetType type2 = receiver.getType();
        DataFlowValue dataFlowValue = new DataFlowValue(receiver, type2, true, false, DataFlowValueFactory.getImmanentNullability(type2));
        if (dataFlowValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        return dataFlowValue;
    }

    @NotNull
    public static DataFlowValue createDataFlowValue(@NotNull ReceiverValue receiverValue, @NotNull ResolutionContext resolutionContext) {
        if (receiverValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValue", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (resolutionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiverValue, resolutionContext.trace.getBindingContext(), resolutionContext.scope.getOwnerDescriptor());
        if (dataFlowValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        return dataFlowValue;
    }

    @NotNull
    public static DataFlowValue createDataFlowValue(@NotNull ReceiverValue receiverValue, @NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor containingDeclarationOrModule) {
        if (receiverValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValue", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (containingDeclarationOrModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclarationOrModule", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (receiverValue instanceof TransientReceiver || receiverValue instanceof ScriptReceiver) {
            JetType type2 = receiverValue.getType();
            DataFlowValue dataFlowValue = new DataFlowValue(receiverValue, type2, true, false, DataFlowValueFactory.getImmanentNullability(type2));
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        if (receiverValue instanceof ClassReceiver || receiverValue instanceof ExtensionReceiver) {
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue((ThisReceiver)receiverValue);
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        if (receiverValue instanceof ExpressionReceiver) {
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(((ExpressionReceiver)receiverValue).getExpression(), receiverValue.getType(), bindingContext, containingDeclarationOrModule);
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        if (receiverValue == ReceiverValue.NO_RECEIVER) {
            throw new IllegalArgumentException("No DataFlowValue exists for ReceiverValue.NO_RECEIVER");
        }
        throw new UnsupportedOperationException("Unsupported receiver value: " + receiverValue.getClass().getName());
    }

    @NotNull
    public static DataFlowValue createDataFlowValue(@NotNull VariableDescriptor variableDescriptor, @NotNull BindingContext bindingContext, @Nullable ModuleDescriptor usageContainingModule) {
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        JetType type2 = variableDescriptor.getType();
        DataFlowValue dataFlowValue = new DataFlowValue(variableDescriptor, type2, DataFlowValueFactory.isStableVariable(variableDescriptor, usageContainingModule), DataFlowValueFactory.isUncapturedLocalVariable(variableDescriptor, bindingContext), DataFlowValueFactory.getImmanentNullability(type2));
        if (dataFlowValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        return dataFlowValue;
    }

    @NotNull
    private static Nullability getImmanentNullability(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getImmanentNullability"));
        }
        Nullability nullability = TypeUtils.isNullableType(type2) ? Nullability.UNKNOWN : Nullability.NOT_NULL;
        if (nullability == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getImmanentNullability"));
        }
        return nullability;
    }

    @NotNull
    private static IdentifierInfo createInfo(Object id, boolean isStable, boolean isLocal) {
        IdentifierInfo identifierInfo = new IdentifierInfo(id, isStable, isLocal, false);
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createInfo"));
        }
        return identifierInfo;
    }

    @NotNull
    private static IdentifierInfo createStableInfo(Object id) {
        IdentifierInfo identifierInfo = DataFlowValueFactory.createInfo(id, true, false);
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createStableInfo"));
        }
        return identifierInfo;
    }

    @NotNull
    private static IdentifierInfo createPackageOrClassInfo(Object id) {
        IdentifierInfo identifierInfo = new IdentifierInfo(id, true, false, true);
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createPackageOrClassInfo"));
        }
        return identifierInfo;
    }

    @NotNull
    private static IdentifierInfo combineInfo(@Nullable IdentifierInfo receiverInfo, @NotNull IdentifierInfo selectorInfo) {
        if (selectorInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "combineInfo"));
        }
        if (selectorInfo.id == null || receiverInfo == NO_IDENTIFIER_INFO) {
            IdentifierInfo identifierInfo = NO_IDENTIFIER_INFO;
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "combineInfo"));
            }
            return identifierInfo;
        }
        if (receiverInfo == null || receiverInfo.isPackage) {
            IdentifierInfo identifierInfo = selectorInfo;
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "combineInfo"));
            }
            return identifierInfo;
        }
        IdentifierInfo identifierInfo = DataFlowValueFactory.createInfo(Pair.create(receiverInfo.id, selectorInfo.id), receiverInfo.isStable && selectorInfo.isStable, false);
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "combineInfo"));
        }
        return identifierInfo;
    }

    @NotNull
    private static IdentifierInfo createPostfixInfo(@NotNull JetPostfixExpression expression, @NotNull IdentifierInfo argumentInfo) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createPostfixInfo"));
        }
        if (argumentInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createPostfixInfo"));
        }
        if (argumentInfo == NO_IDENTIFIER_INFO) {
            IdentifierInfo identifierInfo = NO_IDENTIFIER_INFO;
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createPostfixInfo"));
            }
            return identifierInfo;
        }
        IdentifierInfo identifierInfo = DataFlowValueFactory.createInfo(Pair.create(expression, argumentInfo.id), argumentInfo.isStable, argumentInfo.isLocal);
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createPostfixInfo"));
        }
        return identifierInfo;
    }

    @NotNull
    private static IdentifierInfo getIdForStableIdentifier(@Nullable JetExpression expression, @NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor containingDeclarationOrModule) {
        JetExpression deparenthesized;
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForStableIdentifier"));
        }
        if (containingDeclarationOrModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclarationOrModule", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForStableIdentifier"));
        }
        if (expression != null && expression != (deparenthesized = JetPsiUtil.deparenthesize(expression))) {
            IdentifierInfo identifierInfo = DataFlowValueFactory.getIdForStableIdentifier(deparenthesized, bindingContext, containingDeclarationOrModule);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForStableIdentifier"));
            }
            return identifierInfo;
        }
        if (expression instanceof JetQualifiedExpression) {
            JetQualifiedExpression qualifiedExpression = (JetQualifiedExpression)expression;
            JetExpression receiverExpression = qualifiedExpression.getReceiverExpression();
            JetExpression selectorExpression = qualifiedExpression.getSelectorExpression();
            IdentifierInfo receiverId = DataFlowValueFactory.getIdForStableIdentifier(receiverExpression, bindingContext, containingDeclarationOrModule);
            IdentifierInfo selectorId = DataFlowValueFactory.getIdForStableIdentifier(selectorExpression, bindingContext, containingDeclarationOrModule);
            IdentifierInfo identifierInfo = DataFlowValueFactory.combineInfo(receiverId, selectorId);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForStableIdentifier"));
            }
            return identifierInfo;
        }
        if (expression instanceof JetSimpleNameExpression) {
            IdentifierInfo identifierInfo = DataFlowValueFactory.getIdForSimpleNameExpression((JetSimpleNameExpression)expression, bindingContext, containingDeclarationOrModule);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForStableIdentifier"));
            }
            return identifierInfo;
        }
        if (expression instanceof JetThisExpression) {
            JetThisExpression thisExpression = (JetThisExpression)expression;
            DeclarationDescriptor declarationDescriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, thisExpression.getInstanceReference());
            IdentifierInfo identifierInfo = DataFlowValueFactory.getIdForThisReceiver(declarationDescriptor);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForStableIdentifier"));
            }
            return identifierInfo;
        }
        if (expression instanceof JetPostfixExpression) {
            JetPostfixExpression postfixExpression = (JetPostfixExpression)expression;
            IElementType operationType = postfixExpression.getOperationReference().getReferencedNameElementType();
            if (operationType == JetTokens.PLUSPLUS || operationType == JetTokens.MINUSMINUS) {
                IdentifierInfo identifierInfo = DataFlowValueFactory.createPostfixInfo(postfixExpression, DataFlowValueFactory.getIdForStableIdentifier(postfixExpression.getBaseExpression(), bindingContext, containingDeclarationOrModule));
                if (identifierInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForStableIdentifier"));
                }
                return identifierInfo;
            }
        } else if (expression instanceof JetRootPackageExpression) {
            // empty if block
        }
        IdentifierInfo identifierInfo = NO_IDENTIFIER_INFO;
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForStableIdentifier"));
        }
        return identifierInfo;
    }

    @NotNull
    private static IdentifierInfo getIdForSimpleNameExpression(@NotNull JetSimpleNameExpression simpleNameExpression, @NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor containingDeclarationOrModule) {
        if (simpleNameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleNameExpression", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForSimpleNameExpression"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForSimpleNameExpression"));
        }
        if (containingDeclarationOrModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclarationOrModule", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForSimpleNameExpression"));
        }
        DeclarationDescriptor declarationDescriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, simpleNameExpression);
        if (declarationDescriptor instanceof VariableDescriptor) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(simpleNameExpression, bindingContext);
            ModuleDescriptor usageModuleDescriptor = DescriptorUtils.getContainingModuleOrNull(containingDeclarationOrModule);
            IdentifierInfo receiverInfo = resolvedCall != null ? DataFlowValueFactory.getIdForImplicitReceiver(resolvedCall.getDispatchReceiver(), simpleNameExpression) : null;
            VariableDescriptor variableDescriptor = (VariableDescriptor)declarationDescriptor;
            IdentifierInfo identifierInfo = DataFlowValueFactory.combineInfo(receiverInfo, DataFlowValueFactory.createInfo(variableDescriptor, DataFlowValueFactory.isStableVariable(variableDescriptor, usageModuleDescriptor), DataFlowValueFactory.isUncapturedLocalVariable(variableDescriptor, bindingContext)));
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForSimpleNameExpression"));
            }
            return identifierInfo;
        }
        if (declarationDescriptor instanceof PackageViewDescriptor || declarationDescriptor instanceof ClassDescriptor) {
            IdentifierInfo identifierInfo = DataFlowValueFactory.createPackageOrClassInfo(declarationDescriptor);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForSimpleNameExpression"));
            }
            return identifierInfo;
        }
        IdentifierInfo identifierInfo = NO_IDENTIFIER_INFO;
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForSimpleNameExpression"));
        }
        return identifierInfo;
    }

    @Nullable
    private static IdentifierInfo getIdForImplicitReceiver(@NotNull ReceiverValue receiverValue, @Nullable JetExpression expression) {
        if (receiverValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValue", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForImplicitReceiver"));
        }
        if (receiverValue instanceof ThisReceiver) {
            return DataFlowValueFactory.getIdForThisReceiver(((ThisReceiver)receiverValue).getDeclarationDescriptor());
        }
        assert (!(receiverValue instanceof TransientReceiver)) : "Transient receiver is implicit for an explicit expression: " + expression + ". Receiver: " + receiverValue;
        return null;
    }

    @NotNull
    private static IdentifierInfo getIdForThisReceiver(@Nullable DeclarationDescriptor descriptorOfThisReceiver) {
        if (descriptorOfThisReceiver instanceof CallableDescriptor) {
            ReceiverParameterDescriptor receiverParameter = ((CallableDescriptor)descriptorOfThisReceiver).getExtensionReceiverParameter();
            assert (receiverParameter != null) : "'This' refers to the callable member without a receiver parameter: " + descriptorOfThisReceiver;
            IdentifierInfo identifierInfo = DataFlowValueFactory.createStableInfo(receiverParameter.getValue());
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForThisReceiver"));
            }
            return identifierInfo;
        }
        if (descriptorOfThisReceiver instanceof ClassDescriptor) {
            IdentifierInfo identifierInfo = DataFlowValueFactory.createStableInfo(((ClassDescriptor)descriptorOfThisReceiver).getThisAsReceiverParameter().getValue());
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForThisReceiver"));
            }
            return identifierInfo;
        }
        IdentifierInfo identifierInfo = NO_IDENTIFIER_INFO;
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForThisReceiver"));
        }
        return identifierInfo;
    }

    public static boolean isUncapturedLocalVariable(@NotNull VariableDescriptor variableDescriptor, @NotNull BindingContext bindingContext) {
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "isUncapturedLocalVariable"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "isUncapturedLocalVariable"));
        }
        return variableDescriptor.isVar() && variableDescriptor instanceof LocalVariableDescriptor && !BindingContextUtils.isVarCapturedInClosure(bindingContext, variableDescriptor);
    }

    public static boolean isStableVariable(@NotNull VariableDescriptor variableDescriptor, @Nullable ModuleDescriptor usageModule) {
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "isStableVariable"));
        }
        if (variableDescriptor.isVar()) {
            return false;
        }
        if (variableDescriptor instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variableDescriptor;
            if (!DataFlowValueFactory.isFinal(propertyDescriptor)) {
                return false;
            }
            if (!DataFlowValueFactory.hasDefaultGetter(propertyDescriptor)) {
                return false;
            }
            if (!DataFlowValueFactory.invisibleFromOtherModules(propertyDescriptor)) {
                ModuleDescriptor declarationModule = DescriptorUtils.getContainingModule(propertyDescriptor);
                if (usageModule == null || !usageModule.equals(declarationModule)) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isFinal(PropertyDescriptor propertyDescriptor) {
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            if (classDescriptor.getModality().isOverridable() && propertyDescriptor.getModality().isOverridable()) {
                return false;
            }
        } else if (propertyDescriptor.getModality().isOverridable()) {
            throw new IllegalStateException("Property outside a class must not be overridable: " + propertyDescriptor.getName());
        }
        return true;
    }

    private static boolean invisibleFromOtherModules(@NotNull DeclarationDescriptorWithVisibility descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "invisibleFromOtherModules"));
        }
        if (Visibilities.INVISIBLE_FROM_OTHER_MODULES.contains(descriptor2.getVisibility())) {
            return true;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (!(containingDeclaration instanceof DeclarationDescriptorWithVisibility)) {
            return false;
        }
        return DataFlowValueFactory.invisibleFromOtherModules((DeclarationDescriptorWithVisibility)containingDeclaration);
    }

    private static boolean hasDefaultGetter(PropertyDescriptor propertyDescriptor) {
        PropertyGetterDescriptor getter2 = propertyDescriptor.getGetter();
        return getter2 == null || getter2.isDefault();
    }

    private static class IdentifierInfo {
        public final Object id;
        public final boolean isStable;
        public final boolean isLocal;
        public final boolean isPackage;

        private IdentifierInfo(Object id, boolean isStable, boolean isLocal, boolean isPackage) {
            assert (!isStable || !isLocal) : "Identifier info for object " + id + " cannot be stable and local at one time";
            this.id = id;
            this.isStable = isStable;
            this.isLocal = isLocal;
            this.isPackage = isPackage;
        }
    }
}

