/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import kotlin.IndexedValue;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetMultiDeclaration;
import org.jetbrains.kotlin.psi.JetMultiDeclarationEntry;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.dataClassUtils.DataClassUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.FakeCallResolver;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"2\n)AR*\u001e7uS\u0012+7\r\\1sCRLwN\u001c*fg>dg/\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TQ\u0001^=qKNT1\"\u001a=qe\u0016\u001c8/[8og*\u0019\u0011I\\=\u000b\rqJg.\u001b;?\u0015A1\u0017m[3DC2d'+Z:pYZ,'O\u0003\tGC.,7)\u00197m%\u0016\u001cx\u000e\u001c<fe*\u0011B-Z:de&\u0004Ho\u001c:SKN|GN^3s\u0015I!Um]2sSB$xN\u001d*fg>dg/\u001a:\u000b\u000fI,7o\u001c7wK*aA/\u001f9f%\u0016\u001cx\u000e\u001c<fe*aA+\u001f9f%\u0016\u001cx\u000e\u001c<fe*!2/_7c_2,6/Y4f-\u0006d\u0017\u000eZ1u_JTAcU=nE>dWk]1hKZ\u000bG.\u001b3bi>\u0014(B\u0003<bY&$\u0017\r^5p]*AC-\u001a4j]\u0016dunY1m-\u0006\u0014\u0018.\u00192mKN4%o\\7Nk2$\u0018\u000eR3dY\u0006\u0014\u0018\r^5p]*iqO]5uC\ndWmU2pa\u0016TA\u0003T3yS\u000e\fGn\u0016:ji\u0006\u0014G.Z*d_B,'BB:d_B,7O\u0003\tnk2$\u0018\u000eR3dY\u0006\u0014\u0018\r^5p]*\u0019\"*\u001a;Nk2$\u0018\u000eR3dY\u0006\u0014\u0018\r^5p]*\u0019\u0001o]5\u000b\u0011I,7-Z5wKJTQBU3dK&4XM\u001d,bYV,'\"\u0003:fG\u0016Lg/\u001a:t\u00159\u0011X\r]8si\u0016\u0013(o\u001c:t\u001f:TQBS3u\u000bb\u0004(/Z:tS>t'bB2p]R,\u0007\u0010\u001e\u0006\u0018\u000bb\u0004(/Z:tS>tG+\u001f9j]\u001e\u001cuN\u001c;fqRTA!\u00168ji*Yr-\u001a;FqB,7\r^3e)f\u0004XMR8s\u0007>l\u0007o\u001c8f]RTQ!\u001a8uefT\u0001DS3u\u001bVdG/\u001b#fG2\f'/\u0019;j_:,e\u000e\u001e:z\u0015\u001dQU\r\u001e+za\u0016\u0004 A\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0003!\rQa\u0001\u0003\u0004\u0011\ra\u0001!B\u0002\u0005\u0005!%A\u0002A\u0003\u0003\t\u0005Aa!B\u0002\u0005\n!-A\u0002A\u0003\u0004\t\u0013Aq\u0001\u0004\u0001\u0006\u0005\u0011%\u0001\u0012C\u0003\u0004\t\u0019A\u0001\u0002\u0004\u0001\u0006\u0005\u0011\u0011\u0001\u0012B\u0003\u0003\t\u0013AY!\u0002\u0002\u0005\n!9QA\u0001\u0003\u0007\u0011!)!\u0001\"\u0003\t\u0016\u0015\u0019A!\u0003\u0005\u000b\u0019\u0001)!\u0001B\u0001\t\u0019\u0015\u0019AA\u0003E\f\u0019\u0001)!\u0001B\u0005\t\u001c\u0015\u0019Aa\u0003\u0005\u000e\u0019\u0001)1\u0001\u0002\u0006\t\u001e1\u0001Qa\u0001\u0003\u0003\u0011?a\u0001!B\u0002\u0005\u0007!\u0001B\u0002A\u0003\u0003\t%A!\"\u0002\u0002\u0005\u0015!]QA\u0001\u0003\f\u00115)!\u0001\u0002\u0006\t\u001e\u0015\u0011AA\u0001E\u0010\u000b\r!!\u0002c\t\r\u0001\u0015\u0019A1\u0001\u0005\u0013\u0019\u0001)!\u0001b\u0001\t%\u0015\u0011AA\u0003E\u0012\t\ra)!G\u0002\u0006\u0003!\u001d\u0001tA\u0017\r\t\u0005$\u0001$B\u0011\u0004\u000b\u0005AQ\u0001G\u0003V\u0007\u0011)1\u0001B\u0003\n\u0003!=Q\u0006\u0004\u0003b\ta!\u0011eA\u0003\u0002\u0011\u0011AB!V\u0002\u0005\u000b\r!A!C\u0001\t\u000f5bA!\u0019\u0003\u0019\u0010\u0005\u001aQ!\u0001E\u00071\u001b)6\u0001B\u0003\u0004\t\u001fI\u0011\u0001#\u0005.\u0019\u0011\tG\u0001'\u0004\"\u0007\u0015\t\u00012\u0002M\u0006+\u000e!Qa\u0001C\u0007\u0013\u0005A\u0001\"L \u0005\u0007aIQt\u0002\u0003\u0001\u0011'i1!B\u0001\t\u0014aM\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001bC\u0007\u0004\u000b\u0005A)\u0002'\u0006Q\u0007\u0003iz\u0001\u0002\u0001\t\u001a5\u0019Q!\u0001E\f1/\u00016!AO\b\t\u0001Aa\"D\u0002\u0006\u0003!a\u0001\u0004\u0004)\u0004\u0004u=A\u0001\u0001\u0005\u0010\u001b\r)\u0011\u0001#\u0007\u0019\u001aA\u001b!!I\u0002\u0006\u0003!i\u0001$D)\u0004\u001b\u0011I\u0011\"\u0001\u0003\u0001\u001b\u0005AY\"D\u0001\t\u001d5\t\u0001RD\u0007\u0002\u0011=i\u0011\u0001c\b.@\u0011\t\u0001\u0014EO\b\t\u0001Aq\"D\u0002\u0006\u0003!e\u0001\u0014\u0004)\u0004\u0001u=A\u0001\u0001\u0005\u0012\u001b\r)\u0011\u0001\u0003\t\u0019!A\u001b\t!I\u0002\u0006\u0003!\u0005\u0002\u0014E)\u0004\u000f\u0011\u0005\u0012\"\u0001\u0005\u0012\u001b\u0005Ay\"D\u0001\t$U2T!\u000e\u0003d\u0002a\u001dQt\u0002\u0003\u0001\u0011\u0011i1!B\u0001\t\ta!\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\"B\u0007\u0004\u000b\u0005AQ\u0001G\u0003Q\u0007\u0003iz\u0001\u0002\u0001\t\u000e5\u0019Q!\u0001E\u00061\u0017\u00016!AO\b\t\u0001Ay!D\u0002\u0006\u0003!5\u0001T\u0002)\u0004\u0004\u0005\u001aQ!\u0001E\u00031\u000b\t6a\u0003C\u0004\u0013\u0005!\u0001!D\u0001\t\u000f5\t\u0001rB\u0007\u0002\u0011!i\u0011\u0001#\u0005"})
public final class MultiDeclarationResolver {
    public static final /* synthetic */ KClass $kotlinClass;
    private final FakeCallResolver fakeCallResolver;
    private final DescriptorResolver descriptorResolver;
    private final TypeResolver typeResolver;
    private final SymbolUsageValidator symbolUsageValidator;

    static {
        $kotlinClass = Reflection.createKotlinClass(MultiDeclarationResolver.class);
    }

    public final void defineLocalVariablesFromMultiDeclaration(@NotNull LexicalWritableScope writableScope, @NotNull JetMultiDeclaration multiDeclaration, @NotNull ReceiverValue receiver, @NotNull JetExpression reportErrorsOn, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkParameterIsNotNull(writableScope, "writableScope");
        Intrinsics.checkParameterIsNotNull(multiDeclaration, "multiDeclaration");
        Intrinsics.checkParameterIsNotNull(receiver, "receiver");
        Intrinsics.checkParameterIsNotNull(reportErrorsOn, "reportErrorsOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        for (IndexedValue indexedValue : KotlinPackage.withIndex((Iterable)multiDeclaration.getEntries())) {
            int componentIndex = indexedValue.component1();
            JetMultiDeclarationEntry entry = (JetMultiDeclarationEntry)indexedValue.component2();
            Name componentName = DataClassUtilsKt.createComponentName(componentIndex + 1);
            JetMultiDeclarationEntry jetMultiDeclarationEntry = entry;
            Intrinsics.checkExpressionValueIsNotNull(jetMultiDeclarationEntry, "entry");
            JetType expectedType = this.getExpectedTypeForComponent(context, jetMultiDeclarationEntry);
            ExpressionTypingContext expressionTypingContext = (ExpressionTypingContext)context.replaceExpectedType(expectedType);
            Intrinsics.checkExpressionValueIsNotNull(expressionTypingContext, "context.replaceExpectedType(expectedType)");
            JetExpression jetExpression = entry;
            Intrinsics.checkExpressionValueIsNotNull(jetExpression, "entry");
            OverloadResolutionResults<FunctionDescriptor> results = this.fakeCallResolver.resolveFakeCall(expressionTypingContext, receiver, componentName, jetExpression);
            JetType componentType = null;
            if (results.isSuccess()) {
                context.trace.record(BindingContext.COMPONENT_RESOLVED_CALL, entry, results.getResultingCall());
                FunctionDescriptor functionDescriptor = results.getResultingDescriptor();
                CallableDescriptor callableDescriptor = functionDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(callableDescriptor, "functionDescriptor");
                BindingTrace bindingTrace = context.trace;
                Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
                PsiElement psiElement = entry;
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "entry");
                this.symbolUsageValidator.validateCall(callableDescriptor, bindingTrace, psiElement);
                componentType = functionDescriptor.getReturnType();
                if (componentType != null && !TypeUtils.noExpectedType(expectedType) && !JetTypeChecker.DEFAULT.isSubtypeOf(componentType, expectedType)) {
                    context.trace.report(Errors.COMPONENT_FUNCTION_RETURN_TYPE_MISMATCH.on((JetExpression)((PsiElement)reportErrorsOn), componentName, componentType, expectedType));
                }
            } else if (results.isAmbiguity()) {
                context.trace.report(Errors.COMPONENT_FUNCTION_AMBIGUITY.on((JetExpression)((PsiElement)reportErrorsOn), componentName, results.getResultingCalls()));
            } else {
                context.trace.report(Errors.COMPONENT_FUNCTION_MISSING.on((JetExpression)((PsiElement)reportErrorsOn), componentName, receiver.getType()));
            }
            if (componentType == null) {
                componentType = ErrorUtils.createErrorType(componentName + "() return type");
            }
            LocalVariableDescriptor variableDescriptor = this.descriptorResolver.resolveLocalVariableDescriptorWithType(writableScope, entry, componentType, context.trace);
            LexicalScope lexicalScope = writableScope;
            Name name = variableDescriptor.getName();
            Intrinsics.checkExpressionValueIsNotNull(name, "variableDescriptor.getName()");
            VariableDescriptor olderVariable = ScopeUtilsKt.getLocalVariable(lexicalScope, name);
            ExpressionTypingUtils.checkVariableShadowing(context, variableDescriptor, olderVariable);
            VariableDescriptor variableDescriptor2 = variableDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(variableDescriptor2, "variableDescriptor");
            writableScope.addVariableDescriptor(variableDescriptor2);
        }
    }

    private final JetType getExpectedTypeForComponent(ExpressionTypingContext context, JetMultiDeclarationEntry entry) {
        JetTypeReference jetTypeReference = entry.getTypeReference();
        if (jetTypeReference == null) {
            JetType jetType = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkExpressionValueIsNotNull(jetType, "TypeUtils.NO_EXPECTED_TYPE");
            return jetType;
        }
        JetTypeReference entryTypeRef = jetTypeReference;
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
        JetTypeReference jetTypeReference2 = entryTypeRef;
        Intrinsics.checkExpressionValueIsNotNull(jetTypeReference2, "entryTypeRef");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        return this.typeResolver.resolveType(lexicalScope, jetTypeReference2, bindingTrace, true);
    }

    public MultiDeclarationResolver(@NotNull FakeCallResolver fakeCallResolver, @NotNull DescriptorResolver descriptorResolver, @NotNull TypeResolver typeResolver, @NotNull SymbolUsageValidator symbolUsageValidator) {
        Intrinsics.checkParameterIsNotNull(fakeCallResolver, "fakeCallResolver");
        Intrinsics.checkParameterIsNotNull(descriptorResolver, "descriptorResolver");
        Intrinsics.checkParameterIsNotNull(typeResolver, "typeResolver");
        Intrinsics.checkParameterIsNotNull(symbolUsageValidator, "symbolUsageValidator");
        this.fakeCallResolver = fakeCallResolver;
        this.descriptorResolver = descriptorResolver;
        this.typeResolver = typeResolver;
        this.symbolUsageValidator = symbolUsageValidator;
    }
}

