/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.MostlySingularMultiMap;
import org.jetbrains.annotations.NotNull;

public class SymbolCollectingProcessor
extends BaseScopeProcessor
implements ElementClassHint {
    private final MostlySingularMultiMap<String, ResultWithContext> myResult = new MostlySingularMultiMap();
    private PsiElement myCurrentFileContext = null;

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/intellij/psi/impl/source/resolve/SymbolCollectingProcessor", "getHint"));
        }
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        return null;
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/source/resolve/SymbolCollectingProcessor", "handleEvent"));
        }
        if (event == JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT) {
            this.myCurrentFileContext = (PsiElement)associated;
        }
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        PsiNamedElement named;
        String name;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/SymbolCollectingProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/resolve/SymbolCollectingProcessor", "execute"));
        }
        if (element instanceof PsiNamedElement && element.isValid() && (name = (named = (PsiNamedElement)element).getName()) != null) {
            this.myResult.add(name, new ResultWithContext(named, this.myCurrentFileContext));
        }
        return true;
    }

    @Override
    public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
        return kind == ElementClassHint.DeclarationKind.CLASS || kind == ElementClassHint.DeclarationKind.PACKAGE || kind == ElementClassHint.DeclarationKind.METHOD || kind == ElementClassHint.DeclarationKind.FIELD;
    }

    public MostlySingularMultiMap<String, ResultWithContext> getResults() {
        return this.myResult;
    }

    public static class ResultWithContext {
        private final PsiAnchor myElement;
        private final PsiAnchor myFileContext;

        public ResultWithContext(@NotNull PsiNamedElement element, PsiElement fileContext) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/SymbolCollectingProcessor$ResultWithContext", "<init>"));
            }
            this.myElement = PsiAnchor.create(element);
            this.myFileContext = fileContext == null ? null : PsiAnchor.create(fileContext);
        }

        @NotNull
        public PsiNamedElement getElement() {
            PsiElement element = this.myElement.retrieve();
            if (element == null) {
                String message = "Anchor hasn't survived: " + this.myElement;
                if (this.myElement instanceof PsiAnchor.StubIndexReference) {
                    message = message + "; diagnostics=" + ((PsiAnchor.StubIndexReference)this.myElement).diagnoseNull();
                }
                throw new AssertionError((Object)message);
            }
            PsiNamedElement psiNamedElement = (PsiNamedElement)element;
            if (psiNamedElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/SymbolCollectingProcessor$ResultWithContext", "getElement"));
            }
            return psiNamedElement;
        }

        public PsiElement getFileContext() {
            return this.myFileContext == null ? null : this.myFileContext.retrieve();
        }

        public String toString() {
            return this.myElement.toString();
        }
    }
}

