/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.typeEnhacement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.CompositeAnnotations;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhacement.EnhancedTypeAnnotations;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhacement.EnhancementResult;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhacement.JavaTypeQualifiers;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhacement.MutabilityQualifier;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhacement.NullabilityQualifier;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhacement.Result;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhacement.TypeComponentPosition;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.platform.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.JetScope;
import kotlin.reflect.jvm.internal.impl.types.DelegatingFlexibleType;
import kotlin.reflect.jvm.internal.impl.types.Flexibility;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.JetTypeImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeCapabilities;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypesPackage;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilPackage;
import kotlin.reflect.jvm.internal.impl.utils.UtilsPackage;
import org.jetbrains.annotations.NotNull;

final class TypeEnhacementPackage__TypeEnhancementKt {
    @NotNull
    static final EnhancedTypeAnnotations ENHANCED_NULLABILITY_ANNOTATIONS;
    @NotNull
    static final EnhancedTypeAnnotations ENHANCED_MUTABILITY_ANNOTATIONS;

    @NotNull
    public static final JetType enhance(JetType $receiver, @NotNull Function1<? super Integer, ? extends JavaTypeQualifiers> qualifiers) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(qualifiers, "qualifiers");
        return TypeEnhacementPackage__TypeEnhancementKt.enhancePossiblyFlexible($receiver, qualifiers, 0).getType();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Result enhancePossiblyFlexible(JetType $receiver, @NotNull Function1<? super Integer, ? extends JavaTypeQualifiers> qualifiers, int index2) {
        Result result2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(qualifiers, "qualifiers");
        if ($receiver.isError()) {
            return new Result($receiver, 1);
        }
        if (TypesPackage.isFlexible($receiver)) {
            void value;
            Flexibility receiver = TypesPackage.flexibility($receiver);
            Flexibility $receiver2 = receiver;
            Result lowerResult = TypeEnhacementPackage__TypeEnhancementKt.enhanceInflexible($receiver2.getLowerBound(), qualifiers, index2, TypeComponentPosition.FLEXIBLE_LOWER);
            Result upperResult = TypeEnhacementPackage__TypeEnhancementKt.enhanceInflexible($receiver2.getUpperBound(), qualifiers, index2, TypeComponentPosition.FLEXIBLE_UPPER);
            boolean bl = lowerResult.getSubtreeSize() == upperResult.getSubtreeSize();
            if (KotlinPackage.getASSERTIONS_ENABLED() && value == false) {
                String message = "Different tree sizes of bounds: " + ("lower = (" + $receiver2.getLowerBound() + ", " + lowerResult.getSubtreeSize() + "), ") + ("upper = (" + $receiver2.getUpperBound() + ", " + upperResult.getSubtreeSize() + ")");
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            result2 = new Result(DelegatingFlexibleType.Companion.create(lowerResult.getType(), upperResult.getType(), $receiver2.getExtraCapabilities()), lowerResult.getSubtreeSize());
        } else {
            result2 = TypeEnhacementPackage__TypeEnhancementKt.enhanceInflexible($receiver, qualifiers, index2, TypeComponentPosition.INFLEXIBLE);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Result enhanceInflexible(JetType $receiver, @NotNull Function1<? super Integer, ? extends JavaTypeQualifiers> qualifiers, int index2, @NotNull TypeComponentPosition position) {
        void enhancedNullability;
        void enhancedNullabilityAnnotations;
        void enhancedMutabilityAnnotations;
        void globalArgIndex;
        EnhancementResult<Boolean> destination;
        Annotations $receiver2;
        void $receiver222;
        void enhancedClassifier;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(qualifiers, "qualifiers");
        Intrinsics.checkParameterIsNotNull((Object)position, "position");
        boolean shouldEnhance = TypeEnhacementPackage__TypeEnhancementKt.shouldEnhance(position);
        if (!shouldEnhance && $receiver.getArguments().isEmpty()) {
            return new Result($receiver, 1);
        }
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return new Result($receiver, 1);
        }
        ClassifierDescriptor originalClass = classifierDescriptor;
        JavaTypeQualifiers effectiveQualifiers = qualifiers.invoke((Integer)index2);
        EnhancementResult<ClassifierDescriptor> enhancementResult = TypeEnhacementPackage__TypeEnhancementKt.enhanceMutability(originalClass, effectiveQualifiers, position);
        ClassifierDescriptor classifierDescriptor2 = enhancementResult.component1();
        Annotations annotations2 = enhancementResult.component2();
        enhancementResult = null;
        TypeConstructor typeConstructor2 = enhancedClassifier.getTypeConstructor();
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = index2 + 1;
        Iterable iterable = $receiver.getArguments();
        void var12_13 = $receiver222;
        Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault($receiver222, 10));
        int index3 = 0;
        for (Object item : $receiver2) {
            TypeProjection typeProjection;
            void localArgIndex;
            void arg;
            int n = index3++;
            TypeProjection typeProjection2 = (TypeProjection)item;
            int n2 = n;
            void var19_21 = destination;
            if (arg.isStarProjection()) {
                int n3 = globalArgIndex.element++;
                typeProjection = TypeUtils.makeStarProjection(enhancedClassifier.getTypeConstructor().getParameters().get((int)localArgIndex));
            } else {
                void enhancedType;
                void subtreeSize;
                Result result2 = TypeEnhacementPackage__TypeEnhancementKt.enhancePossiblyFlexible(arg.getType(), qualifiers, globalArgIndex.element);
                JetType jetType = result2.component1();
                int n4 = result2.component2();
                result2 = null;
                globalArgIndex.element += subtreeSize;
                Variance variance = arg.getProjectionKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)variance, "arg.projectionKind");
                typeProjection = TypeUtilPackage.createProjection((JetType)enhancedType, variance, typeConstructor2.getParameters().get((int)localArgIndex));
            }
            TypeProjection typeProjection3 = typeProjection;
            var19_21.add(typeProjection3);
        }
        List enhancedArguments = (List)((Object)destination);
        destination = TypeEnhacementPackage__TypeEnhancementKt.getEnhancedNullability($receiver, effectiveQualifiers, position);
        boolean $receiver222 = destination.component1();
        $receiver2 = destination.component2();
        destination = null;
        Annotations newAnnotations = TypeEnhacementPackage__TypeEnhancementKt.compositeAnnotationsOrSingle(KotlinPackage.filterNotNull((Iterable)KotlinPackage.listOf($receiver.getAnnotations(), enhancedMutabilityAnnotations, enhancedNullabilityAnnotations)));
        List<TypeParameterDescriptor> list = typeConstructor2.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "typeConstructor.parameters");
        TypeSubstitution newSubstitution = TypesPackage.computeNewSubstitution($receiver, list, enhancedArguments);
        TypeConstructor typeConstructor3 = typeConstructor2;
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "typeConstructor");
        JetScope jetScope = enhancedClassifier instanceof ClassDescriptor ? ((ClassDescriptor)enhancedClassifier).getMemberScope(newSubstitution) : enhancedClassifier.getDefaultType().getMemberScope();
        Intrinsics.checkExpressionValueIsNotNull(jetScope, "if (enhancedClassifier i\u2026ltType().getMemberScope()");
        TypeCapabilities typeCapabilities = $receiver.getCapabilities();
        Intrinsics.checkExpressionValueIsNotNull(typeCapabilities, "capabilities");
        JetTypeImpl enhancedType = JetTypeImpl.Companion.create(newAnnotations, typeConstructor3, (boolean)enhancedNullability, enhancedArguments, newSubstitution, jetScope, typeCapabilities);
        return new Result(enhancedType, globalArgIndex.element - index2);
    }

    @NotNull
    public static final Annotations compositeAnnotationsOrSingle(List<? extends Annotations> $receiver) {
        Annotations annotations2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        switch ($receiver.size()) {
            case 0: {
                annotations2 = (Annotations)((Object)KotlinPackage.error("At least one Annotations object expected"));
                break;
            }
            case 1: {
                annotations2 = KotlinPackage.single($receiver);
                break;
            }
            default: {
                annotations2 = new CompositeAnnotations(UtilsPackage.toReadOnlyList((Collection)$receiver));
            }
        }
        return annotations2;
    }

    public static final boolean shouldEnhance(TypeComponentPosition $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, "$receiver");
        return Intrinsics.areEqual((Object)$receiver, (Object)TypeComponentPosition.INFLEXIBLE) ^ true;
    }

    @NotNull
    public static final <T> EnhancementResult<T> noChange(T $receiver) {
        return new EnhancementResult<T>($receiver, null);
    }

    @NotNull
    public static final <T> EnhancementResult<T> enhancedNullability(T $receiver) {
        return new EnhancementResult<T>($receiver, TypeEnhacementPackage__TypeEnhancementKt.getENHANCED_NULLABILITY_ANNOTATIONS());
    }

    @NotNull
    public static final <T> EnhancementResult<T> enhancedMutability(T $receiver) {
        return new EnhancementResult<T>($receiver, TypeEnhacementPackage__TypeEnhancementKt.getENHANCED_MUTABILITY_ANNOTATIONS());
    }

    @NotNull
    public static final EnhancementResult<ClassifierDescriptor> enhanceMutability(ClassifierDescriptor $receiver, @NotNull JavaTypeQualifiers qualifiers, @NotNull TypeComponentPosition position) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(qualifiers, "qualifiers");
        Intrinsics.checkParameterIsNotNull((Object)position, "position");
        if (!TypeEnhacementPackage__TypeEnhancementKt.shouldEnhance(position)) {
            return TypeEnhacementPackage__TypeEnhancementKt.noChange($receiver);
        }
        if (!($receiver instanceof ClassDescriptor)) {
            return TypeEnhacementPackage__TypeEnhancementKt.noChange($receiver);
        }
        JavaToKotlinClassMap mapping = JavaToKotlinClassMap.INSTANCE;
        MutabilityQualifier mutabilityQualifier = qualifiers.getMutability();
        if (Intrinsics.areEqual((Object)mutabilityQualifier, (Object)MutabilityQualifier.READ_ONLY)) {
            if (Intrinsics.areEqual((Object)position, (Object)TypeComponentPosition.FLEXIBLE_LOWER) && mapping.isMutable((ClassDescriptor)$receiver)) {
                return TypeEnhacementPackage__TypeEnhancementKt.enhancedMutability(mapping.convertMutableToReadOnly((ClassDescriptor)$receiver));
            }
        } else if (Intrinsics.areEqual((Object)mutabilityQualifier, (Object)MutabilityQualifier.MUTABLE) && Intrinsics.areEqual((Object)position, (Object)TypeComponentPosition.FLEXIBLE_UPPER) && mapping.isReadOnly((ClassDescriptor)$receiver)) {
            return TypeEnhacementPackage__TypeEnhancementKt.enhancedMutability(mapping.convertReadOnlyToMutable((ClassDescriptor)$receiver));
        }
        return TypeEnhacementPackage__TypeEnhancementKt.noChange($receiver);
    }

    @NotNull
    public static final EnhancementResult<Boolean> getEnhancedNullability(JetType $receiver, @NotNull JavaTypeQualifiers qualifiers, @NotNull TypeComponentPosition position) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(qualifiers, "qualifiers");
        Intrinsics.checkParameterIsNotNull((Object)position, "position");
        if (!TypeEnhacementPackage__TypeEnhancementKt.shouldEnhance(position)) {
            return TypeEnhacementPackage__TypeEnhancementKt.noChange($receiver.isMarkedNullable());
        }
        NullabilityQualifier nullabilityQualifier = qualifiers.getNullability();
        return Intrinsics.areEqual((Object)nullabilityQualifier, (Object)NullabilityQualifier.NULLABLE) ? TypeEnhacementPackage__TypeEnhancementKt.enhancedNullability(true) : (Intrinsics.areEqual((Object)nullabilityQualifier, (Object)NullabilityQualifier.NOT_NULL) ? TypeEnhacementPackage__TypeEnhancementKt.enhancedNullability(false) : TypeEnhacementPackage__TypeEnhancementKt.noChange($receiver.isMarkedNullable()));
    }

    @NotNull
    public static final EnhancedTypeAnnotations getENHANCED_NULLABILITY_ANNOTATIONS() {
        return ENHANCED_NULLABILITY_ANNOTATIONS;
    }

    @NotNull
    public static final EnhancedTypeAnnotations getENHANCED_MUTABILITY_ANNOTATIONS() {
        return ENHANCED_MUTABILITY_ANNOTATIONS;
    }

    static {
        FqName fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION");
        ENHANCED_NULLABILITY_ANNOTATIONS = new EnhancedTypeAnnotations(fqName2);
        FqName fqName3 = JvmAnnotationNames.ENHANCED_MUTABILITY_ANNOTATION;
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "JvmAnnotationNames.ENHANCED_MUTABILITY_ANNOTATION");
        ENHANCED_MUTABILITY_ANNOTATIONS = new EnhancedTypeAnnotations(fqName3);
    }
}

