/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.context;

import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.inline.FunctionReader;
import org.jetbrains.kotlin.js.inline.context.InliningContext;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.util.FunctionUtilsKt;
import org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;
import org.jetbrains.kotlin.js.inline.util.NamingUtilsKt;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsParameter;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"F\n)ya)\u001e8di&|gnQ8oi\u0016DHOC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\tQ7O\u0003\u0004j]2Lg.\u001a\u0006\bG>tG/\u001a=u\u0015\r\te.\u001f\u0006\u0007y%t\u0017\u000e\u001e \u000b\u0011\u0019,hn\u0019;j_:T!BS:Gk:\u001cG/[8o\u0015\r\u0019w.\u001c\u0006\u0007O>|w\r\\3\u000b\t\u0011\f'\u000f\u001e\u0006\tG>l\u0007/\u001b7fe*9!-Y2lK:$'bA1ti*y\u0011N\u001c7j]&twmQ8oi\u0016DHOC\bJ]2Lg.\u001b8h\u0007>tG/\u001a=u\u001591WO\\2uS>t'+Z1eKJTaBR;oGRLwN\u001c*fC\u0012,'O\u0003\u000bgk:\u001cG/[8og^KG\u000f[\"m_N,(/\u001a\u0006\u0010\u0013\u0012,g\u000e^5us\"\u000b7\u000f['ba*!!.\u0019<b\u0015\u0011)H/\u001b7\u000b\u0019)\u001b\u0018J\u001c<pG\u0006$\u0018n\u001c8\u000b#\u0005\u0004\b\u000f\\=DCB$XO]3e\u0003J<7O\u0003\u0003dC2d'\"B5o]\u0016\u0014(\"B8vi\u0016\u0014(B\b3fG2\f'/\u001a$v]\u000e$\u0018n\u001c8D_:\u001cHO];di>\u00148)\u00197m\u0015\u0011)f.\u001b;\u000b?\u0011,7\r\\1sK\u001a+hn\u0019;j_:\u001cuN\\:ueV\u001cGo\u001c:DC2d7OC\u0005be\u001e,X.\u001a8ug*!A*[:u\u00151Q5/\u0012=qe\u0016\u001c8/[8o\u0015U9W\r\u001e$v]\u000e$\u0018n\u001c8EK\u001aLg.\u001b;j_:T\u0011dZ3u\rVt7\r^5p]\u0012+g-\u001b8ji&|g.S7qY*1r-\u001a;Gk:\u001cG/[8o/&$\bn\u00117pgV\u0014XM\u0003\u0005hKR\u001c6m\u001c9f\u0015\u001dQ5oU2pa\u0016TQ\u0003[1t\rVt7\r^5p]\u0012+g-\u001b8ji&|gNC\u0004C_>dW-\u00198\u000b)1|wn[+q'R\fG/[2Gk:\u001cG/[8o\u001511WO\\2uS>tg*Y7f\u0015\u0019Q5OT1nKB\u0010!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!\u0002\u0002\u0005\u0005!\u0019Qa\u0001C\u0003\u0011\u0001a\u0001!B\u0001\t\u0004\u0015\u0019Aq\u0001E\u0004\u0019\u0001)\u0011\u0001c\u0003\u0006\u0005\u0011%\u0001BB\u0003\u0003\t\u0015Ai!\u0002\u0002\u0005\f!9QA\u0001\u0003\u0007\u0011\u001f)!\u0001\"\u0004\t\u0005\u0015\u0011Aa\u0002\u0005\t\u000b\r!y\u0001C\u0003\r\u0001\u0015\u0019AQ\u0001\u0005\n\u0019\u0001)1\u0001\u0002\u0002\t\u00151\u0001QA\u0001C\b\u0011\u0015)!\u0001\"\u0002\t\u0013\u0015\u0011AA\u0001\u0005\u000b\u000b\u0005A9\"\u0002\u0002\u0005\u0017!aQa\u0001C\f\u0011-a\u0001!B\u0002\u0005\u0010!eA\u0002A\u0003\u0003\t/A1\"\u0002\u0002\u0005\u0010!eQa\u0001C\u0004\u0011?a\u0001!B\u0002\u0005\b!\tB\u0002A\u0003\u0004\t\u001fA\u0019\u0003\u0004\u0001\u0006\u0005\u0011]\u0001\"E\u0003\u0004\t\u001fAA\u0003\u0004\u0001\u0006\u0005\u0011=\u0001\u0002F\u0003\u0004\t\u000fAQ\u0003\u0004\u0001\u0006\u0007\u0011=\u0001R\u0006\u0007\u0001\u000b\t!y\u0001#\f\u0005'1\u0019\u0011dA\u0003\u0002\u0011\u0011AB!\f\u0007\u0005C\u0012AJ!I\u0002\u0006\u0003!A\u0001\u0004C+\u0004\t\u0015\u0019A\u0011B\u0005\u0002\u0011'iC\u0002B1\u00051'\t3!B\u0001\t\u0013aIQk\u0001\u0003\u0006\u0007\u0011M\u0011\"\u0001E\u000b[]!\u0011\r\u0002M\u000bC9)\u0011\u0001\u0003\u0007\n\t%\u0019Q!\u0001E\r13IQ!\u0003\u0003\u0006\u0003!AA\u0012\u0001\r\t11)6\u0001B\u0003\u0004\t+I\u0011\u0001C\u0007.\u0019\u0011\tG\u0001'\u0005\"\u0007\u0015\t\u0001\u0012\u0003M\t+\u000e!Qa\u0001C\t\u0013\u0005A!\"\f\u0016\u0005\u0003aiQt\u0002\u0003\u0001\u00117i1!B\u0001\t\u001aae\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001BD\u0007\u0004\u000b\u0005A\u0001\u0002\u0007\u0005Q\u0007\u0003iz\u0001\u0002\u0001\t\u001e5\u0019Q!\u0001\u0005\t1!\u00016!A\u0011\u0004\u000b\u0005A\u0001\u0002\u0007\u0005R\u0007%!Q\"C\u0001\t\u00145\t\u00012D\u0007\u0002\u0011'i\u0011\u0001c\u0005.+\u0011\u0019\u0001dDO\b\t\u0001AY\"D\u0002\u0006\u0003!e\u0001\u0014\u0004)\u0004\u0001\u0005\u001aQ!\u0001\u0005\u000f19\t6!\u0002\u0003\u0010\u0013\u0005!\u0001!D\u0001\t\u001c5RBa\u0001\r\u0011;3!\u0001\u0001#\t\u000e\u0011\u0015\t\u0001RD\u0005\u0005\u0013\r)\u0011\u0001C\b\u0019\u001fau\u0001k\u0001\u0001\"\u0007\u0015\t\u0001B\u0004\r\u000f#\u000e)A\u0001E\u0005\u0002\t\u0001i\u0011\u0001c\b.+\u0011\u0019\u0001DEO\b\t\u0001AY\"D\u0002\u0006\u0003!e\u0001\u0014\u0004)\u0004\u0001\u0005\u001aQ!\u0001\u0005\t1!\t6!\u0002\u0003\u0013\u0013\u0005A\u0019\"D\u0001\t\u001c52B!\u0001M\u0013;\u001f!\u0001\u0001c\u0007\u000e\u0007\u0015\t\u0001\u0012\u0004M\r!\u000e\u0001\u0011\u0005B\u0003\u0002\u0011!a\t\u0001\u0007\u0005R\u0007\u0015!)#C\u0001\t\u00145\t\u00012D\u0017\u0016\t\u0005A2#h\u0004\u0005\u0001!mQbA\u0003\u0002\u00113AJ\u0002U\u0002\u0001C\r)\u0011\u0001\u0003\u0005\u0019\u0011E\u001bQ\u0001B\n\n\u0003!MQ\"\u0001E\u000e[+!1\u0001g\n\"\u0007\u0015\t\u0001\u0002\u0005\r\u0011#\u000e\u0019AqE\u0005\u0002\u0011CiS\u0003B\u0002\u0019*u=A\u0001\u0001E\u000e\u001b\r)\u0011\u0001#\u0007\u0019\u001aA\u001b\u0001!I\u0002\u0006\u0003!\t\u0002$E)\u0004\u000b\u0011%\u0012\"\u0001C\u0001\u001b\u0005AY\"L\f\u0005%a-R\u0014\u0003\u0003\u0001\u0011YiA!B\u0001\t$1\u0005\u00014\u0005)\u0004\u0001\u0005\"Q!\u0001\u0005\t\u0019\u0003A\u0002\"U\u0002\u0006\tWI\u0011\u0001c\u0005\u000e\u0003!\u0011RwKC+\t\r\b\u0001\u0004BO\b\t\u0001AI!D\u0002\u0006\u0003!A\u0001\u0004\u0003)\u0004\u0001u=A\u0001\u0001E\t\u001b\r)\u0011\u0001#\u0005\u0019\u0012A\u001b\t!h\u0004\u0005\u0001!MQbA\u0003\u0002\u0011%A\u0012\u0002U\u0002\u0002C\r)\u0011\u0001C\u0002\u0019\u0007E\u001b\u0011\u0002\u0002\u0003\n\u0003\u0011\u0001Q\"\u0001E\n\u001b\u0005A!\"D\u0001\t\u0016\u0001"})
public abstract class FunctionContext {
    public static final /* synthetic */ KClass $kotlinClass;
    private final IdentityHashMap<JsInvocation, JsFunction> functionsWithClosure;
    private final JsFunction function;
    private final InliningContext inliningContext;
    private final FunctionReader functionReader;

    static {
        $kotlinClass = Reflection.createKotlinClass(FunctionContext.class);
    }

    @Nullable
    protected abstract JsFunction lookUpStaticFunction(@Nullable JsName var1);

    @NotNull
    public final JsFunction getFunctionDefinition(@NotNull JsInvocation call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        JsFunction jsFunction = this.getFunctionDefinitionImpl(call);
        if (jsFunction == null) {
            Intrinsics.throwNpe();
        }
        return jsFunction;
    }

    public final boolean hasFunctionDefinition(@NotNull JsInvocation call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        return this.getFunctionDefinitionImpl(call) != null;
    }

    @NotNull
    public final JsScope getScope() {
        JsScope jsScope = this.function.getScope();
        Intrinsics.checkExpressionValueIsNotNull(jsScope, "function.getScope()");
        return jsScope;
    }

    public final void declareFunctionConstructorCalls(@NotNull List<? extends JsExpression> arguments2) {
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        List<JsInvocation> calls = ContainerUtil.findAll((Collection)arguments2, JsInvocation.class);
        Iterator<JsInvocation> iterator2 = calls.iterator();
        while (iterator2.hasNext()) {
            JsNode functionCalled;
            JsNode staticRef;
            JsInvocation call;
            JsInvocation jsInvocation = call = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(jsInvocation, "call");
            JsName callName = InvocationUtilsKt.getSimpleName(jsInvocation);
            if (callName == null || !((staticRef = MetadataProperties.getStaticRef(callName)) instanceof JsFunction) || !FunctionUtilsKt.isFunctionCreator((JsFunction)(functionCalled = staticRef))) continue;
            JsInvocation jsInvocation2 = call;
            Intrinsics.checkExpressionValueIsNotNull(jsInvocation2, "call");
            this.declareFunctionConstructorCall(jsInvocation2);
        }
    }

    public final void declareFunctionConstructorCall(@NotNull JsInvocation call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        this.functionsWithClosure.put(call, null);
    }

    private final JsFunction getFunctionDefinitionImpl(JsInvocation call) {
        JsFunction jsFunction;
        JsExpression qualifier;
        JsNode jsNode;
        CallableDescriptor descriptor2 = MetadataProperties.getDescriptor(call);
        if (descriptor2 != null && this.functionReader.contains(descriptor2)) {
            return this.functionReader.get(descriptor2);
        }
        JsExpression callQualifier = call.getQualifier();
        if (InvocationUtilsKt.isCallInvocation(call)) {
            JsExpression jsExpression = callQualifier;
            if (jsExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsNameRef");
            }
            JsExpression jsExpression2 = ((JsNameRef)jsExpression).getQualifier();
            if (jsExpression2 == null) {
                Intrinsics.throwNpe();
            }
            callQualifier = jsExpression2;
        }
        if (callQualifier instanceof JsNameRef) {
            JsExpression jsExpression;
            JsName jsName = ((JsNameRef)callQualifier).getName();
            JsNode staticRef = jsName != null ? MetadataProperties.getStaticRef(jsName) : null;
            jsNode = staticRef;
            if (jsNode instanceof JsNameRef) {
                jsExpression = (JsExpression)staticRef;
            } else if (jsNode instanceof JsInvocation) {
                jsExpression = (JsExpression)staticRef;
            } else if (jsNode instanceof JsFunction || Intrinsics.areEqual(jsNode, null)) {
                jsExpression = callQualifier;
            } else {
                throw (Throwable)((Object)new AssertionError((Object)("Unexpected static reference type " + staticRef.getClass())));
            }
            callQualifier = jsExpression;
        }
        if ((jsNode = (qualifier = callQualifier)) instanceof JsInvocation) {
            JsInvocation jsInvocation = (JsInvocation)qualifier;
            Intrinsics.checkExpressionValueIsNotNull(jsInvocation, "qualifier");
            jsFunction = this.getFunctionWithClosure(jsInvocation);
        } else {
            jsFunction = jsNode instanceof JsNameRef ? this.lookUpStaticFunction(((JsNameRef)qualifier).getName()) : (JsFunction)null;
        }
        return jsFunction;
    }

    private final JsFunction getFunctionWithClosure(JsInvocation call) {
        JsFunction constructed = this.functionsWithClosure.get(call);
        if (constructed instanceof JsFunction) {
            return constructed;
        }
        JsName jsName = InvocationUtilsKt.getSimpleName(call);
        if (jsName == null) {
            Intrinsics.throwNpe();
        }
        JsName name = jsName;
        JsFunction jsFunction = this.lookUpStaticFunction(name);
        if (jsFunction == null) {
            Intrinsics.throwNpe();
        }
        JsFunction closureCreator = jsFunction;
        JsFunction jsFunction2 = FunctionUtilsKt.getInnerFunction(closureCreator);
        if (jsFunction2 == null) {
            Intrinsics.throwNpe();
        }
        JsFunction innerFunction = jsFunction2;
        JsFunction withCapturedArgs = this.applyCapturedArgs(call, innerFunction, closureCreator);
        this.functionsWithClosure.put(call, withCapturedArgs);
        return withCapturedArgs;
    }

    private final JsFunction applyCapturedArgs(JsInvocation call, JsFunction inner, JsFunction outer) {
        JsFunction innerClone = inner.deepCopy();
        NamingContext namingContext = this.inliningContext.newNamingContext();
        List<JsExpression> arguments2 = call.getArguments();
        List<JsParameter> parameters2 = outer.getParameters();
        List<JsExpression> list = arguments2;
        Intrinsics.checkExpressionValueIsNotNull(list, "arguments");
        List<JsParameter> list2 = parameters2;
        Intrinsics.checkExpressionValueIsNotNull(list2, "parameters");
        NamingUtilsKt.aliasArgumentsIfNeeded(namingContext, list, list2);
        JsNode jsNode = innerClone;
        Intrinsics.checkExpressionValueIsNotNull(jsNode, "innerClone");
        namingContext.applyRenameTo(jsNode);
        JsFunction jsFunction = innerClone;
        Intrinsics.checkExpressionValueIsNotNull(jsFunction, "innerClone");
        return jsFunction;
    }

    public FunctionContext(@NotNull JsFunction function, @NotNull InliningContext inliningContext, @NotNull FunctionReader functionReader) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        Intrinsics.checkParameterIsNotNull(inliningContext, "inliningContext");
        Intrinsics.checkParameterIsNotNull(functionReader, "functionReader");
        this.function = function;
        this.inliningContext = inliningContext;
        this.functionReader = functionReader;
        this.functionsWithClosure = new IdentityHashMap();
    }
}

