/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.inline;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.inline.InlineOption;
import org.jetbrains.kotlin.resolve.inline.InlineStrategy;

public class InlineUtil {
    public static boolean isInlineLambdaParameter(@NotNull ParameterDescriptor valueParameterOrReceiver) {
        if (valueParameterOrReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterOrReceiver", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "isInlineLambdaParameter"));
        }
        return !KotlinBuiltIns.isNoinline(valueParameterOrReceiver) && KotlinBuiltIns.isExactFunctionOrExtensionFunctionType(valueParameterOrReceiver.getOriginal().getType());
    }

    public static boolean isInline(@Nullable DeclarationDescriptor descriptor2) {
        return descriptor2 instanceof SimpleFunctionDescriptor && InlineUtil.getInlineStrategy(descriptor2).isInline();
    }

    @NotNull
    public static InlineStrategy getInlineStrategy(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "getInlineStrategy"));
        }
        AnnotationDescriptor annotation2 = descriptor2.getAnnotations().findAnnotation(KotlinBuiltIns.FQ_NAMES.inline);
        if (annotation2 == null) {
            InlineStrategy inlineStrategy = InlineStrategy.NOT_INLINE;
            if (inlineStrategy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "getInlineStrategy"));
            }
            return inlineStrategy;
        }
        ConstantValue<?> argument = KotlinPackage.firstOrNull(annotation2.getAllValueArguments().values());
        if (argument == null) {
            InlineStrategy inlineStrategy = InlineStrategy.AS_FUNCTION;
            if (inlineStrategy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "getInlineStrategy"));
            }
            return inlineStrategy;
        }
        assert (argument instanceof EnumValue) : "Inline annotation parameter should be enum entry but was: " + argument;
        InlineStrategy inlineStrategy = InlineStrategy.valueOf(((ClassDescriptor)((EnumValue)argument).getValue()).getName().asString());
        if (inlineStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "getInlineStrategy"));
        }
        return inlineStrategy;
    }

    public static boolean hasOnlyLocalContinueAndBreak(@NotNull ValueParameterDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "hasOnlyLocalContinueAndBreak"));
        }
        return InlineUtil.hasInlineOption(descriptor2, InlineOption.LOCAL_CONTINUE_AND_BREAK);
    }

    public static boolean hasOnlyLocalReturn(@NotNull ValueParameterDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "hasOnlyLocalReturn"));
        }
        return InlineUtil.hasInlineOption(descriptor2, InlineOption.ONLY_LOCAL_RETURN) || descriptor2.getAnnotations().findAnnotation(KotlinBuiltIns.FQ_NAMES.crossinline) != null;
    }

    private static boolean hasInlineOption(@NotNull ValueParameterDescriptor descriptor2, @NotNull InlineOption option) {
        ConstantValue<?> argument;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "hasInlineOption"));
        }
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "hasInlineOption"));
        }
        AnnotationDescriptor annotation2 = descriptor2.getAnnotations().findAnnotation(KotlinBuiltIns.FQ_NAMES.inlineOptions);
        if (annotation2 != null && (argument = KotlinPackage.firstOrNull(annotation2.getAllValueArguments().values())) instanceof ArrayValue) {
            for (ConstantValue value : (List)((ArrayValue)argument).getValue()) {
                if (!(value instanceof EnumValue) || !((ClassDescriptor)((EnumValue)value).getValue()).getName().asString().equals(option.name())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkNonLocalReturnUsage(@NotNull DeclarationDescriptor fromFunction, @NotNull JetExpression startExpression, @NotNull BindingTrace trace) {
        if (fromFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromFunction", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "checkNonLocalReturnUsage"));
        }
        if (startExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startExpression", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "checkNonLocalReturnUsage"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "checkNonLocalReturnUsage"));
        }
        Object containingFunction = PsiTreeUtil.getParentOfType((PsiElement)startExpression, JetClassOrObject.class, JetDeclarationWithBody.class);
        if (containingFunction == null) {
            return false;
        }
        DeclarationDescriptor containingFunctionDescriptor = trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, containingFunction);
        if (containingFunctionDescriptor == null) {
            return false;
        }
        BindingContext bindingContext = trace.getBindingContext();
        while (InlineUtil.canBeInlineArgument(containingFunction) && fromFunction != containingFunctionDescriptor) {
            if (!InlineUtil.isInlinedArgument((JetFunction)containingFunction, bindingContext, true)) {
                return false;
            }
            containingFunction = (containingFunctionDescriptor = InlineUtil.getContainingClassOrFunctionDescriptor(containingFunctionDescriptor, true)) != null ? DescriptorToSourceUtils.descriptorToDeclaration(containingFunctionDescriptor) : null;
        }
        return fromFunction == containingFunctionDescriptor;
    }

    public static boolean isInlinedArgument(@NotNull JetFunction argument, @NotNull BindingContext bindingContext, boolean checkNonLocalReturn) {
        ValueParameterDescriptor parameter;
        ArgumentMapping mapping;
        ValueArgument valueArgument;
        ResolvedCall<? extends CallableDescriptor> resolvedCall;
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "isInlinedArgument"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "isInlinedArgument"));
        }
        if (!InlineUtil.canBeInlineArgument(argument)) {
            return false;
        }
        JetExpression call = JetPsiUtil.getParentCallIfPresent(argument);
        if (call != null && (resolvedCall = CallUtilPackage.getResolvedCall(call, bindingContext)) != null && InlineUtil.isInline(resolvedCall.getResultingDescriptor()) && (valueArgument = CallUtilPackage.getValueArgumentForExpression(resolvedCall.getCall(), argument)) != null && (mapping = resolvedCall.getArgumentMapping(valueArgument)) instanceof ArgumentMatch && InlineUtil.isInlineLambdaParameter(parameter = ((ArgumentMatch)mapping).getValueParameter())) {
            return !checkNonLocalReturn || InlineUtil.allowsNonLocalReturns(parameter);
        }
        return false;
    }

    public static boolean canBeInlineArgument(@Nullable PsiElement functionalExpression) {
        return functionalExpression instanceof JetFunctionLiteral || functionalExpression instanceof JetNamedFunction;
    }

    @Nullable
    public static DeclarationDescriptor getContainingClassOrFunctionDescriptor(@NotNull DeclarationDescriptor descriptor2, boolean strict) {
        DeclarationDescriptor current;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "getContainingClassOrFunctionDescriptor"));
        }
        DeclarationDescriptor declarationDescriptor = current = strict ? descriptor2.getContainingDeclaration() : descriptor2;
        while (current != null) {
            if (current instanceof FunctionDescriptor || current instanceof ClassDescriptor) {
                return current;
            }
            current = current.getContainingDeclaration();
        }
        return null;
    }

    public static boolean allowsNonLocalReturns(@NotNull CallableDescriptor lambda2) {
        if (lambda2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambda", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "allowsNonLocalReturns"));
        }
        return !(lambda2 instanceof ValueParameterDescriptor) || !InlineUtil.hasOnlyLocalReturn((ValueParameterDescriptor)lambda2);
    }
}

