/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.descriptors.DescriptorsFactory;
import org.jetbrains.kotlin.backend.jvm.descriptors.FileClassDescriptorImpl;
import org.jetbrains.kotlin.backend.jvm.descriptors.JvmPropertyDescriptorImpl;
import org.jetbrains.kotlin.backend.jvm.descriptors.UtilKt;
import org.jetbrains.kotlin.builtins.CompanionObjectMapping;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.descriptors.FileClassDescriptor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.ir.SourceManager;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.symbols.IrBindableSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrConstructorSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.load.java.JavaVisibilities;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi2ir.PsiSourceManager;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u001bH\u0016J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u000bH\u0016J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/backend/jvm/descriptors/JvmDescriptorsFactory;", "Lorg/jetbrains/kotlin/backend/common/descriptors/DescriptorsFactory;", "psiSourceManager", "Lorg/jetbrains/kotlin/psi2ir/PsiSourceManager;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(Lorg/jetbrains/kotlin/psi2ir/PsiSourceManager;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "innerClassConstructors", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "outerThisDescriptors", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "singletonFieldDescriptors", "Lorg/jetbrains/kotlin/ir/symbols/IrBindableSymbol;", "createEnumEntryFieldDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "enumEntryDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "createFileClassDescriptor", "Lorg/jetbrains/kotlin/codegen/descriptors/FileClassDescriptor;", "fileEntry", "Lorg/jetbrains/kotlin/ir/SourceManager$FileEntry;", "packageFragment", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "createInnerClassConstructorWithOuterThisParameter", "oldConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "createObjectInstanceFieldDescriptor", "objectDescriptor", "getInnerClassConstructorWithOuterThisParameter", "innerClassConstructor", "getOuterThisFieldSymbol", "innerClass", "getSymbolForEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/ir/symbols/IrEnumEntrySymbol;", "getSymbolForObjectInstance", "singleton", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "backend"})
public final class JvmDescriptorsFactory
implements DescriptorsFactory {
    private final HashMap<IrBindableSymbol<?, ?>, IrFieldSymbol> singletonFieldDescriptors;
    private final HashMap<IrClass, IrFieldSymbol> outerThisDescriptors;
    private final HashMap<IrConstructorSymbol, IrConstructorSymbol> innerClassConstructors;
    private final PsiSourceManager psiSourceManager;
    private final KotlinBuiltIns builtIns;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrFieldSymbol getSymbolForEnumEntry(@NotNull IrEnumEntrySymbol enumEntry) {
        IrFieldSymbol irFieldSymbol;
        Intrinsics.checkParameterIsNotNull((Object)enumEntry, (String)"enumEntry");
        Map $receiver$iv = this.singletonFieldDescriptors;
        Object value$iv = $receiver$iv.get(enumEntry);
        if (value$iv == null) {
            IrFieldSymbol answer$iv = new IrFieldSymbolImpl(this.createEnumEntryFieldDescriptor((ClassDescriptor)enumEntry.getDescriptor()));
            $receiver$iv.put(enumEntry, answer$iv);
            irFieldSymbol = answer$iv;
        } else {
            void var3_3;
            irFieldSymbol = var3_3;
        }
        return irFieldSymbol;
    }

    @NotNull
    public final FileClassDescriptor createFileClassDescriptor(@NotNull SourceManager.FileEntry fileEntry, @NotNull PackageFragmentDescriptor packageFragment2) {
        Intrinsics.checkParameterIsNotNull((Object)fileEntry, (String)"fileEntry");
        Intrinsics.checkParameterIsNotNull((Object)packageFragment2, (String)"packageFragment");
        KtFile ktFile = this.psiSourceManager.getKtFile((PsiSourceManager.PsiFileEntry)fileEntry);
        if (ktFile == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected file entry: " + fileEntry)));
        }
        KtFile ktFile2 = ktFile;
        JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(ktFile2);
        KotlinSourceElement sourceElement = new KotlinSourceElement(ktFile2);
        Name name = fileClassInfo.getFileClassFqName().shortName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"fileClassInfo.fileClassFqName.shortName()");
        return new FileClassDescriptorImpl(name, packageFragment2, CollectionsKt.listOf((Object)this.builtIns.getAnyType()), sourceElement, Annotations.Companion.getEMPTY());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrFieldSymbol getOuterThisFieldSymbol(@NotNull IrClass innerClass) {
        IrFieldSymbol irFieldSymbol;
        Intrinsics.checkParameterIsNotNull((Object)innerClass, (String)"innerClass");
        if (!innerClass.isInner()) {
            throw (Throwable)((Object)new AssertionError((Object)("Class is not inner: " + DumpIrTreeKt.dump(innerClass))));
        }
        Map $receiver$iv = this.outerThisDescriptors;
        Object value$iv = $receiver$iv.get(innerClass);
        if (value$iv == null) {
            IrDeclarationParent irDeclarationParent = innerClass.getParent();
            if (!(irDeclarationParent instanceof IrClass)) {
                irDeclarationParent = null;
            }
            IrClass irClass = (IrClass)irDeclarationParent;
            if (irClass == null) {
                throw (Throwable)((Object)new AssertionError((Object)("No containing class for inner class " + DumpIrTreeKt.dump(innerClass))));
            }
            IrClass outerClass2 = irClass;
            Name name = Name.identifier("this$0");
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(\"this$0\")");
            KotlinType kotlinType = IrTypesKt.toKotlinType(IrUtilsKt.getDefaultType(outerClass2));
            ClassDescriptor classDescriptor2 = innerClass.getDescriptor();
            Annotations annotations2 = Annotations.Companion.getEMPTY();
            Visibility visibility = JavaVisibilities.PACKAGE_VISIBILITY;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"JavaVisibilities.PACKAGE_VISIBILITY");
            SourceElement sourceElement = SourceElement.NO_SOURCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"SourceElement.NO_SOURCE");
            IrFieldSymbol answer$iv = new IrFieldSymbolImpl(JvmPropertyDescriptorImpl.Companion.createFinalField(name, kotlinType, classDescriptor2, annotations2, visibility, 4096, sourceElement));
            $receiver$iv.put(innerClass, answer$iv);
            irFieldSymbol = answer$iv;
        } else {
            void var3_3;
            irFieldSymbol = var3_3;
        }
        return irFieldSymbol;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrConstructorSymbol getInnerClassConstructorWithOuterThisParameter(@NotNull IrConstructor innerClassConstructor) {
        Object object;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)innerClassConstructor, (String)"innerClassConstructor");
        IrDeclarationParent irDeclarationParent = innerClassConstructor.getParent();
        if (irDeclarationParent == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        }
        boolean bl = ((IrClass)irDeclarationParent).isInner();
        if (_Assertions.ENABLED && !bl) {
            IrDeclarationParent irDeclarationParent2 = innerClassConstructor.getParent();
            if (irDeclarationParent2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            }
            String string = "Class is not inner: " + DumpIrTreeKt.dump((IrClass)irDeclarationParent2);
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Map map2 = this.innerClassConstructors;
        IrFunctionSymbol key$iv = innerClassConstructor.getSymbol();
        Object value$iv = $receiver$iv.get(key$iv);
        if (value$iv == null) {
            IrConstructorSymbol answer$iv = this.createInnerClassConstructorWithOuterThisParameter(innerClassConstructor);
            $receiver$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (IrConstructorSymbol)object;
    }

    /*
     * WARNING - void declaration
     */
    private final IrConstructorSymbol createInnerClassConstructorWithOuterThisParameter(IrConstructor oldConstructor) {
        Collection<ValueParameterDescriptor> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        ClassConstructorDescriptor oldDescriptor = oldConstructor.getDescriptor();
        ClassDescriptor classDescriptor2 = oldDescriptor.getContainingDeclaration();
        DeclarationDescriptor declarationDescriptor = classDescriptor2.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        SimpleType simpleType2 = ((ClassDescriptor)declarationDescriptor).getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"(classDescriptor.contain\u2026ssDescriptor).defaultType");
        SimpleType outerThisType = simpleType2;
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl = ClassConstructorDescriptorImpl.createSynthesized(classDescriptor2, oldDescriptor.getAnnotations(), oldDescriptor.isPrimary(), oldDescriptor.getSource());
        Intrinsics.checkExpressionValueIsNotNull((Object)classConstructorDescriptorImpl, (String)"ClassConstructorDescript\u2026scriptor.source\n        )");
        ClassConstructorDescriptorImpl newDescriptor2 = classConstructorDescriptorImpl;
        ValueParameterDescriptor outerThisValueParameter = UtilKt.createValueParameter(newDescriptor2, 0, "$outer", outerThisType);
        Collection collection2 = CollectionsKt.listOf((Object)outerThisValueParameter);
        List<ValueParameterDescriptor> list2 = oldDescriptor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"oldDescriptor.valueParameters");
        Iterable iterable = list2;
        Collection collection3 = collection2;
        void var9_9 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            CallableDescriptor callableDescriptor = newDescriptor2;
            void v6 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it");
            Name name = v6.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"it.name");
            ValueParameterDescriptor valueParameterDescriptor2 = it.copy(callableDescriptor, name, it.getIndex() + 1);
            collection.add(valueParameterDescriptor2);
        }
        collection = (List)destination$iv$iv;
        List newValueParameters = CollectionsKt.plus((Collection)collection3, (Iterable)collection);
        ReceiverParameterDescriptor receiverParameterDescriptor = oldDescriptor.getExtensionReceiverParameter();
        newDescriptor2.initialize(receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null, null, oldDescriptor.getTypeParameters(), newValueParameters, oldDescriptor.getReturnType(), oldDescriptor.getModality(), oldDescriptor.getVisibility());
        return new IrConstructorSymbolImpl(newDescriptor2);
    }

    private final PropertyDescriptor createEnumEntryFieldDescriptor(ClassDescriptor enumEntryDescriptor) {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = enumEntryDescriptor.getKind() == ClassKind.ENUM_ENTRY;
        if (_Assertions.ENABLED && !bl2) {
            String string = "Should be enum entry: " + enumEntryDescriptor;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        DeclarationDescriptor declarationDescriptor = enumEntryDescriptor.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        ClassDescriptor enumClassDescriptor = (ClassDescriptor)declarationDescriptor;
        boolean bl4 = bl = enumClassDescriptor.getKind() == ClassKind.ENUM_CLASS;
        if (_Assertions.ENABLED && !bl) {
            String string = "Should be enum class: " + enumClassDescriptor;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Name name = enumEntryDescriptor.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"enumEntryDescriptor.name");
        SimpleType simpleType2 = enumClassDescriptor.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"enumClassDescriptor.defaultType");
        KotlinType kotlinType = simpleType2;
        DeclarationDescriptor declarationDescriptor2 = enumClassDescriptor;
        Annotations annotations2 = enumEntryDescriptor.getAnnotations();
        Visibility visibility = Visibilities.PUBLIC;
        Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"Visibilities.PUBLIC");
        SourceElement sourceElement = enumEntryDescriptor.getSource();
        Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"enumEntryDescriptor.source");
        return JvmPropertyDescriptorImpl.Companion.createStaticVal(name, kotlinType, declarationDescriptor2, annotations2, Modality.FINAL, visibility, 16384, sourceElement);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrFieldSymbol getSymbolForObjectInstance(@NotNull IrClassSymbol singleton) {
        IrFieldSymbol irFieldSymbol;
        Intrinsics.checkParameterIsNotNull((Object)singleton, (String)"singleton");
        Map $receiver$iv = this.singletonFieldDescriptors;
        Object value$iv = $receiver$iv.get(singleton);
        if (value$iv == null) {
            IrFieldSymbol answer$iv = new IrFieldSymbolImpl(this.createObjectInstanceFieldDescriptor((ClassDescriptor)singleton.getDescriptor()));
            $receiver$iv.put(singleton, answer$iv);
            irFieldSymbol = answer$iv;
        } else {
            void var3_3;
            irFieldSymbol = var3_3;
        }
        return irFieldSymbol;
    }

    private final PropertyDescriptor createObjectInstanceFieldDescriptor(ClassDescriptor objectDescriptor) {
        boolean bl;
        boolean bl2 = bl = objectDescriptor.getKind() == ClassKind.OBJECT;
        if (_Assertions.ENABLED && !bl) {
            String string = "Should be an object: " + objectDescriptor;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean isNotMappedCompanion = objectDescriptor.isCompanionObject() && !CompanionObjectMapping.INSTANCE.isMappedIntrinsicCompanionObject(objectDescriptor);
        Name name = isNotMappedCompanion ? objectDescriptor.getName() : Name.identifier("INSTANCE");
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"if (isNotMappedCompanion\u2026me.identifier(\"INSTANCE\")");
        Name name2 = name;
        DeclarationDescriptor declarationDescriptor = isNotMappedCompanion ? objectDescriptor.getContainingDeclaration() : (DeclarationDescriptor)objectDescriptor;
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"if (isNotMappedCompanion\u2026ion else objectDescriptor");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        PropertyDescriptorImpl propertyDescriptorImpl = PropertyDescriptorImpl.create(containingDeclaration, Annotations.Companion.getEMPTY(), Modality.FINAL, Visibilities.PUBLIC, false, name2, CallableMemberDescriptor.Kind.SYNTHESIZED, SourceElement.NO_SOURCE, false, false, false, false, false, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptorImpl, (String)"PropertyDescriptorImpl.c\u2026ated = */ false\n        )");
        SimpleType simpleType2 = objectDescriptor.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"objectDescriptor.defaultType");
        return UtilKt.initialize$default(propertyDescriptorImpl, simpleType2, null, null, null, null, null, 62, null);
    }

    public JvmDescriptorsFactory(@NotNull PsiSourceManager psiSourceManager, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull((Object)psiSourceManager, (String)"psiSourceManager");
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        this.psiSourceManager = psiSourceManager;
        this.builtIns = builtIns;
        this.singletonFieldDescriptors = new HashMap();
        this.outerThisDescriptors = new HashMap();
        this.innerClassConstructors = new HashMap();
    }
}

