/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrIntrinsicFunction;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrIntrinsicFunctionKt;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Equals;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "operator", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "(Lcom/intellij/psi/tree/IElementType;)V", "getOperator", "()Lcom/intellij/psi/tree/IElementType;", "toCallable", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "signature", "Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "backend"})
public final class Equals
extends IntrinsicMethod {
    @NotNull
    private final IElementType operator;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrIntrinsicFunction toCallable(@NotNull IrMemberAccessExpression expression2, @NotNull JvmMethodSignature signature, @NotNull JvmBackendContext context) {
        void rightType;
        void leftType;
        boolean bl;
        Ref.ObjectRef objectRef;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Ref.ObjectRef $receiver = objectRef = IrIntrinsicFunctionKt.receiverAndArgs(expression2);
        boolean bl2 = bl = $receiver.size() == 2;
        if (_Assertions.ENABLED && !bl) {
            String string = "Equals expects 2 arguments, but " + CollectionsKt.joinToString$default((Iterable)((Iterable)$receiver), null, null, null, (int)0, null, null, (int)63, null);
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Ref.ObjectRef receiverAndArgs = objectRef;
        objectRef = new Ref.ObjectRef();
        Type type2 = context.getState().getTypeMapper().mapType(IrTypesKt.toKotlinType(((IrExpression)CollectionsKt.first((List)receiverAndArgs)).getType()));
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"context.state.typeMapper\u2026st().type.toKotlinType())");
        objectRef.element = type2;
        $receiver = new Ref.ObjectRef();
        Type type3 = context.getState().getTypeMapper().mapType(IrTypesKt.toKotlinType(((IrExpression)CollectionsKt.last((List)receiverAndArgs)).getType()));
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"context.state.typeMapper\u2026st().type.toKotlinType())");
        $receiver.element = type3;
        if (AsmUtil.isPrimitive((Type)leftType.element) != AsmUtil.isPrimitive((Type)rightType.element)) {
            Type type4 = AsmUtil.boxType((Type)leftType.element);
            Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"boxType(leftType)");
            leftType.element = type4;
            Type type5 = AsmUtil.boxType((Type)rightType.element);
            Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"boxType(rightType)");
            rightType.element = type5;
        }
        return new IrIntrinsicFunction(this, expression2, (Ref.ObjectRef)leftType, (Ref.ObjectRef)rightType, signature, context, expression2, signature, context, CollectionsKt.listOf((Object[])new Type[]{(Type)leftType.element, (Type)rightType.element})){
            final /* synthetic */ Equals this$0;
            final /* synthetic */ IrMemberAccessExpression $expression;
            final /* synthetic */ Ref.ObjectRef $leftType;
            final /* synthetic */ Ref.ObjectRef $rightType;
            final /* synthetic */ JvmMethodSignature $signature;
            final /* synthetic */ JvmBackendContext $context;

            public void genInvokeInstruction(@NotNull InstructionAdapter v2) {
                StackValue stackValue;
                Intrinsics.checkParameterIsNotNull((Object)v2, (String)"v");
                IrStatementOrigin opToken = this.$expression.getOrigin();
                if (opToken == IrStatementOrigin.EQEQEQ.INSTANCE || opToken == IrStatementOrigin.EXCLEQEQ.INSTANCE) {
                    Type operandType = AsmUtil.isPrimitive((Type)this.$leftType.element) ? (Type)this.$leftType.element : AsmTypes.OBJECT_TYPE;
                    stackValue = StackValue.cmp(this.this$0.getOperator(), operandType, StackValue.onStack((Type)this.$leftType.element), StackValue.onStack((Type)this.$rightType.element));
                } else {
                    stackValue = AsmUtil.genEqualsForExpressionsOnStack(this.this$0.getOperator(), StackValue.onStack((Type)this.$leftType.element), StackValue.onStack((Type)this.$rightType.element));
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)stackValue, (String)"if (opToken === IrStatem\u2026tType))\n                }");
                StackValue value = stackValue;
                value.put(Type.BOOLEAN_TYPE, v2);
            }
            {
                this.this$0 = $outer;
                this.$expression = $captured_local_variable$1;
                this.$leftType = $captured_local_variable$2;
                this.$rightType = $captured_local_variable$3;
                this.$signature = $captured_local_variable$4;
                this.$context = $captured_local_variable$5;
                super($super_call_param$6, $super_call_param$7, $super_call_param$8, $super_call_param$9);
            }
        };
    }

    @NotNull
    public final IElementType getOperator() {
        return this.operator;
    }

    public Equals(@NotNull IElementType operator) {
        Intrinsics.checkParameterIsNotNull((Object)operator, (String)"operator");
        this.operator = operator;
    }
}

