/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.DataOutput;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;
import org.jetbrains.kotlin.com.intellij.util.io.IOUtil;
import org.jetbrains.kotlin.com.intellij.util.io.KeyDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentHashMap;
import org.jetbrains.kotlin.incremental.storage.LazyStorage$sam$com_intellij_util_io_PersistentHashMap_ValueDataAppender$0;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0002\u0010\nJ)\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00120\u0014H\u0002\u00a2\u0006\u0002\u0010\u0016J\u001b\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J\u001b\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u0012J\u0006\u0010\u001d\u001a\u00020\u0012J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010 J\u0014\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010H\u0002J\u000e\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u001fJ\u0018\u0010$\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0013\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010%J\u0016\u0010&\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0010H\u0002J\u0014\u0010'\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010H\u0002J\u0013\u0010(\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010)J\u001e\u0010*\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00028\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010+R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00108\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/LazyStorage;", "K", "V", "", "storageFile", "Ljava/io/File;", "keyDescriptor", "Lorg/jetbrains/kotlin/com/intellij/util/io/KeyDescriptor;", "valueExternalizer", "Lorg/jetbrains/kotlin/com/intellij/util/io/DataExternalizer;", "(Ljava/io/File;Lcom/intellij/util/io/KeyDescriptor;Lcom/intellij/util/io/DataExternalizer;)V", "keys", "", "getKeys", "()Ljava/util/Collection;", "storage", "Lorg/jetbrains/kotlin/com/intellij/util/io/PersistentHashMap;", "append", "", "key", "Lkotlin/Function1;", "Ljava/io/DataOutput;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "value", "", "(Ljava/lang/Object;I)V", "", "(Ljava/lang/Object;Ljava/lang/String;)V", "clean", "close", "contains", "", "(Ljava/lang/Object;)Z", "createMap", "flush", "memoryCachesOnly", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "getStorageIfExists", "getStorageOrCreateNew", "remove", "(Ljava/lang/Object;)V", "set", "(Ljava/lang/Object;Ljava/lang/Object;)V", "kotlin-build-common"})
public final class LazyStorage<K, V> {
    private volatile PersistentHashMap<K, V> storage;
    private final File storageFile;
    private final KeyDescriptor<K> keyDescriptor;
    private final DataExternalizer<V> valueExternalizer;

    private final synchronized PersistentHashMap<K, V> getStorageIfExists() {
        if (this.storage != null) {
            return this.storage;
        }
        if (this.storageFile.exists()) {
            this.storage = this.createMap();
            return this.storage;
        }
        return null;
    }

    private final synchronized PersistentHashMap<K, V> getStorageOrCreateNew() {
        if (this.storage == null) {
            this.storage = this.createMap();
        }
        PersistentHashMap<K, V> persistentHashMap = this.storage;
        if (persistentHashMap == null) {
            Intrinsics.throwNpe();
        }
        return persistentHashMap;
    }

    @NotNull
    public final Collection<K> getKeys() {
        PersistentHashMap<K, V> persistentHashMap = this.getStorageIfExists();
        if (persistentHashMap == null || (persistentHashMap = persistentHashMap.getAllKeysWithExistingMapping()) == null) {
            persistentHashMap = CollectionsKt.emptyList();
        }
        return persistentHashMap;
    }

    public final boolean contains(K key) {
        PersistentHashMap<K, V> persistentHashMap = this.getStorageIfExists();
        return persistentHashMap != null ? persistentHashMap.containsMapping(key) : false;
    }

    @Nullable
    public final V get(K key) {
        PersistentHashMap<K, V> persistentHashMap = this.getStorageIfExists();
        return (V)(persistentHashMap != null ? persistentHashMap.get(key) : null);
    }

    public final void set(K key, V value) {
        this.getStorageOrCreateNew().put(key, value);
    }

    public final void remove(K key) {
        block0: {
            PersistentHashMap<K, V> persistentHashMap = this.getStorageIfExists();
            if (persistentHashMap == null) break block0;
            persistentHashMap.remove(key);
        }
    }

    public final void append(K key, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.append(key, (Function1<DataOutput, Unit>)((Function1)new Function1<DataOutput, Unit>(value){
            final /* synthetic */ String $value;

            public final void invoke(@NotNull DataOutput out) {
                Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
                IOUtil.writeUTF(out, this.$value);
            }
            {
                this.$value = string;
                super(1);
            }
        }));
    }

    public final void append(K key, int value) {
        this.append(key, (Function1<DataOutput, Unit>)((Function1)new Function1<DataOutput, Unit>(value){
            final /* synthetic */ int $value;

            public final void invoke(@NotNull DataOutput out) {
                Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
                out.writeInt(this.$value);
            }
            {
                this.$value = n;
                super(1);
            }
        }));
    }

    public final synchronized void clean() {
        try {
            PersistentHashMap<K, V> persistentHashMap = this.storage;
            if (persistentHashMap != null) {
                persistentHashMap.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PersistentHashMap.deleteFilesStartingWith(this.storageFile);
        this.storage = null;
    }

    public final synchronized void flush(boolean memoryCachesOnly) {
        PersistentHashMap<K, V> persistentHashMap = this.storage;
        if (persistentHashMap == null) {
            return;
        }
        PersistentHashMap<K, V> existingStorage = persistentHashMap;
        if (memoryCachesOnly) {
            if (existingStorage.isDirty()) {
                existingStorage.dropMemoryCaches();
            }
        } else {
            existingStorage.force();
        }
    }

    public final synchronized void close() {
        block0: {
            PersistentHashMap<K, V> persistentHashMap = this.storage;
            if (persistentHashMap == null) break block0;
            persistentHashMap.close();
        }
    }

    private final PersistentHashMap<K, V> createMap() {
        return new PersistentHashMap<K, V>(this.storageFile, this.keyDescriptor, this.valueExternalizer);
    }

    private final void append(K key, Function1<? super DataOutput, Unit> append2) {
        PersistentHashMap<K, V> persistentHashMap = this.getStorageOrCreateNew();
        Object object = append2;
        if (object != null) {
            Function1<? super DataOutput, Unit> function1 = object;
            object = new LazyStorage$sam$com_intellij_util_io_PersistentHashMap_ValueDataAppender$0(function1);
        }
        persistentHashMap.appendData(key, (PersistentHashMap.ValueDataAppender)object);
    }

    public LazyStorage(@NotNull File storageFile, @NotNull KeyDescriptor<K> keyDescriptor, @NotNull DataExternalizer<V> valueExternalizer) {
        Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
        Intrinsics.checkParameterIsNotNull(keyDescriptor, (String)"keyDescriptor");
        Intrinsics.checkParameterIsNotNull(valueExternalizer, (String)"valueExternalizer");
        this.storageFile = storageFile;
        this.keyDescriptor = keyDescriptor;
        this.valueExternalizer = valueExternalizer;
    }
}

