/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ir;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.OperatorNames;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rJ\u0016\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rJ \u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0016\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rJ\u0016\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rJ\u0016\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rJ\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rJ\u0016\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rJ\u0016\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rJ\u0016\u0010\u001f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rJ\u0016\u0010 \u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rJ\u0016\u0010!\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rJ\u0016\u0010\"\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ir/JsIrArithBuilder;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "getSymbols", "()Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "add", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "l", "r", "and", "andand", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "buildBinaryOperator", "name", "Lorg/jetbrains/kotlin/name/Name;", "buildUnaryOperator", "v", "div", "inv", "mod", "mul", "not", "or", "oror", "shl", "shr", "shru", "sub", "backend.js"})
public final class JsIrArithBuilder {
    @NotNull
    private final Symbols<CommonBackendContext> symbols;
    @NotNull
    private final JsIrBackendContext context;

    @NotNull
    public final Symbols<CommonBackendContext> getSymbols() {
        return this.symbols;
    }

    private final IrExpression buildBinaryOperator(Name name, IrExpression l, IrExpression r) {
        IrCall irCall;
        IrFunctionSymbol symbol2;
        IrFunctionSymbol irFunctionSymbol = symbol2 = this.context.getOperatorByName(name, IrTypesKt.toKotlinType(l.getType()));
        if (irFunctionSymbol == null) {
            Intrinsics.throwNpe();
        }
        IrCall $receiver = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, irFunctionSymbol, null, null, 6, null);
        $receiver.setDispatchReceiver(l);
        $receiver.putValueArgument(0, r);
        return irCall;
    }

    private final IrExpression buildUnaryOperator(Name name, IrExpression v2) {
        IrCall irCall;
        IrFunctionSymbol irFunctionSymbol = this.context.getOperatorByName(name, IrTypesKt.toKotlinType(v2.getType()));
        if (irFunctionSymbol == null) {
            Intrinsics.throwNpe();
        }
        IrFunctionSymbol symbol2 = irFunctionSymbol;
        IrCall $receiver = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, symbol2, null, null, 6, null);
        $receiver.setDispatchReceiver(v2);
        return irCall;
    }

    @NotNull
    public final IrExpression add(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getADD(), l, r);
    }

    @NotNull
    public final IrExpression sub(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getSUB(), l, r);
    }

    @NotNull
    public final IrExpression mul(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getMUL(), l, r);
    }

    @NotNull
    public final IrExpression div(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getDIV(), l, r);
    }

    @NotNull
    public final IrExpression mod(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getMOD(), l, r);
    }

    @NotNull
    public final IrExpression and(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getAND(), l, r);
    }

    @NotNull
    public final IrExpression or(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getOR(), l, r);
    }

    @NotNull
    public final IrExpression shl(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getSHL(), l, r);
    }

    @NotNull
    public final IrExpression shr(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getSHR(), l, r);
    }

    @NotNull
    public final IrExpression shru(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        return this.buildBinaryOperator(OperatorNames.INSTANCE.getSHRU(), l, r);
    }

    @NotNull
    public final IrExpression not(@NotNull IrExpression v2) {
        Intrinsics.checkParameterIsNotNull((Object)v2, (String)"v");
        return this.buildUnaryOperator(OperatorNames.INSTANCE.getNOT(), v2);
    }

    @NotNull
    public final IrExpression inv(@NotNull IrExpression v2) {
        Intrinsics.checkParameterIsNotNull((Object)v2, (String)"v");
        return this.buildUnaryOperator(OperatorNames.INSTANCE.getINV(), v2);
    }

    @NotNull
    public final IrWhen andand(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        return JsIrBuilder.INSTANCE.buildIfElse(this.context.getIrBuiltIns().getBooleanType(), l, r, JsIrBuilder.INSTANCE.buildBoolean(this.context.getIrBuiltIns().getBooleanType(), false));
    }

    @NotNull
    public final IrWhen oror(@NotNull IrExpression l, @NotNull IrExpression r) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        return JsIrBuilder.INSTANCE.buildIfElse(this.context.getIrBuiltIns().getBooleanType(), l, JsIrBuilder.INSTANCE.buildBoolean(this.context.getIrBuiltIns().getBooleanType(), true), r);
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public JsIrArithBuilder(@NotNull JsIrBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.symbols = this.context.getIr().getSymbols();
    }
}

