/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=2, xi=2, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\n\u0010\u0017\u001a\u00020\u0006*\u00020\u0018\u001a\n\u0010\u0019\u001a\u00020\u0006*\u00020\u001a\u001a\n\u0010\u0019\u001a\u00020\u0006*\u00020\u0018\u001a\n\u0010\u001b\u001a\u00020\u0006*\u00020\n\u001a\n\u0010\u001c\u001a\u00020\u0006*\u00020\u001d\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\"\u0015\u0010\t\u001a\u00020\n*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"constructedClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "getConstructedClass", "(Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;)Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isReified", "", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "(Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;)Z", "propertyIfAccessor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "getPropertyIfAccessor", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;)Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "createValueParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "containingDeclaration", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "index", "", "name", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "isDynamic", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "isEffectivelyExternal", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isFakeOverriddenFromAny", "isSuperToAny", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "backend.js"})
public final class DescriptorBasedUtilsKt {
    @NotNull
    public static final ClassDescriptor getConstructedClass(@NotNull IrConstructorSymbol $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassDescriptor classDescriptor2 = ((ClassConstructorDescriptor)$receiver.getDescriptor()).getConstructedClass();
        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"descriptor.constructedClass");
        return classDescriptor2;
    }

    @NotNull
    public static final ValueParameterDescriptor createValueParameter(@NotNull CallableDescriptor containingDeclaration, int index2, @NotNull String name, @NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)containingDeclaration, (String)"containingDeclaration");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        Name name2 = Name.identifier(name);
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(name)");
        SourceElement sourceElement = SourceElement.NO_SOURCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"SourceElement.NO_SOURCE");
        return new ValueParameterDescriptorImpl(containingDeclaration, null, index2, annotations2, name2, type2, false, false, false, null, sourceElement);
    }

    @NotNull
    public static final CallableMemberDescriptor getPropertyIfAccessor(@NotNull CallableMemberDescriptor $receiver) {
        CallableMemberDescriptor callableMemberDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"this.correspondingProperty");
            callableMemberDescriptor = propertyDescriptor;
        } else {
            callableMemberDescriptor = $receiver;
        }
        return callableMemberDescriptor;
    }

    public static final boolean isReified(@NotNull IrTypeParameter $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getDescriptor().isReified();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isFakeOverriddenFromAny(@NotNull CallableMemberDescriptor $receiver) {
        CallableMemberDescriptor callableMemberDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        CallableMemberDescriptor.Kind kind = $receiver.getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kind), (String)"kind");
        if (kind.isReal()) {
            if (!($receiver.getContainingDeclaration() instanceof ClassDescriptor)) return false;
            DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            if (!KotlinBuiltIns.isAny((ClassDescriptor)declarationDescriptor)) return false;
            return true;
        }
        Collection<? extends CallableMemberDescriptor> collection = $receiver.getOverriddenDescriptors();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"overriddenDescriptors");
        Iterable $receiver$iv = collection;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            CallableMemberDescriptor it;
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            callableMemberDescriptor = it = (CallableMemberDescriptor)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"it");
        } while (DescriptorBasedUtilsKt.isFakeOverriddenFromAny(callableMemberDescriptor));
        return false;
    }

    public static final boolean isEffectivelyExternal(@NotNull IrDeclaration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return DescriptorUtilsKt.isEffectivelyExternal($receiver.getDescriptor());
    }

    public static final boolean isEffectivelyExternal(@NotNull IrSymbol $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return DescriptorUtilsKt.isEffectivelyExternal($receiver.getDescriptor());
    }

    public static final boolean isDynamic(@NotNull IrSymbol $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return DynamicCallsKt.isDynamic($receiver.getDescriptor());
    }

    public static final boolean isSuperToAny(@NotNull IrCall $receiver) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassDescriptor classDescriptor2 = $receiver.getSuperQualifier();
        if (classDescriptor2 != null) {
            ClassDescriptor classDescriptor3;
            ClassDescriptor it = classDescriptor3 = classDescriptor2;
            bl = DescriptorBasedUtilsKt.isFakeOverriddenFromAny($receiver.getSymbol().getOwner().getDescriptor());
        } else {
            bl = false;
        }
        return bl;
    }
}

