/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.backend.js.utils.NameGenerator;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.backend.js.utils.SimpleNameGenerator;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.naming.NameSuggestionKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/SimpleNameGenerator;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameGenerator;", "()V", "loopCache", "", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "nameCache", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getNameForDescriptor", "descriptor", "context", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "getNameForLoop", "loop", "getNameForSymbol", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "sanitizeName", "", "name", "backend.js"})
public final class SimpleNameGenerator
implements NameGenerator {
    private final Map<DeclarationDescriptor, JsName> nameCache;
    private final Map<IrLoop, JsName> loopCache;

    @Override
    @NotNull
    public JsName getNameForSymbol(@NotNull IrSymbol symbol2, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)symbol2, (String)"symbol");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.getNameForDescriptor(symbol2.getDescriptor(), context);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public JsName getNameForLoop(@NotNull IrLoop loop2, @NotNull JsGenerationContext context) {
        JsName jsName;
        Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string = loop2.getLabel();
        if (string != null) {
            Object object;
            void $receiver$iv;
            String string2;
            String it = string2 = string;
            Map<IrLoop, JsName> map2 = this.loopCache;
            IrLoop key$iv = loop2;
            Object value$iv = $receiver$iv.get(key$iv);
            if (value$iv == null) {
                JsScope jsScope = context.getCurrentScope();
                String string3 = loop2.getLabel();
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                JsName jsName2 = jsScope.declareFreshName(this.sanitizeName(string3));
                Intrinsics.checkExpressionValueIsNotNull((Object)jsName2, (String)"context.currentScope.dec\u2026nitizeName(loop.label!!))");
                JsName answer$iv = jsName2;
                $receiver$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            jsName = (JsName)object;
        } else {
            jsName = null;
        }
        return jsName;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final JsName getNameForDescriptor(DeclarationDescriptor descriptor2, JsGenerationContext context) {
        DeclarationDescriptor declarationDescriptor;
        JsName jsName;
        JsName jsName2;
        Map<DeclarationDescriptor, JsName> $receiver$iv = this.nameCache;
        JsName value$iv = $receiver$iv.get(descriptor2);
        if (value$iv != null) {
            jsName2 = value$iv;
            return jsName2;
        }
        Function1 nameDeclarator2 = (Function1)new Function1<String, JsName>(context.getCurrentScope()){

            @NotNull
            public final JsName invoke(@NotNull String p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((JsScope)this.receiver).declareName(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(JsScope.class);
            }

            public final String getName() {
                return "declareName";
            }

            public final String getSignature() {
                return "declareName(Ljava/lang/String;)Lorg/jetbrains/kotlin/js/backend/ast/JsName;";
            }
        };
        if (DynamicCallsKt.isDynamic(descriptor2)) {
            String string = descriptor2.getName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"descriptor.name.asString()");
            jsName = (JsName)nameDeclarator2.invoke((Object)string);
        } else if (descriptor2 instanceof MemberDescriptor && DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2)) {
            MemberDescriptor memberDescriptor;
            declarationDescriptor = descriptor2;
            if (declarationDescriptor instanceof ConstructorDescriptor) {
                ClassDescriptor classDescriptor2 = ((ConstructorDescriptor)descriptor2).getConstructedClass();
                Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"descriptor.constructedClass");
                memberDescriptor = classDescriptor2;
            } else if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
                PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty();
                Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"descriptor.correspondingProperty");
                memberDescriptor = propertyDescriptor;
            } else {
                memberDescriptor = (MemberDescriptor)descriptor2;
            }
            MemberDescriptor descriptorForName = memberDescriptor;
            String string = descriptorForName.getName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"descriptorForName.name.asString()");
            jsName = (JsName)nameDeclarator2.invoke((Object)string);
        } else {
            StringBuilder nameBuilder = new StringBuilder();
            declarationDescriptor = descriptor2;
            if (declarationDescriptor instanceof ReceiverParameterDescriptor) {
                ReceiverValue receiverValue = ((ReceiverParameterDescriptor)descriptor2).getValue();
                if (receiverValue instanceof ExtensionReceiver) {
                    nameBuilder.append(Namer.INSTANCE.getEXTENSION_RECEIVER_NAME());
                } else {
                    if (!(receiverValue instanceof ImplicitClassReceiver)) {
                        String string = "name for " + descriptor2;
                        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
                    }
                    nameBuilder.append(Namer.INSTANCE.getIMPLICIT_RECEIVER_NAME());
                }
            } else if (declarationDescriptor instanceof ValueParameterDescriptor) {
                String string = ((ValueParameterDescriptor)descriptor2).getName().asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"descriptor.name.asString()");
                String declaredName = string;
                nameBuilder.append(declaredName);
                nameDeclarator2 = (Function1)new Function1<String, JsName>(context.getCurrentScope()){

                    @NotNull
                    public final JsName invoke(@NotNull String p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        return ((JsScope)this.receiver).declareFreshName(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(JsScope.class);
                    }

                    public final String getName() {
                        return "declareFreshName";
                    }

                    public final String getSignature() {
                        return "declareFreshName(Ljava/lang/String;)Lorg/jetbrains/kotlin/js/backend/ast/JsName;";
                    }
                };
            } else if (declarationDescriptor instanceof PropertyDescriptor) {
                nameBuilder.append(((PropertyDescriptor)descriptor2).getName().asString());
                if (Intrinsics.areEqual((Object)((PropertyDescriptor)descriptor2).getVisibility(), (Object)Visibilities.PRIVATE) || ((PropertyDescriptor)descriptor2).getModality() != Modality.FINAL) {
                    nameBuilder.append('$');
                    DeclarationDescriptor declarationDescriptor2 = ((PropertyDescriptor)descriptor2).getContainingDeclaration();
                    Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"descriptor.containingDeclaration");
                    nameBuilder.append(this.getNameForDescriptor(declarationDescriptor2, context));
                }
            } else if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
                DeclarationDescriptor declaredName = descriptor2;
                if (declaredName instanceof PropertyGetterDescriptor) {
                    nameBuilder.append(Namer.INSTANCE.getGETTER_PREFIX());
                } else if (declaredName instanceof PropertySetterDescriptor) {
                    nameBuilder.append(Namer.INSTANCE.getSETTER_PREFIX());
                }
                PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty();
                Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"descriptor.correspondingProperty");
                nameBuilder.append(propertyDescriptor.getName().asString());
                ReceiverParameterDescriptor receiverParameterDescriptor = ((PropertyAccessorDescriptor)descriptor2).getExtensionReceiverParameter();
                if (receiverParameterDescriptor != null) {
                    DeclarationDescriptor it = declaredName = receiverParameterDescriptor;
                    StringBuilder stringBuilder = new StringBuilder().append("_r$");
                    DeclarationDescriptor declarationDescriptor3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor3, (String)"it");
                    nameBuilder.append(stringBuilder.append(declarationDescriptor3.getType()).toString());
                }
                if (Intrinsics.areEqual((Object)((PropertyAccessorDescriptor)descriptor2).getVisibility(), (Object)Visibilities.PRIVATE)) {
                    nameBuilder.append('$');
                    DeclarationDescriptor declarationDescriptor4 = ((PropertyAccessorDescriptor)descriptor2).getContainingDeclaration();
                    Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor4, (String)"descriptor.containingDeclaration");
                    nameBuilder.append(this.getNameForDescriptor(declarationDescriptor4, context));
                }
            } else if (declarationDescriptor instanceof ClassDescriptor) {
                Name name = ((ClassDescriptor)descriptor2).getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"descriptor.name");
                if (name.isSpecial()) {
                    String declaredName = ((ClassDescriptor)descriptor2).getName().asString();
                    StringBuilder stringBuilder = nameBuilder;
                    String it = declaredName;
                    StringBuilder stringBuilder2 = new StringBuilder();
                    String string = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                    String $i$a$2$let = string;
                    int n = 1;
                    int n2 = it.length() - 1;
                    StringBuilder stringBuilder3 = stringBuilder2;
                    String string2 = $i$a$2$let;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(n, n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string4 = string3;
                    String string5 = stringBuilder3.append(string4).append(descriptor2.hashCode()).toString();
                    stringBuilder.append(string5);
                } else {
                    String string = DescriptorUtilsKt.getFqNameSafe(descriptor2).asString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"descriptor.fqNameSafe.asString()");
                    nameBuilder.append(StringsKt.replace$default((String)string, (char)'.', (char)'$', (boolean)false, (int)4, null));
                }
            } else if (declarationDescriptor instanceof ConstructorDescriptor) {
                ClassDescriptor classDescriptor3 = ((ConstructorDescriptor)descriptor2).getConstructedClass();
                Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor3, (String)"descriptor.constructedClass");
                nameBuilder.append(this.getNameForDescriptor(classDescriptor3, context));
            } else if (declarationDescriptor instanceof VariableDescriptor) {
                Name name = ((VariableDescriptor)descriptor2).getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"descriptor.name");
                nameBuilder.append(name.getIdentifier());
                nameDeclarator2 = (Function1)new Function1<String, JsName>(context.getCurrentScope()){

                    @NotNull
                    public final JsName invoke(@NotNull String p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        return ((JsScope)this.receiver).declareFreshName(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(JsScope.class);
                    }

                    public final String getName() {
                        return "declareFreshName";
                    }

                    public final String getSignature() {
                        return "declareFreshName(Ljava/lang/String;)Lorg/jetbrains/kotlin/js/backend/ast/JsName;";
                    }
                };
            } else if (declarationDescriptor instanceof CallableDescriptor) {
                Object object;
                List $receiver;
                Object $receiver$iv2;
                nameBuilder.append(((CallableDescriptor)descriptor2).getName().asString());
                Object it = $receiver$iv2 = (Collection)((CallableDescriptor)descriptor2).getTypeParameters();
                if (!it.isEmpty()) {
                    $receiver = (List)$receiver$iv2;
                    nameBuilder.append("_$t");
                    StringBuilder cfr_ignored_0 = (StringBuilder)CollectionsKt.joinTo$default((Iterable)$receiver, (Appendable)nameBuilder, (CharSequence)"", null, null, (int)0, null, (Function1)getNameForDescriptor.1.5.1.INSTANCE, (int)60, null);
                }
                ReceiverParameterDescriptor receiverParameterDescriptor = ((CallableDescriptor)descriptor2).getExtensionReceiverParameter();
                if (receiverParameterDescriptor != null) {
                    it = $receiver$iv2 = receiverParameterDescriptor;
                    StringBuilder stringBuilder = new StringBuilder().append("_r$");
                    Object object2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"it");
                    nameBuilder.append(stringBuilder.append(object2.getType()).toString());
                }
                if (!(object = ($receiver$iv2 = (Collection)((CallableDescriptor)descriptor2).getValueParameters())).isEmpty()) {
                    $receiver = (List)$receiver$iv2;
                    StringBuilder cfr_ignored_1 = (StringBuilder)CollectionsKt.joinTo$default((Iterable)$receiver, (Appendable)nameBuilder, (CharSequence)"", null, null, (int)0, null, (Function1)getNameForDescriptor.1.7.1.INSTANCE, (int)60, null);
                }
            }
            String string = nameBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"nameBuilder.toString()");
            jsName = (JsName)nameDeclarator2.invoke((Object)this.sanitizeName(string));
        }
        JsName answer$iv = jsName;
        $receiver$iv.put(descriptor2, answer$iv);
        jsName2 = answer$iv;
        return jsName2;
    }

    /*
     * WARNING - void declaration
     */
    private final String sanitizeName(String name) {
        Collection<Character> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        CharSequence charSequence = name;
        if (charSequence.length() == 0) {
            return "_";
        }
        char c = StringsKt.first((CharSequence)name);
        char it22 = c;
        char first2 = NameSuggestionKt.isES5IdentifierStart(it22) ? it22 : (char)'_';
        CharSequence charSequence2 = StringsKt.drop((String)name, (int)1);
        StringBuilder stringBuilder = new StringBuilder().append(String.valueOf(first2));
        void it22 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length());
        void var6_10 = $receiver$iv$iv;
        for (int i = 0; i < var6_10.length(); ++i) {
            char it;
            char item$iv$iv;
            char c2 = item$iv$iv = var6_10.charAt(i);
            collection = destination$iv$iv;
            Character c3 = Character.valueOf(NameSuggestionKt.isES5IdentifierPart(it) ? it : (char)'_');
            collection.add(c3);
        }
        collection = (List)destination$iv$iv;
        return stringBuilder.append(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"", null, null, (int)0, null, null, (int)62, null)).toString();
    }

    public SimpleNameGenerator() {
        Map map2;
        SimpleNameGenerator simpleNameGenerator = this;
        simpleNameGenerator.nameCache = map2 = (Map)new LinkedHashMap();
        simpleNameGenerator = this;
        simpleNameGenerator.loopCache = map2 = (Map)new LinkedHashMap();
    }
}

