/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclarationStub;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinScriptStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.ScriptDefinitionProvider;

public class KtScript
extends KtNamedDeclarationStub<KotlinScriptStub>
implements KtDeclarationContainer {
    public final Lazy<KotlinScriptDefinition> kotlinScriptDefinition = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> {
        ScriptDefinitionProvider definitionsProvider = ScriptDefinitionProvider.Companion.getInstance(this.getProject());
        KotlinScriptDefinition definition = definitionsProvider.findScriptDefinition(this.getContainingKtFile().getName());
        return definition != null ? definition : definitionsProvider.getDefaultScriptDefinition();
    });

    public KtScript(@NotNull ASTNode node) {
        super(node);
    }

    public KtScript(@NotNull KotlinScriptStub stub2) {
        super(stub2, KtStubElementTypes.SCRIPT);
    }

    @Override
    @NotNull
    public FqName getFqName() {
        KotlinScriptStub stub2 = (KotlinScriptStub)this.getStub();
        if (stub2 != null) {
            return stub2.getFqName();
        }
        KtFile containingKtFile = this.getContainingKtFile();
        return containingKtFile.getPackageFqName().child(((KotlinScriptDefinition)this.kotlinScriptDefinition.getValue()).getScriptName(this));
    }

    @Override
    public String getName() {
        return this.getFqName().shortName().asString();
    }

    @NotNull
    public KtBlockExpression getBlockExpression() {
        return this.findNotNullChildByClass(KtBlockExpression.class);
    }

    @Override
    @NotNull
    public List<KtDeclaration> getDeclarations() {
        return PsiTreeUtil.getChildrenOfTypeAsList(this.getBlockExpression(), KtDeclaration.class);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        return visitor2.visitScript(this, data);
    }
}

