/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtPlaceHolderStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J=\u0010\b\u001a\n \n*\u0004\u0018\u0001H\tH\t\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u000b0\r2\u0006\u0010\u000e\u001a\u0002H\u000bH\u0016\u00a2\u0006\u0002\u0010\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0019\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "Lorg/jetbrains/kotlin/psi/KtConstructor;", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinPlaceHolderStub;", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinPlaceHolderStub;)V", "accept", "R", "kotlin.jvm.PlatformType", "D", "visitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "getBodyExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "getConstructorKeyword", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "getContainingClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getDelegationCall", "Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;", "hasImplicitDelegationCall", "", "replaceImplicitDelegationCallWithExplicit", "isThis", "psi"})
public final class KtSecondaryConstructor
extends KtConstructor<KtSecondaryConstructor> {
    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        Intrinsics.checkParameterIsNotNull(visitor2, (String)"visitor");
        return visitor2.visitSecondaryConstructor(this, data);
    }

    @Override
    @NotNull
    public KtClassOrObject getContainingClassOrObject() {
        PsiElement psiElement = this.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"parent");
        PsiElement psiElement2 = psiElement.getParent();
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
        }
        return (KtClassOrObject)psiElement2;
    }

    @Override
    @Nullable
    public KtBlockExpression getBodyExpression() {
        return this.findChildByClass(KtBlockExpression.class);
    }

    @Override
    @NotNull
    public PsiElement getConstructorKeyword() {
        return this.notNullChild(super.getConstructorKeyword());
    }

    @NotNull
    public final KtConstructorDelegationCall getDelegationCall() {
        return this.findNotNullChildByClass(KtConstructorDelegationCall.class);
    }

    public final boolean hasImplicitDelegationCall() {
        return this.getDelegationCall().isImplicit();
    }

    @NotNull
    public final KtConstructorDelegationCall replaceImplicitDelegationCallWithExplicit(boolean isThis) {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        KtConstructorDelegationCall current = this.getDelegationCall();
        boolean bl = current.isImplicit();
        if (_Assertions.ENABLED && !bl) {
            String string = "Method should not be called with explicit delegation call: " + this.getText();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        current.delete();
        PsiElement colon = this.addAfter(psiFactory.createColon(), this.getValueParameterList());
        String delegationName = isThis ? "this" : "super";
        PsiElement psiElement = this.addAfter(psiFactory.creareDelegatedSuperTypeEntry(delegationName + "()"), colon);
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtConstructorDelegationCall");
        }
        return (KtConstructorDelegationCall)psiElement;
    }

    public KtSecondaryConstructor(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        super(node);
    }

    public KtSecondaryConstructor(@NotNull KotlinPlaceHolderStub<KtSecondaryConstructor> stub2) {
        Intrinsics.checkParameterIsNotNull(stub2, (String)"stub");
        KtPlaceHolderStubElementType<KtSecondaryConstructor> ktPlaceHolderStubElementType = KtStubElementTypes.SECONDARY_CONSTRUCTOR;
        Intrinsics.checkExpressionValueIsNotNull(ktPlaceHolderStubElementType, (String)"KtStubElementTypes.SECONDARY_CONSTRUCTOR");
        super(stub2, ktPlaceHolderStubElementType);
    }
}

