/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.checkers.PrimitiveNumericComparisonInfo;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J2\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u0014*\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u0014*\u00020\u0014H\u0002J\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J\f\u0010\u001f\u001a\u00020\u0014*\u00020\u0014H\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/PrimitiveNumericComparisonCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "comparisonOperatorTokens", "", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "inferPrimitiveNumericComparisonType", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "leftTypes", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "rightTypes", "comparison", "Lorg/jetbrains/kotlin/psi/KtExpression;", "leastCommonPrimitiveNumericType", "t1", "t2", "findPrimitiveType", "getPrimitiveTypeOrSupertype", "getStableTypesForExpression", "expression", "promoteIntegerTypeToIntIfRequired", "frontend"})
public final class PrimitiveNumericComparisonCallChecker
implements CallChecker {
    private static final Set<KtSingleValueToken> comparisonOperatorTokens;
    public static final PrimitiveNumericComparisonCallChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
        KtElement ktElement = call2.getCallElement();
        if (!(ktElement instanceof KtBinaryExpression)) {
            ktElement = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktElement;
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression binaryExpression = ktBinaryExpression;
        if (!CollectionsKt.contains((Iterable)comparisonOperatorTokens, (Object)binaryExpression.getOperationReference().getReferencedNameElementType())) {
            return;
        }
        KtExpression ktExpression = binaryExpression.getLeft();
        if (ktExpression == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"binaryExpression.left ?: return");
        KtExpression leftExpr = ktExpression;
        KtExpression ktExpression2 = binaryExpression.getRight();
        if (ktExpression2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"binaryExpression.right ?: return");
        KtExpression rightExpr = ktExpression2;
        List<KotlinType> leftTypes = this.getStableTypesForExpression(context, leftExpr);
        List<KotlinType> rightTypes = this.getStableTypesForExpression(context, rightExpr);
        this.inferPrimitiveNumericComparisonType(context.getTrace(), leftTypes, rightTypes, binaryExpression);
    }

    public final void inferPrimitiveNumericComparisonType(@NotNull BindingTrace trace, @NotNull List<? extends KotlinType> leftTypes, @NotNull List<? extends KotlinType> rightTypes, @NotNull KtExpression comparison) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull(leftTypes, (String)"leftTypes");
        Intrinsics.checkParameterIsNotNull(rightTypes, (String)"rightTypes");
        Intrinsics.checkParameterIsNotNull((Object)comparison, (String)"comparison");
        KotlinType kotlinType = this.findPrimitiveType(leftTypes);
        if (kotlinType == null) {
            return;
        }
        KotlinType leftPrimitiveType = kotlinType;
        KotlinType kotlinType2 = this.findPrimitiveType(rightTypes);
        if (kotlinType2 == null) {
            return;
        }
        KotlinType rightPrimitiveType = kotlinType2;
        KotlinType leastCommonType = this.leastCommonPrimitiveNumericType(leftPrimitiveType, rightPrimitiveType);
        trace.record(BindingContext.PRIMITIVE_NUMERIC_COMPARISON_INFO, comparison, new PrimitiveNumericComparisonInfo(leastCommonType, leftPrimitiveType, rightPrimitiveType));
    }

    private final KotlinType leastCommonPrimitiveNumericType(KotlinType t1, KotlinType t2) {
        SimpleType simpleType2;
        KotlinType pt1 = this.promoteIntegerTypeToIntIfRequired(t1);
        KotlinType pt2 = this.promoteIntegerTypeToIntIfRequired(t2);
        if (TypeUtilsKt.isDouble(pt1) || TypeUtilsKt.isDouble(pt2)) {
            simpleType2 = TypeUtilsKt.getBuiltIns(t1).getDoubleType();
        } else if (TypeUtilsKt.isFloat(pt1) || TypeUtilsKt.isFloat(pt2)) {
            simpleType2 = TypeUtilsKt.getBuiltIns(t1).getFloatType();
        } else if (TypeUtilsKt.isLong(pt1) || TypeUtilsKt.isLong(pt2)) {
            simpleType2 = TypeUtilsKt.getBuiltIns(t1).getLongType();
        } else if (TypeUtilsKt.isInt(pt1) || TypeUtilsKt.isInt(pt2)) {
            simpleType2 = TypeUtilsKt.getBuiltIns(t1).getIntType();
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected types: t1=" + t1 + ", t2=" + t2)));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"when {\n            pt1.i\u20261=$t1, t2=$t2\")\n        }");
        return simpleType2;
    }

    private final KotlinType promoteIntegerTypeToIntIfRequired(@NotNull KotlinType $receiver) {
        KotlinType kotlinType;
        if (!TypeUtilsKt.isPrimitiveNumberType($receiver)) {
            throw (Throwable)((Object)new AssertionError((Object)("Primitive number type expected: " + $receiver)));
        }
        if (TypeUtilsKt.isByte($receiver) || TypeUtilsKt.isShort($receiver)) {
            SimpleType simpleType2 = TypeUtilsKt.getBuiltIns($receiver).getIntType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"builtIns.intType");
            kotlinType = simpleType2;
        } else {
            kotlinType = $receiver;
        }
        return kotlinType;
    }

    private final List<KotlinType> getStableTypesForExpression(@NotNull CallCheckerContext $receiver, KtExpression expression2) {
        KotlinType kotlinType = $receiver.getTrace().getBindingContext().getType(expression2);
        if (kotlinType == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"trace.bindingContext.get\u2026on) ?: return emptyList()");
        KotlinType type2 = kotlinType;
        DataFlowValueFactory dataFlowValueFactory = $receiver.getDataFlowValueFactory();
        BindingContext bindingContext = $receiver.getTrace().getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        DataFlowValue dataFlowValue2 = dataFlowValueFactory.createDataFlowValue(expression2, type2, bindingContext, $receiver.getResolutionContext().scope.getOwnerDescriptor());
        Object object = (KotlinTypeInfo)$receiver.getTrace().get(BindingContext.EXPRESSION_TYPE_INFO, expression2);
        if (object == null || (object = ((KotlinTypeInfo)object).getDataFlowInfo()) == null) {
            return CollectionsKt.emptyList();
        }
        Object dataFlowInfo = object;
        Set<KotlinType> stableTypes = dataFlowInfo.getStableTypes(dataFlowValue2, $receiver.getLanguageVersionSettings());
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)type2), (Iterable)stableTypes);
    }

    private final KotlinType findPrimitiveType(@NotNull List<? extends KotlinType> $receiver) {
        KotlinType kotlinType;
        block1: {
            Iterable $receiver$iv = $receiver;
            for (Object element$iv : $receiver$iv) {
                KotlinType it = (KotlinType)element$iv;
                KotlinType result$iv = INSTANCE.getPrimitiveTypeOrSupertype(it);
                if (result$iv == null) continue;
                kotlinType = result$iv;
                break block1;
            }
            kotlinType = null;
        }
        return kotlinType;
    }

    private final KotlinType getPrimitiveTypeOrSupertype(@NotNull KotlinType $receiver) {
        KotlinType kotlinType;
        block3: {
            if ($receiver.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
                Iterable $receiver$iv = TypeUtilsKt.immediateSupertypes($receiver);
                for (Object element$iv : $receiver$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    KotlinType result$iv = INSTANCE.getPrimitiveTypeOrSupertype(it);
                    if (result$iv == null) continue;
                    kotlinType = result$iv;
                    break block3;
                }
                kotlinType = null;
            } else {
                kotlinType = TypeUtilsKt.isPrimitiveNumberOrNullableType($receiver) ? TypeUtilsKt.makeNotNullable($receiver) : null;
            }
        }
        return kotlinType;
    }

    private PrimitiveNumericComparisonCallChecker() {
    }

    static {
        PrimitiveNumericComparisonCallChecker primitiveNumericComparisonCallChecker;
        INSTANCE = primitiveNumericComparisonCallChecker = new PrimitiveNumericComparisonCallChecker();
        comparisonOperatorTokens = SetsKt.setOf((Object[])new KtSingleValueToken[]{KtTokens.EQEQ, KtTokens.EXCLEQ, KtTokens.LT, KtTokens.LTEQ, KtTokens.GT, KtTokens.GTEQ});
    }
}

