/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.OverloadFilter;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/JvmOverloadFilter;", "Lorg/jetbrains/kotlin/resolve/OverloadFilter;", "()V", "filterPackageMemberOverloads", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorNonRoot;", "overloads", "frontend.java"})
public final class JvmOverloadFilter
implements OverloadFilter {
    public static final JvmOverloadFilter INSTANCE;

    @Override
    @NotNull
    public Collection<DeclarationDescriptorNonRoot> filterPackageMemberOverloads(@NotNull Collection<? extends DeclarationDescriptorNonRoot> overloads) {
        Intrinsics.checkParameterIsNotNull(overloads, (String)"overloads");
        ArrayList<DeclarationDescriptorNonRoot> result2 = new ArrayList<DeclarationDescriptorNonRoot>();
        HashSet<FqName> sourceClassesFQNs = new HashSet<FqName>();
        for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot : overloads) {
            KtFile file2;
            if (DescriptorToSourceUtils.getContainingFile(declarationDescriptorNonRoot) == null) {
                continue;
            }
            result2.add(declarationDescriptorNonRoot);
            sourceClassesFQNs.add(JvmFileClassUtil.getFileClassInfoNoResolve(file2).getFileClassFqName());
        }
        for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot : overloads) {
            FqName implClassFQN;
            if (declarationDescriptorNonRoot instanceof ConstructorDescriptor || !(declarationDescriptorNonRoot instanceof DeserializedCallableMemberDescriptor) || sourceClassesFQNs.contains(implClassFQN = JvmFileClassUtil.INSTANCE.getPartFqNameForDeserialized((DeserializedMemberDescriptor)declarationDescriptorNonRoot))) continue;
            result2.add(declarationDescriptorNonRoot);
        }
        return result2;
    }

    private JvmOverloadFilter() {
    }

    static {
        JvmOverloadFilter jvmOverloadFilter;
        INSTANCE = jvmOverloadFilter = new JvmOverloadFilter();
    }
}

