/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.extensions;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.container.DslKt;
import org.jetbrains.kotlin.context.ProjectContext;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodyResolver;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzer;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.jvm.extensions.AnalysisHandlerExtension;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.TypeConstructor;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J@\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J*\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001c0\u001eH\u0002J$\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001f2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001c0\u001eH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/extensions/PartialAnalysisHandlerExtension;", "Lorg/jetbrains/kotlin/resolve/jvm/extensions/AnalysisHandlerExtension;", "()V", "analyzePartially", "", "getAnalyzePartially", "()Z", "containingScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getContainingScope", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "doAnalysis", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "projectContext", "Lorg/jetbrains/kotlin/context/ProjectContext;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "bindingTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "componentProvider", "Lorg/jetbrains/kotlin/container/ComponentProvider;", "doForEachDeclaration", "", "f", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "frontend.java"})
public class PartialAnalysisHandlerExtension
implements AnalysisHandlerExtension {
    protected boolean getAnalyzePartially() {
        return true;
    }

    @Override
    @Nullable
    public AnalysisResult doAnalysis(@NotNull Project project, @NotNull ModuleDescriptor module2, @NotNull ProjectContext projectContext, @NotNull Collection<? extends KtFile> files2, @NotNull BindingTrace bindingTrace, @NotNull ComponentProvider componentProvider) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)projectContext, (String)"projectContext");
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)bindingTrace, (String)"bindingTrace");
        Intrinsics.checkParameterIsNotNull((Object)componentProvider, (String)"componentProvider");
        if (!this.getAnalyzePartially()) {
            return null;
        }
        ComponentProvider $receiver$iv = componentProvider;
        ResolveSession resolveSession = DslKt.getService($receiver$iv, ResolveSession.class);
        ComponentProvider $receiver$iv2 = componentProvider;
        BodyResolver bodyResolver = DslKt.getService($receiver$iv2, BodyResolver.class);
        ComponentProvider $receiver$iv3 = componentProvider;
        DeclarationScopeProvider declarationScopeProvider = DslKt.getService($receiver$iv3, DeclarationScopeProvider.class);
        ComponentProvider $receiver$iv4 = componentProvider;
        LazyTopDownAnalyzer topDownAnalyzer = DslKt.getService($receiver$iv4, LazyTopDownAnalyzer.class);
        TopDownAnalysisContext topDownAnalysisContext = new TopDownAnalysisContext(TopDownAnalysisMode.TopLevelDeclarations, DataFlowInfo.Companion.getEMPTY(), declarationScopeProvider);
        for (KtFile ktFile : files2) {
            ForceResolveUtil.forceResolveAllContents(resolveSession.getFileAnnotations(ktFile));
            topDownAnalyzer.resolveImportsInFile(ktFile);
        }
        this.doForEachDeclaration(files2, (Function1<? super KtDeclaration, Unit>)((Function1)new Function1<KtDeclaration, Unit>(this, resolveSession, bodyResolver, topDownAnalysisContext, bindingTrace){
            final /* synthetic */ PartialAnalysisHandlerExtension this$0;
            final /* synthetic */ ResolveSession $resolveSession;
            final /* synthetic */ BodyResolver $bodyResolver;
            final /* synthetic */ TopDownAnalysisContext $topDownAnalysisContext;
            final /* synthetic */ BindingTrace $bindingTrace;

            public final void invoke(@NotNull KtDeclaration declaration) {
                DeclarationDescriptor descriptor2;
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                DeclarationDescriptor declarationDescriptor = this.$resolveSession.resolveToDescriptor(declaration);
                Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"resolveSession.resolveToDescriptor(declaration)");
                DeclarationDescriptor declarationDescriptor2 = descriptor2 = declarationDescriptor;
                if (declarationDescriptor2 instanceof ClassDescriptor) {
                    ForceResolveUtil.forceResolveAllContents(descriptor2);
                    TypeConstructor typeConstructor2 = ((ClassDescriptor)descriptor2).getTypeConstructor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"descriptor.typeConstructor");
                    ForceResolveUtil.forceResolveAllContents(typeConstructor2.getSupertypes());
                    if (declaration instanceof KtClassOrObject && descriptor2 instanceof ClassDescriptorWithResolutionScopes) {
                        this.$bodyResolver.resolveSuperTypeEntryList(DataFlowInfo.Companion.getEMPTY(), (KtClassOrObject)declaration, (ClassDescriptor)descriptor2, ((ClassDescriptorWithResolutionScopes)descriptor2).getUnsubstitutedPrimaryConstructor(), ((ClassDescriptorWithResolutionScopes)descriptor2).getScopeForConstructorHeaderResolution(), ((ClassDescriptorWithResolutionScopes)descriptor2).getScopeForMemberDeclarationResolution());
                    }
                } else if (declarationDescriptor2 instanceof PropertyDescriptor) {
                    if (declaration instanceof KtProperty) {
                        this.$bodyResolver.resolveProperty(this.$topDownAnalysisContext, (KtProperty)declaration, (PropertyDescriptor)descriptor2);
                    } else if (declaration instanceof KtParameter) {
                        LexicalScope containingScope;
                        DeclarationDescriptor ownerDescriptor;
                        KtDeclarationWithBody ownerElement = ((KtParameter)declaration).getOwnerFunction();
                        VariableDescriptor variableDescriptor = (VariableDescriptor)this.$bindingTrace.get(BindingContext.VALUE_PARAMETER, declaration);
                        DeclarationDescriptor declarationDescriptor3 = ownerDescriptor = variableDescriptor != null ? variableDescriptor.getContainingDeclaration() : null;
                        LexicalScope lexicalScope = containingScope = declarationDescriptor3 != null ? PartialAnalysisHandlerExtension.access$getContainingScope$p(this.this$0, declarationDescriptor3) : null;
                        if (ownerElement instanceof KtPrimaryConstructor && ownerDescriptor instanceof ConstructorDescriptor && containingScope != null) {
                            this.$bodyResolver.resolveConstructorParameterDefaultValues(this.$topDownAnalysisContext.getOuterDataFlowInfo(), this.$bindingTrace, (KtPrimaryConstructor)ownerElement, (ConstructorDescriptor)ownerDescriptor, containingScope);
                        }
                    }
                } else if (declarationDescriptor2 instanceof FunctionDescriptor && declaration instanceof KtFunction && !((KtFunction)declaration).hasDeclaredReturnType() && !((KtFunction)declaration).hasBlockBody()) {
                    ForceResolveUtil.forceResolveAllContents(descriptor2);
                }
            }
            {
                this.this$0 = partialAnalysisHandlerExtension;
                this.$resolveSession = resolveSession;
                this.$bodyResolver = bodyResolver;
                this.$topDownAnalysisContext = topDownAnalysisContext;
                this.$bindingTrace = bindingTrace;
                super(1);
            }
        }));
        BindingContext bindingContext = bindingTrace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"bindingTrace.bindingContext");
        return AnalysisResult.Companion.success(bindingContext, module2, true);
    }

    private final LexicalScope getContainingScope(@NotNull DeclarationDescriptor $receiver) {
        DeclarationDescriptor containingDescriptor;
        DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
        if (declarationDescriptor == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"containingDeclaration ?: return null");
        DeclarationDescriptor declarationDescriptor2 = containingDescriptor = declarationDescriptor;
        return declarationDescriptor2 instanceof ClassDescriptorWithResolutionScopes ? ((ClassDescriptorWithResolutionScopes)containingDescriptor).getScopeForInitializerResolution() : (declarationDescriptor2 instanceof PackageFragmentDescriptor ? (LexicalScope)new LexicalScope.Base(ScopeUtilsKt.memberScopeAsImportingScope$default(((PackageFragmentDescriptor)containingDescriptor).getMemberScope(), null, 1, null), $receiver) : null);
    }

    private final void doForEachDeclaration(KtDeclaration declaration, Function1<? super KtDeclaration, Unit> f) {
        KtDeclaration it;
        Iterable $receiver$iv;
        if (!(declaration instanceof KtAnonymousInitializer)) {
            f.invoke((Object)declaration);
        }
        if (declaration instanceof KtClassOrObject) {
            $receiver$iv = ((KtClassOrObject)declaration).getDeclarations();
            for (Object element$iv : $receiver$iv) {
                it = (KtDeclaration)element$iv;
                this.doForEachDeclaration(it, f);
            }
        }
        if (declaration instanceof KtClass && ((KtClass)declaration).isAnnotation()) {
            $receiver$iv = ((KtClass)declaration).getPrimaryConstructorParameters();
            for (Object element$iv : $receiver$iv) {
                it = (KtParameter)element$iv;
                this.doForEachDeclaration(it, f);
            }
        }
    }

    private final void doForEachDeclaration(Collection<? extends KtFile> files2, Function1<? super KtDeclaration, Unit> f) {
        for (KtFile ktFile : files2) {
            Iterable $receiver$iv = ktFile.getDeclarations();
            for (Object element$iv : $receiver$iv) {
                KtDeclaration it = (KtDeclaration)element$iv;
                this.doForEachDeclaration(it, f);
            }
        }
    }

    @Override
    @Nullable
    public AnalysisResult analysisCompleted(@NotNull Project project, @NotNull ModuleDescriptor module2, @NotNull BindingTrace bindingTrace, @NotNull Collection<? extends KtFile> files2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)bindingTrace, (String)"bindingTrace");
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        return AnalysisHandlerExtension.DefaultImpls.analysisCompleted(this, project, module2, bindingTrace, files2);
    }

    @Nullable
    public static final /* synthetic */ LexicalScope access$getContainingScope$p(PartialAnalysisHandlerExtension $this, @NotNull DeclarationDescriptor $receiver) {
        return $this.getContainingScope($receiver);
    }
}

