/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.metadata.serialization.StringTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.ErrorUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/serialization/DescriptorAwareStringTable;", "Lorg/jetbrains/kotlin/metadata/serialization/StringTable;", "getFqNameIndex", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "getLocalClassIdReplacement", "Lorg/jetbrains/kotlin/name/ClassId;", "renderDescriptor", "", "serialization"})
public interface DescriptorAwareStringTable
extends StringTable {
    public int getFqNameIndex(@NotNull ClassifierDescriptorWithTypeParameters var1);

    @Nullable
    public ClassId getLocalClassIdReplacement(@NotNull ClassifierDescriptorWithTypeParameters var1);

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static int getFqNameIndex(DescriptorAwareStringTable $this, @NotNull ClassifierDescriptorWithTypeParameters descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            if (ErrorUtils.isError(descriptor2)) {
                throw (Throwable)new IllegalStateException("Cannot get FQ name of error class: " + DefaultImpls.renderDescriptor($this, descriptor2));
            }
            ClassId classId = DescriptorUtilsKt.getClassId(descriptor2);
            if (classId == null) {
                classId = $this.getLocalClassIdReplacement(descriptor2);
            }
            if (classId == null) {
                throw (Throwable)new IllegalStateException("Cannot get FQ name of local class: " + DefaultImpls.renderDescriptor($this, descriptor2));
            }
            ClassId classId2 = classId;
            String string = classId2.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classId.asString()");
            return $this.getQualifiedClassNameIndex(string, classId2.isLocal());
        }

        @Nullable
        public static ClassId getLocalClassIdReplacement(DescriptorAwareStringTable $this, @NotNull ClassifierDescriptorWithTypeParameters descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            return null;
        }

        private static String renderDescriptor(DescriptorAwareStringTable $this, ClassifierDescriptorWithTypeParameters descriptor2) {
            StringBuilder stringBuilder = new StringBuilder().append(DescriptorRenderer.COMPACT.render(descriptor2)).append(" defined in ");
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
            return stringBuilder.append(DescriptorRenderer.FQ_NAMES_IN_TYPES.render(declarationDescriptor)).toString();
        }
    }
}

