/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import com.intellij.psi.PsiElement;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.js.inline.FunctionInlineMutator;
import org.jetbrains.kotlin.js.inline.FunctionReader;
import org.jetbrains.kotlin.js.inline.InlineableResult;
import org.jetbrains.kotlin.js.inline.clean.RemoveUnusedFunctionDefinitionsKt;
import org.jetbrains.kotlin.js.inline.clean.RemoveUnusedLocalFunctionDeclarationsKt;
import org.jetbrains.kotlin.js.inline.context.FunctionContext;
import org.jetbrains.kotlin.js.inline.context.InliningContext;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.CollectionUtilsKt;
import org.jetbrains.kotlin.js.inline.util.ExpressionDecomposer;
import org.jetbrains.kotlin.js.inline.util.NamingUtilsKt;
import org.jetbrains.kotlin.js.inline.util.SideEffectUtilsKt;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsProgram;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.resolve.inline.InlineStrategy;

public class JsInliner
extends JsVisitorWithContextImpl {
    private final IdentityHashMap<JsName, JsFunction> functions;
    private final Stack<JsInliningContext> inliningContexts;
    private final Set<JsFunction> processedFunctions;
    private final Set<JsFunction> inProcessFunctions;
    private final FunctionReader functionReader;
    private final DiagnosticSink trace;
    private final Stack<JsFunction> namedFunctionsStack;
    private final LinkedList<JsCallInfo> inlineCallInfos;
    private final Function1<JsNode, Boolean> canBeExtractedByInliner;

    public static JsProgram process(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/inline/JsInliner", "process"));
        }
        JsProgram program = context.program();
        IdentityHashMap<JsName, JsFunction> functions2 = CollectUtilsKt.collectNamedFunctions(program);
        JsInliner inliner = new JsInliner(functions2, new FunctionReader(context), context.bindingTrace());
        inliner.accept(program);
        RemoveUnusedFunctionDefinitionsKt.removeUnusedFunctionDefinitions(program, functions2);
        return program;
    }

    private JsInliner(@NotNull IdentityHashMap<JsName, JsFunction> functions2, @NotNull FunctionReader functionReader, @NotNull DiagnosticSink trace) {
        if (functions2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functions", "org/jetbrains/kotlin/js/inline/JsInliner", "<init>"));
        }
        if (functionReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionReader", "org/jetbrains/kotlin/js/inline/JsInliner", "<init>"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/js/inline/JsInliner", "<init>"));
        }
        this.inliningContexts = new Stack();
        this.processedFunctions = CollectionUtilsKt.IdentitySet();
        this.inProcessFunctions = CollectionUtilsKt.IdentitySet();
        this.namedFunctionsStack = new Stack();
        this.inlineCallInfos = new LinkedList();
        this.canBeExtractedByInliner = new Function1<JsNode, Boolean>(){

            @Override
            public Boolean invoke(JsNode node) {
                if (!(node instanceof JsInvocation)) {
                    return false;
                }
                JsInvocation call = (JsInvocation)node;
                if (JsInliner.this.hasToBeInlined(call)) {
                    JsFunction function = JsInliner.this.getFunctionContext().getFunctionDefinition(call);
                    return !FunctionInlineMutator.canBeExpression(function);
                }
                return false;
            }
        };
        this.functions = functions2;
        this.functionReader = functionReader;
        this.trace = trace;
    }

    @Override
    public boolean visit(@NotNull JsFunction function, @NotNull JsContext context) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/js/inline/JsInliner", "visit"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/inline/JsInliner", "visit"));
        }
        this.inliningContexts.push(new JsInliningContext(function));
        assert (!this.inProcessFunctions.contains(function)) : "Inliner has revisited function";
        this.inProcessFunctions.add(function);
        if (this.functions.containsValue(function)) {
            this.namedFunctionsStack.push(function);
        }
        return super.visit(function, context);
    }

    @Override
    public void endVisit(@NotNull JsFunction function, @NotNull JsContext context) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/js/inline/JsInliner", "endVisit"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/inline/JsInliner", "endVisit"));
        }
        super.endVisit(function, context);
        NamingUtilsKt.refreshLabelNames(this.getInliningContext().newNamingContext(), function);
        RemoveUnusedLocalFunctionDeclarationsKt.removeUnusedLocalFunctionDeclarations(function);
        this.processedFunctions.add(function);
        assert (this.inProcessFunctions.contains(function));
        this.inProcessFunctions.remove(function);
        this.inliningContexts.pop();
        if (!this.namedFunctionsStack.empty() && this.namedFunctionsStack.peek() == function) {
            this.namedFunctionsStack.pop();
        }
    }

    @Override
    public boolean visit(@NotNull JsInvocation call, @NotNull JsContext context) {
        JsFunction definition;
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/js/inline/JsInliner", "visit"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/inline/JsInliner", "visit"));
        }
        if (!this.hasToBeInlined(call)) {
            return true;
        }
        JsFunction containingFunction = this.getCurrentNamedFunction();
        if (containingFunction != null) {
            this.inlineCallInfos.add(new JsCallInfo(call, containingFunction));
        }
        if (this.inProcessFunctions.contains(definition = this.getFunctionContext().getFunctionDefinition(call))) {
            this.reportInlineCycle(call, definition);
        } else if (!this.processedFunctions.contains(definition)) {
            this.accept(definition);
        }
        return true;
    }

    @Override
    public void endVisit(@NotNull JsInvocation x, @NotNull JsContext ctx) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/inline/JsInliner", "endVisit"));
        }
        if (ctx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctx", "org/jetbrains/kotlin/js/inline/JsInliner", "endVisit"));
        }
        if (this.hasToBeInlined(x)) {
            this.inline(x, ctx);
        }
        JsCallInfo lastCallInfo = null;
        if (!this.inlineCallInfos.isEmpty()) {
            lastCallInfo = this.inlineCallInfos.getLast();
        }
        if (lastCallInfo != null && lastCallInfo.call == x) {
            this.inlineCallInfos.removeLast();
        }
    }

    @Override
    protected void doAcceptStatementList(List<JsStatement> statements) {
        if (!this.inliningContexts.isEmpty()) {
            List<JsStatement> additionalStatements;
            JsScope scope2 = this.getFunctionContext().getScope();
            for (int i = 0; i < statements.size(); i += additionalStatements.size() + 1) {
                additionalStatements = ExpressionDecomposer.preserveEvaluationOrder(scope2, statements.get(i), this.canBeExtractedByInliner);
                statements.addAll(i, additionalStatements);
            }
        }
        super.doAcceptStatementList(statements);
    }

    private void inline(@NotNull JsInvocation call, @NotNull JsContext context) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/js/inline/JsInliner", "inline"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/inline/JsInliner", "inline"));
        }
        JsInliningContext inliningContext = this.getInliningContext();
        FunctionContext functionContext = this.getFunctionContext();
        functionContext.declareFunctionConstructorCalls(call.getArguments());
        InlineableResult inlineableResult = FunctionInlineMutator.getInlineableCallReplacement(call, inliningContext);
        JsStatement inlineableBody = inlineableResult.getInlineableBody();
        JsExpression resultExpression = inlineableResult.getResultExpression();
        JsContext<JsStatement> statementContext = inliningContext.getStatementContext();
        JsStatement inlineableBodyWithLambdasInlined = this.accept(inlineableBody);
        assert (inlineableBody == inlineableBodyWithLambdasInlined);
        statementContext.addPrevious(JsAstUtils.flattenStatement(inlineableBody));
        if (resultExpression == null) {
            statementContext.removeMe();
            return;
        }
        resultExpression = this.accept(resultExpression);
        JsStatement currentStatement = statementContext.getCurrentNode();
        if (currentStatement instanceof JsExpressionStatement && ((JsExpressionStatement)currentStatement).getExpression() == call && (resultExpression == null || !SideEffectUtilsKt.canHaveSideEffect(resultExpression))) {
            statementContext.removeMe();
        } else {
            context.replaceMe(resultExpression);
        }
    }

    @NotNull
    private JsInliningContext getInliningContext() {
        JsInliningContext jsInliningContext = this.inliningContexts.peek();
        if (jsInliningContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/inline/JsInliner", "getInliningContext"));
        }
        return jsInliningContext;
    }

    @NotNull
    FunctionContext getFunctionContext() {
        FunctionContext functionContext = this.getInliningContext().getFunctionContext();
        if (functionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/inline/JsInliner", "getFunctionContext"));
        }
        return functionContext;
    }

    @Nullable
    private JsFunction getCurrentNamedFunction() {
        if (this.namedFunctionsStack.empty()) {
            return null;
        }
        return this.namedFunctionsStack.peek();
    }

    private void reportInlineCycle(@NotNull JsInvocation call, @NotNull JsFunction calledFunction) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/js/inline/JsInliner", "reportInlineCycle"));
        }
        if (calledFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calledFunction", "org/jetbrains/kotlin/js/inline/JsInliner", "reportInlineCycle"));
        }
        MetadataProperties.setInlineStrategy(call, InlineStrategy.NOT_INLINE);
        Iterator<JsCallInfo> it2 = this.inlineCallInfos.descendingIterator();
        while (it2.hasNext()) {
            JsCallInfo callInfo = it2.next();
            PsiElement psiElement2 = MetadataProperties.getPsiElement(callInfo.call);
            CallableDescriptor descriptor2 = MetadataProperties.getDescriptor(callInfo.call);
            if (psiElement2 != null && descriptor2 != null) {
                this.trace.report(Errors.INLINE_CALL_CYCLE.on(psiElement2, descriptor2));
            }
            if (callInfo.containingFunction != calledFunction) continue;
            break;
        }
    }

    public boolean hasToBeInlined(@NotNull JsInvocation call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/js/inline/JsInliner", "hasToBeInlined"));
        }
        InlineStrategy strategy = MetadataProperties.getInlineStrategy(call);
        if (strategy == null || !strategy.isInline()) {
            return false;
        }
        return this.getFunctionContext().hasFunctionDefinition(call);
    }

    private static class JsCallInfo {
        @NotNull
        public final JsInvocation call;
        @NotNull
        public final JsFunction containingFunction;

        private JsCallInfo(@NotNull JsInvocation call, @NotNull JsFunction function) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/js/inline/JsInliner$JsCallInfo", "<init>"));
            }
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/js/inline/JsInliner$JsCallInfo", "<init>"));
            }
            this.call = call;
            this.containingFunction = function;
        }
    }

    private class JsInliningContext
    implements InliningContext {
        private final FunctionContext functionContext;

        JsInliningContext(JsFunction function) {
            this.functionContext = new FunctionContext(function, this, JsInliner.this.functionReader){

                @Override
                @Nullable
                protected JsFunction lookUpStaticFunction(@Nullable JsName functionName) {
                    return (JsFunction)JsInliner.this.functions.get(functionName);
                }
            };
        }

        @Override
        @NotNull
        public NamingContext newNamingContext() {
            JsScope scope2 = this.getFunctionContext().getScope();
            NamingContext namingContext = new NamingContext(scope2, this.getStatementContext());
            if (namingContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/inline/JsInliner$JsInliningContext", "newNamingContext"));
            }
            return namingContext;
        }

        @Override
        @NotNull
        public JsContext<JsStatement> getStatementContext() {
            JsContext jsContext = JsInliner.this.getLastStatementLevelContext();
            if (jsContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/inline/JsInliner$JsInliningContext", "getStatementContext"));
            }
            return jsContext;
        }

        @Override
        @NotNull
        public FunctionContext getFunctionContext() {
            FunctionContext functionContext = this.functionContext;
            if (functionContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/inline/JsInliner$JsInliningContext", "getFunctionContext"));
            }
            return functionContext;
        }
    }
}

