/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kdoc.parser.KDocElementTypes;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtTokens;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u0003\u0015\u0001A\u0002\u0001\t\b3\u0005A\n!(\u0001\bC\u000b\t6!\u0001\u0005\u0002K%!\u0011\u0001c\u0001\u000e\u0003a\u0011\u0011\u0004\u0002E\u0003\u001b\ta\t\u0001G\u0002&\u0019\u0011Y\u0001rA\u0007\u00021\u0011I2\u0001#\u0003\u000e\u0003a\u0019\u0011d\u0001\u0005\u0006\u001b\u0005AZ!\n\u0005\u0005\u0003!1Q\"\u0001M\u00073\rAQ!D\u0001\u0019\f\u0001"}, strings={"Lorg/jetbrains/kotlin/kdoc/parser/KDocLinkParser;", "Lcom/intellij/lang/PsiParser;", "()V", "isName", "", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "parse", "Lcom/intellij/lang/ASTNode;", "root", "builder", "Lcom/intellij/lang/PsiBuilder;", "parseQualifiedName", "", "Companion"}, moduleName="kotlin-compiler")
public final class KDocLinkParser
implements PsiParser {
    public static final Companion Companion = org.jetbrains.kotlin.kdoc.parser.KDocLinkParser$Companion.INSTANCE;

    @Override
    @NotNull
    public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder) {
        Intrinsics.checkParameterIsNotNull(root, "root");
        Intrinsics.checkParameterIsNotNull(builder, "builder");
        PsiBuilder.Marker rootMarker = builder.mark();
        boolean hasLBracket = Intrinsics.areEqual(builder.getTokenType(), KtTokens.LBRACKET);
        if (hasLBracket) {
            builder.advanceLexer();
        }
        this.parseQualifiedName(builder);
        if (hasLBracket) {
            if (!builder.eof() && Intrinsics.areEqual(builder.getTokenType(), KtTokens.RBRACKET) ^ true) {
                builder.error("Closing bracket expected");
                while (!builder.eof() && Intrinsics.areEqual(builder.getTokenType(), KtTokens.RBRACKET) ^ true) {
                    builder.advanceLexer();
                }
            }
            if (Intrinsics.areEqual(builder.getTokenType(), KtTokens.RBRACKET)) {
                builder.advanceLexer();
            }
        } else if (!builder.eof()) {
            builder.error("Expression expected");
            while (!builder.eof()) {
                builder.advanceLexer();
            }
        }
        rootMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        Intrinsics.checkExpressionValueIsNotNull(aSTNode, "builder.getTreeBuilt()");
        return aSTNode;
    }

    private final void parseQualifiedName(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        while (true) {
            if (!this.isName(builder.getTokenType())) {
                marker.drop();
                builder.error("Identifier expected");
                break;
            }
            builder.advanceLexer();
            marker.done(KDocElementTypes.KDOC_NAME);
            if (Intrinsics.areEqual(builder.getTokenType(), KtTokens.DOT) ^ true) break;
            marker = marker.precede();
            builder.advanceLexer();
        }
    }

    private final boolean isName(IElementType tokenType) {
        return Intrinsics.areEqual(tokenType, KtTokens.IDENTIFIER) || KtTokens.KEYWORDS.contains(tokenType);
    }

    @JvmStatic
    @NotNull
    public static final ASTNode parseMarkdownLink(@NotNull IElementType root, @NotNull ASTNode chameleon) {
        Intrinsics.checkParameterIsNotNull(root, "root");
        Intrinsics.checkParameterIsNotNull(chameleon, "chameleon");
        return org.jetbrains.kotlin.kdoc.parser.KDocLinkParser$Companion.INSTANCE.parseMarkdownLink(root, chameleon);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0019\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001\u0001Bb\u0002\u0019\u0001I\u0012\u0001'\u0001\"\b\u0011\t\u0011kA\u0001\t\u0003\u0015bAq\u0001E\u0002\u001b\u0005A\"!G\u0002\t\u00065\t\u0001dA\r\u0004\u0011\u000fi\u0011\u0001\u0007\u0002"}, strings={"Lorg/jetbrains/kotlin/kdoc/parser/KDocLinkParser$Companion;", "", "()V", "parseMarkdownLink", "Lcom/intellij/lang/ASTNode;", "root", "Lcom/intellij/psi/tree/IElementType;", "chameleon"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        @JvmStatic
        @NotNull
        public final ASTNode parseMarkdownLink(@NotNull IElementType root, @NotNull ASTNode chameleon) {
            Intrinsics.checkParameterIsNotNull(root, "root");
            Intrinsics.checkParameterIsNotNull(chameleon, "chameleon");
            PsiElement parentElement = chameleon.getTreeParent().getPsi();
            Project project = parentElement.getProject();
            PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, (Lexer)new KotlinLexer(), root.getLanguage(), (CharSequence)chameleon.getText());
            KDocLinkParser parser = new KDocLinkParser();
            PsiBuilder psiBuilder = builder;
            Intrinsics.checkExpressionValueIsNotNull(psiBuilder, "builder");
            ASTNode aSTNode = parser.parse(root, psiBuilder).getFirstChildNode();
            Intrinsics.checkExpressionValueIsNotNull(aSTNode, "parser.parse(root, builder).getFirstChildNode()");
            return aSTNode;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

