/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.name;

import kotlin.CharIterator;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt$WhenMappings;
import org.jetbrains.kotlin.name.State;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u0019\u0015\u0001Q!\u0001E\u0006\u000b\u0001)\u0011\u0001C\u0004\u0006\u0003\u0011\u0015Q!\u0001\u0007\u0002\u000b\u0005!\u0019!d\u0007\u0005\u0003!\u0001Q\"\u0001M\u00013\rA\u0011!D\u0001\u0019\u0004e\u0019\u0001BA\u0007\u00021\u0007!6QAG\n\u0011\ri\u0011\u0001'\u0001\u001a\t!\u001dQB\u0001G\u00011\u0007!6QAG\u0007\u0011\u0011i\u0011\u0001'\u0001\u0016\u0003a%Ak!\u0002\u000e\u0019!\u0001Q\"\u0001M\u0001+\u0005AJ!'\u0003\t\u000b5\t\u0001\u0014\u0002)\u0004\u0002Q\u001b)!\u0004\u0007\t\f5\t\u0001\u0014B\u000b\u00021\u0013IJ\u0001\u0003\u0004\u000e\u0003a%\u0001k!\u0001U\u0007\u000b\u0001"}, strings={"isSubpackageOf", "", "subpackageNameStr", "", "packageNameStr", "FqNamesUtilKt", "isValidJavaFqName", "qualifiedName", "isOneSegmentFQN", "Lorg/jetbrains/kotlin/name/FqName;", "packageName", "tail", "prefix"}, moduleName="kotlin-compiler")
public final class FqNamesUtilKt {
    public static final boolean isSubpackageOf(FqName $receiver, @NotNull FqName packageName) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(packageName, "packageName");
        if (Intrinsics.areEqual($receiver, packageName)) {
            bl = true;
        } else if (packageName.isRoot()) {
            bl = true;
        } else {
            String string = $receiver.asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "this.asString()");
            String string2 = packageName.asString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "packageName.asString()");
            bl = FqNamesUtilKt.isSubpackageOf(string, string2);
        }
        return bl;
    }

    private static final boolean isSubpackageOf(String subpackageNameStr, String packageNameStr) {
        return StringsKt.startsWith$default(subpackageNameStr, packageNameStr, false, 2) && subpackageNameStr.charAt(CollectionsKt.length(packageNameStr)) == '.';
    }

    public static final boolean isOneSegmentFQN(FqName $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return !$receiver.isRoot() && $receiver.parent().isRoot();
    }

    @NotNull
    public static final FqName tail(FqName $receiver, @NotNull FqName prefix) {
        FqName fqName2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(prefix, "prefix");
        if (!FqNamesUtilKt.isSubpackageOf($receiver, prefix) || prefix.isRoot()) {
            fqName2 = $receiver;
        } else if (Intrinsics.areEqual($receiver, prefix)) {
            FqName fqName3 = FqName.ROOT;
            fqName2 = fqName3;
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "FqName.ROOT");
        } else {
            fqName2 = new FqName(StringsKt.substring($receiver.asString(), CollectionsKt.length(prefix.asString()) + 1));
        }
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "when {\n        !isSubpac\u2026ng().length() + 1))\n    }");
        return fqName2;
    }

    public static final boolean isValidJavaFqName(@Nullable String qualifiedName) {
        if (qualifiedName == null) {
            return false;
        }
        State state = State.BEGINNING;
        CharIterator charIterator = StringsKt.iterator(qualifiedName);
        while (charIterator.hasNext()) {
            char c = charIterator.nextChar();
            switch (FqNamesUtilKt$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: 
                case 2: {
                    if (!Character.isJavaIdentifierPart(c)) {
                        return false;
                    }
                    state = State.MIDDLE;
                    break;
                }
                case 3: {
                    if (c == '.') {
                        state = State.AFTER_DOT;
                        break;
                    }
                    if (Character.isJavaIdentifierPart(c)) break;
                    return false;
                }
            }
        }
        return Intrinsics.areEqual((Object)state, (Object)State.AFTER_DOT) ^ true;
    }
}

