/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtObjectDeclarationName;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinObjectStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"?\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0003\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005Aq!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005AA!\u0002\u0001\u0006\u0003!-Q!\u0001C\u0002\u0019\u0001I\u0012\u0001'\u0001\"\u0010\u0011Y\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0002\u0011\t\t{\u0001B\u0006\n\u0007!\u0015Q\"\u0001\r\u0004#\u000e\t\u0001rAS\u001b\t-AY!D\u0001%\rE\u0011A\u0001\u0001\u0005\u0007#\t!\t\u0001#\u0004\u001a\u0013!9QbB\u0005\u0003\u0013\u0005!c!\u0003\u0002\n\u0003\u00116\u0001tB\r\u0004\u0011!i\u0011\u0001*\u0004R\u0007\u0005A\t\"J\u0003\u0005\u0017!IQB\u0001G\u00011')S\u0001B\u0006\t\u00155\u0011A\u0012\u0001M\u000bK\rA1\"D\u0001\u0019\u0016\u0015\"Aa\u0003E\f\u001b\u0005AB\"J\u0002\t\u001a5\t\u0001$D\u0013\u0004\u00117i\u0011\u0001G\u0007&\u0013\u0011Y\u0001BD\u0007\u00021+IB\u0001\"\u0001\t\u001e5\t\u00014C\u0015\f\t\u0005C\u0001\u0002B\u0007\u0003\u0019\u0003A2\u0001H\u0011R\u0007\ri!\u0001\"\u0003\t\u000b\u0001"}, strings={"Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;)V", "_stub", "get_stub", "()Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;", "accept", "R", "D", "visitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "getName", "", "getNameIdentifier", "Lcom/intellij/psi/PsiElement;", "getObjectKeyword", "getTextOffset", "", "isCompanion", "", "isObjectLiteral", "setName", "name"}, moduleName="kotlin-compiler")
public final class KtObjectDeclaration
extends KtClassOrObject {
    private final KotlinObjectStub get_stub() {
        KotlinClassOrObjectStub kotlinClassOrObjectStub = (KotlinClassOrObjectStub)this.getStub();
        if (!(kotlinClassOrObjectStub instanceof KotlinObjectStub)) {
            kotlinClassOrObjectStub = null;
        }
        return (KotlinObjectStub)kotlinClassOrObjectStub;
    }

    @Override
    @Nullable
    public String getName() {
        Object object = this.get_stub();
        if (object != null && (object = object.getName()) != null) {
            Object $receiver = object;
            String it2 = (String)$receiver;
            return it2;
        }
        KtObjectDeclarationName nameAsDeclaration = this.getNameAsDeclaration();
        if (nameAsDeclaration == null && this.isCompanion()) {
            return SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT.toString();
        }
        KtObjectDeclarationName ktObjectDeclarationName = nameAsDeclaration;
        return ktObjectDeclarationName != null ? ktObjectDeclarationName.getName() : null;
    }

    @Override
    @Nullable
    public PsiElement getNameIdentifier() {
        KtObjectDeclarationName ktObjectDeclarationName = this.getNameAsDeclaration();
        return ktObjectDeclarationName != null ? ktObjectDeclarationName.getNameIdentifier() : null;
    }

    @Override
    @NotNull
    public PsiElement setName(@NonNls @NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        KtObjectDeclarationName declarationName = this.getNameAsDeclaration();
        if (declarationName == null) {
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull(project, "project");
            KtPsiFactory psiFactory = new KtPsiFactory(project);
            PsiElement result2 = this.addAfter(psiFactory.createObjectDeclarationName(name), this.getObjectKeyword());
            this.addAfter(psiFactory.createWhiteSpace(), this.getObjectKeyword());
            PsiElement psiElement2 = result2;
            Intrinsics.checkExpressionValueIsNotNull(psiElement2, "result");
            return psiElement2;
        }
        PsiElement psiElement3 = declarationName.setName(name);
        Intrinsics.checkExpressionValueIsNotNull(psiElement3, "declarationName.setName(name)");
        return psiElement3;
    }

    public final boolean isCompanion() {
        KotlinObjectStub kotlinObjectStub = this.get_stub();
        return kotlinObjectStub != null ? kotlinObjectStub.isCompanion() : this.hasModifier(KtTokens.COMPANION_KEYWORD);
    }

    @Override
    public int getTextOffset() {
        Object object = this.getNameIdentifier();
        return object != null && (object = object.getTextRange()) != null ? ((TextRange)object).getStartOffset() : this.getObjectKeyword().getTextRange().getStartOffset();
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        return visitor2.visitObjectDeclaration(this, data);
    }

    public final boolean isObjectLiteral() {
        KotlinObjectStub kotlinObjectStub = this.get_stub();
        return kotlinObjectStub != null ? kotlinObjectStub.isObjectLiteral() : this.getParent() instanceof KtObjectLiteralExpression;
    }

    @NotNull
    public final PsiElement getObjectKeyword() {
        Object t = this.findChildByType(KtTokens.OBJECT_KEYWORD);
        if (t == null) {
            Intrinsics.throwNpe();
        }
        return t;
    }

    public KtObjectDeclaration(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        super(node);
    }

    public KtObjectDeclaration(@NotNull KotlinObjectStub stub) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        KotlinClassOrObjectStub kotlinClassOrObjectStub = stub;
        IStubElementType iStubElementType = KtStubElementTypes.OBJECT_DECLARATION;
        Intrinsics.checkExpressionValueIsNotNull(iStubElementType, "KtStubElementTypes.OBJECT_DECLARATION");
        super(kotlinClassOrObjectStub, iStubElementType);
    }
}

