/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Sets;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverloadUtil;

public class OverloadResolver {
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final MainFunctionDetector mainFunctionDetector;

    public OverloadResolver(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/OverloadResolver", "<init>"));
        }
        this.trace = trace;
        this.mainFunctionDetector = new MainFunctionDetector(trace.getBindingContext());
    }

    public void process(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/OverloadResolver", "process"));
        }
        this.checkOverloads(c);
    }

    private void checkOverloads(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/OverloadResolver", "checkOverloads"));
        }
        MultiMap<ClassDescriptor, ConstructorDescriptor> inClasses = MultiMap.create();
        MultiMap<FqNameUnsafe, ConstructorDescriptor> inPackages = MultiMap.create();
        OverloadResolver.fillGroupedConstructors(c, inClasses, inPackages);
        for (Map.Entry<KtClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            this.checkOverloadsInAClass(entry.getValue(), entry.getKey(), inClasses.get(entry.getValue()));
        }
        this.checkOverloadsInPackages(c, inPackages);
    }

    private static void fillGroupedConstructors(@NotNull BodiesResolveContext c, @NotNull MultiMap<ClassDescriptor, ConstructorDescriptor> inClasses, @NotNull MultiMap<FqNameUnsafe, ConstructorDescriptor> inPackages) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/OverloadResolver", "fillGroupedConstructors"));
        }
        if (inClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inClasses", "org/jetbrains/kotlin/resolve/OverloadResolver", "fillGroupedConstructors"));
        }
        if (inPackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inPackages", "org/jetbrains/kotlin/resolve/OverloadResolver", "fillGroupedConstructors"));
        }
        for (ClassDescriptorWithResolutionScopes klass : c.getDeclaredClasses().values()) {
            if (klass.getKind().isSingleton() || klass.getName().isSpecial()) continue;
            DeclarationDescriptor containingDeclaration = klass.getContainingDeclaration();
            if (containingDeclaration instanceof ClassDescriptor) {
                ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
                inClasses.putValues(classDescriptor, klass.getConstructors());
                continue;
            }
            if (containingDeclaration instanceof PackageFragmentDescriptor) {
                inPackages.putValues(DescriptorUtils.getFqName(klass), klass.getConstructors());
                continue;
            }
            if (containingDeclaration instanceof ScriptDescriptor || containingDeclaration instanceof FunctionDescriptor) continue;
            throw new IllegalStateException("Illegal class container: " + containingDeclaration);
        }
    }

    private void checkOverloadsInPackages(@NotNull BodiesResolveContext c, @NotNull MultiMap<FqNameUnsafe, ConstructorDescriptor> inPackages) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/OverloadResolver", "checkOverloadsInPackages"));
        }
        if (inPackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inPackages", "org/jetbrains/kotlin/resolve/OverloadResolver", "checkOverloadsInPackages"));
        }
        MultiMap<FqNameUnsafe, CallableMemberDescriptor> functionsByName = MultiMap.create();
        for (SimpleFunctionDescriptor simpleFunctionDescriptor : c.getFunctions().values()) {
            if (!(simpleFunctionDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor)) continue;
            functionsByName.putValue(DescriptorUtils.getFqName(simpleFunctionDescriptor), simpleFunctionDescriptor);
        }
        for (PropertyDescriptor propertyDescriptor : c.getProperties().values()) {
            if (!(propertyDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor)) continue;
            functionsByName.putValue(DescriptorUtils.getFqName(propertyDescriptor), propertyDescriptor);
        }
        for (Map.Entry entry : inPackages.entrySet()) {
            functionsByName.putValues((FqNameUnsafe)entry.getKey(), (Collection)entry.getValue());
        }
        for (Map.Entry entry : functionsByName.entrySet()) {
            FqNameUnsafe fqName2 = ((FqNameUnsafe)entry.getKey()).parent();
            this.checkOverloadsWithSameName((Collection)entry.getValue(), fqName2.isRoot() ? "root package" : fqName2.asString());
        }
    }

    private static String nameForErrorMessage(ClassDescriptor classDescriptor, KtClassOrObject jetClass) {
        String name = jetClass.getName();
        if (name != null) {
            return name;
        }
        if (jetClass instanceof KtObjectDeclaration) {
            name = classDescriptor.getContainingDeclaration().getName().asString();
            return "companion object " + name;
        }
        return "<unknown>";
    }

    private void checkOverloadsInAClass(ClassDescriptorWithResolutionScopes classDescriptor, KtClassOrObject klass, Collection<ConstructorDescriptor> nestedClassConstructors) {
        MultiMap<Name, CallableMemberDescriptor> functionsByName = MultiMap.create();
        for (CallableMemberDescriptor callableMemberDescriptor : classDescriptor.getDeclaredCallableMembers()) {
            functionsByName.putValue(callableMemberDescriptor.getName(), callableMemberDescriptor);
        }
        for (ConstructorDescriptor constructorDescriptor : nestedClassConstructors) {
            functionsByName.putValue(constructorDescriptor.getContainingDeclaration().getName(), constructorDescriptor);
        }
        for (Map.Entry entry : functionsByName.entrySet()) {
            this.checkOverloadsWithSameName((Collection)entry.getValue(), OverloadResolver.nameForErrorMessage(classDescriptor, klass));
        }
    }

    private void checkOverloadsWithSameName(Collection<CallableMemberDescriptor> functions2, @NotNull String functionContainer) {
        if (functionContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionContainer", "org/jetbrains/kotlin/resolve/OverloadResolver", "checkOverloadsWithSameName"));
        }
        if (functions2.size() == 1) {
            return;
        }
        this.reportRedeclarations(functionContainer, this.findRedeclarations(functions2));
    }

    @NotNull
    private Set<Pair<KtDeclaration, CallableMemberDescriptor>> findRedeclarations(@NotNull Collection<CallableMemberDescriptor> functions2) {
        if (functions2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functions", "org/jetbrains/kotlin/resolve/OverloadResolver", "findRedeclarations"));
        }
        LinkedHashSet<Pair<KtDeclaration, CallableMemberDescriptor>> redeclarations = Sets.newLinkedHashSet();
        for (CallableMemberDescriptor member : functions2) {
            for (CallableMemberDescriptor member2 : functions2) {
                KtDeclaration ktDeclaration;
                OverloadUtil.OverloadCompatibilityInfo overloadable;
                if (member == member2 || OverloadResolver.isConstructorsOfDifferentRedeclaredClasses(member, member2) || (overloadable = OverloadUtil.isOverloadable(member, member2)).isSuccess() || member.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED || (ktDeclaration = (KtDeclaration)DescriptorToSourceUtils.descriptorToDeclaration(member)) == null) continue;
                redeclarations.add(Pair.create(ktDeclaration, member));
            }
        }
        LinkedHashSet<Pair<KtDeclaration, CallableMemberDescriptor>> linkedHashSet = redeclarations;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverloadResolver", "findRedeclarations"));
        }
        return linkedHashSet;
    }

    private static boolean isConstructorsOfDifferentRedeclaredClasses(@NotNull CallableMemberDescriptor member, @NotNull CallableMemberDescriptor member2) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/kotlin/resolve/OverloadResolver", "isConstructorsOfDifferentRedeclaredClasses"));
        }
        if (member2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member2", "org/jetbrains/kotlin/resolve/OverloadResolver", "isConstructorsOfDifferentRedeclaredClasses"));
        }
        if (!(member instanceof ConstructorDescriptor) || !(member2 instanceof ConstructorDescriptor)) {
            return false;
        }
        assert (member.getContainingDeclaration().getContainingDeclaration() != null) : "Grandparent of constructor should not be null";
        return member.getContainingDeclaration() != member2.getContainingDeclaration() && member.getContainingDeclaration().getContainingDeclaration().equals(member2.getContainingDeclaration().getContainingDeclaration());
    }

    private void reportRedeclarations(@NotNull String functionContainer, @NotNull Set<Pair<KtDeclaration, CallableMemberDescriptor>> redeclarations) {
        if (functionContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionContainer", "org/jetbrains/kotlin/resolve/OverloadResolver", "reportRedeclarations"));
        }
        if (redeclarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "redeclarations", "org/jetbrains/kotlin/resolve/OverloadResolver", "reportRedeclarations"));
        }
        for (Pair<KtDeclaration, CallableMemberDescriptor> redeclaration : redeclarations) {
            CallableMemberDescriptor memberDescriptor = redeclaration.getSecond();
            if (DescriptorToSourceUtils.isTopLevelMainFunction(memberDescriptor, this.mainFunctionDetector)) {
                return;
            }
            KtDeclaration ktDeclaration = redeclaration.getFirst();
            if (memberDescriptor instanceof PropertyDescriptor) {
                this.trace.report(Errors.REDECLARATION.on(ktDeclaration, memberDescriptor.getName().asString()));
                continue;
            }
            String containingClassName = ktDeclaration instanceof KtSecondaryConstructor ? ((KtSecondaryConstructor)ktDeclaration).getContainingClassOrObject().getName() : null;
            this.trace.report(Errors.CONFLICTING_OVERLOADS.on(ktDeclaration, memberDescriptor, containingClassName != null ? containingClassName : functionContainer));
        }
    }
}

