/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.relocated.javax.inject.Inject;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

public class CallExpressionResolver {
    private final CallResolver callResolver;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    private final SymbolUsageValidator symbolUsageValidator;
    private final DataFlowAnalyzer dataFlowAnalyzer;
    private ExpressionTypingServices expressionTypingServices;

    public CallExpressionResolver(@NotNull CallResolver callResolver, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull SymbolUsageValidator symbolUsageValidator, @NotNull DataFlowAnalyzer dataFlowAnalyzer) {
        if (callResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callResolver", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "<init>"));
        }
        if (constantExpressionEvaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constantExpressionEvaluator", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "<init>"));
        }
        if (symbolUsageValidator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbolUsageValidator", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "<init>"));
        }
        if (dataFlowAnalyzer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowAnalyzer", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "<init>"));
        }
        this.callResolver = callResolver;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.symbolUsageValidator = symbolUsageValidator;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    @Nullable
    public ResolvedCall<FunctionDescriptor> getResolvedCallForFunction(@NotNull Call call, @NotNull KtExpression callExpression, @NotNull ResolutionContext context, @NotNull CheckArgumentTypesMode checkArguments, @NotNull boolean[] result2) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        if (checkArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkArguments", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        OverloadResolutionResults<FunctionDescriptor> results = this.callResolver.resolveFunctionCall(BasicCallResolutionContext.create(context, call, checkArguments));
        if (!results.isNothing()) {
            result2[0] = true;
            return OverloadResolutionResultsUtil.getResultingCall(results, context.contextDependency);
        }
        result2[0] = false;
        return null;
    }

    @Nullable
    private KotlinType getVariableType(@NotNull KtSimpleNameExpression nameExpression, @NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context, @NotNull boolean[] result2) {
        QualifierReceiver qualifier2;
        if (nameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExpression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getVariableType"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getVariableType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getVariableType"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getVariableType"));
        }
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as local variable or property", nameExpression);
        Call call = CallMaker.makePropertyCall(receiver, callOperationNode, nameExpression);
        BasicCallResolutionContext contextForVariable = BasicCallResolutionContext.create(context.replaceTraceAndCache(temporaryForVariable), call, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        OverloadResolutionResults<VariableDescriptor> resolutionResult = this.callResolver.resolveSimpleProperty(contextForVariable);
        boolean isLHSOfDot = KtPsiUtil.isLHSOfDot(nameExpression);
        if (!resolutionResult.isNothing() && resolutionResult.getResultCode() != OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER) {
            boolean isQualifier;
            boolean bl = isQualifier = isLHSOfDot && resolutionResult.isSingleResult() && resolutionResult.getResultingDescriptor() instanceof FakeCallableDescriptorForObject;
            if (!isQualifier) {
                result2[0] = true;
                temporaryForVariable.commit();
                return resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : null;
            }
        }
        if ((qualifier2 = QualifierKt.createQualifier(nameExpression, receiver, context)) != null) {
            result2[0] = true;
            if (!isLHSOfDot) {
                QualifierKt.resolveAsStandaloneExpression(qualifier2, context, this.symbolUsageValidator);
            }
            return null;
        }
        temporaryForVariable.commit();
        result2[0] = !resolutionResult.isNothing();
        return resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : null;
    }

    @NotNull
    public JetTypeInfo getSimpleNameExpressionTypeInfo(@NotNull KtSimpleNameExpression nameExpression, @NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context) {
        if (nameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExpression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        boolean[] result2 = new boolean[1];
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as variable", nameExpression);
        KotlinType type2 = this.getVariableType(nameExpression, receiver, callOperationNode, (ExpressionTypingContext)context.replaceTraceAndCache(temporaryForVariable), result2);
        if (result2[0]) {
            temporaryForVariable.commit();
            JetTypeInfo jetTypeInfo = TypeInfoFactoryKt.createTypeInfo(type2, context);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
            }
            return jetTypeInfo;
        }
        Call call = CallMaker.makeCall(nameExpression, receiver, callOperationNode, nameExpression, Collections.emptyList());
        TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context, "trace to resolve as function", nameExpression);
        Object newContext = context.replaceTraceAndCache(temporaryForFunction);
        ResolvedCall<FunctionDescriptor> resolvedCall = this.getResolvedCallForFunction(call, nameExpression, (ResolutionContext)newContext, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, result2);
        if (result2[0]) {
            FunctionDescriptor functionDescriptor = resolvedCall != null ? resolvedCall.getResultingDescriptor() : null;
            temporaryForFunction.commit();
            boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
            context.trace.report(Errors.FUNCTION_CALL_EXPECTED.on(nameExpression, nameExpression, hasValueParameters));
            type2 = functionDescriptor != null ? functionDescriptor.getReturnType() : null;
            JetTypeInfo jetTypeInfo = TypeInfoFactoryKt.createTypeInfo(type2, context);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
            }
            return jetTypeInfo;
        }
        temporaryForVariable.commit();
        JetTypeInfo jetTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo getCallExpressionTypeInfo(@NotNull KtCallExpression callExpression, @NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfo"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfo"));
        }
        JetTypeInfo typeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck(callExpression, receiver, callOperationNode, context);
        if (context.contextDependency == ContextDependency.INDEPENDENT) {
            this.dataFlowAnalyzer.checkType(typeInfo.getType(), (KtExpression)callExpression, (ResolutionContext)context);
        }
        JetTypeInfo jetTypeInfo = typeInfo;
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfo"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo getCallExpressionTypeInfoWithoutFinalTypeCheck(@NotNull KtCallExpression callExpression, @NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
        }
        boolean[] result2 = new boolean[1];
        Call call = CallMaker.makeCall(receiver, callOperationNode, callExpression);
        TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context, "trace to resolve as function call", callExpression);
        ResolvedCall<FunctionDescriptor> resolvedCall = this.getResolvedCallForFunction(call, callExpression, (ResolutionContext)((ExpressionTypingContext)context.replaceTraceAndCache(temporaryForFunction)).replaceInsideCallChain(false), CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, result2);
        if (result2[0]) {
            DataFlowInfo resultFlowInfo;
            FunctionDescriptor functionDescriptor = resolvedCall != null ? resolvedCall.getResultingDescriptor() : null;
            temporaryForFunction.commit();
            if (callExpression.getValueArgumentList() == null && callExpression.getFunctionLiteralArguments().isEmpty()) {
                boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
                context.trace.report(Errors.FUNCTION_CALL_EXPECTED.on(callExpression, callExpression, hasValueParameters));
            }
            if (functionDescriptor == null) {
                JetTypeInfo jetTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
                if (jetTypeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
                }
                return jetTypeInfo;
            }
            if (functionDescriptor instanceof ConstructorDescriptor) {
                DeclarationDescriptor containingDescriptor = functionDescriptor.getContainingDeclaration();
                if (DescriptorUtils.isAnnotationClass(containingDescriptor) && !CallExpressionResolver.canInstantiateAnnotationClass(callExpression, context.trace)) {
                    context.trace.report(Errors.ANNOTATION_CLASS_CONSTRUCTOR_CALL.on(callExpression));
                }
                if (DescriptorUtils.isEnumClass(containingDescriptor)) {
                    context.trace.report(Errors.ENUM_CLASS_CONSTRUCTOR_CALL.on(callExpression));
                }
                if (containingDescriptor instanceof ClassDescriptor && ((ClassDescriptor)containingDescriptor).getModality() == Modality.SEALED) {
                    context.trace.report(Errors.SEALED_CLASS_CONSTRUCTOR_CALL.on(callExpression));
                }
            }
            KotlinType type2 = functionDescriptor.getReturnType();
            List<KtValueArgument> arguments2 = callExpression.getValueArguments();
            DataFlowInfo jumpFlowInfo = resultFlowInfo = resolvedCall.getDataFlowInfoForArguments().getResultInfo();
            boolean jumpOutPossible = false;
            for (ValueArgument valueArgument : arguments2) {
                JetTypeInfo argTypeInfo = context.trace.get(BindingContext.EXPRESSION_TYPE_INFO, valueArgument.getArgumentExpression());
                if (argTypeInfo == null || !argTypeInfo.getJumpOutPossible()) continue;
                jumpOutPossible = true;
                jumpFlowInfo = argTypeInfo.getJumpFlowInfo();
                break;
            }
            JetTypeInfo jetTypeInfo = TypeInfoFactoryKt.createTypeInfo(type2, resultFlowInfo, jumpOutPossible, jumpFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
            }
            return jetTypeInfo;
        }
        KtExpression calleeExpression = callExpression.getCalleeExpression();
        if (calleeExpression instanceof KtSimpleNameExpression && callExpression.getTypeArgumentList() == null) {
            TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as variable with 'invoke' call", callExpression);
            KotlinType type3 = this.getVariableType((KtSimpleNameExpression)calleeExpression, receiver, callOperationNode, (ExpressionTypingContext)context.replaceTraceAndCache(temporaryForVariable), result2);
            Qualifier qualifier2 = temporaryForVariable.trace.get(BindingContext.QUALIFIER, calleeExpression);
            if (result2[0] && (qualifier2 == null || qualifier2.getPackageView() == null)) {
                temporaryForVariable.commit();
                context.trace.report(Errors.FUNCTION_EXPECTED.on(calleeExpression, calleeExpression, type3 != null ? type3 : ErrorUtils.createErrorType("")));
                JetTypeInfo jetTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
                if (jetTypeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
                }
                return jetTypeInfo;
            }
        }
        temporaryForFunction.commit();
        JetTypeInfo jetTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
        }
        return jetTypeInfo;
    }

    private static boolean canInstantiateAnnotationClass(@NotNull KtCallExpression expression, @NotNull BindingTrace trace) {
        KtClass ktClass;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "canInstantiateAnnotationClass"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "canInstantiateAnnotationClass"));
        }
        Object parent2 = PsiTreeUtil.getParentOfType((PsiElement)expression, KtValueArgument.class, KtParameter.class);
        if (parent2 instanceof KtValueArgument) {
            return PsiTreeUtil.getParentOfType(parent2, KtAnnotationEntry.class) != null;
        }
        if (parent2 instanceof KtParameter && (ktClass = PsiTreeUtil.getParentOfType(parent2, KtClass.class)) != null) {
            DeclarationDescriptor descriptor2 = trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, ktClass);
            return DescriptorUtils.isAnnotationClass(descriptor2);
        }
        return false;
    }

    @NotNull
    private JetTypeInfo getSelectorReturnTypeInfo(@NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @Nullable KtExpression selectorExpression, @NotNull ExpressionTypingContext context) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
        }
        if (selectorExpression instanceof KtCallExpression) {
            JetTypeInfo jetTypeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck((KtCallExpression)selectorExpression, receiver, callOperationNode, context);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
            }
            return jetTypeInfo;
        }
        if (selectorExpression instanceof KtSimpleNameExpression) {
            JetTypeInfo jetTypeInfo = this.getSimpleNameExpressionTypeInfo((KtSimpleNameExpression)selectorExpression, receiver, callOperationNode, context);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
            }
            return jetTypeInfo;
        }
        if (selectorExpression != null) {
            context.trace.report(Errors.ILLEGAL_SELECTOR.on(selectorExpression, selectorExpression.getText()));
        }
        JetTypeInfo jetTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo getQualifiedExpressionTypeInfo(@NotNull KtQualifiedExpression expression, @NotNull ExpressionTypingContext context) {
        JetTypeInfo typeInfo;
        CompileTimeConstant<?> value2;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getQualifiedExpressionTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getQualifiedExpressionTypeInfo"));
        }
        KtExpression selectorExpression = expression.getSelectorExpression();
        KtExpression receiverExpression = expression.getReceiverExpression();
        boolean safeCall = expression.getOperationSign() == KtTokens.SAFE_ACCESS;
        Object contextForReceiver = ((ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT)).replaceInsideCallChain(true);
        JetTypeInfo receiverTypeInfo = this.expressionTypingServices.getTypeInfo(receiverExpression, (ResolutionContext)contextForReceiver);
        KotlinType receiverType = receiverTypeInfo.getType();
        QualifierReceiver qualifierReceiver = (QualifierReceiver)context.trace.get(BindingContext.QUALIFIER, receiverExpression);
        if (receiverType == null) {
            receiverType = ErrorUtils.createErrorType("Type for " + expression.getText());
        }
        ReceiverValue receiver = qualifierReceiver == null ? new ExpressionReceiver(receiverExpression, receiverType) : qualifierReceiver;
        DataFlowInfo receiverDataFlowInfo = receiverTypeInfo.getDataFlowInfo();
        context = (ExpressionTypingContext)context.replaceDataFlowInfo(receiverDataFlowInfo);
        JetTypeInfo selectorReturnTypeInfo = this.getSelectorReturnTypeInfo(receiver, expression.getOperationTokenNode(), selectorExpression, context);
        KotlinType selectorReturnType = selectorReturnTypeInfo.getType();
        this.resolveDeferredReceiverInQualifiedExpression(qualifierReceiver, expression, context);
        CallExpressionResolver.checkNestedClassAccess(expression, context);
        if (safeCall && selectorReturnType != null && TypeUtils.isNullableType(receiverType)) {
            selectorReturnType = TypeUtils.makeNullable(selectorReturnType);
            selectorReturnTypeInfo = selectorReturnTypeInfo.replaceType(selectorReturnType);
        }
        if (selectorExpression != null && selectorReturnType != null) {
            context.trace.recordType(selectorExpression, selectorReturnType);
        }
        if ((value2 = this.constantExpressionEvaluator.evaluateExpression(expression, context.trace, context.expectedType)) != null && value2.isPure()) {
            JetTypeInfo jetTypeInfo = this.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(value2, expression, context);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getQualifiedExpressionTypeInfo"));
            }
            return jetTypeInfo;
        }
        DataFlowInfo safeCallChainInfo = receiverTypeInfo instanceof JetTypeInfoInsideSafeCall ? ((JetTypeInfoInsideSafeCall)receiverTypeInfo).getSafeCallChainInfo() : null;
        if (safeCall) {
            if (safeCallChainInfo == null) {
                safeCallChainInfo = receiverDataFlowInfo;
            }
            typeInfo = context.insideCallChain ? new JetTypeInfoInsideSafeCall(selectorReturnTypeInfo, safeCallChainInfo) : selectorReturnTypeInfo.replaceDataFlowInfo(safeCallChainInfo);
        } else {
            typeInfo = context.insideCallChain || safeCallChainInfo == null ? new JetTypeInfoInsideSafeCall(selectorReturnTypeInfo, selectorReturnTypeInfo.getDataFlowInfo()) : selectorReturnTypeInfo.replaceDataFlowInfo(safeCallChainInfo);
        }
        if (context.contextDependency == ContextDependency.INDEPENDENT) {
            this.dataFlowAnalyzer.checkType(typeInfo.getType(), (KtExpression)expression, (ResolutionContext)context);
        }
        JetTypeInfo jetTypeInfo = typeInfo;
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getQualifiedExpressionTypeInfo"));
        }
        return jetTypeInfo;
    }

    private void resolveDeferredReceiverInQualifiedExpression(@Nullable QualifierReceiver qualifierReceiver, @NotNull KtQualifiedExpression qualifiedExpression, @NotNull ExpressionTypingContext context) {
        if (qualifiedExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedExpression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "resolveDeferredReceiverInQualifiedExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "resolveDeferredReceiverInQualifiedExpression"));
        }
        if (qualifierReceiver == null) {
            return;
        }
        KtExpression calleeExpression = KtPsiUtil.deparenthesize(CallUtilKt.getCalleeExpressionIfAny(qualifiedExpression.getSelectorExpression()));
        DeclarationDescriptor selectorDescriptor = calleeExpression instanceof KtReferenceExpression ? context.trace.get(BindingContext.REFERENCE_TARGET, (KtReferenceExpression)calleeExpression) : null;
        QualifierKt.resolveAsReceiverInQualifiedExpression(qualifierReceiver, context, this.symbolUsageValidator, selectorDescriptor);
    }

    private static void checkNestedClassAccess(@NotNull KtQualifiedExpression expression, @NotNull ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "checkNestedClassAccess"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "checkNestedClassAccess"));
        }
        KtExpression selectorExpression = expression.getSelectorExpression();
        if (selectorExpression == null) {
            return;
        }
        Qualifier expressionQualifier = context.trace.get(BindingContext.QUALIFIER, expression);
        Qualifier receiverQualifier = context.trace.get(BindingContext.QUALIFIER, expression.getReceiverExpression());
        if (receiverQualifier == null && expressionQualifier != null) {
            assert (expressionQualifier.getClassifier() instanceof ClassDescriptor) : "Only class can (package cannot) be accessed by instance reference: " + expressionQualifier;
            context.trace.report(Errors.NESTED_CLASS_ACCESSED_VIA_INSTANCE_REFERENCE.on(selectorExpression, (ClassDescriptor)expressionQualifier.getClassifier()));
        }
    }

    private static class JetTypeInfoInsideSafeCall
    extends JetTypeInfo {
        private final DataFlowInfo safeCallChainInfo;

        private JetTypeInfoInsideSafeCall(@NotNull JetTypeInfo typeInfo, @Nullable DataFlowInfo safeCallChainInfo) {
            if (typeInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInfo", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver$JetTypeInfoInsideSafeCall", "<init>"));
            }
            super(typeInfo.getType(), typeInfo.getDataFlowInfo(), typeInfo.getJumpOutPossible(), typeInfo.getJumpFlowInfo());
            this.safeCallChainInfo = safeCallChainInfo;
        }

        @Nullable
        public DataFlowInfo getSafeCallChainInfo() {
            return this.safeCallChainInfo;
        }
    }
}

