/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.List;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.types.KotlinType;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001\u0003\t\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011)Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t\f\u0015\u0001Q!\u0001\u0005\u0001\u000b\u0001)\u0011\u0001\u0003\u0003\r\u0001eI\u0011bB\u0005\u0007\u0013\u0011I1!C\u0001\u0005\u0004a\u0005\u0001$\u0001M\u0001COI\u0001\u0002c\u0001\u000e\r%!\u0011bA\u0005\u0002\t\u0007A\n\u0001G\u0001\n\u0007!\u0011Q\"\u0001M\u0003\u0013\rA1!D\u0001\u0019\bE\u001b\u0011\u0001\u0003\u0003&>\u0011Y\u0001RB\u0007\u0006!\u001f)\"\u0001$\u0001%\u000f\u0011:\u0011C\u0001\u0003\u0001\u0011\u001d\t\"\u0001\"\u0001\t\u0011eI\u0001\u0012C\u0007\b\u0013\tI\u0011\u0001J\u0004\n\u0005%\tA\u0005\u0003\r\n3\rA\u0019\"D\u0001%\u0011E\u001b\u0011\u0001\u0003\u0006&\u0014\u0011YE\u0001#\u0006\u000e\u0003aY\u0011\u0004\u0002E\f\u001b\ta\t\u0001\u0007\u0007&\t\u0011Y\u0001\u0012D\u0007\u000215Is\u0001B!\t\u0011\ri\u0011\u0001g\u0002R\u0007\u0005)\u0001!\u000b\u0006\u0005\u0007\"AI!D\u0001\u0019\u0006q\u0019\u0013kA\u0002\u000e\u0005\u0011)\u00012B\u0015\u000b\t-C\u0001BA\u0007\u00021\u000b\t6\u0001B\u0003\u0001\u001b\t!a\u0001c\u0003"}, strings={"Lorg/jetbrains/kotlin/resolve/constants/ArrayValue;", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "", "value", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(Ljava/util/List;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "elementType", "getElementType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getType", "accept", "R", "kotlin.jvm.PlatformType", "D", "visitor", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationArgumentVisitor;", "data", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationArgumentVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "equals", "", "other", "", "hashCode", ""}, moduleName="kotlin-compiler")
public final class ArrayValue
extends ConstantValue<List<? extends ConstantValue<?>>> {
    @NotNull
    private final KotlinType type;
    private final KotlinBuiltIns builtIns;

    @Override
    public <R, D> R accept(@NotNull AnnotationArgumentVisitor<R, D> visitor2, D data) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        return visitor2.visitArrayValue(this, data);
    }

    @NotNull
    public final KotlinType getElementType() {
        KotlinType kotlinType = this.builtIns.getArrayElementType(this.getType());
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "builtIns.getArrayElementType(type)");
        return kotlinType;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.constants.ArrayValue");
        }
        return Intrinsics.areEqual((List)this.getValue(), (List)((ArrayValue)object2).getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    @Override
    @NotNull
    public KotlinType getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayValue(@NotNull List<? extends ConstantValue<?>> value2, @NotNull KotlinType type2, @NotNull KotlinBuiltIns builtIns) {
        void value3;
        Intrinsics.checkParameterIsNotNull(value2, "value");
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        super(value2);
        this.type = type2;
        this.builtIns = builtIns;
        boolean bl = KotlinBuiltIns.isArray(this.getType()) || KotlinBuiltIns.isPrimitiveArray(this.getType());
        if (PreconditionsKt.getASSERTIONS_ENABLED() && value3 == false) {
            String message = "Type should be an array, but was " + this.getType() + ": " + value2;
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
    }
}

