/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.relocated.gnu.trove.THashMap;

public class ResolveState {
    private static final ResolveState ourInitialState = new ResolveState();

    @NotNull
    public static ResolveState initial() {
        ResolveState resolveState = ourInitialState;
        if (resolveState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ResolveState", "initial"));
        }
        return resolveState;
    }

    @NotNull
    public <T> ResolveState put(@NotNull Key<T> key, T value2) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/ResolveState", "put"));
        }
        OneElementResolveState oneElementResolveState = new OneElementResolveState(key, value2);
        if (oneElementResolveState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ResolveState", "put"));
        }
        return oneElementResolveState;
    }

    public <T> T get(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/ResolveState", "get"));
        }
        if (key instanceof KeyWithDefaultValue) {
            return ((KeyWithDefaultValue)key).getDefaultValue();
        }
        return null;
    }

    private static class ManyElementResolveState
    extends ResolveState {
        private final Map<Object, Object> myValues;

        ManyElementResolveState(@NotNull ManyElementResolveState parent2, @NotNull Key key, Object value2) {
            if (parent2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/ResolveState$ManyElementResolveState", "<init>"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/ResolveState$ManyElementResolveState", "<init>"));
            }
            this.myValues = new THashMap<Object, Object>();
            this.myValues.putAll(parent2.myValues);
            this.myValues.put(key, value2);
        }

        ManyElementResolveState(@NotNull TwoElementResolveState twoState, @NotNull Key key, Object value2) {
            if (twoState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "twoState", "com/intellij/psi/ResolveState$ManyElementResolveState", "<init>"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/ResolveState$ManyElementResolveState", "<init>"));
            }
            this.myValues = new THashMap<Object, Object>();
            this.myValues.put(twoState.myKey1, twoState.myValue1);
            this.myValues.put(twoState.myKey2, twoState.myValue2);
            this.myValues.put(key, value2);
        }

        @Override
        @NotNull
        public <T> ResolveState put(@NotNull Key<T> key, T value2) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/ResolveState$ManyElementResolveState", "put"));
            }
            ManyElementResolveState manyElementResolveState = new ManyElementResolveState(this, key, value2);
            if (manyElementResolveState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ResolveState$ManyElementResolveState", "put"));
            }
            return manyElementResolveState;
        }

        @Override
        public <T> T get(@NotNull Key<T> key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/ResolveState$ManyElementResolveState", "get"));
            }
            Object value2 = this.myValues.get(key);
            if (value2 == null && key instanceof KeyWithDefaultValue) {
                return ((KeyWithDefaultValue)key).getDefaultValue();
            }
            return (T)value2;
        }
    }

    private static class TwoElementResolveState
    extends ResolveState {
        @NotNull
        private final Key myKey1;
        private final Object myValue1;
        @NotNull
        private final Key myKey2;
        private final Object myValue2;

        TwoElementResolveState(@NotNull Key key1, Object value1, @NotNull Key key2, Object value2) {
            if (key1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key1", "com/intellij/psi/ResolveState$TwoElementResolveState", "<init>"));
            }
            if (key2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key2", "com/intellij/psi/ResolveState$TwoElementResolveState", "<init>"));
            }
            this.myKey1 = key1;
            this.myValue1 = value1;
            this.myKey2 = key2;
            this.myValue2 = value2;
        }

        @Override
        @NotNull
        public <T> ResolveState put(@NotNull Key<T> key, T value2) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/ResolveState$TwoElementResolveState", "put"));
            }
            if (this.myKey1.equals(key)) {
                TwoElementResolveState twoElementResolveState = new TwoElementResolveState(key, value2, this.myKey2, this.myValue2);
                if (twoElementResolveState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ResolveState$TwoElementResolveState", "put"));
                }
                return twoElementResolveState;
            }
            if (this.myKey2.equals(key)) {
                TwoElementResolveState twoElementResolveState = new TwoElementResolveState(this.myKey1, this.myValue1, key, value2);
                if (twoElementResolveState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ResolveState$TwoElementResolveState", "put"));
                }
                return twoElementResolveState;
            }
            ManyElementResolveState manyElementResolveState = new ManyElementResolveState(this, key, value2);
            if (manyElementResolveState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ResolveState$TwoElementResolveState", "put"));
            }
            return manyElementResolveState;
        }

        @Override
        public <T> T get(@NotNull Key<T> key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/ResolveState$TwoElementResolveState", "get"));
            }
            Object value2 = this.myKey1.equals(key) ? this.myValue1 : (this.myKey2.equals(key) ? this.myValue2 : null);
            if (value2 == null && key instanceof KeyWithDefaultValue) {
                return ((KeyWithDefaultValue)key).getDefaultValue();
            }
            return (T)value2;
        }
    }

    private static class OneElementResolveState
    extends ResolveState {
        @NotNull
        private final Key myKey;
        private final Object myValue;

        private OneElementResolveState(@NotNull Key key, Object value2) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/ResolveState$OneElementResolveState", "<init>"));
            }
            this.myKey = key;
            this.myValue = value2;
        }

        @Override
        @NotNull
        public <T> ResolveState put(@NotNull Key<T> key, T value2) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/ResolveState$OneElementResolveState", "put"));
            }
            if (this.myKey.equals(key)) {
                OneElementResolveState oneElementResolveState = new OneElementResolveState(key, value2);
                if (oneElementResolveState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ResolveState$OneElementResolveState", "put"));
                }
                return oneElementResolveState;
            }
            TwoElementResolveState twoElementResolveState = new TwoElementResolveState(this.myKey, this.myValue, key, value2);
            if (twoElementResolveState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ResolveState$OneElementResolveState", "put"));
            }
            return twoElementResolveState;
        }

        @Override
        public <T> T get(@NotNull Key<T> key) {
            Object value2;
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/ResolveState$OneElementResolveState", "get"));
            }
            Object object = value2 = this.myKey.equals(key) ? this.myValue : null;
            if (value2 == null && key instanceof KeyWithDefaultValue) {
                return ((KeyWithDefaultValue)key).getDefaultValue();
            }
            return (T)value2;
        }
    }
}

