/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalsControlFlowPolicy
implements ControlFlowPolicy {
    private final PsiElement myCodeFragment;

    public LocalsControlFlowPolicy(@NotNull PsiElement codeFragment) {
        if (codeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFragment", "com/intellij/psi/controlFlow/LocalsControlFlowPolicy", "<init>"));
        }
        this.myCodeFragment = codeFragment;
    }

    @Override
    public PsiVariable getUsedVariable(@NotNull PsiReferenceExpression refExpr) {
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "com/intellij/psi/controlFlow/LocalsControlFlowPolicy", "getUsedVariable"));
        }
        if (refExpr.isQualified()) {
            return null;
        }
        PsiElement refElement = refExpr.resolve();
        return refElement instanceof PsiLocalVariable || refElement instanceof PsiParameter ? this.checkCodeFragment(refElement) : null;
    }

    @Nullable
    private PsiVariable checkCodeFragment(@NotNull PsiElement refElement) {
        PsiElement declarationScope;
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "com/intellij/psi/controlFlow/LocalsControlFlowPolicy", "checkCodeFragment"));
        }
        PsiElement codeFragment = refElement instanceof PsiParameter ? ((declarationScope = ((PsiParameter)refElement).getDeclarationScope()) instanceof PsiMethod ? ((PsiMethod)declarationScope).getBody() : (declarationScope instanceof PsiLambdaExpression ? ((PsiLambdaExpression)declarationScope).getBody() : ControlFlowUtil.findCodeFragment(refElement))) : ControlFlowUtil.findCodeFragment(refElement);
        if (codeFragment == null) {
            return null;
        }
        if (!(this.myCodeFragment.getContainingFile() != codeFragment.getContainingFile() || this.myCodeFragment.equals(codeFragment) || this.myCodeFragment.getParent() instanceof PsiLambdaExpression && PsiTreeUtil.isAncestor(PsiTreeUtil.getParentOfType(this.myCodeFragment, PsiClass.class), codeFragment, false))) {
            return null;
        }
        return (PsiVariable)refElement;
    }

    @Override
    public boolean isParameterAccepted(@NotNull PsiParameter psiParameter) {
        if (psiParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiParameter", "com/intellij/psi/controlFlow/LocalsControlFlowPolicy", "isParameterAccepted"));
        }
        return this.checkCodeFragment(psiParameter) != null;
    }

    @Override
    public boolean isLocalVariableAccepted(@NotNull PsiLocalVariable psiVariable) {
        if (psiVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiVariable", "com/intellij/psi/controlFlow/LocalsControlFlowPolicy", "isLocalVariableAccepted"));
        }
        return this.checkCodeFragment(psiVariable) != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalsControlFlowPolicy policy = (LocalsControlFlowPolicy)o;
        return this.myCodeFragment.equals(policy.myCodeFragment);
    }

    public int hashCode() {
        return this.myCodeFragment.hashCode();
    }
}

