/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.List;
import kotlin.jvm.functions.Function0;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithSource;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.LazyClassReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.LazySubstitutingClassDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.InnerClassesScopeWrapper;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.KtScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.SubstitutingScope;
import kotlin.reflect.jvm.internal.impl.storage.NotNullLazyValue;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.IndexedParametersSubstitution;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractClassDescriptor
implements ClassDescriptor {
    private final Name name;
    protected final NotNullLazyValue<KotlinType> defaultType;
    private final NotNullLazyValue<KtScope> unsubstitutedInnerClassesScope;
    private final NotNullLazyValue<ReceiverParameterDescriptor> thisAsReceiverParameter;

    public AbstractClassDescriptor(@NotNull StorageManager storageManager, @NotNull Name name) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractClassDescriptor", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractClassDescriptor", "<init>"));
        }
        this.name = name;
        this.defaultType = storageManager.createLazyValue(new Function0<KotlinType>(){

            @Override
            public KotlinType invoke() {
                return TypeUtils.makeUnsubstitutedType(AbstractClassDescriptor.this, AbstractClassDescriptor.this.getUnsubstitutedMemberScope());
            }
        });
        this.unsubstitutedInnerClassesScope = storageManager.createLazyValue(new Function0<KtScope>(){

            @Override
            public KtScope invoke() {
                return new InnerClassesScopeWrapper(AbstractClassDescriptor.this.getUnsubstitutedMemberScope());
            }
        });
        this.thisAsReceiverParameter = storageManager.createLazyValue(new Function0<ReceiverParameterDescriptor>(){

            @Override
            public ReceiverParameterDescriptor invoke() {
                return new LazyClassReceiverParameterDescriptor(AbstractClassDescriptor.this);
            }
        });
    }

    @Override
    @NotNull
    public Name getName() {
        Name name = this.name;
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractClassDescriptor", "getName"));
        }
        return name;
    }

    @Override
    @NotNull
    public DeclarationDescriptorWithSource getOriginal() {
        AbstractClassDescriptor abstractClassDescriptor = this;
        if (abstractClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractClassDescriptor", "getOriginal"));
        }
        return abstractClassDescriptor;
    }

    @Override
    @NotNull
    public KtScope getUnsubstitutedInnerClassesScope() {
        KtScope ktScope = (KtScope)this.unsubstitutedInnerClassesScope.invoke();
        if (ktScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractClassDescriptor", "getUnsubstitutedInnerClassesScope"));
        }
        return ktScope;
    }

    @Override
    @NotNull
    public ReceiverParameterDescriptor getThisAsReceiverParameter() {
        ReceiverParameterDescriptor receiverParameterDescriptor = (ReceiverParameterDescriptor)this.thisAsReceiverParameter.invoke();
        if (receiverParameterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractClassDescriptor", "getThisAsReceiverParameter"));
        }
        return receiverParameterDescriptor;
    }

    @Override
    @NotNull
    public KtScope getMemberScope(@NotNull List<? extends TypeProjection> typeArguments) {
        if (typeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArguments", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractClassDescriptor", "getMemberScope"));
        }
        assert (typeArguments.size() == this.getTypeConstructor().getParameters().size()) : "Illegal number of type arguments: expected " + this.getTypeConstructor().getParameters().size() + " but was " + typeArguments.size() + " for " + this.getTypeConstructor() + " " + this.getTypeConstructor().getParameters();
        if (typeArguments.isEmpty()) {
            KtScope ktScope = this.getUnsubstitutedMemberScope();
            if (ktScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractClassDescriptor", "getMemberScope"));
            }
            return ktScope;
        }
        TypeSubstitutor substitutor2 = new IndexedParametersSubstitution(this.getTypeConstructor(), typeArguments).buildSubstitutor();
        SubstitutingScope substitutingScope = new SubstitutingScope(this.getUnsubstitutedMemberScope(), substitutor2);
        if (substitutingScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractClassDescriptor", "getMemberScope"));
        }
        return substitutingScope;
    }

    @Override
    @NotNull
    public KtScope getMemberScope(@NotNull TypeSubstitution typeSubstitution) {
        if (typeSubstitution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeSubstitution", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractClassDescriptor", "getMemberScope"));
        }
        if (typeSubstitution.isEmpty()) {
            KtScope ktScope = this.getUnsubstitutedMemberScope();
            if (ktScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractClassDescriptor", "getMemberScope"));
            }
            return ktScope;
        }
        TypeSubstitutor substitutor2 = TypeSubstitutor.create(typeSubstitution);
        SubstitutingScope substitutingScope = new SubstitutingScope(this.getUnsubstitutedMemberScope(), substitutor2);
        if (substitutingScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractClassDescriptor", "getMemberScope"));
        }
        return substitutingScope;
    }

    @Override
    @NotNull
    public ClassDescriptor substitute(@NotNull TypeSubstitutor substitutor2) {
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractClassDescriptor", "substitute"));
        }
        if (substitutor2.isEmpty()) {
            AbstractClassDescriptor abstractClassDescriptor = this;
            if (abstractClassDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractClassDescriptor", "substitute"));
            }
            return abstractClassDescriptor;
        }
        LazySubstitutingClassDescriptor lazySubstitutingClassDescriptor = new LazySubstitutingClassDescriptor(this, substitutor2);
        if (lazySubstitutingClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractClassDescriptor", "substitute"));
        }
        return lazySubstitutingClassDescriptor;
    }

    @Override
    @NotNull
    public KotlinType getDefaultType() {
        KotlinType kotlinType = (KotlinType)this.defaultType.invoke();
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractClassDescriptor", "getDefaultType"));
        }
        return kotlinType;
    }

    @Override
    public void acceptVoid(DeclarationDescriptorVisitor<Void, Void> visitor2) {
        visitor2.visitClassDescriptor(this, null);
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data) {
        return visitor2.visitClassDescriptor(this, data);
    }
}

