/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.KtScope;
import kotlin.reflect.jvm.internal.impl.types.DelegatingFlexibleType;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.Flexibility;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeCapabilities;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeImpl;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeIntersector;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonSupertypes {
    @Nullable
    public static KotlinType commonSupertypeForNonDenotableTypes(@NotNull Collection<KotlinType> types2) {
        KotlinType type2;
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "commonSupertypeForNonDenotableTypes"));
        }
        if (types2.isEmpty()) {
            return null;
        }
        if (types2.size() == 1 && (type2 = types2.iterator().next()).getConstructor() instanceof IntersectionTypeConstructor) {
            return CommonSupertypes.commonSupertypeForNonDenotableTypes(type2.getConstructor().getSupertypes());
        }
        return CommonSupertypes.commonSupertype(types2);
    }

    @NotNull
    public static KotlinType commonSupertype(@NotNull Collection<KotlinType> types2) {
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "commonSupertype"));
        }
        KotlinType kotlinType = CommonSupertypes.findCommonSupertype(types2, 0, CommonSupertypes.maxDepth(types2) + 3);
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "commonSupertype"));
        }
        return kotlinType;
    }

    private static int maxDepth(@NotNull Collection<KotlinType> types2) {
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "maxDepth"));
        }
        int max = 0;
        for (KotlinType type2 : types2) {
            int depth = CommonSupertypes.depth(type2);
            if (max >= depth) continue;
            max = depth;
        }
        return max;
    }

    private static int depth(final @NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "depth"));
        }
        return 1 + CommonSupertypes.maxDepth(CollectionsKt.map(type2.getArguments(), new Function1<TypeProjection, KotlinType>(){

            @Override
            public KotlinType invoke(TypeProjection projection) {
                if (projection.isStarProjection()) {
                    return type2.getConstructor().getBuiltIns().getAnyType();
                }
                return projection.getType();
            }
        }));
    }

    @NotNull
    private static KotlinType findCommonSupertype(@NotNull Collection<KotlinType> types2, int recursionDepth, int maxDepth) {
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "findCommonSupertype"));
        }
        assert (recursionDepth <= maxDepth) : "Recursion depth exceeded: " + recursionDepth + " > " + maxDepth + " for types " + types2;
        boolean hasFlexible = false;
        ArrayList<KotlinType> upper = new ArrayList<KotlinType>(types2.size());
        ArrayList<KotlinType> lower = new ArrayList<KotlinType>(types2.size());
        LinkedHashSet<FlexibleTypeCapabilities> capabilities = new LinkedHashSet<FlexibleTypeCapabilities>();
        for (KotlinType type2 : types2) {
            if (FlexibleTypesKt.isFlexible(type2)) {
                hasFlexible = true;
                Flexibility flexibility = FlexibleTypesKt.flexibility(type2);
                upper.add(flexibility.getUpperBound());
                lower.add(flexibility.getLowerBound());
                capabilities.add(flexibility.getExtraCapabilities());
                continue;
            }
            upper.add(type2);
            lower.add(type2);
        }
        if (!hasFlexible) {
            KotlinType kotlinType = CommonSupertypes.commonSuperTypeForInflexible(types2, recursionDepth, maxDepth);
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "findCommonSupertype"));
            }
            return kotlinType;
        }
        KotlinType kotlinType = DelegatingFlexibleType.create(CommonSupertypes.commonSuperTypeForInflexible(lower, recursionDepth, maxDepth), CommonSupertypes.commonSuperTypeForInflexible(upper, recursionDepth, maxDepth), (FlexibleTypeCapabilities)CollectionsKt.single(capabilities));
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "findCommonSupertype"));
        }
        return kotlinType;
    }

    @NotNull
    private static KotlinType commonSuperTypeForInflexible(@NotNull Collection<KotlinType> types2, int recursionDepth, int maxDepth) {
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "commonSuperTypeForInflexible"));
        }
        assert (!types2.isEmpty());
        HashSet<KotlinType> typeSet = new HashSet<KotlinType>(types2);
        KotlinType bestFit = FlexibleTypesKt.singleBestRepresentative(typeSet);
        if (bestFit != null) {
            KotlinType kotlinType = bestFit;
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "commonSuperTypeForInflexible"));
            }
            return kotlinType;
        }
        boolean nullable2 = false;
        Iterator iterator2 = typeSet.iterator();
        while (iterator2.hasNext()) {
            KotlinType type2 = (KotlinType)iterator2.next();
            assert (type2 != null);
            assert (!FlexibleTypesKt.isFlexible(type2)) : "Flexible type " + type2 + " passed to commonSuperTypeForInflexible";
            if (KotlinBuiltIns.isNothingOrNullableNothing(type2)) {
                iterator2.remove();
            }
            if (type2.isError()) {
                KotlinType kotlinType = ErrorUtils.createErrorType("Supertype of error type " + type2);
                if (kotlinType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "commonSuperTypeForInflexible"));
                }
                return kotlinType;
            }
            nullable2 |= type2.isMarkedNullable();
        }
        if (typeSet.isEmpty()) {
            KotlinBuiltIns builtIns = types2.iterator().next().getConstructor().getBuiltIns();
            KotlinType kotlinType = nullable2 ? builtIns.getNullableNothingType() : builtIns.getNothingType();
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "commonSuperTypeForInflexible"));
            }
            return kotlinType;
        }
        if (typeSet.size() == 1) {
            KotlinType kotlinType = TypeUtils.makeNullableIfNeeded((KotlinType)typeSet.iterator().next(), nullable2);
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "commonSuperTypeForInflexible"));
            }
            return kotlinType;
        }
        Map<TypeConstructor, Set<KotlinType>> commonSupertypes = CommonSupertypes.computeCommonRawSupertypes(typeSet);
        while (commonSupertypes.size() > 1) {
            HashSet<KotlinType> merge = new HashSet<KotlinType>();
            for (Set<KotlinType> supertypes2 : commonSupertypes.values()) {
                merge.addAll(supertypes2);
            }
            commonSupertypes = CommonSupertypes.computeCommonRawSupertypes(merge);
        }
        assert (!commonSupertypes.isEmpty()) : commonSupertypes + " <- " + types2;
        Map.Entry<TypeConstructor, Set<KotlinType>> entry = commonSupertypes.entrySet().iterator().next();
        KotlinType result2 = CommonSupertypes.computeSupertypeProjections(entry.getKey(), entry.getValue(), recursionDepth, maxDepth);
        KotlinType kotlinType = TypeUtils.makeNullableIfNeeded(result2, nullable2);
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "commonSuperTypeForInflexible"));
        }
        return kotlinType;
    }

    @NotNull
    private static Map<TypeConstructor, Set<KotlinType>> computeCommonRawSupertypes(@NotNull Collection<KotlinType> types2) {
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "computeCommonRawSupertypes"));
        }
        assert (!types2.isEmpty());
        HashMap<TypeConstructor, Set<KotlinType>> constructorToAllInstances = new HashMap<TypeConstructor, Set<KotlinType>>();
        HashSet<TypeConstructor> commonSuperclasses = null;
        List<TypeConstructor> order = null;
        for (KotlinType type2 : types2) {
            HashSet<TypeConstructor> visited = new HashSet<TypeConstructor>();
            order = TypeUtils.topologicallySortSuperclassesAndRecordAllInstances(type2, constructorToAllInstances, visited);
            if (commonSuperclasses == null) {
                commonSuperclasses = visited;
                continue;
            }
            commonSuperclasses.retainAll(visited);
        }
        assert (order != null);
        HashSet<TypeConstructor> notSource = new HashSet<TypeConstructor>();
        HashMap<TypeConstructor, Set<KotlinType>> result2 = new HashMap<TypeConstructor, Set<KotlinType>>();
        for (TypeConstructor superConstructor : order) {
            if (!commonSuperclasses.contains(superConstructor) || notSource.contains(superConstructor)) continue;
            result2.put(superConstructor, (Set<KotlinType>)constructorToAllInstances.get(superConstructor));
            CommonSupertypes.markAll(superConstructor, notSource);
        }
        HashMap<TypeConstructor, Set<KotlinType>> hashMap = result2;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "computeCommonRawSupertypes"));
        }
        return hashMap;
    }

    @NotNull
    private static KotlinType computeSupertypeProjections(@NotNull TypeConstructor constructor, @NotNull Set<KotlinType> types2, int recursionDepth, int maxDepth) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "computeSupertypeProjections"));
        }
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "computeSupertypeProjections"));
        }
        assert (!types2.isEmpty());
        if (types2.size() == 1) {
            KotlinType kotlinType = types2.iterator().next();
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "computeSupertypeProjections"));
            }
            return kotlinType;
        }
        List<TypeParameterDescriptor> parameters2 = constructor.getParameters();
        ArrayList<TypeProjection> newProjections = new ArrayList<TypeProjection>(parameters2.size());
        for (TypeParameterDescriptor parameterDescriptor : parameters2) {
            HashSet<TypeProjection> typeProjections = new HashSet<TypeProjection>();
            for (KotlinType type2 : types2) {
                typeProjections.add(type2.getArguments().get(parameterDescriptor.getIndex()));
            }
            newProjections.add(CommonSupertypes.computeSupertypeProjection(parameterDescriptor, typeProjections, recursionDepth, maxDepth));
        }
        boolean nullable2 = false;
        for (KotlinType type3 : types2) {
            nullable2 |= type3.isMarkedNullable();
        }
        ClassifierDescriptor declarationDescriptor = constructor.getDeclarationDescriptor();
        KtScope newScope = declarationDescriptor instanceof ClassDescriptor ? ((ClassDescriptor)declarationDescriptor).getMemberScope(newProjections) : (declarationDescriptor instanceof TypeParameterDescriptor ? ((TypeParameterDescriptor)declarationDescriptor).getUpperBoundsAsType().getMemberScope() : ErrorUtils.createErrorScope("A scope for common supertype which is not a normal classifier", true));
        KotlinTypeImpl kotlinTypeImpl = KotlinTypeImpl.create(Annotations.Companion.getEMPTY(), constructor, nullable2, newProjections, newScope);
        if (kotlinTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "computeSupertypeProjections"));
        }
        return kotlinTypeImpl;
    }

    @NotNull
    private static TypeProjection computeSupertypeProjection(@NotNull TypeParameterDescriptor parameterDescriptor, @NotNull Set<TypeProjection> typeProjections, int recursionDepth, int maxDepth) {
        Variance projectionKind;
        if (parameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterDescriptor", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "computeSupertypeProjection"));
        }
        if (typeProjections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjections", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "computeSupertypeProjection"));
        }
        TypeProjection singleBestProjection = FlexibleTypesKt.singleBestRepresentative(typeProjections);
        if (singleBestProjection != null) {
            TypeProjection typeProjection = singleBestProjection;
            if (typeProjection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjection;
        }
        if (recursionDepth >= maxDepth) {
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(Variance.OUT_VARIANCE, DescriptorUtilsKt.getBuiltIns(parameterDescriptor).getNullableAnyType());
            if (typeProjectionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjectionImpl;
        }
        HashSet<KotlinType> ins = new HashSet<KotlinType>();
        HashSet<KotlinType> outs = new HashSet<KotlinType>();
        Variance variance = parameterDescriptor.getVariance();
        switch (variance) {
            case INVARIANT: {
                break;
            }
            case IN_VARIANCE: {
                outs = null;
                break;
            }
            case OUT_VARIANCE: {
                ins = null;
            }
        }
        for (TypeProjection projection : typeProjections) {
            Variance projectionKind2 = projection.getProjectionKind();
            if (projectionKind2.getAllowsInPosition()) {
                if (ins != null) {
                    ins.add(projection.getType());
                }
            } else {
                ins = null;
            }
            if (projectionKind2.getAllowsOutPosition()) {
                if (outs == null) continue;
                outs.add(projection.getType());
                continue;
            }
            outs = null;
        }
        if (outs != null) {
            assert (!outs.isEmpty()) : "Out projections is empty for parameter " + parameterDescriptor + ", type projections " + typeProjections;
            projectionKind = variance == Variance.OUT_VARIANCE ? Variance.INVARIANT : Variance.OUT_VARIANCE;
            KotlinType superType = CommonSupertypes.findCommonSupertype(outs, recursionDepth + 1, maxDepth);
            for (KotlinType upperBound : parameterDescriptor.getUpperBounds()) {
                if (TypeUtilsKt.isSubtypeOf(superType, upperBound)) continue;
                StarProjectionImpl starProjectionImpl = new StarProjectionImpl(parameterDescriptor);
                if (starProjectionImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "computeSupertypeProjection"));
                }
                return starProjectionImpl;
            }
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(projectionKind, superType);
            if (typeProjectionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjectionImpl;
        }
        if (ins != null) {
            assert (!ins.isEmpty()) : "In projections is empty for parameter " + parameterDescriptor + ", type projections " + typeProjections;
            KotlinType intersection = TypeIntersector.intersectTypes(KotlinTypeChecker.DEFAULT, ins);
            if (intersection == null) {
                TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(Variance.OUT_VARIANCE, CommonSupertypes.findCommonSupertype(parameterDescriptor.getUpperBounds(), recursionDepth + 1, maxDepth));
                if (typeProjectionImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "computeSupertypeProjection"));
                }
                return typeProjectionImpl;
            }
            Variance projectionKind3 = variance == Variance.IN_VARIANCE ? Variance.INVARIANT : Variance.IN_VARIANCE;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(projectionKind3, intersection);
            if (typeProjectionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjectionImpl;
        }
        projectionKind = variance == Variance.OUT_VARIANCE ? Variance.INVARIANT : Variance.OUT_VARIANCE;
        TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(projectionKind, CommonSupertypes.findCommonSupertype(parameterDescriptor.getUpperBounds(), recursionDepth + 1, maxDepth));
        if (typeProjectionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "computeSupertypeProjection"));
        }
        return typeProjectionImpl;
    }

    private static void markAll(@NotNull TypeConstructor typeConstructor2, @NotNull Set<TypeConstructor> markerSet) {
        if (typeConstructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstructor", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "markAll"));
        }
        if (markerSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markerSet", "kotlin/reflect/jvm/internal/impl/types/CommonSupertypes", "markAll"));
        }
        markerSet.add(typeConstructor2);
        for (KotlinType type2 : typeConstructor2.getSupertypes()) {
            CommonSupertypes.markAll(type2.getConstructor(), markerSet);
        }
    }
}

