/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.lazy.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.IndexedValue;
import kotlin.PreconditionsKt;
import kotlin.SetsKt;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.CompositeAnnotations;
import org.jetbrains.kotlin.load.java.components.TypeUsage;
import org.jetbrains.kotlin.load.java.lazy.LazyJavaAnnotations;
import org.jetbrains.kotlin.load.java.lazy.LazyJavaResolverContext;
import org.jetbrains.kotlin.load.java.lazy.TypeParameterResolver;
import org.jetbrains.kotlin.load.java.lazy.types.JavaTypeAttributes;
import org.jetbrains.kotlin.load.java.lazy.types.JavaTypeFlexibility;
import org.jetbrains.kotlin.load.java.lazy.types.LazyJavaTypeResolverKt;
import org.jetbrains.kotlin.load.java.lazy.types.RawSubstitution;
import org.jetbrains.kotlin.load.java.lazy.types.RawTypeCapabilities;
import org.jetbrains.kotlin.load.java.structure.JavaArrayType;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaConstructor;
import org.jetbrains.kotlin.load.java.structure.JavaPrimitiveType;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.JavaWildcardType;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.resolve.jvm.JavaDescriptorResolverKt;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.types.AbstractLazyType;
import org.jetbrains.kotlin.types.CustomTypeVariable;
import org.jetbrains.kotlin.types.DelegatingFlexibleType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.FlexibleTypeCapabilities;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.Specificity;
import org.jetbrains.kotlin.types.TypeCapabilities;
import org.jetbrains.kotlin.types.TypeCapability;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u00012B\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tA\u0002A\r\u00021\u0003i\u0012!c\u0005\"\u0016%\u0019\u0001\"A\u0007\u00021\u0007I1\u0001\u0003\u0002\u000e\u0003a\u0015\u0011kA\u0001\t\u0007\u0015\u0002\u0002rA\u0007\u00021\u0011I2\u0001#\u0003\u000e\u0003a)\u0011d\u0001E\u0006\u001b\u0005Ab!\u0007\u0003\u0005\u0003!5Q\"\u0001\r\bK-Ay!D\u0001\u0019\te\u0019\u0001\u0002C\u0007\u00021#I2\u0001c\u0003\u000e\u0003a1\u0011f\u0002\u0003B\u0011!\tQ\"\u0001M\u0002#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001BA\u0007\u00021\u000b\t6!A\u0003\u0001"}, strings={"Lorg/jetbrains/kotlin/load/java/lazy/types/LazyJavaTypeResolver;", "", "c", "Lorg/jetbrains/kotlin/load/java/lazy/LazyJavaResolverContext;", "typeParameterResolver", "Lorg/jetbrains/kotlin/load/java/lazy/TypeParameterResolver;", "(Lorg/jetbrains/kotlin/load/java/lazy/LazyJavaResolverContext;Lorg/jetbrains/kotlin/load/java/lazy/TypeParameterResolver;)V", "transformArrayType", "Lorg/jetbrains/kotlin/types/KotlinType;", "arrayType", "Lorg/jetbrains/kotlin/load/java/structure/JavaArrayType;", "attr", "Lorg/jetbrains/kotlin/load/java/lazy/types/JavaTypeAttributes;", "isVararg", "", "transformJavaType", "javaType", "Lorg/jetbrains/kotlin/load/java/structure/JavaType;", "FlexibleJavaClassifierTypeCapabilities", "LazyJavaClassifierType"}, moduleName="kotlin-compiler")
public final class LazyJavaTypeResolver {
    private final LazyJavaResolverContext c;
    private final TypeParameterResolver typeParameterResolver;

    @NotNull
    public final KotlinType transformJavaType(@NotNull JavaType javaType2, @NotNull JavaTypeAttributes attr) {
        KotlinType kotlinType;
        Intrinsics.checkParameterIsNotNull(javaType2, "javaType");
        Intrinsics.checkParameterIsNotNull(attr, "attr");
        JavaType javaType3 = javaType2;
        if (javaType3 instanceof JavaPrimitiveType) {
            PrimitiveType primitiveType = ((JavaPrimitiveType)javaType2).getType();
            kotlinType = primitiveType != null ? this.c.getModule().getBuiltIns().getPrimitiveJetType(primitiveType) : this.c.getModule().getBuiltIns().getUnitType();
        } else if (javaType3 instanceof JavaClassifierType) {
            kotlinType = JavaDescriptorResolverKt.getPLATFORM_TYPES() && attr.getAllowFlexible() && Intrinsics.areEqual((Object)attr.getHowThisTypeIsUsed(), (Object)TypeUsage.SUPERTYPE) ^ true ? FlexibleJavaClassifierTypeCapabilities.create(new LazyJavaClassifierType((JavaClassifierType)javaType2, LazyJavaTypeResolverKt.toFlexible(attr, JavaTypeFlexibility.FLEXIBLE_LOWER_BOUND)), new LazyJavaClassifierType((JavaClassifierType)javaType2, LazyJavaTypeResolverKt.toFlexible(attr, JavaTypeFlexibility.FLEXIBLE_UPPER_BOUND))) : (KotlinType)new LazyJavaClassifierType((JavaClassifierType)javaType2, attr);
        } else if (javaType3 instanceof JavaArrayType) {
            kotlinType = LazyJavaTypeResolver.transformArrayType$default(this, (JavaArrayType)javaType2, attr, false, 4);
        } else {
            throw (Throwable)new UnsupportedOperationException("Unsupported type: " + javaType2);
        }
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "when (javaType) {\n      \u2026: \" + javaType)\n        }");
        return kotlinType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KotlinType transformArrayType(@NotNull JavaArrayType arrayType, @NotNull JavaTypeAttributes attr, boolean isVararg) {
        KotlinType kotlinType;
        PrimitiveType primitiveType;
        void $receiver;
        Intrinsics.checkParameterIsNotNull(arrayType, "arrayType");
        Intrinsics.checkParameterIsNotNull(attr, "attr");
        LazyJavaTypeResolver lazyJavaTypeResolver = this;
        LazyJavaTypeResolver $receiver2 = (LazyJavaTypeResolver)$receiver;
        JavaType javaComponentType = arrayType.getComponentType();
        JavaType javaType2 = javaComponentType;
        if (!(javaType2 instanceof JavaPrimitiveType)) {
            javaType2 = null;
        }
        JavaPrimitiveType javaPrimitiveType = (JavaPrimitiveType)javaType2;
        PrimitiveType primitiveType2 = primitiveType = javaPrimitiveType != null ? javaPrimitiveType.getType() : null;
        if (primitiveType != null) {
            KotlinType jetType = $receiver2.c.getModule().getBuiltIns().getPrimitiveArrayJetType(primitiveType);
            if (JavaDescriptorResolverKt.getPLATFORM_TYPES() && attr.getAllowFlexible()) {
                KotlinType kotlinType2 = jetType;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "jetType");
                KotlinType kotlinType3 = TypeUtils.makeNullable(jetType);
                Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "TypeUtils.makeNullable(jetType)");
                kotlinType = FlexibleJavaClassifierTypeCapabilities.create(kotlinType2, kotlinType3);
            } else {
                KotlinType kotlinType4 = TypeUtils.makeNullableAsSpecified(jetType, !attr.isMarkedNotNull());
                kotlinType = kotlinType4;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType4, "TypeUtils.makeNullableAs\u2026e, !attr.isMarkedNotNull)");
            }
        } else {
            JavaType javaType3 = javaComponentType;
            Intrinsics.checkExpressionValueIsNotNull(javaType3, "javaComponentType");
            KotlinType componentType = $receiver2.transformJavaType(javaType3, LazyJavaTypeResolverKt.toAttributes$default(TypeUsage.TYPE_ARGUMENT, attr.getAllowFlexible(), attr.isForAnnotationParameter(), null, 4));
            if (JavaDescriptorResolverKt.getPLATFORM_TYPES() && attr.getAllowFlexible()) {
                KotlinType kotlinType5 = $receiver2.c.getModule().getBuiltIns().getArrayType(Variance.INVARIANT, componentType);
                Intrinsics.checkExpressionValueIsNotNull(kotlinType5, "c.module.builtIns.getArr\u2026INVARIANT, componentType)");
                KotlinType kotlinType6 = TypeUtils.makeNullable($receiver2.c.getModule().getBuiltIns().getArrayType(Variance.OUT_VARIANCE, componentType));
                Intrinsics.checkExpressionValueIsNotNull(kotlinType6, "TypeUtils.makeNullable(c\u2026VARIANCE, componentType))");
                kotlinType = FlexibleJavaClassifierTypeCapabilities.create(kotlinType5, kotlinType6);
            } else {
                Variance projectionKind = Intrinsics.areEqual((Object)attr.getHowThisTypeIsUsed(), (Object)TypeUsage.MEMBER_SIGNATURE_CONTRAVARIANT) || isVararg ? Variance.OUT_VARIANCE : Variance.INVARIANT;
                KotlinType result2 = $receiver2.c.getModule().getBuiltIns().getArrayType(projectionKind, componentType);
                kotlinType = TypeUtils.makeNullableAsSpecified(result2, !attr.isMarkedNotNull());
            }
        }
        return TypeUtilsKt.replaceAnnotations(kotlinType, attr.getTypeAnnotations());
    }

    @NotNull
    public static /* synthetic */ KotlinType transformArrayType$default(LazyJavaTypeResolver lazyJavaTypeResolver, JavaArrayType javaArrayType, JavaTypeAttributes javaTypeAttributes, boolean bl, int n) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return lazyJavaTypeResolver.transformArrayType(javaArrayType, javaTypeAttributes, bl);
    }

    public LazyJavaTypeResolver(@NotNull LazyJavaResolverContext c, @NotNull TypeParameterResolver typeParameterResolver) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(typeParameterResolver, "typeParameterResolver");
        this.c = c;
        this.typeParameterResolver = typeParameterResolver;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"m\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005AY!\u0002\u0001\u0006\u0003!\u0001R!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011\u0001B!\u0003\u0019\u0001I\u0012\u0001'\u0001\"\u001c%%\u0001\"A\u0007\u00021\u0007\u00016\u0011AE\u0005\u0011\ti\u0011\u0001'\u0002Q\u0007\u0005\t6!\u0001\u0005\u0004K\u001d!!\u0002\u0003\u0005\u000e\t%\u0011\u0011\"\u0001\r\n1#)C\u0001\u0002\u0006\t\u00145\t\u0001DC\u0013\u0005\t-A)\"D\u0001\u0019\t\u0015\"Aa\u0003\u0005\f\u001b\u0005A:\"\n\u0003\u0005\u0003!aQ\"\u0001M\rK\u0011!\u0011\u0001C\u0007\u000e\u0003a=Q\u0005\u0002\u0003\f\u00117i\u0011\u0001g\u0004&\t\u0011\t\u0001BD\u0007\u00021\u001f)\u0013\u0002B\u0001\t\u001e5\u0011A\u0012\u0001\r\u00103\rAy\"D\u0001\u0019!\u0015\u0002B!\u0001E\u0011\u001b\u0005A\u0012\"G\u0002\t\u00035\t\u0001$E\r\u0004\u0011\ti\u0011\u0001'\u0002\u001a\u0007!\rR\"\u0001\r\u0013S\u001d!\u0011\t\u0003E\u0004\u001b\u0005AB!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\ti\u0011\u0001'\u0002R\u0007\u0005)\u0001!+\u0007\u0005\u0003\"AI!$\u0004\n\n%\u001d\u00014B)\u0004\u0003\u00111\u0001$B)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!\tQ\"\u0001M\u0002#\u000e\tQ\u0001A\u0015\u000b\t\u0005C\u0001RB\u0007\u0005\u0013\tI\u0011\u0001g\u0004\u0019\u000fE\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/kotlin/load/java/lazy/types/LazyJavaTypeResolver$LazyJavaClassifierType;", "Lorg/jetbrains/kotlin/types/AbstractLazyType;", "javaType", "Lorg/jetbrains/kotlin/load/java/structure/JavaClassifierType;", "attr", "Lorg/jetbrains/kotlin/load/java/lazy/types/JavaTypeAttributes;", "(Lorg/jetbrains/kotlin/load/java/lazy/types/LazyJavaTypeResolver;Lorg/jetbrains/kotlin/load/java/structure/JavaClassifierType;Lorg/jetbrains/kotlin/load/java/lazy/types/JavaTypeAttributes;)V", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/CompositeAnnotations;", "classifier", "Lorg/jetbrains/kotlin/storage/NullableLazyValue;", "Lorg/jetbrains/kotlin/load/java/structure/JavaClassifier;", "Lorg/jetbrains/annotations/Nullable;", "nullable", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "", "computeArguments", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "computeTypeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "getAnnotations", "getCapabilities", "Lorg/jetbrains/kotlin/types/TypeCapabilities;", "getConstructorTypeParameterSubstitute", "Lorg/jetbrains/kotlin/types/KotlinType;", "isConstructorTypeParameter", "isMarkedNullable", "isRaw", "mapKotlinClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "transformToTypeProjection", "Lorg/jetbrains/kotlin/load/java/structure/JavaType;", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;"}, moduleName="kotlin-compiler")
    private final class LazyJavaClassifierType
    extends AbstractLazyType {
        private final CompositeAnnotations annotations;
        private final NullableLazyValue<JavaClassifier> classifier;
        private final NotNullLazyValue<Boolean> nullable;
        private final JavaClassifierType javaType;
        private final JavaTypeAttributes attr;

        @Override
        @NotNull
        protected TypeConstructor computeTypeConstructor() {
            Annotated annotated;
            JavaClassifier classifier2 = (JavaClassifier)this.classifier.invoke();
            if (classifier2 == null) {
                TypeConstructor typeConstructor2 = ErrorUtils.createErrorTypeConstructor("Unresolved java classifier: " + this.javaType.getPresentableText());
                Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "ErrorUtils.createErrorTy\u2026ype.getPresentableText())");
                return typeConstructor2;
            }
            JavaClassifier javaClassifier = classifier2;
            if (javaClassifier instanceof JavaClass) {
                ClassDescriptor classData;
                Annotated annotated2;
                FqName fqName2;
                FqName $receiver = ((JavaClass)classifier2).getFqName();
                FqName fqName3 = $receiver;
                if (fqName3 == null) {
                    AssertionError assertionError;
                    AssertionError assertionError2 = assertionError;
                    AssertionError assertionError3 = assertionError;
                    String string = "Class type should have a FQ name: " + classifier2;
                    assertionError2((Object)string);
                    throw (Throwable)((Object)assertionError3);
                }
                FqName fqName4 = fqName2 = fqName3;
                Intrinsics.checkExpressionValueIsNotNull(fqName4, "fqName");
                ClassDescriptor classDescriptor = this.mapKotlinClass(fqName4);
                if (classDescriptor == null) {
                    classDescriptor = LazyJavaTypeResolver.this.c.getComponents().getModuleClassResolver().resolveClass((JavaClass)classifier2);
                }
                if ((annotated2 = (classData = classDescriptor)) == null || (annotated2 = annotated2.getTypeConstructor()) == null) {
                    annotated2 = ErrorUtils.createErrorTypeConstructor("Unresolved java classifier: " + this.javaType.getPresentableText());
                }
                annotated = annotated2;
                Intrinsics.checkExpressionValueIsNotNull(annotated2, "classData?.getTypeConstr\u2026ype.getPresentableText())");
            } else if (javaClassifier instanceof JavaTypeParameter) {
                if (this.isConstructorTypeParameter()) {
                    annotated = this.getConstructorTypeParameterSubstitute().getConstructor();
                } else {
                    annotated = LazyJavaTypeResolver.this.typeParameterResolver.resolveTypeParameter((JavaTypeParameter)classifier2);
                    if (annotated == null || (annotated = annotated.getTypeConstructor()) == null) {
                        annotated = ErrorUtils.createErrorTypeConstructor("Unresolved Java type parameter: " + this.javaType.getPresentableText());
                    }
                }
            } else {
                throw (Throwable)new IllegalStateException("Unknown classifier kind: " + classifier2);
            }
            Intrinsics.checkExpressionValueIsNotNull(annotated, "when (classifier) {\n    \u2026lassifier\")\n            }");
            return annotated;
        }

        private final ClassDescriptor mapKotlinClass(FqName fqName2) {
            if (this.attr.isForAnnotationParameter() && Intrinsics.areEqual(fqName2, LazyJavaTypeResolverKt.access$getJAVA_LANG_CLASS_FQ_NAME$p())) {
                return LazyJavaTypeResolver.this.c.getReflectionTypes().getKClass();
            }
            JavaToKotlinClassMap javaToKotlin = JavaToKotlinClassMap.INSTANCE;
            TypeUsage howThisTypeIsUsedEffectively = Intrinsics.areEqual((Object)this.attr.getFlexibility(), (Object)JavaTypeFlexibility.FLEXIBLE_LOWER_BOUND) ? TypeUsage.MEMBER_SIGNATURE_COVARIANT : (Intrinsics.areEqual((Object)this.attr.getFlexibility(), (Object)JavaTypeFlexibility.FLEXIBLE_UPPER_BOUND) ? TypeUsage.MEMBER_SIGNATURE_CONTRAVARIANT : (javaToKotlin.mapPlatformClass(fqName2).isEmpty() ? this.attr.getHowThisTypeIsUsed() : this.attr.getHowThisTypeIsUsedAccordingToAnnotations()));
            ClassDescriptor classDescriptor = javaToKotlin.mapJavaToKotlin(fqName2);
            if (classDescriptor == null) {
                return null;
            }
            ClassDescriptor kotlinDescriptor = classDescriptor;
            if ((Intrinsics.areEqual((Object)howThisTypeIsUsedEffectively, (Object)TypeUsage.MEMBER_SIGNATURE_COVARIANT) || Intrinsics.areEqual((Object)howThisTypeIsUsedEffectively, (Object)TypeUsage.SUPERTYPE)) && javaToKotlin.isReadOnly(kotlinDescriptor)) {
                return javaToKotlin.convertReadOnlyToMutable(kotlinDescriptor);
            }
            return kotlinDescriptor;
        }

        private final boolean isConstructorTypeParameter() {
            JavaClassifier classifier2 = (JavaClassifier)this.classifier.invoke();
            return classifier2 instanceof JavaTypeParameter && ((JavaTypeParameter)classifier2).getOwner() instanceof JavaConstructor;
        }

        private final KotlinType getConstructorTypeParameterSubstitute() {
            HashSet<KotlinType> supertypesJet = new HashSet<KotlinType>();
            Object r = this.classifier.invoke();
            if (r == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.load.java.structure.JavaTypeParameter");
            }
            for (JavaClassifierType supertype : ((JavaTypeParameter)r).getUpperBounds()) {
                JavaType javaType2 = supertype;
                Intrinsics.checkExpressionValueIsNotNull(javaType2, "supertype");
                supertypesJet.add(LazyJavaTypeResolver.this.transformJavaType(javaType2, LazyJavaTypeResolverKt.toAttributes$default(TypeUsage.UPPER_BOUND, false, false, null, 7)));
            }
            if (supertypesJet.isEmpty()) {
                KotlinType kotlinType = LazyJavaTypeResolver.this.c.getModule().getBuiltIns().getNullableAnyType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "c.module.builtIns.nullableAnyType");
                return kotlinType;
            }
            KotlinType kotlinType = TypeIntersector.intersectTypes(KotlinTypeChecker.DEFAULT, (Set<KotlinType>)supertypesJet);
            if (kotlinType == null) {
                kotlinType = ErrorUtils.createErrorType("Can't intersect upper bounds of " + this.javaType.getPresentableText());
            }
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "TypeIntersector.intersec\u2026ype.getPresentableText())");
            return kotlinType;
        }

        private final boolean isRaw() {
            if (this.javaType.isRaw()) {
                return true;
            }
            return this.javaType.getTypeArguments().isEmpty() && !this.getConstructor().getParameters().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected List<TypeProjection> computeArguments() {
            void destination;
            void $receiver;
            TypeConstructor typeConstructor2 = this.getConstructor();
            List<TypeParameterDescriptor> typeParameters = typeConstructor2.getParameters();
            if (this.isRaw()) {
                void destination2;
                void $receiver2;
                Iterable $receiver3 = typeParameters;
                Iterable iterable = $receiver3;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver3, 10));
                for (Object item : $receiver2) {
                    void parameter;
                    TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item;
                    void var9_20 = destination2;
                    KotlinType erasedUpperBound = LazyJavaTypeResolverKt.getErasedUpperBound((TypeParameterDescriptor)parameter, this.attr.getUpperBoundOfTypeParameter(), (Function0<? extends KotlinType>)new Function0<KotlinType>(this){
                        final /* synthetic */ LazyJavaClassifierType this$0;

                        public final KotlinType invoke() {
                            ClassifierDescriptor classifierDescriptor = this.this$0.getConstructor().getDeclarationDescriptor();
                            if (classifierDescriptor == null) {
                                Intrinsics.throwNpe();
                            }
                            return LazyJavaTypeResolverKt.access$replaceArgumentsWithStarProjections(classifierDescriptor.getDefaultType());
                        }
                        {
                            this.this$0 = lazyJavaClassifierType;
                            super(0);
                        }
                    });
                    void v0 = parameter;
                    Intrinsics.checkExpressionValueIsNotNull(v0, "parameter");
                    TypeProjection typeProjection = RawSubstitution.INSTANCE.computeProjection((TypeParameterDescriptor)v0, this.attr, erasedUpperBound);
                    var9_20.add(typeProjection);
                }
                return (List)destination2;
            }
            if (this.isConstructorTypeParameter()) {
                List<TypeProjection> list = this.getConstructorTypeParameterSubstitute().getArguments();
                Intrinsics.checkExpressionValueIsNotNull(list, "getConstructorTypeParame\u2026bstitute().getArguments()");
                return list;
            }
            Object $receiver4 = typeParameters;
            int n = $receiver4.size();
            $receiver4 = this.javaType.getTypeArguments();
            int n2 = n;
            int n3 = $receiver4.size();
            if (n2 != n3) {
                void $receiver5;
                $receiver4 = typeParameters;
                Object $i$f$size = $receiver4;
                Collection destination2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver4, 10));
                for (Object item : $receiver5) {
                    void p;
                    TypeParameterDescriptor parameter = (TypeParameterDescriptor)item;
                    Collection collection = destination2;
                    TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(ErrorUtils.createErrorType(p.getName().asString()));
                    collection.add(typeProjectionImpl);
                }
                return (List)destination2;
            }
            $receiver4 = new Ref.ObjectRef();
            ((Ref.ObjectRef)$receiver4).element = Intrinsics.areEqual((Object)this.attr.getHowThisTypeIsUsed(), (Object)TypeUsage.SUPERTYPE) ? TypeUsage.SUPERTYPE_ARGUMENT : TypeUsage.TYPE_ARGUMENT;
            Iterable $receiver5 = CollectionsKt.withIndex((Iterable)this.javaType.getTypeArguments());
            Iterable destination3 = $receiver5;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver5, 10));
            for (Object item : $receiver) {
                void howTheProjectionIsUsed;
                void t;
                void $receiver6;
                void i;
                void javaTypeParameter;
                IndexedValue $i$a$2 = (IndexedValue)item;
                void var9_23 = destination;
                Object $i$f$mapTo = javaTypeParameter;
                int $i$f$map = $i$f$mapTo.component1();
                JavaType $i$f$map2 = (JavaType)$i$f$mapTo.component2();
                $i$f$mapTo = null;
                Collection collection2 = typeParameters;
                void var16_34 = i;
                int n4 = $receiver6.size();
                TypeParameterDescriptor parameter = var16_34 >= n4 ? ErrorUtils.createErrorTypeParameter((int)i, "#" + (int)i + " for " + typeConstructor2) : typeParameters.get((int)i);
                void v3 = t;
                Intrinsics.checkExpressionValueIsNotNull(v3, "t");
                JavaTypeAttributes javaTypeAttributes = LazyJavaTypeResolverKt.toAttributes$default((TypeUsage)((Object)howTheProjectionIsUsed.element), false, false, null, 7);
                TypeParameterDescriptor typeParameterDescriptor = parameter;
                Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "parameter");
                TypeProjection typeProjection = this.transformToTypeProjection((JavaType)v3, javaTypeAttributes, typeParameterDescriptor);
                var9_23.add(typeProjection);
            }
            return CollectionsKt.toList((List)destination);
        }

        private final TypeProjection transformToTypeProjection(JavaType javaType2, JavaTypeAttributes attr, TypeParameterDescriptor typeParameter) {
            JavaType bound;
            JavaType javaType3 = javaType2;
            return javaType3 instanceof JavaWildcardType ? ((bound = ((JavaWildcardType)javaType2).getBound()) == null ? LazyJavaTypeResolverKt.makeStarProjection(typeParameter, attr) : TypeUtilsKt.createProjection(LazyJavaTypeResolver.this.transformJavaType(bound, LazyJavaTypeResolverKt.toAttributes$default(TypeUsage.UPPER_BOUND, false, false, null, 7)), ((JavaWildcardType)javaType2).isExtends() ? Variance.OUT_VARIANCE : Variance.IN_VARIANCE, typeParameter)) : (TypeProjection)new TypeProjectionImpl(Variance.INVARIANT, LazyJavaTypeResolver.this.transformJavaType(javaType2, attr));
        }

        @Override
        @NotNull
        public TypeCapabilities getCapabilities() {
            return this.isRaw() ? (TypeCapabilities)RawTypeCapabilities.INSTANCE : (TypeCapabilities)TypeCapabilities.NONE.INSTANCE;
        }

        @Override
        public boolean isMarkedNullable() {
            return (Boolean)this.nullable.invoke();
        }

        @Override
        @NotNull
        public CompositeAnnotations getAnnotations() {
            return this.annotations;
        }

        public LazyJavaClassifierType(@NotNull JavaClassifierType javaType2, @NotNull JavaTypeAttributes attr) {
            Intrinsics.checkParameterIsNotNull(javaType2, "javaType");
            Intrinsics.checkParameterIsNotNull(attr, "attr");
            super(LazyJavaTypeResolver.this.c.getStorageManager());
            this.javaType = javaType2;
            this.attr = attr;
            this.annotations = new CompositeAnnotations(CollectionsKt.listOf(new LazyJavaAnnotations(LazyJavaTypeResolver.this.c, this.javaType), this.attr.getTypeAnnotations()));
            this.classifier = LazyJavaTypeResolver.this.c.getStorageManager().createNullableLazyValue((Function0)new Function0<JavaClassifier>(this){
                final /* synthetic */ LazyJavaClassifierType this$0;

                @Nullable
                public final JavaClassifier invoke() {
                    return LazyJavaClassifierType.access$getJavaType$p(this.this$0).getClassifier();
                }
                {
                    this.this$0 = lazyJavaClassifierType;
                    super(0);
                }
            });
            this.nullable = LazyJavaTypeResolver.this.c.getStorageManager().createLazyValue((Function0)new Function0<Boolean>(this){
                final /* synthetic */ LazyJavaClassifierType this$0;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean invoke() {
                    JavaTypeFlexibility javaTypeFlexibility = LazyJavaClassifierType.access$getAttr$p(this.this$0).getFlexibility();
                    if (Intrinsics.areEqual((Object)((Object)javaTypeFlexibility), (Object)((Object)JavaTypeFlexibility.FLEXIBLE_LOWER_BOUND))) {
                        return false;
                    }
                    if (Intrinsics.areEqual((Object)((Object)javaTypeFlexibility), (Object)((Object)JavaTypeFlexibility.FLEXIBLE_UPPER_BOUND))) {
                        return true;
                    }
                    if (LazyJavaClassifierType.access$getAttr$p(this.this$0).isMarkedNotNull()) return false;
                    JavaClassifier javaClassifier = (JavaClassifier)LazyJavaClassifierType.access$getClassifier$p(this.this$0).invoke();
                    if (!(javaClassifier instanceof JavaTypeParameter ? (LazyJavaClassifierType.access$isConstructorTypeParameter(this.this$0) ? LazyJavaClassifierType.access$getConstructorTypeParameterSubstitute(this.this$0).isMarkedNullable() : SetsKt.setOf(TypeUsage.TYPE_ARGUMENT, TypeUsage.UPPER_BOUND, TypeUsage.SUPERTYPE_ARGUMENT, TypeUsage.SUPERTYPE).contains((Object)((Object)LazyJavaClassifierType.access$getAttr$p(this.this$0).getHowThisTypeIsUsed())) ^ true) : (javaClassifier instanceof JavaClass || Intrinsics.areEqual(javaClassifier, null) ? SetsKt.setOf(TypeUsage.TYPE_ARGUMENT, TypeUsage.SUPERTYPE_ARGUMENT, TypeUsage.SUPERTYPE).contains((Object)((Object)LazyJavaClassifierType.access$getAttr$p(this.this$0).getHowThisTypeIsUsed())) ^ true : (Boolean)((Object)PreconditionsKt.error("Unknown classifier: " + (JavaClassifier)LazyJavaClassifierType.access$getClassifier$p(this.this$0).invoke()))))) return false;
                    return true;
                }
                {
                    this.this$0 = lazyJavaClassifierType;
                    super(0);
                }
            });
        }

        public static final /* synthetic */ boolean access$isConstructorTypeParameter(LazyJavaClassifierType $this) {
            return $this.isConstructorTypeParameter();
        }

        @NotNull
        public static final /* synthetic */ KotlinType access$getConstructorTypeParameterSubstitute(LazyJavaClassifierType $this) {
            return $this.getConstructorTypeParameterSubstitute();
        }

        @NotNull
        public static final /* synthetic */ JavaClassifierType access$getJavaType$p(LazyJavaClassifierType $this) {
            return $this.javaType;
        }

        @NotNull
        public static final /* synthetic */ NullableLazyValue<JavaClassifier> access$getClassifier$p(LazyJavaClassifierType $this) {
            return $this.classifier;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"3\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0005!1-\u0001\u0007\u00013\u0005A\n!(\u0001\u000bC\u000f!\u0011!U\u0002\u0002\u0011\u0005)C\u0002b\u0002\t\b5\t\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001\u0007\u0003\u001a\u0007!)Q\"\u0001\r\u0005Ko!1\u0002c\u0003\u000e\u00051\u0005AEB\t\u0005\t\u0001Aa!F\u0001\u0019\u000ee1\u0001bB\u0007\u0005\u0013\tI\u0011\u0001\n\u0004\u0019\u0010e\u0019\u0001\u0002C\u0007\u00021\u0011I2\u0001#\u0005\u000e\u0003aI\u0011kA\u0001\t\u0014%RAa\u0013\u0005\t\u00045\t\u0001D\u0001\u000f,#\u000e\u0019QB\u0001C\u0003\u0011\r\u0001"}, strings={"Lorg/jetbrains/kotlin/load/java/lazy/types/LazyJavaTypeResolver$FlexibleJavaClassifierTypeCapabilities;", "Lorg/jetbrains/kotlin/types/FlexibleTypeCapabilities;", "()V", "id", "", "getId", "()Ljava/lang/String;", "create", "Lorg/jetbrains/kotlin/types/KotlinType;", "lowerBound", "upperBound", "getCapability", "T", "Lorg/jetbrains/kotlin/types/TypeCapability;", "capabilityClass", "Ljava/lang/Class;", "jetType", "flexibility", "Lorg/jetbrains/kotlin/types/Flexibility;", "(Ljava/lang/Class;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/Flexibility;)Lorg/jetbrains/kotlin/types/TypeCapability;", "Impl"}, moduleName="kotlin-compiler")
    public static final class FlexibleJavaClassifierTypeCapabilities
    implements FlexibleTypeCapabilities {
        public static final FlexibleJavaClassifierTypeCapabilities INSTANCE;
        public static final FlexibleJavaClassifierTypeCapabilities INSTANCE$;

        @JvmStatic
        @NotNull
        public static final KotlinType create(@NotNull KotlinType lowerBound, @NotNull KotlinType upperBound) {
            Intrinsics.checkParameterIsNotNull(lowerBound, "lowerBound");
            Intrinsics.checkParameterIsNotNull(upperBound, "upperBound");
            return DelegatingFlexibleType.Companion.create(lowerBound, upperBound, INSTANCE);
        }

        @Override
        @NotNull
        public String getId() {
            return "kotlin.jvm.PlatformType";
        }

        @Override
        @Nullable
        public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass, @NotNull KotlinType jetType, @NotNull Flexibility flexibility) {
            Intrinsics.checkParameterIsNotNull(capabilityClass, "capabilityClass");
            Intrinsics.checkParameterIsNotNull(jetType, "jetType");
            Intrinsics.checkParameterIsNotNull(flexibility, "flexibility");
            Class<T> clazz = capabilityClass;
            return (T)(Intrinsics.areEqual(clazz, CustomTypeVariable.class) || Intrinsics.areEqual(clazz, Specificity.class) ? (TypeCapability)new Impl(flexibility) : (TypeCapability)null);
        }

        static {
            new FlexibleJavaClassifierTypeCapabilities();
        }

        private FlexibleJavaClassifierTypeCapabilities() {
            INSTANCE = this;
            INSTANCE$ = this;
        }

        @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\t)\u0011\u0001c\u0003\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tAQA\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0005\u00031\u0001\u0011$\u0001M\u00013\u0005A\u0012!)\u0004\n\u0007!\rQ\"\u0001\r\u0003#\u000e\t\u0001RA\u0013\t\t-A)\"D\u0001\u0019\u0017e\u0019\u0001rC\u0007\u00021\u0019)\u0003\u0002B\u0006\t\u00195\t\u0001DB\r\u0004\u00113i\u0011\u0001\u0007\u0004*\u0015\u0011\u0019\u0005\u0002c\u0001\u000e\u0003a\u0011\u0011k\u0001\u0003\u0006\u00015\u0011Aa\u0001E\u0004S)!1\n\u0003\u0005\u0005\u001b\u0005AJ!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0003\t\u000b%RA!\u0011\u0005\t\f5\t\u0001D\u0002\u000f\"#\u000e\u0019QB\u0001C\u0007\u0011\u001dI3\u0002B&\t\u0011\u001fi!\u0001$\u0001\u0019\u0011E\u001bA!\u0002\u0001\u000e\u0005\u0011E\u0001\"C\u0015\u000b\t\u0005C\u00012C\u0007\u00021\u0019a\u0012%U\u0002\u0004\u001b\t!!\u0002C\u0004"}, strings={"Lorg/jetbrains/kotlin/load/java/lazy/types/LazyJavaTypeResolver$FlexibleJavaClassifierTypeCapabilities$Impl;", "Lorg/jetbrains/kotlin/types/CustomTypeVariable;", "Lorg/jetbrains/kotlin/types/Specificity;", "flexibility", "Lorg/jetbrains/kotlin/types/Flexibility;", "(Lorg/jetbrains/kotlin/types/Flexibility;)V", "getFlexibility", "()Lorg/jetbrains/kotlin/types/Flexibility;", "isTypeVariable", "", "()Z", "lowerBound", "Lorg/jetbrains/kotlin/types/KotlinType;", "getLowerBound", "()Lorg/jetbrains/kotlin/types/KotlinType;", "typeParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "getTypeParameterDescriptor", "()Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "upperBound", "getUpperBound", "getSpecificityRelationTo", "Lorg/jetbrains/kotlin/types/Specificity$Relation;", "otherType", "substitutionResult", "replacement"}, moduleName="kotlin-compiler")
        private static final class Impl
        implements CustomTypeVariable,
        Specificity {
            private final boolean isTypeVariable;
            @Nullable
            private final TypeParameterDescriptor typeParameterDescriptor;
            @NotNull
            private final Flexibility flexibility;

            private final KotlinType getLowerBound() {
                return this.flexibility.getLowerBound();
            }

            private final KotlinType getUpperBound() {
                return this.flexibility.getUpperBound();
            }

            @Override
            public boolean isTypeVariable() {
                return this.isTypeVariable;
            }

            @Override
            @Nullable
            public TypeParameterDescriptor getTypeParameterDescriptor() {
                return this.typeParameterDescriptor;
            }

            @Override
            @NotNull
            public KotlinType substitutionResult(@NotNull KotlinType replacement) {
                KotlinType kotlinType;
                Intrinsics.checkParameterIsNotNull(replacement, "replacement");
                if (FlexibleTypesKt.isFlexible(replacement)) {
                    kotlinType = replacement;
                } else {
                    KotlinType kotlinType2 = TypeUtils.makeNullable(replacement);
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "TypeUtils.makeNullable(replacement)");
                    kotlinType = FlexibleJavaClassifierTypeCapabilities.create(replacement, kotlinType2);
                }
                return kotlinType;
            }

            @Override
            @NotNull
            public Specificity.Relation getSpecificityRelationTo(@NotNull KotlinType otherType) {
                Intrinsics.checkParameterIsNotNull(otherType, "otherType");
                if (!KotlinBuiltIns.isPrimitiveType(otherType) || !KotlinBuiltIns.isPrimitiveType(this.getLowerBound())) {
                    return Specificity.Relation.DONT_KNOW;
                }
                if (FlexibleTypesKt.isFlexible(otherType)) {
                    return Specificity.Relation.DONT_KNOW;
                }
                if (otherType.isMarkedNullable()) {
                    return Specificity.Relation.DONT_KNOW;
                }
                return Specificity.Relation.LESS_SPECIFIC;
            }

            @NotNull
            public final Flexibility getFlexibility() {
                return this.flexibility;
            }

            public Impl(@NotNull Flexibility flexibility) {
                TypeParameterDescriptor typeParameterDescriptor;
                Intrinsics.checkParameterIsNotNull(flexibility, "flexibility");
                this.flexibility = flexibility;
                boolean bl = this.isTypeVariable = Intrinsics.areEqual(this.getLowerBound().getConstructor(), this.getUpperBound().getConstructor()) && this.getLowerBound().getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor;
                if (this.isTypeVariable()) {
                    ClassifierDescriptor classifierDescriptor = this.getLowerBound().getConstructor().getDeclarationDescriptor();
                    if (classifierDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.TypeParameterDescriptor");
                    }
                    typeParameterDescriptor = (TypeParameterDescriptor)classifierDescriptor;
                } else {
                    typeParameterDescriptor = null;
                }
                this.typeParameterDescriptor = typeParameterDescriptor;
            }
        }
    }
}

