/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.resolvedCallUtil;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt$WhenMappings;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ThisReceiver;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u001d\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\t\u00012B\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u00045E\u0001\u0002A\u0007\u00021\u0003)2!C\u0001\u0005\u0004a\tAka\u0001\u000e\u0012!\u0011Q\"\u0001M\u0001+\rI\u0011\u0001b\u0001\u0019\u0003Q\u001b\u0019!\u0004\b\t\u00065\t\u0001dA\u000b\u0004\u0013\u0005!\u0019\u0001G\u0001\u001a\n!\u001dQ\"\u0001\r\u0005!\u000e\u0005Aka\u0001\u000e\u001d!%Q\"\u0001\r\u0004+\rI\u0011\u0001b\u0001\u0019\u0003e%\u0001rA\u0007\u00021\u0011\u00016\u0011\u0001+\u0004\u00045QB!\u0001E\u0005\u001b\u0005A2!F\u0002\n\u0003\u0011\r\u0001$AM\u0005\u0011\u000fi\u0011\u0001\u0007\u0003Q\u0007\u0003IJ\u0001C\u0003\u000e\u0003a\u0019\u0001kA\u0001\u001a\n!-Q\"\u0001\r\u0004!\u000e\rAka\u0001"}, strings={"getExplicitReceiverValue", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "ResolvedCallUtilKt", "getImplicitReceiverValue", "hasImplicitThisOrSuperDispatchReceiver", "", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "hasThisOrNoDispatchReceiver", "returnForNoReceiver", "considerExplicitReceivers"}, moduleName="kotlin-compiler")
public final class ResolvedCallUtilKt {
    public static final boolean hasThisOrNoDispatchReceiver(ResolvedCall<?> $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return ResolvedCallUtilKt.hasThisOrNoDispatchReceiver($receiver, context, true, true);
    }

    public static final boolean hasImplicitThisOrSuperDispatchReceiver(ResolvedCall<?> $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return ResolvedCallUtilKt.hasThisOrNoDispatchReceiver($receiver, context, false, false);
    }

    private static final boolean hasThisOrNoDispatchReceiver(ResolvedCall<?> $receiver, BindingContext context, boolean returnForNoReceiver, boolean considerExplicitReceivers) {
        KtExpression expression;
        ReceiverValue dispatchReceiverValue = $receiver.getDispatchReceiver();
        if ($receiver.getResultingDescriptor().getDispatchReceiverParameter() == null || !dispatchReceiverValue.exists()) {
            return returnForNoReceiver;
        }
        DeclarationDescriptor dispatchReceiverDescriptor = null;
        if (dispatchReceiverValue instanceof ThisReceiver) {
            dispatchReceiverDescriptor = ((ThisReceiver)dispatchReceiverValue).getDeclarationDescriptor();
        } else if (dispatchReceiverValue instanceof ExpressionReceiver && considerExplicitReceivers && (expression = KtPsiUtil.deparenthesize(((ExpressionReceiver)dispatchReceiverValue).getExpression())) instanceof KtThisExpression) {
            dispatchReceiverDescriptor = (DeclarationDescriptor)context.get(BindingContext.REFERENCE_TARGET, ((KtThisExpression)expression).getInstanceReference());
        }
        return Intrinsics.areEqual(dispatchReceiverDescriptor, DescriptorUtilsKt.getOwnerForEffectiveDispatchReceiverParameter($receiver.getResultingDescriptor()));
    }

    @NotNull
    public static final ReceiverValue getExplicitReceiverValue(ResolvedCall<?> $receiver) {
        ReceiverValue receiverValue;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        switch (ResolvedCallUtilKt$WhenMappings.$EnumSwitchMapping$0[$receiver.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                ReceiverValue receiverValue2 = $receiver.getDispatchReceiver();
                receiverValue = receiverValue2;
                Intrinsics.checkExpressionValueIsNotNull(receiverValue2, "getDispatchReceiver()");
                break;
            }
            case 2: 
            case 3: {
                ReceiverValue receiverValue3 = $receiver.getExtensionReceiver();
                receiverValue = receiverValue3;
                Intrinsics.checkExpressionValueIsNotNull(receiverValue3, "getExtensionReceiver()");
                break;
            }
            default: {
                ReceiverValue receiverValue4 = ReceiverValue.NO_RECEIVER;
                receiverValue = receiverValue4;
                Intrinsics.checkExpressionValueIsNotNull(receiverValue4, "ReceiverValue.NO_RECEIVER");
            }
        }
        Intrinsics.checkExpressionValueIsNotNull(receiverValue, "when (getExplicitReceive\u2026erValue.NO_RECEIVER\n    }");
        return receiverValue;
    }

    @NotNull
    public static final ReceiverValue getImplicitReceiverValue(ResolvedCall<?> $receiver) {
        ReceiverValue receiverValue;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        switch (ResolvedCallUtilKt$WhenMappings.$EnumSwitchMapping$1[$receiver.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                if ($receiver.getExtensionReceiver().exists()) {
                    receiverValue = $receiver.getExtensionReceiver();
                    break;
                }
                receiverValue = $receiver.getDispatchReceiver();
                break;
            }
            case 2: {
                ReceiverValue receiverValue2 = $receiver.getExtensionReceiver();
                receiverValue = receiverValue2;
                Intrinsics.checkExpressionValueIsNotNull(receiverValue2, "extensionReceiver");
                break;
            }
            case 3: {
                ReceiverValue receiverValue3 = $receiver.getDispatchReceiver();
                receiverValue = receiverValue3;
                Intrinsics.checkExpressionValueIsNotNull(receiverValue3, "dispatchReceiver");
                break;
            }
            default: {
                ReceiverValue receiverValue4 = ReceiverValue.NO_RECEIVER;
                receiverValue = receiverValue4;
                Intrinsics.checkExpressionValueIsNotNull(receiverValue4, "ReceiverValue.NO_RECEIVER");
            }
        }
        Intrinsics.checkExpressionValueIsNotNull(receiverValue, "when (getExplicitReceive\u2026erValue.NO_RECEIVER\n    }");
        return receiverValue;
    }
}

