/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstUtilKt;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.BinaryOperationKey;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorVisitor;
import org.jetbrains.kotlin.resolve.constants.evaluate.OperationsMapGeneratedKt;
import org.jetbrains.kotlin.resolve.constants.evaluate.UnaryOperationKey;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"l\u0004)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\t\u0007)\u0011\u0001c\u0003\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001\u0003\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001#\u0003\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!!!B\u0001\t\u000f\u0015\tA\u0011B\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\u0001R\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ\u0013\u0001\u0004\u0005\u00031\u0001\u0011DC\u0005\u0006\u0013\u0011I\u0011\u0001b\u0001\r\u0002a\t\u0011BA\u0005\u00021\u0007A\n!(\u0001/C+I1\u0001\u0003\u0002\u000e\u0003a\u0015\u0011b\u0001\u0005\u0004\u001b\u0005A:!U\u0002\u0002\u0011\u0011)\u0003\u0002B\u0001\t\u000f5\t\u0001tB\r\u0004\u0011!i\u0011\u0001'\u0005&)\u0011\t\u0001\"C\u0007\u0005\u0013\u0005!\u0019\u0001$\u0001\u0019\u0003e!\u00012C\u0007\u0003\u0019\u0003A\"\"G\u0002\t\u00165\t\u0001dC\r\u0004\u0011/i\u0011\u0001g\u0001&+\u0011\t\u0001\u0002D\u0007\u0005\u0013\u0005!\u0019\u0001$\u0001\u0019\u0003e!\u00012C\u0007\u0003\u0019\u0003A\"\"\u0007\u0003\t\u00185\u0011A\u0012\u0001M\u00023\rA)\"D\u0001\u0019\u0017\u0015\u001aB!\u0001E\r\u001b\u0011I\u0011\u0001b\u0001\r\u0002a\t\u0011d\u0001E\n\u001b\u0005AR\"G\u0002\t\u00165\t\u0001dC\r\u0004\u0011/i\u0011\u0001g\u0001&'\u0011\t\u00012D\u0007\u0003\u0019\u0003Ab\"G\u0002\t\u00115\t\u0001\u0014C\r\u0004\u0011;i\u0011\u0001g\u0001\u001a\u000b!yQbA\u0005\u0002\t\u0007Az\"J\u0007\u0005\u0003!\u0001RB\u0001G\u000119I2\u0001#\t\u000e\u0003a\t\u0012d\u0001E\u0012\u001b\u0005A\"#J\b\u0005\u0003!\u0015RB\u0001G\u000119IR\u0001C\n\u000e\u0007%\tA1\u0001M\u00143\rA\u0001\"D\u0001\u0019\u0012\u0015z\u0001\u0002F\u0007\u0005\u0013\u0005!\u0019\u0001$\u0001\u0019\u0003e\u0019\u0001\u0002C\u0007\u00021#IB\u0001c\u0006\u000e\u00051\u0005\u00014A\u0013\u0016\t\u0005AI#\u0004\u0002\r\u0002aQ\u0011d\u0001\u0005\u0016\u001b\u0005Ab\"G\u0002\t$5\t\u0001DD\r\u0004\u0011Wi\u0011\u0001\u0007\f\u001a\u0007!5R\"\u0001M\tKQ!\u0011\u0001C\f\u000e\t%\tA1\u0001G\u00011\u0005I2\u0001#\f\u000e\u0003aE\u0011d\u0001E\u0018\u001b\u0005A\n\"\u0007\u0003\t\u00185\u0011A\u0012\u0001M\u0002KE!\u0011\u0001\u0003\r\u000e\u00051\u0005\u0001DC\r\u0004\u0011Ui\u0011\u0001\u0007\b\u001a\u0007!-R\"\u0001\r\u00173\rAi#D\u0001\u0019\u0012\u0015jA!\u0001E\u0019\u001b\u0019I1\u0001\"\u0001\n\u0003aQA\u0012\u0001M\u00103\rA\u0011$D\u0001\u0019\u0004\u0015jA!\u0001E\u001a\u001b\u0005Az!G\u0002\t,5\t\u0001DF\r\u0005\u0011Gi!\u0001$\u0001\u0019\u0015\u0015BA!\u0001\u0005\u001b\u001b\u0005Az!G\u0002\t65\t\u0001dG\u0013\t\t\u0005A9$D\u0001\u0019\u0010e\u0019\u0001\u0002C\u0007\u00021#)C\u0003B\u0001\t951\u0011\u0002B\u0005\u0004\u0013\u0005!\u0019\u0001G\u0001\u0019:e1\u0001\"H\u0007\u0005\u0013\tI\u0011\u0001g\u000f\u0019:e\u0019\u0001rC\u0007\u00021\u0007)\u0003\u0002B\u0001\t=5\t\u0001tB\r\u0004\u0011!i\u0011\u0001'\u0005&\u0011\u0011\t\u0001RH\u0007\u00021\u001fI2\u0001\u0003\u0005\u000e\u0003aEQ\u0005\u0005\u0003\f\u0011}iA!C\u0001\u0005\u00041\u0005\u0001$A\r\u0004\u0011!i\u0011\u0001g\u0010\u001a\t!]QB\u0001G\u00011\u0007)\u0003\u0003B\u0006\tA5!\u0011\"\u0001C\u0002\u0019\u0003A\u0012!G\u0002\t\u00115\t\u0001\u0014I\r\u0005\u0011/i!\u0001$\u0001\u0019\u0004\u0015\u0002Ba\u0003\u0005\"\u001b\u0011I\u0011\u0001b\u0001\r\u0002a\t\u0011d\u0001\u0005\t\u001b\u0005A\u001a%\u0007\u0003\t\u00185\u0011A\u0012\u0001M\u0002KA!1\u0002\u0003\u0012\u000e\t%\tA1\u0001G\u00011\u0005I2\u0001\u0003\u0005\u000e\u0003a\u0015\u0013\u0004\u0002E\f\u001b\ta\t\u0001g\u0001&!\u0011Y\u0001bI\u0007\u0005\u0013\u0005!\u0019\u0001$\u0001\u0019\u0003e\u0019\u0001\u0002C\u0007\u00021\u000fJB\u0001c\u0006\u000e\u00051\u0005\u00014A\u0013\u0011\t-AA%\u0004\u0003\n\u0003\u0011\rA\u0012\u0001\r\u00023\rAI%D\u0001\u0019Ke!\u0001rC\u0007\u0003\u0019\u0003A\u001a!\n\t\u0005\u0017!-S\u0002B\u0005\u0002\t\u0007a\t\u0001G\u0001\u001a\u0007!AQ\"\u0001\r'3\u0011A9\"\u0004\u0002\r\u0002a\rQ\u0005\u0005\u0003\f\u0011\u001bjA!C\u0001\u0005\u00041\u0005\u0001$A\r\u0004\u0011!i\u0011\u0001G\u0014\u001a\t!]QB\u0001G\u00011\u0007)\u0003\u0003B\u0006\tP5!\u0011\"\u0001C\u0002\u0019\u0003A\u0012!G\u0002\t\u00115\t\u0001\u0004K\r\u0005\u0011/i!\u0001$\u0001\u0019\u0004\u0015\u0002Ba\u0003E)\u001b\u0011I\u0011\u0001b\u0001\r\u0002a\t\u0011d\u0001\u0005\t\u001b\u0005A\u0012&\u0007\u0003\t\u00185\u0011A\u0012\u0001M\u0002KA!1\u0002c\u0015\u000e\t%\tA1\u0001G\u00011\u0005I2\u0001\u0003\u0005\u000e\u0003aQ\u0013\u0004\u0002E\f\u001b\ta\t\u0001g\u0001&!\u0011Y\u0001RK\u0007\u0005\u0013\u0005!\u0019\u0001$\u0001\u0019\u0003e\u0019\u0001\u0002C\u0007\u00021-JB\u0001c\u0006\u000e\u00051\u0005\u00014A\u0013*\t\u0005A9&\u0004\u0003\n\u0005%\tA\u0015\f\r-#\t!\u0001\u0001#\u0017\u0016\t%\u0011\u0011\"\u0001S-15JZ\u0001B\u0001\t\u000f5\t\u0001t\u0002)\u0004\u0002e-A!\u0001E.\u001b\u0005Az\u0001U\u0002\u00023\u0017!\u0011\u0001#\u0010\u000e\u0003a=\u0001ka\u0001\u001a\f\u0011\t\u0001BH\u0007\u00021\u001f\u00016AAS\u0015\t\u0005A9&\u0004\u0003\n\u0005%\tA\u0015\f\r-#\t!\u0001\u0001#\u0017\u0016\t%\u0011\u0011\"\u0001S-15JJ\u0001#\u0006\u000e\u0003aY\u0001k!\u0001*\u000f\u0011\t\u0005\u0002\u0003\u0002\u000e\u0003a\u0015\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\n5\t\u0001$B)\u0004\u0003\u0015\u0001\u0011\u0006\u0003\u0003B\u0011!-Q\"\u0001\r\u0007#\u000e\u0011Q!\u0001E\u0007S\u001d!\u0011\t\u0003\u0005\u0004\u001b\u0005A:!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "Lorg/jetbrains/kotlin/types/KotlinType;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "factory", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValueFactory;", "stringExpressionEvaluator", "org/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$stringExpressionEvaluator$1", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$stringExpressionEvaluator$1;", "canBeUsedInAnnotation", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "createCompileTimeConstant", "value", "", "parameters", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "expectedType", "createConstant", "createIntegerCompileTimeConstant", "", "createOperationArgument", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$OperationArgument;", "expressionType", "compileTimeType", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "createOperationArgumentForFirstParameter", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "createOperationArgumentForReceiver", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "evaluate", "evaluateBinaryAndCheck", "receiver", "name", "", "callExpression", "evaluateCall", "receiverExpression", "evaluateUnaryAndCheck", "getCompileTimeType", "c", "isDivisionByZero", "isPropertyCompileTimeConstant", "descriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "isPureConstant", "resolveArguments", "", "valueArguments", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "usesNonConstValAsConstant", "usesVariableAsConstant", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitBinaryWithTypeRHSExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitClassLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;", "visitConstantExpression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "visitJetElement", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "visitLabeledExpression", "Lorg/jetbrains/kotlin/psi/KtLabeledExpression;", "visitParenthesizedExpression", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "visitQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitStringTemplateExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "wrap", "Lorg/jetbrains/kotlin/resolve/constants/TypedCompileTimeConstant;", "T", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "isPure", "OperationArgument"}, moduleName="kotlin-compiler")
public final class ConstantExpressionEvaluatorVisitor
extends KtVisitor<CompileTimeConstant<?>, KotlinType> {
    private final ConstantValueFactory factory;
    private final stringExpressionEvaluator.1 stringExpressionEvaluator;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    private final BindingTrace trace;

    @Nullable
    public final CompileTimeConstant<?> evaluate(@NotNull KtExpression expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        BindingContext bindingContext2 = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "trace.getBindingContext()");
        CompileTimeConstant<?> recordedCompileTimeConstant = ConstantExpressionEvaluator.Companion.getPossiblyErrorConstant(expression, bindingContext2);
        if (recordedCompileTimeConstant != null) {
            return recordedCompileTimeConstant;
        }
        KtVisitor ktVisitor = this;
        KotlinType kotlinType = expectedType;
        if (kotlinType == null) {
            KotlinType kotlinType2 = TypeUtils.NO_EXPECTED_TYPE;
            kotlinType = kotlinType2;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "TypeUtils.NO_EXPECTED_TYPE");
        }
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)expression.accept(ktVisitor, kotlinType);
        if (compileTimeConstant != null) {
            this.trace.record(BindingContext.COMPILE_TIME_VALUE, expression, compileTimeConstant);
            return compileTimeConstant;
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitConstantExpression(@NotNull KtConstantExpression expression, @Nullable KotlinType expectedType) {
        Object object;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        String string = expression.getText();
        if (string == null) {
            return null;
        }
        String text = string;
        IElementType nodeElementType = expression.getNode().getElementType();
        if (Intrinsics.areEqual(nodeElementType, KtNodeTypes.NULL)) {
            return ConstantExpressionEvaluatorVisitor.wrap$default(this, this.factory.createNullValue(), false, false, false, false, 15);
        }
        IElementType iElementType = nodeElementType;
        if (Intrinsics.areEqual(iElementType, KtNodeTypes.INTEGER_CONSTANT)) {
            object = ConstantExpressionEvaluatorKt.parseLong(text);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.FLOAT_CONSTANT)) {
            object = ConstantExpressionEvaluatorKt.access$parseFloatingLiteral(text);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.BOOLEAN_CONSTANT)) {
            object = ConstantExpressionEvaluatorKt.access$parseBoolean(text);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.CHARACTER_CONSTANT)) {
            object = CompileTimeConstantChecker.parseChar(expression);
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported constant: " + expression);
        }
        if (object == null) {
            return null;
        }
        Long result2 = object;
        Function0<Boolean> isLongWithSuffix$ = new Function0<Boolean>(nodeElementType, text){
            final /* synthetic */ IElementType $nodeElementType;
            final /* synthetic */ String $text;

            public final boolean invoke() {
                return Intrinsics.areEqual(this.$nodeElementType, KtNodeTypes.INTEGER_CONSTANT) && ConstantExpressionEvaluatorKt.access$hasLongSuffix(this.$text);
            }
            {
                this.$nodeElementType = iElementType;
                this.$text = string;
                super(0);
            }
        };
        return this.createConstant(result2, expectedType, new CompileTimeConstant.Parameters(true, !isLongWithSuffix$.invoke(), false, false));
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtExpression deparenthesizedExpression = KtPsiUtil.deparenthesize(expression);
        if (deparenthesizedExpression != null && Intrinsics.areEqual(deparenthesizedExpression, expression) ^ true) {
            return this.evaluate(deparenthesizedExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitLabeledExpression(@NotNull KtLabeledExpression expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtExpression baseExpression = expression.getBaseExpression();
        if (baseExpression != null) {
            return this.evaluate(baseExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression, @Nullable KotlinType expectedType) {
        CompileTimeConstant<?> compileTimeConstant;
        int n;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        StringBuilder sb = new StringBuilder();
        boolean interupted = false;
        boolean canBeUsedInAnnotation = true;
        int usesVariableAsConstant = 0;
        boolean usesNonConstantVariableAsConstant = false;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = expression.getEntries();
        for (n = 0; n < ktStringTemplateEntryArray.length; ++n) {
            KtStringTemplateEntry entry;
            KtStringTemplateEntry ktStringTemplateEntry = entry = ktStringTemplateEntryArray[n];
            Intrinsics.checkExpressionValueIsNotNull(ktStringTemplateEntry, "entry");
            TypedCompileTimeConstant<String> constant = this.stringExpressionEvaluator.evaluate(ktStringTemplateEntry);
            if (constant == null) {
                interupted = true;
                break;
            }
            if (!constant.getCanBeUsedInAnnotations()) {
                canBeUsedInAnnotation = false;
            }
            if (constant.getUsesVariableAsConstant()) {
                usesVariableAsConstant = 1;
            }
            if (constant.getUsesNonConstValAsConstant()) {
                usesNonConstantVariableAsConstant = true;
            }
            sb.append(constant.getConstantValue().getValue());
        }
        if (!interupted) {
            boolean bl = usesNonConstantVariableAsConstant;
            n = usesVariableAsConstant;
            boolean bl2 = canBeUsedInAnnotation;
            boolean bl3 = false;
            compileTimeConstant = this.createConstant(sb.toString(), expectedType, new CompileTimeConstant.Parameters(bl2, bl3, n != 0, bl));
        } else {
            compileTimeConstant = null;
        }
        return compileTimeConstant;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtExpression ktExpression = expression.getLeft();
        Intrinsics.checkExpressionValueIsNotNull(ktExpression, "expression.getLeft()");
        return this.evaluate(ktExpression, expectedType);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public CompileTimeConstant<?> visitBinaryExpression(@NotNull KtBinaryExpression expression, @Nullable KotlinType expectedType) {
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtExpression ktExpression = expression.getLeft();
        if (ktExpression == null) {
            return null;
        }
        KtExpression leftExpression = ktExpression;
        IElementType operationToken = expression.getOperationToken();
        Map map2 = OperatorConventions.BOOLEAN_OPERATIONS;
        void var6_6 = $receiver2;
        void v1 = $receiver;
        if (v1 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Map<kotlin.Any?, *>");
        }
        if (((Map)v1).containsKey(operationToken)) {
            boolean bl;
            KtExpression rightExpression;
            KotlinType booleanType = this.constantExpressionEvaluator.getBuiltIns$kotlin_compiler().getBooleanType();
            KtExpression ktExpression2 = leftExpression;
            Intrinsics.checkExpressionValueIsNotNull(ktExpression2, "leftExpression");
            CompileTimeConstant<?> leftConstant = this.evaluate(ktExpression2, booleanType);
            if (leftConstant == null) {
                return null;
            }
            KtExpression ktExpression3 = expression.getRight();
            if (ktExpression3 == null) {
                return null;
            }
            KtExpression ktExpression4 = rightExpression = ktExpression3;
            Intrinsics.checkExpressionValueIsNotNull(ktExpression4, "rightExpression");
            CompileTimeConstant<?> compileTimeConstant = this.evaluate(ktExpression4, booleanType);
            if (compileTimeConstant == null) {
                return null;
            }
            CompileTimeConstant<?> rightConstant = compileTimeConstant;
            KotlinType kotlinType = booleanType;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "booleanType");
            Object leftValue = leftConstant.getValue(kotlinType);
            KotlinType kotlinType2 = booleanType;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "booleanType");
            Object rightValue = rightConstant.getValue(kotlinType2);
            if (!(leftValue instanceof Boolean) || !(rightValue instanceof Boolean)) {
                return null;
            }
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual(iElementType, KtTokens.ANDAND)) {
                bl = ((Boolean)leftValue).booleanValue() && ((Boolean)rightValue).booleanValue();
            } else if (Intrinsics.areEqual(iElementType, KtTokens.OROR)) {
                bl = ((Boolean)leftValue).booleanValue() || ((Boolean)rightValue).booleanValue();
            } else {
                throw (Throwable)new IllegalArgumentException("Unknown boolean operation token " + operationToken);
            }
            boolean result2 = bl;
            return this.createConstant(result2, expectedType, new CompileTimeConstant.Parameters(true, false, leftConstant.getUsesVariableAsConstant() || rightConstant.getUsesVariableAsConstant(), leftConstant.getUsesNonConstValAsConstant() || rightConstant.getUsesNonConstValAsConstant()));
        }
        KtExpression ktExpression5 = expression.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull(ktExpression5, "expression.getOperationReference()");
        KtExpression ktExpression6 = leftExpression;
        Intrinsics.checkExpressionValueIsNotNull(ktExpression6, "leftExpression");
        return this.evaluateCall(ktExpression5, ktExpression6, expectedType);
    }

    /*
     * WARNING - void declaration
     */
    private final CompileTimeConstant<?> evaluateCall(KtExpression callExpression, KtExpression receiverExpression, KotlinType expectedType) {
        ValueParameterDescriptor $receiver;
        KtElement ktElement = callExpression;
        BindingContext bindingContext2 = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "trace.getBindingContext()");
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(ktElement, bindingContext2);
        if (resolvedCall == null) {
            return null;
        }
        Name resultingDescriptorName = resolvedCall.getResultingDescriptor().getName();
        OperationArgument argumentForReceiver = this.createOperationArgumentForReceiver(resolvedCall, receiverExpression);
        if (argumentForReceiver == null) {
            return null;
        }
        Set<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> argumentsEntrySet = CollectionsKt.mutableEntrySet(resolvedCall.getValueArguments());
        if (argumentsEntrySet.isEmpty()) {
            String string = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "resultingDescriptorName.asString()");
            Object result2 = this.evaluateUnaryAndCheck(argumentForReceiver, string, callExpression);
            if (result2 == null) {
                return null;
            }
            boolean isArgumentPure = this.isPureConstant(argumentForReceiver.getExpression());
            boolean canBeUsedInAnnotation = this.canBeUsedInAnnotation(argumentForReceiver.getExpression());
            boolean usesVariableAsConstant = this.usesVariableAsConstant(argumentForReceiver.getExpression());
            boolean usesNonConstValAsConstant = this.usesNonConstValAsConstant(argumentForReceiver.getExpression());
            boolean isNumberConversionMethod = OperatorConventions.NUMBER_CONVERSIONS.contains(resultingDescriptorName);
            return this.createConstant(result2, expectedType, new CompileTimeConstant.Parameters(canBeUsedInAnnotation, !isNumberConversionMethod && isArgumentPure, usesVariableAsConstant, usesNonConstValAsConstant));
        }
        Collection result2 = argumentsEntrySet;
        if ($receiver.size() == 1) {
            CompileTimeConstant compileTimeConstant;
            void parameter;
            void argument;
            Map.Entry $receiver2;
            Map.Entry canBeUsedInAnnotation;
            Map.Entry usesVariableAsConstant = canBeUsedInAnnotation = (Map.Entry)CollectionsKt.first((Iterable)argumentsEntrySet);
            $receiver = (ValueParameterDescriptor)$receiver2.getKey();
            $receiver2 = canBeUsedInAnnotation;
            ResolvedValueArgument $i$f$size = (ResolvedValueArgument)$receiver2.getValue();
            canBeUsedInAnnotation = null;
            void v3 = argument;
            Intrinsics.checkExpressionValueIsNotNull(v3, "argument");
            void v4 = parameter;
            Intrinsics.checkExpressionValueIsNotNull(v4, "parameter");
            OperationArgument argumentForParameter = this.createOperationArgumentForFirstParameter((ResolvedValueArgument)v3, (ValueParameterDescriptor)v4);
            if (argumentForParameter == null) {
                return null;
            }
            String string = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "resultingDescriptorName.asString()");
            if (this.isDivisionByZero(string, argumentForParameter.getValue())) {
                KtExpression ktExpression = PsiTreeUtil.getParentOfType((PsiElement)receiverExpression, KtExpression.class);
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                KtExpression parentExpression = ktExpression;
                this.trace.report(Errors.DIVISION_BY_ZERO.on((KtExpression)((PsiElement)parentExpression)));
                return ConstantExpressionEvaluatorVisitor.wrap$default(this, this.factory.createErrorValue("Division by zero"), false, false, false, false, 15);
            }
            String string2 = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "resultingDescriptorName.asString()");
            Object result3 = this.evaluateBinaryAndCheck(argumentForReceiver, argumentForParameter, string2, callExpression);
            if (result3 == null) {
                return null;
            }
            boolean areArgumentsPure = this.isPureConstant(argumentForReceiver.getExpression()) && this.isPureConstant(argumentForParameter.getExpression());
            boolean canBeUsedInAnnotation2 = this.canBeUsedInAnnotation(argumentForReceiver.getExpression()) && this.canBeUsedInAnnotation(argumentForParameter.getExpression());
            boolean usesVariableAsConstant2 = this.usesVariableAsConstant(argumentForReceiver.getExpression()) || this.usesVariableAsConstant(argumentForParameter.getExpression());
            boolean usesNonConstValAsConstant = this.usesNonConstValAsConstant(argumentForReceiver.getExpression()) || this.usesNonConstValAsConstant(argumentForParameter.getExpression());
            CompileTimeConstant.Parameters parameters2 = new CompileTimeConstant.Parameters(canBeUsedInAnnotation2, areArgumentsPure, usesVariableAsConstant2, usesNonConstValAsConstant);
            Name name = resultingDescriptorName;
            if (Intrinsics.areEqual(name, OperatorNameConventions.INSTANCE.getCOMPARE_TO())) {
                ConstantValue<?> constantValue = ConstantExpressionEvaluatorKt.access$createCompileTimeConstantForCompareTo(result3, callExpression, this.factory);
                compileTimeConstant = constantValue != null ? this.wrap(constantValue, parameters2) : null;
            } else if (Intrinsics.areEqual(name, OperatorNameConventions.INSTANCE.getEQUALS())) {
                ConstantValue<?> constantValue = ConstantExpressionEvaluatorKt.access$createCompileTimeConstantForEquals(result3, callExpression, this.factory);
                compileTimeConstant = constantValue != null ? this.wrap(constantValue, parameters2) : null;
            } else {
                compileTimeConstant = this.createConstant(result3, expectedType, parameters2);
            }
            return compileTimeConstant;
        }
        return null;
    }

    private final boolean usesVariableAsConstant(KtExpression expression) {
        BindingContext bindingContext2 = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "trace.getBindingContext()");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression, bindingContext2);
        return compileTimeConstant != null ? compileTimeConstant.getUsesVariableAsConstant() : false;
    }

    private final boolean usesNonConstValAsConstant(KtExpression expression) {
        BindingContext bindingContext2 = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "trace.bindingContext");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression, bindingContext2);
        return compileTimeConstant != null ? compileTimeConstant.getUsesNonConstValAsConstant() : false;
    }

    private final boolean canBeUsedInAnnotation(KtExpression expression) {
        BindingContext bindingContext2 = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "trace.getBindingContext()");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression, bindingContext2);
        return compileTimeConstant != null ? compileTimeConstant.getCanBeUsedInAnnotations() : false;
    }

    private final boolean isPureConstant(KtExpression expression) {
        BindingContext bindingContext2 = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "trace.getBindingContext()");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression, bindingContext2);
        return compileTimeConstant != null ? compileTimeConstant.isPure() : false;
    }

    /*
     * WARNING - void declaration
     */
    private final Object evaluateUnaryAndCheck(OperationArgument receiver, String name, KtExpression callExpression) {
        boolean value2;
        void check;
        void function;
        Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>> functions2 = OperationsMapGeneratedKt.getUnaryOperations().get(new UnaryOperationKey(receiver.getCtcType(), name));
        if (functions2 == null) {
            return null;
        }
        Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>> pair = functions2;
        Function1<? super Object, ? extends Object> function1 = pair.component1();
        Function1<? super Long, ? extends Long> function12 = pair.component2();
        pair = null;
        Object result2 = function.invoke(receiver.getValue());
        if (Intrinsics.areEqual(check, OperationsMapGeneratedKt.getEmptyUnaryFun())) {
            return result2;
        }
        boolean bl = ConstantExpressionEvaluatorKt.isIntegerType(receiver.getValue());
        if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
            String message = "Only integer constants should be checked for overflow";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        value2 = Intrinsics.areEqual(name, "minus") || Intrinsics.areEqual(name, "unaryMinus");
        if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
            String message = "Only negation should be checked for overflow";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        if (Intrinsics.areEqual(receiver.getValue(), result2)) {
            void $receiver;
            PsiElement value3 = callExpression;
            DiagnosticFactory0<KtExpression> diagnosticFactory0 = Errors.INTEGER_OVERFLOW;
            BindingTrace bindingTrace = this.trace;
            KtExpression ktExpression = PsiTreeUtil.getParentOfType((PsiElement)$receiver, KtExpression.class, true);
            KtExpression ktExpression2 = ktExpression;
            if (ktExpression2 == null) {
                ktExpression2 = callExpression;
            }
            bindingTrace.report(diagnosticFactory0.on((KtExpression)((PsiElement)ktExpression2)));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final Object evaluateBinaryAndCheck(OperationArgument receiver, OperationArgument parameter, String name, KtExpression callExpression) {
        void value2;
        void checker;
        Object var9_9;
        Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>> functions2 = OperationsMapGeneratedKt.getBinaryOperations().get(new BinaryOperationKey(receiver.getCtcType(), parameter.getCtcType(), name));
        if (functions2 == null) {
            return null;
        }
        Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>> pair = functions2;
        Function2<? super Object, ? super Object, ? extends Object> function2 = pair.component1();
        Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger> function22 = pair.component2();
        pair = null;
        try {
            void function;
            var9_9 = function.invoke(receiver.getValue(), parameter.getValue());
        }
        catch (Exception e) {
            var9_9 = null;
        }
        Object actualResult = var9_9;
        if (Intrinsics.areEqual(checker, OperationsMapGeneratedKt.getEmptyBinaryFun())) {
            return actualResult;
        }
        boolean bl = ConstantExpressionEvaluatorKt.isIntegerType(receiver.getValue()) && ConstantExpressionEvaluatorKt.isIntegerType(parameter.getValue());
        if (PreconditionsKt.getASSERTIONS_ENABLED() && value2 == false) {
            String message = "Only integer constants should be checked for overflow";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        evaluateBinaryAndCheck.2 toBigInteger$ = evaluateBinaryAndCheck.2.INSTANCE;
        Object object = toBigInteger$.invoke(receiver.getValue());
        Intrinsics.checkExpressionValueIsNotNull(object, "toBigInteger(receiver.value)");
        Object object2 = toBigInteger$.invoke(parameter.getValue());
        Intrinsics.checkExpressionValueIsNotNull(object2, "toBigInteger(parameter.value)");
        BigInteger resultInBigIntegers = (BigInteger)checker.invoke(object, object2);
        if (Intrinsics.areEqual(toBigInteger$.invoke((Object)actualResult), resultInBigIntegers) ^ true) {
            void $receiver;
            PsiElement $i$f$assert = callExpression;
            DiagnosticFactory0<KtExpression> diagnosticFactory0 = Errors.INTEGER_OVERFLOW;
            BindingTrace bindingTrace = this.trace;
            KtExpression ktExpression = PsiTreeUtil.getParentOfType((PsiElement)$receiver, KtExpression.class, true);
            KtExpression ktExpression2 = ktExpression;
            if (ktExpression2 == null) {
                ktExpression2 = callExpression;
            }
            bindingTrace.report(diagnosticFactory0.on((KtExpression)((PsiElement)ktExpression2)));
        }
        return actualResult;
    }

    private final boolean isDivisionByZero(String name, Object parameter) {
        Object v = OperatorConventions.BINARY_OPERATION_NAMES.get(KtTokens.DIV);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual(name, ((Name)v).asString())) {
            if (ConstantExpressionEvaluatorKt.isIntegerType(parameter)) {
                Object object = parameter;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
                }
                return ((Number)object).longValue() == (long)0;
            }
            if (parameter instanceof Float || parameter instanceof Double) {
                Object object = parameter;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
                }
                return ((Number)object).doubleValue() == 0.0;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitUnaryExpression(@NotNull KtUnaryExpression expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtExpression leftExpression = expression.getBaseExpression();
        if (leftExpression == null) {
            return null;
        }
        KtExpression ktExpression = expression.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull(ktExpression, "expression.getOperationReference()");
        return this.evaluateCall(ktExpression, leftExpression, expectedType);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression, @Nullable KotlinType expectedType) {
        CallableDescriptor callableDescriptor;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        DeclarationDescriptor enumDescriptor = (DeclarationDescriptor)this.trace.getBindingContext().get(BindingContext.REFERENCE_TARGET, expression);
        if (enumDescriptor != null && DescriptorUtils.isEnumEntry(enumDescriptor)) {
            DeclarationDescriptor declarationDescriptor = enumDescriptor;
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            return ConstantExpressionEvaluatorVisitor.wrap$default(this, this.factory.createEnumValue((ClassDescriptor)declarationDescriptor), false, false, false, false, 15);
        }
        KtElement ktElement = expression;
        BindingContext bindingContext2 = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "trace.getBindingContext()");
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(ktElement, bindingContext2);
        if (resolvedCall != null && (callableDescriptor = resolvedCall.getResultingDescriptor()) instanceof VariableDescriptor) {
            ConstantValue<?> constantValue = ((VariableDescriptor)callableDescriptor).getCompileTimeInitializer();
            if (constantValue == null) {
                return null;
            }
            ConstantValue<?> variableInitializer = constantValue;
            Object obj = variableInitializer.getValue();
            VariableDescriptor variableDescriptor = (VariableDescriptor)callableDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(variableDescriptor, "callableDescriptor");
            return this.createConstant(obj, expectedType, new CompileTimeConstant.Parameters(this.isPropertyCompileTimeConstant(variableDescriptor), false, true, !((VariableDescriptor)callableDescriptor).isConst()));
        }
        return null;
    }

    private final boolean isPropertyCompileTimeConstant(VariableDescriptor descriptor2) {
        if (descriptor2.isVar()) {
            return false;
        }
        if (DescriptorUtils.isObject(descriptor2.getContainingDeclaration()) || DescriptorUtils.isStaticDeclaration(descriptor2)) {
            return ConstUtilKt.canBeUsedForConstVal(descriptor2.getType());
        }
        return false;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitQualifiedExpression(@NotNull KtQualifiedExpression expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtExpression selectorExpression = expression.getSelectorExpression();
        if (selectorExpression instanceof KtCallExpression) {
            KtExpression receiverExpression;
            CompileTimeConstant<?> qualifiedCallValue = this.evaluate(selectorExpression, expectedType);
            if (qualifiedCallValue != null) {
                return qualifiedCallValue;
            }
            KtExpression calleeExpression = ((KtCallExpression)selectorExpression).getCalleeExpression();
            if (!(calleeExpression instanceof KtSimpleNameExpression)) {
                return null;
            }
            KtExpression ktExpression = receiverExpression = expression.getReceiverExpression();
            Intrinsics.checkExpressionValueIsNotNull(ktExpression, "receiverExpression");
            return this.evaluateCall(calleeExpression, ktExpression, expectedType);
        }
        if (selectorExpression instanceof KtSimpleNameExpression) {
            KtExpression ktExpression = expression.getReceiverExpression();
            Intrinsics.checkExpressionValueIsNotNull(ktExpression, "expression.receiverExpression");
            CompileTimeConstant<?> result2 = this.evaluateCall(selectorExpression, ktExpression, expectedType);
            if (result2 != null) {
                return result2;
            }
        }
        if (selectorExpression != null) {
            return this.evaluate(selectorExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitCallExpression(@NotNull KtCallExpression expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtElement ktElement = expression;
        BindingContext bindingContext2 = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "trace.getBindingContext()");
        ResolvedCall<? extends CallableDescriptor> call = CallUtilKt.getResolvedCall(ktElement, bindingContext2);
        if (call == null) {
            return null;
        }
        CallableDescriptor resultingDescriptor2 = call.getResultingDescriptor();
        if (CompileTimeConstantUtils.isArrayMethodCall(call)) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            ConstantExpressionEvaluatorVisitor constantExpressionEvaluatorVisitor;
            Object object;
            block11: {
                boolean bl5;
                CompileTimeConstant it2;
                List arguments2;
                Iterable $receiver;
                block10: {
                    Collection collection;
                    Collection destination;
                    Object it3;
                    Iterable $receiver2;
                    KotlinType kotlinType = CollectionsKt.first(resultingDescriptor2.getValueParameters()).getVarargElementType();
                    if (kotlinType == null) {
                        Intrinsics.throwNpe();
                    }
                    KotlinType varargType = kotlinType;
                    Iterable iterable = CollectionsKt.mutableValues(call.getValueArguments());
                    Iterator iterator2 = $receiver;
                    Collection collection2 = new ArrayList();
                    for (Object element : $receiver2) {
                        it3 = (ResolvedValueArgument)element;
                        List<ValueArgument> list = it3.getArguments();
                        Intrinsics.checkExpressionValueIsNotNull(list, "it.getArguments()");
                        KotlinType kotlinType2 = varargType;
                        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "varargType");
                        Iterable list2 = this.resolveArguments(list, kotlinType2);
                        CollectionsKt.addAll(destination, list2);
                    }
                    arguments2 = (List)destination;
                    $receiver = arguments2;
                    object = this.factory;
                    constantExpressionEvaluatorVisitor = this;
                    $receiver2 = $receiver;
                    destination = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver, 10));
                    for (Object item : $receiver2) {
                        it3 = (CompileTimeConstant)item;
                        collection = destination;
                        KotlinType kotlinType3 = varargType;
                        Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "varargType");
                        ConstantValue constantValue = it3.toConstantValue(kotlinType3);
                        collection.add(constantValue);
                    }
                    collection = (List)destination;
                    KotlinType kotlinType4 = resultingDescriptor2.getReturnType();
                    if (kotlinType4 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType4, "resultingDescriptor.getReturnType()!!");
                    $receiver = arguments2;
                    bl4 = false;
                    bl3 = false;
                    object = ((ConstantValueFactory)object).createArrayValue((List<? extends ConstantValue<?>>)collection, kotlinType4);
                    for (Object element : $receiver) {
                        it2 = (CompileTimeConstant)element;
                        if (!it2.getUsesVariableAsConstant()) continue;
                        bl5 = true;
                        break block10;
                    }
                    bl5 = false;
                }
                bl2 = bl5;
                $receiver = arguments2;
                for (Object element : $receiver) {
                    it2 = (CompileTimeConstant)element;
                    if (!it2.getUsesNonConstValAsConstant()) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
            boolean bl6 = bl;
            return ConstantExpressionEvaluatorVisitor.wrap$default(constantExpressionEvaluatorVisitor, (ConstantValue)object, bl3, bl4, bl2, bl6, 3);
        }
        if (resultingDescriptor2 instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor = ((ConstructorDescriptor)resultingDescriptor2).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "resultingDescriptor.getContainingDeclaration()");
            ClassDescriptor classDescriptor2 = classDescriptor;
            if (DescriptorUtils.isAnnotationClass(classDescriptor2)) {
                AnnotationDescriptorImpl descriptor2 = new AnnotationDescriptorImpl(classDescriptor2.getDefaultType(), this.constantExpressionEvaluator.resolveAnnotationArguments$kotlin_compiler(call, this.trace), SourceElement.NO_SOURCE);
                return ConstantExpressionEvaluatorVisitor.wrap$default(this, new AnnotationValue(descriptor2), false, false, false, false, 15);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression, @Nullable KotlinType expectedType) {
        KotlinType jetType;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KotlinType kotlinType = this.trace.getType(expression);
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        if ((jetType = kotlinType).isError()) {
            return null;
        }
        KotlinType kotlinType2 = jetType;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "jetType");
        return ConstantExpressionEvaluatorVisitor.wrap$default(this, new KClassValue(kotlinType2), false, false, false, false, 15);
    }

    private final List<CompileTimeConstant<?>> resolveArguments(List<? extends ValueArgument> valueArguments2, KotlinType expectedType) {
        ArrayList<CompileTimeConstant> constants = CollectionsKt.arrayListOf(new CompileTimeConstant[0]);
        for (ValueArgument valueArgument : valueArguments2) {
            CompileTimeConstant<?> compileTimeConstant;
            KtExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null || (compileTimeConstant = this.evaluate(argumentExpression, expectedType)) == null) continue;
            constants.add(compileTimeConstant);
        }
        return constants;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitJetElement(@NotNull KtElement element, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        return null;
    }

    private final OperationArgument createOperationArgumentForReceiver(ResolvedCall<?> resolvedCall, KtExpression expression) {
        KotlinType receiverExpressionType = ConstantExpressionEvaluatorKt.access$getReceiverExpressionType(resolvedCall);
        if (receiverExpressionType == null) {
            return null;
        }
        CompileTimeType<? extends Object> receiverCompileTimeType = this.getCompileTimeType(receiverExpressionType);
        if (receiverCompileTimeType == null) {
            return null;
        }
        return this.createOperationArgument(expression, receiverExpressionType, receiverCompileTimeType);
    }

    /*
     * WARNING - void declaration
     */
    private final OperationArgument createOperationArgumentForFirstParameter(ResolvedValueArgument argument, ValueParameterDescriptor parameter) {
        void $receiver;
        KotlinType kotlinType = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "parameter.getType()");
        CompileTimeType<? extends Object> argumentCompileTimeType = this.getCompileTimeType(kotlinType);
        if (argumentCompileTimeType == null) {
            return null;
        }
        List<ValueArgument> arguments2 = argument.getArguments();
        Collection collection = arguments2;
        if ($receiver.size() != 1) {
            return null;
        }
        KtExpression argumentExpression = CollectionsKt.first(arguments2).getArgumentExpression();
        if (argumentExpression == null) {
            return null;
        }
        KotlinType kotlinType2 = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "parameter.getType()");
        return this.createOperationArgument(argumentExpression, kotlinType2, argumentCompileTimeType);
    }

    private final CompileTimeType<? extends Object> getCompileTimeType(KotlinType c) {
        KotlinBuiltIns builtIns = this.constantExpressionEvaluator.getBuiltIns$kotlin_compiler();
        KotlinType kotlinType = TypeUtils.makeNotNullable(c);
        return Intrinsics.areEqual(kotlinType, builtIns.getIntType()) ? ConstantExpressionEvaluatorKt.getINT() : (Intrinsics.areEqual(kotlinType, builtIns.getByteType()) ? ConstantExpressionEvaluatorKt.getBYTE() : (Intrinsics.areEqual(kotlinType, builtIns.getShortType()) ? ConstantExpressionEvaluatorKt.getSHORT() : (Intrinsics.areEqual(kotlinType, builtIns.getLongType()) ? ConstantExpressionEvaluatorKt.getLONG() : (Intrinsics.areEqual(kotlinType, builtIns.getDoubleType()) ? ConstantExpressionEvaluatorKt.getDOUBLE() : (Intrinsics.areEqual(kotlinType, builtIns.getFloatType()) ? ConstantExpressionEvaluatorKt.getFLOAT() : (Intrinsics.areEqual(kotlinType, builtIns.getCharType()) ? ConstantExpressionEvaluatorKt.getCHAR() : (Intrinsics.areEqual(kotlinType, builtIns.getBooleanType()) ? ConstantExpressionEvaluatorKt.getBOOLEAN() : (Intrinsics.areEqual(kotlinType, builtIns.getStringType()) ? ConstantExpressionEvaluatorKt.getSTRING() : (Intrinsics.areEqual(kotlinType, builtIns.getAnyType()) ? ConstantExpressionEvaluatorKt.getANY() : (CompileTimeType)null)))))))));
    }

    private final OperationArgument createOperationArgument(KtExpression expression, KotlinType expressionType, CompileTimeType<?> compileTimeType) {
        CompileTimeConstant<?> compileTimeConstant = this.constantExpressionEvaluator.evaluateExpression(expression, this.trace, expressionType);
        if (compileTimeConstant == null) {
            return null;
        }
        CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
        Object obj = compileTimeConstant2.getValue(expressionType);
        if (obj == null) {
            return null;
        }
        Object evaluationResult = obj;
        return new OperationArgument(evaluationResult, compileTimeType, expression);
    }

    private final CompileTimeConstant<?> createConstant(Object value2, KotlinType expectedType, CompileTimeConstant.Parameters parameters2) {
        if (parameters2.isPure()) {
            KotlinType kotlinType = expectedType;
            if (kotlinType == null) {
                KotlinType kotlinType2 = TypeUtils.NO_EXPECTED_TYPE;
                kotlinType = kotlinType2;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "TypeUtils.NO_EXPECTED_TYPE");
            }
            return this.createCompileTimeConstant(value2, parameters2, kotlinType);
        }
        ConstantValue<?> constantValue = this.factory.createConstantValue(value2);
        return constantValue != null ? this.wrap(constantValue, parameters2) : null;
    }

    private final CompileTimeConstant<?> createCompileTimeConstant(Object value2, CompileTimeConstant.Parameters parameters2, KotlinType expectedType) {
        CompileTimeConstant compileTimeConstant;
        Object object = value2;
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
            Object object2 = value2;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
            }
            compileTimeConstant = this.createIntegerCompileTimeConstant(((Number)object2).longValue(), parameters2, expectedType);
        } else {
            ConstantValue<?> constantValue = this.factory.createConstantValue(value2);
            compileTimeConstant = constantValue != null ? this.wrap(constantValue, parameters2) : null;
        }
        return compileTimeConstant;
    }

    private final CompileTimeConstant<?> createIntegerCompileTimeConstant(long value2, CompileTimeConstant.Parameters parameters2, KotlinType expectedType) {
        if (TypeUtils.noExpectedType(expectedType) || expectedType.isError()) {
            return new IntegerValueTypeConstant(value2, this.constantExpressionEvaluator.getBuiltIns$kotlin_compiler(), parameters2);
        }
        ConstantValue<?> integerValue = this.factory.createIntegerConstantValue(value2, expectedType);
        if (integerValue != null) {
            return this.wrap(integerValue, parameters2);
        }
        long l = value2;
        return this.wrap(l == (long)((int)value2) ? (IntegerValueConstant)this.factory.createIntValue((int)value2) : (IntegerValueConstant)this.factory.createLongValue(value2), parameters2);
    }

    private final <T> TypedCompileTimeConstant<T> wrap(ConstantValue<? extends T> $receiver, CompileTimeConstant.Parameters parameters2) {
        return new TypedCompileTimeConstant<T>($receiver, parameters2);
    }

    private final <T> TypedCompileTimeConstant<T> wrap(ConstantValue<? extends T> $receiver, boolean canBeUsedInAnnotation, boolean isPure, boolean usesVariableAsConstant, boolean usesNonConstValAsConstant) {
        return this.wrap($receiver, new CompileTimeConstant.Parameters(canBeUsedInAnnotation, isPure, usesVariableAsConstant, usesNonConstValAsConstant));
    }

    static /* synthetic */ TypedCompileTimeConstant wrap$default(ConstantExpressionEvaluatorVisitor constantExpressionEvaluatorVisitor, ConstantValue constantValue, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) {
        if ((n & 1) != 0) {
            boolean bl5 = bl = !(constantValue instanceof NullValue);
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        if ((n & 8) != 0) {
            bl4 = false;
        }
        return constantExpressionEvaluatorVisitor.wrap(constantValue, bl, bl2, bl3, bl4);
    }

    public ConstantExpressionEvaluatorVisitor(@NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(constantExpressionEvaluator, "constantExpressionEvaluator");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.trace = trace;
        this.factory = this.constantExpressionEvaluator.getConstantValueFactory$kotlin_compiler();
        this.stringExpressionEvaluator = new KtVisitor(this){
            final /* synthetic */ ConstantExpressionEvaluatorVisitor this$0;

            private final TypedCompileTimeConstant<String> createStringConstant(CompileTimeConstant<?> compileTimeConstant) {
                ConstantValue<?> constantValue;
                KotlinType kotlinType = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "TypeUtils.NO_EXPECTED_TYPE");
                ConstantValue<?> constantValue2 = constantValue = compileTimeConstant.toConstantValue(kotlinType);
                if (constantValue2 instanceof ErrorValue || constantValue2 instanceof EnumValue) {
                    return null;
                }
                return ConstantExpressionEvaluatorVisitor.access$wrap(this.this$0, constantValue2 instanceof NullValue ? ConstantExpressionEvaluatorVisitor.access$getFactory$p(this.this$0).createStringValue("null") : ConstantExpressionEvaluatorVisitor.access$getFactory$p(this.this$0).createStringValue(String.valueOf(constantValue.getValue())), compileTimeConstant.getParameters());
            }

            @Nullable
            public final TypedCompileTimeConstant<String> evaluate(@NotNull KtStringTemplateEntry entry) {
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                return (TypedCompileTimeConstant)entry.accept(this, null);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public TypedCompileTimeConstant<String> visitStringTemplateEntryWithExpression(@NotNull KtStringTemplateEntryWithExpression entry, @Nullable Void data) {
                TypedCompileTimeConstant<String> typedCompileTimeConstant;
                KtExpression expression;
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                KtExpression ktExpression = entry.getExpression();
                if (ktExpression == null) {
                    return null;
                }
                KtExpression ktExpression2 = expression = ktExpression;
                Intrinsics.checkExpressionValueIsNotNull(ktExpression2, "expression");
                CompileTimeConstant<?> compileTimeConstant = this.this$0.evaluate(ktExpression2, ConstantExpressionEvaluatorVisitor.access$getConstantExpressionEvaluator$p(this.this$0).getBuiltIns$kotlin_compiler().getStringType());
                if (compileTimeConstant != null) {
                    void $receiver;
                    CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
                    CompileTimeConstant it2 = (CompileTimeConstant)$receiver;
                    typedCompileTimeConstant = stringExpressionEvaluator.1.access$createStringConstant(this, it2);
                } else {
                    typedCompileTimeConstant = null;
                }
                return typedCompileTimeConstant;
            }

            @NotNull
            public TypedCompileTimeConstant<String> visitLiteralStringTemplateEntry(@NotNull KtLiteralStringTemplateEntry entry, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                ConstantValueFactory constantValueFactory = ConstantExpressionEvaluatorVisitor.access$getFactory$p(this.this$0);
                String string = entry.getText();
                Intrinsics.checkExpressionValueIsNotNull(string, "entry.getText()");
                return ConstantExpressionEvaluatorVisitor.wrap$default(this.this$0, constantValueFactory.createStringValue(string), false, false, false, false, 15);
            }

            @NotNull
            public TypedCompileTimeConstant<String> visitEscapeStringTemplateEntry(@NotNull KtEscapeStringTemplateEntry entry, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                ConstantValueFactory constantValueFactory = ConstantExpressionEvaluatorVisitor.access$getFactory$p(this.this$0);
                String string = entry.getUnescapedValue();
                Intrinsics.checkExpressionValueIsNotNull(string, "entry.getUnescapedValue()");
                return ConstantExpressionEvaluatorVisitor.wrap$default(this.this$0, constantValueFactory.createStringValue(string), false, false, false, false, 15);
            }
            {
                this.this$0 = $outer;
            }

            @Nullable
            public static final /* synthetic */ TypedCompileTimeConstant<String> access$createStringConstant(stringExpressionEvaluator.1 $this, @NotNull CompileTimeConstant<?> compileTimeConstant) {
                return $this.createStringConstant(compileTimeConstant);
            }
        };
    }

    @NotNull
    public static final /* synthetic */ ConstantValueFactory access$getFactory$p(ConstantExpressionEvaluatorVisitor $this) {
        return $this.factory;
    }

    @NotNull
    public static final /* synthetic */ <T> TypedCompileTimeConstant<T> access$wrap(ConstantExpressionEvaluatorVisitor $this, ConstantValue<? extends T> $receiver, @NotNull CompileTimeConstant.Parameters parameters2) {
        return $this.wrap($receiver, parameters2);
    }

    @NotNull
    public static final /* synthetic */ <T> TypedCompileTimeConstant<T> access$wrap(ConstantExpressionEvaluatorVisitor $this, ConstantValue<? extends T> $receiver, boolean canBeUsedInAnnotation, boolean isPure, boolean usesVariableAsConstant, boolean usesNonConstValAsConstant) {
        return $this.wrap($receiver, canBeUsedInAnnotation, isPure, usesVariableAsConstant, usesNonConstValAsConstant);
    }

    @NotNull
    public static final /* synthetic */ ConstantExpressionEvaluator access$getConstantExpressionEvaluator$p(ConstantExpressionEvaluatorVisitor $this) {
        return $this.constantExpressionEvaluator;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001b\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0002\u0005\u00031\u0001\u0011$\u0001M\u0001CCI1\u0001C\u0001\u000e\u0003a\u0005\u0011\"\u0002E\u0002\u001b\rI\u0011\u0001b\u0001\u0019\u0005%\u0019\u0001RA\u0007\u00021\r\t6!\u0001E\u0004S1!1\t\u0003E\u0002\u001b\rI\u0011\u0001b\u0001\u0019\u0005E\u001bA!\u0002\u0001\u000e\u0005\u0011!\u0001\u0012B\u0015\u000b\t\rC\u0001RA\u0007\u00021\r\t6\u0001B\u0003\u0001\u001b\t!Q\u0001c\u0003*\u0015\u0011\u0019\u0005\u0002C\u0001\u000e\u0003a\u0005\u0011k\u0001\u0003\u0006\u00015\u0011AA\u0002E\u0007"}, strings={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$OperationArgument;", "", "value", "ctcType", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "getCtcType", "()Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "getValue", "()Ljava/lang/Object;"}, moduleName="kotlin-compiler")
    private static final class OperationArgument {
        @NotNull
        private final Object value;
        @NotNull
        private final CompileTimeType<?> ctcType;
        @NotNull
        private final KtExpression expression;

        @NotNull
        public final Object getValue() {
            return this.value;
        }

        @NotNull
        public final CompileTimeType<?> getCtcType() {
            return this.ctcType;
        }

        @NotNull
        public final KtExpression getExpression() {
            return this.expression;
        }

        public OperationArgument(@NotNull Object value2, @NotNull CompileTimeType<?> ctcType, @NotNull KtExpression expression) {
            Intrinsics.checkParameterIsNotNull(value2, "value");
            Intrinsics.checkParameterIsNotNull(ctcType, "ctcType");
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            this.value = value2;
            this.ctcType = ctcType;
            this.expression = expression;
        }
    }
}

