/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"+\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00011\u0001\u0011$\u0001M\u0001C\u000b\t6!\u0001\u0005\u0002KQ!1\u0002c\u0001\u000e\u0003a\u0011\u0011d\u0001E\u0003\u001b\u0005A2!G\u0002\t\b5\t\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001G\u0003\u001a\u0007!-Q\"\u0001\r\u0007KA!\u0011\u0001#\u0004\u000e\u0003a\u0011\u0011d\u0001E\u0003\u001b\u0005A2!G\u0002\t\b5\t\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001G\u0003"}, strings={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/PlatformStaticAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "checkDeclaration"}, moduleName="kotlin-compiler")
public final class PlatformStaticAnnotationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext2, "bindingContext");
        if (AnnotationUtilKt.hasPlatformStaticAnnotation(descriptor2) && (declaration instanceof KtNamedFunction || declaration instanceof KtProperty || declaration instanceof KtPropertyAccessor)) {
            this.checkDeclaration(declaration, descriptor2, diagnosticHolder);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDeclaration(KtDeclaration declaration, DeclarationDescriptor descriptor, DiagnosticSink diagnosticHolder) {
        container = descriptor.getContainingDeclaration();
        v0 = insideObject = container != null && DescriptorUtils.isNonCompanionObject(container) != false;
        if (container == null || !DescriptorUtils.isCompanionObject(container)) ** GOTO lbl-1000
        var6_6 = container.getContainingDeclaration();
        it = (DeclarationDescriptor)$receiver;
        if (DescriptorUtils.isClass(it) != false || DescriptorUtils.isEnumClass(it) != false) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = insideCompanionObjectInClass = false;
        }
        if (!insideObject && !insideCompanionObjectInClass) {
            diagnosticHolder.report(ErrorsJvm.JVM_STATIC_NOT_IN_OBJECT.on((KtDeclaration)((PsiElement)declaration)));
        }
        if ((var7_7 = declaration) instanceof KtPropertyAccessor) {
            v2 = ((KtPropertyAccessor)declaration).getParent();
            if (v2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
            }
            v3 = (KtProperty)v2;
        } else {
            v3 = checkDeclaration = declaration;
        }
        if (insideObject) {
            v4 = checkDeclaration.getModifierList();
            if (Intrinsics.areEqual(v4 != null ? Boolean.valueOf(v4.hasModifier(KtTokens.OVERRIDE_KEYWORD)) : null, true)) {
                diagnosticHolder.report(ErrorsJvm.OVERRIDE_CANNOT_BE_STATIC.on((KtDeclaration)((PsiElement)declaration)));
            }
        }
    }
}

