/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"m\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u001d)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!1!B\u0001\t\f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t\u0003\u0015\tAAA\u0003\u0002\u0011A)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001\u0003\u0003\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0002\t\u0011)\u0011\u0001D\u0001\u0006\u0003\u0011\u001dQ!\u0001\u0007\u0002\u000b\u0005!\u0011\u0001B2\u0002\u0019\u0001I\u0012\u0001'\u0001\"\b\u0011\t\u0011kA\u0001\t\u0003\u0015\u0002B!\u0001E\t\u001b\u0005A\u0012\"G\u0002\t\u00145\t\u0001DC\r\u0004\u0011+i\u0011\u0001G\u0002\u001a\u0007!YQ\"\u0001\r\u0003K1!\u0011\u0001c\u0006\u000e\u0003aa\u0011d\u0001E\r\u001b\u0005A\"\"G\u0002\t\u001b5\t\u0001dA\u0013\u0010\t\u000fAY\"D\u0001\u0019\u0019e1\u0001BD\u0007\u0005\u0013\tI\u0011\u0001G\u0002\u0019\u001ee\u0019\u0001\"D\u0007\u00021\r)C\u0002B\u0001\t\u001f5\t\u0001\u0004D\r\u0004\u0011?i\u0011\u0001\u0007\u0006\u001a\u0007!iQ\"\u0001\r\u0004KA!9\u0001\u0003\t\u000e\u00051\u0005\u0001\u0014E\r\u0007\u0011EiA!\u0003\u0002\n\u0003a\u0005\u0002TD\r\u0004\u0011Gi\u0011\u0001G\u0002&\u0013\u0011\u001d\u0001BE\u0007\u0003\u0019\u0003A2!G\u0002\t\u00145\t\u0001DC\u0013\n\t\u0005A)#\u0004\u0002\r\u0002a\u0019\u0012d\u0001E\n\u001b\u0005A\"\"J\u0005\u0005\u0003!\u001dRB\u0001G\u00011MI2\u0001c\u0005\u000e\u0003aQQ%\u0003\u0003\u0002\u0011Qi!\u0001$\u0001\u0019'e\u0019\u00012C\u0007\u00021))\u0013\u0002B\u0001\t*5\u0011A\u0012\u0001\r\u00163\rA\u0019\"D\u0001\u0019\u0015\u0015JA!\u0001E\u0016\u001b\ta\t\u0001G\u0002\u001a\u0007!1R\"\u0001\r\u0004K!!9\u0001#\f\u000e\u0003aI\u0011d\u0001E\n\u001b\u0005A\"\"\n\u0005\u0005\b!9R\"\u0001\r\n3\rA\u0019\"D\u0001\u0019\u0015\u0015BAq\u0001E\u0018\u001b\u0005A\u0012\"G\u0002\t\u00145\t\u0001DC\u0013\t\t\u000fA\u0001$D\u0001\u0019\u0013e\u0019\u00012C\u0007\u00021))S\u0003B\u0001\t25\t\u0001\u0004D\r\u0004\u00113i\u0011\u0001\u0007\u0006\u001a\u0019!IRBC\u0005\u0003\u0013\u0005A2!\u0003\u0002\n\u0003a\u0019\u0011BA\u0005\u000211A\u001a$\n\u000b\t55\t\u0001\u0004D\r\u0004\u0011?i\u0011\u0001\u0007\u0006\u001a\u0019!IRBC\u0005\u0003\u0013\u0005A2!\u0003\u0002\n\u0003a\u0019\u0011BA\u0005\u000211A\u001a$\n\u000b\t65\t\u0001\u0004D\r\u0004\u00113i\u0011\u0001\u0007\u0006\u001a\u0019!IRBC\u0005\u0003\u0013\u0005A2!\u0003\u0002\n\u0003a\u0019\u0011BA\u0005\u000211A\u001a$\n\r\u0005\b!YR\"\u0001\r\r3\u0019A9$\u0004\u0003\n\u0005%\t\u0001D\u0003M\u000f31A\u0011$\u0004\u0006\n\u0005%\t\u0001dA\u0005\u0003\u0013\u0005A2!\u0003\u0002\n\u0003aa\u00014G\u0013\u0016\t\u000fAA$D\u0001\u0019\u0019e\u0019\u0001\u0012H\u0007\u00021)IB\u0002C\r\u000e\u0015%\u0011\u0011\"\u0001\r\u0004\u0013\tI\u0011\u0001G\u0002\n\u0005%\t\u0001\u0004\u0004M\u001aK/!\u0011\u0001C\u000f\u000e\u0003a\u0019Q#\u0001M\u001e3\u0013Aa$D\u0001\u0019\u0007A\u001b\t!*\u000b\u0005\u0003!uR\"\u0001\r\r+\u0005A\"\"g\u0007\t35Q\u0011BA\u0005\u00021\rI!!C\u0001\u0019\u0007%\u0011\u0011\"\u0001\r\r1g\u00016\u0011A\u0015\b\t\u0005C\u00012A\u0007\u00021\t\t6!A\u0003\u0001S+!1\tS\u0001\t\u00065\t\u0001dA)\u0004\t\u0015\u0001QB\u0001C\u0004\u0011\u0011I\u001b\u0002B!\t\u0011\u0013i9\u0001G\u0003R\u0007\u0005!Y!U\u0002\u0002\u000b\u0001I{\u0001B!I\u0003!1Q\"\u0001\r\u0004#\u000e\tQ\u0001AU\b\t\u0005C\u0015\u0001#\u0004\u000e\u0003a\u0019\u0011kA\u0001\u0006\u0001%>A!\u0011%\u0002\u0011\u001di\u0011\u0001G\u0002R\u0007\u0005)\u0001!K\u0004\u0005\u0003rAy!D\u0001\u0019\u0007E\u001b\u0011!\u0002\u0001*\u000f\u0011\tE\u0004\u0003\u0005\u000e\u0003a\u0019\u0011kA\u0001\u0006\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/utils/LibraryUtils;", "", "()V", "KOTLIN_JS_MODULE_ATTRIBUTE_NAME", "Ljava/util/jar/Attributes$Name;", "KOTLIN_JS_MODULE_NAME", "", "getKOTLIN_JS_MODULE_NAME", "()Ljava/lang/String;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MANIFEST_PATH", "METAINF", "METAINF_RESOURCES", "TITLE_KOTLIN_JAVASCRIPT_LIB", "TITLE_KOTLIN_JAVASCRIPT_STDLIB", "checkAttributeValue", "", "library", "Ljava/io/File;", "expected", "attributeName", "copyJsFilesFromDirectory", "", "dir", "outputLibraryJsPath", "copyJsFilesFromLibraries", "libraries", "", "copyJsFilesFromZip", "file", "getJarFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "classesRoots", "jarName", "getKotlinJsModuleName", "getManifestFromDirectory", "Ljava/util/jar/Manifest;", "getManifestFromJar", "getManifestFromJarOrDirectory", "getManifestMainAttributesFromJarOrDirectory", "Ljava/util/jar/Attributes;", "getSuggestedPath", "path", "isKotlinJavascriptLibrary", "isKotlinJavascriptLibraryWithMetadata", "isKotlinJavascriptStdLibrary", "isOldKotlinJavascriptLibrary", "processDirectory", "action", "Lkotlin/Function2;", "traverseArchive", "traverseDirectory", "traverseJsLibraries", "libs", "traverseJsLibrary", "lib", "getPropertyOrFail", "Ljava/util/Properties;", "propName", "runIfFileExists"}, moduleName="kotlin-compiler")
public final class LibraryUtils {
    private static final Logger LOG;
    @NotNull
    public static final String KOTLIN_JS_MODULE_NAME = "Kotlin-JS-Module-Name";
    private static String TITLE_KOTLIN_JAVASCRIPT_STDLIB;
    private static String TITLE_KOTLIN_JAVASCRIPT_LIB;
    private static final String METAINF = "META-INF/";
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final String METAINF_RESOURCES = "META-INF/resources/";
    private static final Attributes.Name KOTLIN_JS_MODULE_ATTRIBUTE_NAME;
    public static final LibraryUtils INSTANCE;
    public static final LibraryUtils INSTANCE$;

    @NotNull
    public final String getKOTLIN_JS_MODULE_NAME() {
        return KOTLIN_JS_MODULE_NAME;
    }

    @JvmStatic
    @Nullable
    public static final VirtualFile getJarFile(@NotNull List<? extends VirtualFile> classesRoots, @NotNull String jarName) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull(classesRoots, "classesRoots");
            Intrinsics.checkParameterIsNotNull(jarName, "jarName");
            Iterable $receiver = classesRoots;
            for (Object element : $receiver) {
                VirtualFile it2 = (VirtualFile)element;
                if (!Intrinsics.areEqual(it2.getName(), jarName)) continue;
                v0 = element;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @JvmStatic
    @Nullable
    public static final String getKotlinJsModuleName(@NotNull File library) {
        Intrinsics.checkParameterIsNotNull(library, "library");
        Attributes attributes = INSTANCE.getManifestMainAttributesFromJarOrDirectory(library);
        return attributes != null ? attributes.getValue(KOTLIN_JS_MODULE_ATTRIBUTE_NAME) : null;
    }

    @JvmStatic
    public static final boolean isOldKotlinJavascriptLibrary(@NotNull File library) {
        Intrinsics.checkParameterIsNotNull(library, "library");
        Attributes.Name name = Attributes.Name.SPECIFICATION_TITLE;
        Intrinsics.checkExpressionValueIsNotNull(name, "Attributes.Name.SPECIFICATION_TITLE");
        return INSTANCE.checkAttributeValue(library, TITLE_KOTLIN_JAVASCRIPT_LIB, name) && LibraryUtils.getKotlinJsModuleName(library) != null;
    }

    @JvmStatic
    public static final boolean isKotlinJavascriptLibraryWithMetadata(@NotNull File library) {
        Intrinsics.checkParameterIsNotNull(library, "library");
        return CollectionsKt.isNotEmpty((Collection)KotlinJavascriptMetadataUtils.loadMetadata(library));
    }

    @JvmStatic
    public static final boolean isKotlinJavascriptLibrary(@NotNull File library) {
        Intrinsics.checkParameterIsNotNull(library, "library");
        return LibraryUtils.isOldKotlinJavascriptLibrary(library) || LibraryUtils.isKotlinJavascriptLibraryWithMetadata(library);
    }

    @JvmStatic
    public static final boolean isKotlinJavascriptStdLibrary(@NotNull File library) {
        Intrinsics.checkParameterIsNotNull(library, "library");
        Attributes.Name name = Attributes.Name.IMPLEMENTATION_TITLE;
        Intrinsics.checkExpressionValueIsNotNull(name, "Attributes.Name.IMPLEMENTATION_TITLE");
        return INSTANCE.checkAttributeValue(library, TITLE_KOTLIN_JAVASCRIPT_STDLIB, name);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void copyJsFilesFromLibraries(@NotNull List<? extends String> libraries, @NotNull String outputLibraryJsPath) {
        Intrinsics.checkParameterIsNotNull(libraries, "libraries");
        Intrinsics.checkParameterIsNotNull(outputLibraryJsPath, "outputLibraryJsPath");
        for (String string : libraries) {
            void value2;
            File file = new File(string);
            boolean bl = file.exists();
            if (PreconditionsKt.getASSERTIONS_ENABLED() && value2 == false) {
                String message = "Library " + string + " not found";
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            if (file.isDirectory()) {
                INSTANCE.copyJsFilesFromDirectory(file, outputLibraryJsPath);
                continue;
            }
            INSTANCE.copyJsFilesFromZip(file, outputLibraryJsPath);
        }
    }

    @JvmStatic
    public static final void traverseJsLibraries(@NotNull List<? extends File> libs, @NotNull Function2<? super String, ? super String, ? extends Unit> action) {
        Intrinsics.checkParameterIsNotNull(libs, "libs");
        Intrinsics.checkParameterIsNotNull(action, "action");
        Iterable $receiver = libs;
        for (Object element : $receiver) {
            File it2 = (File)element;
            LibraryUtils.traverseJsLibrary(it2, action);
        }
    }

    @JvmStatic
    public static final void traverseJsLibrary(@NotNull File lib, @NotNull Function2<? super String, ? super String, ? extends Unit> action) {
        Intrinsics.checkParameterIsNotNull(lib, "lib");
        Intrinsics.checkParameterIsNotNull(action, "action");
        if (lib.isDirectory()) {
            INSTANCE.traverseDirectory(lib, action);
        } else if (FileUtil.isJarOrZip(lib)) {
            INSTANCE.traverseArchive(lib, action);
        } else if (StringsKt.endsWith$default(lib.getName(), KotlinJavascriptMetadataUtils.INSTANCE.getJS_EXT(), false, 2)) {
            Unit unit;
            File jsFile;
            INSTANCE.runIfFileExists(lib, action);
            File file = jsFile = FileUtilsKt.withReplacedExtensionOrNull(lib, KotlinJavascriptMetadataUtils.INSTANCE.getMETA_JS_SUFFIX(), KotlinJavascriptMetadataUtils.INSTANCE.getJS_EXT());
            if (file != null) {
                INSTANCE.runIfFileExists(file, action);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        } else {
            throw (Throwable)new IllegalArgumentException("Unknown library format (directory, zip or js file expected): " + lib);
        }
    }

    private final void runIfFileExists(File $receiver, Function2<? super String, ? super String, ? extends Unit> action) {
        if ($receiver.isFile()) {
            String string = FileUtil.loadFile($receiver);
            Intrinsics.checkExpressionValueIsNotNull(string, "FileUtil.loadFile(this)");
            action.invoke(string, "");
        }
    }

    private final void copyJsFilesFromDirectory(File dir, String outputLibraryJsPath) {
        this.traverseDirectory(dir, (Function2<? super String, ? super String, ? extends Unit>)new Function2<String, String, Unit>(outputLibraryJsPath){
            final /* synthetic */ String $outputLibraryJsPath;

            public final void invoke(@NotNull String content, @NotNull String relativePath) {
                Intrinsics.checkParameterIsNotNull(content, "content");
                Intrinsics.checkParameterIsNotNull(relativePath, "relativePath");
                FileUtil.writeToFile(new File(this.$outputLibraryJsPath, relativePath), content);
            }
            {
                this.$outputLibraryJsPath = string;
                super(2);
            }
        });
    }

    private final void processDirectory(File dir, Function2<? super String, ? super String, ? extends Unit> action) {
        FileUtil.processFilesRecursively(dir, new Processor<File>(dir, action){
            final /* synthetic */ File $dir;
            final /* synthetic */ Function2 $action;

            public boolean process(@NotNull File file) {
                Intrinsics.checkParameterIsNotNull(file, "file");
                String string = FileUtil.getRelativePath(this.$dir, file);
                if (string == null) {
                    throw (Throwable)new IllegalArgumentException("relativePath should not be null " + this.$dir + " " + file);
                }
                String relativePath = string;
                if (file.isFile() && StringsKt.endsWith$default(relativePath, KotlinJavascriptMetadataUtils.INSTANCE.getJS_EXT(), false, 2)) {
                    String string2 = relativePath;
                    Intrinsics.checkExpressionValueIsNotNull(string2, "relativePath");
                    String suggestedRelativePath = LibraryUtils.access$getSuggestedPath(LibraryUtils.INSTANCE, string2);
                    if (suggestedRelativePath == null) {
                        return true;
                    }
                    String string3 = FileUtil.loadFile(file);
                    Intrinsics.checkExpressionValueIsNotNull(string3, "FileUtil.loadFile(file)");
                    this.$action.invoke(string3, suggestedRelativePath);
                }
                return true;
            }
            {
                this.$dir = $captured_local_variable$0;
                this.$action = $captured_local_variable$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final void traverseDirectory(@NotNull File dir, @NotNull Function2<? super String, ? super String, ? extends Unit> action) {
        Intrinsics.checkParameterIsNotNull(dir, "dir");
        Intrinsics.checkParameterIsNotNull(action, "action");
        try {
            this.processDirectory(dir, action);
        }
        catch (IOException ex) {
            void $receiver;
            Throwable throwable = ex;
            StringBuilder stringBuilder = new StringBuilder().append("Could not read files from directory ").append(dir.getName()).append(": ");
            Logger logger = LOG;
            String string = $receiver.getMessage();
            logger.error(stringBuilder.append(string).toString());
        }
    }

    private final void copyJsFilesFromZip(File file, String outputLibraryJsPath) {
        this.traverseArchive(file, (Function2<? super String, ? super String, ? extends Unit>)new Function2<String, String, Unit>(outputLibraryJsPath){
            final /* synthetic */ String $outputLibraryJsPath;

            public final void invoke(@NotNull String content, @NotNull String relativePath) {
                Intrinsics.checkParameterIsNotNull(content, "content");
                Intrinsics.checkParameterIsNotNull(relativePath, "relativePath");
                FileUtil.writeToFile(new File(this.$outputLibraryJsPath, relativePath), content);
            }
            {
                this.$outputLibraryJsPath = string;
                super(2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void traverseArchive(@NotNull File file, @NotNull Function2<? super String, ? super String, ? extends Unit> action) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        Intrinsics.checkParameterIsNotNull(action, "action");
        ZipFile zipFile = new ZipFile(file.getPath());
        try {
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                String content;
                ZipEntry entry = zipEntries.nextElement();
                String entryName = entry.getName();
                if (entry.isDirectory() || !StringsKt.endsWith$default(entryName, KotlinJavascriptMetadataUtils.INSTANCE.getJS_EXT(), false, 2)) continue;
                String string = entryName;
                Intrinsics.checkExpressionValueIsNotNull(string, "entryName");
                String relativePath = this.getSuggestedPath(string);
                if (relativePath == null) continue;
                InputStream stream = zipFile.getInputStream(entry);
                String string2 = content = FileUtil.loadTextAndClose(stream);
                Intrinsics.checkExpressionValueIsNotNull(string2, "content");
                action.invoke(string2, relativePath);
            }
        }
        catch (IOException ex) {
            void $receiver;
            Throwable entry = ex;
            StringBuilder stringBuilder = new StringBuilder().append("Could not extract files from archive ").append(file.getName()).append(": ");
            Logger logger = LOG;
            String string = $receiver.getMessage();
            logger.error(stringBuilder.append(string).toString());
        }
        finally {
            zipFile.close();
        }
    }

    private final String getSuggestedPath(String path) {
        String systemIndependentPath = FileUtil.toSystemIndependentName(path);
        if (StringsKt.startsWith$default(systemIndependentPath, METAINF, false, 2)) {
            if (StringsKt.startsWith$default(systemIndependentPath, METAINF_RESOURCES, false, 2)) {
                return StringsKt.substring(path, CollectionsKt.length(METAINF_RESOURCES));
            }
            return null;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Manifest getManifestFromJar(File library) {
        if (!library.canRead()) {
            return null;
        }
        try {
            JarFile jarFile = new JarFile(library);
            try {
                Manifest manifest = jarFile.getManifest();
                return manifest;
            }
            finally {
                jarFile.close();
            }
        }
        catch (IOException ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Manifest getManifestFromDirectory(File library) {
        if (!library.canRead() || !library.isDirectory()) {
            return null;
        }
        File manifestFile = new File(library, MANIFEST_PATH);
        if (!manifestFile.exists()) {
            return null;
        }
        try {
            FileInputStream inputStream = new FileInputStream(manifestFile);
            try {
                Manifest manifest = new Manifest(inputStream);
                return manifest;
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException ignored) {
            LOG.warn("IOException " + ignored);
            return null;
        }
    }

    private final Manifest getManifestFromJarOrDirectory(File library) {
        return library.isDirectory() ? this.getManifestFromDirectory(library) : this.getManifestFromJar(library);
    }

    private final Attributes getManifestMainAttributesFromJarOrDirectory(File library) {
        Manifest manifest = this.getManifestFromJarOrDirectory(library);
        return manifest != null ? manifest.getMainAttributes() : null;
    }

    private final boolean checkAttributeValue(File library, String expected, Attributes.Name attributeName) {
        Attributes attributes;
        Attributes attributes2 = attributes = this.getManifestMainAttributesFromJarOrDirectory(library);
        String value2 = attributes2 != null ? attributes2.getValue(attributeName) : null;
        return value2 != null && Intrinsics.areEqual(value2, expected);
    }

    private final String getPropertyOrFail(Properties $receiver, String propName) {
        String value2 = $receiver.getProperty(propName);
        if (value2 == null) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            $receiver.list(new PrintStream(bytes));
            LOG.error(propName + " not found." + "\n" + " " + bytes);
        }
        String string = value2;
        Intrinsics.checkExpressionValueIsNotNull(string, "value");
        return string;
    }

    static {
        new LibraryUtils();
    }

    private LibraryUtils() {
        INSTANCE = this;
        INSTANCE$ = this;
        LOG = Logger.getInstance(LibraryUtils.class);
        KOTLIN_JS_MODULE_NAME = KOTLIN_JS_MODULE_NAME;
        METAINF = METAINF;
        MANIFEST_PATH = METAINF + "MANIFEST.MF";
        METAINF_RESOURCES = METAINF + "resources/";
        KOTLIN_JS_MODULE_ATTRIBUTE_NAME = new Attributes.Name(KOTLIN_JS_MODULE_NAME);
        String jsStdLib = "";
        String jsLib = "";
        InputStream manifestProperties = LibraryUtils.class.getResourceAsStream("/kotlinManifest.properties");
        if (manifestProperties != null) {
            try {
                Properties properties2 = new Properties();
                properties2.load(manifestProperties);
                jsStdLib = this.getPropertyOrFail(properties2, "manifest.impl.title.kotlin.javascript.stdlib");
                jsLib = this.getPropertyOrFail(properties2, "manifest.spec.title.kotlin.javascript.lib");
            }
            catch (IOException e) {
                LOG.error(e);
            }
        } else {
            LOG.error("Resource 'kotlinManifest.properties' not found.");
        }
        TITLE_KOTLIN_JAVASCRIPT_STDLIB = jsStdLib;
        TITLE_KOTLIN_JAVASCRIPT_LIB = jsLib;
    }

    @Nullable
    public static final /* synthetic */ String access$getSuggestedPath(LibraryUtils $this, @NotNull String path) {
        return $this.getSuggestedPath(path);
    }
}

