/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import org.jetbrains.annotations.NotNull;

public abstract class AtomicNotNullLazyValue<T>
extends NotNullLazyValue<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("AtomicNotNullLazyValue");
    private volatile T myValue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public final T getValue() {
        T value2 = this.myValue;
        if (value2 != null) {
            T t = value2;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/AtomicNotNullLazyValue", "getValue"));
            }
            return t;
        }
        AtomicNotNullLazyValue atomicNotNullLazyValue = this;
        synchronized (atomicNotNullLazyValue) {
            value2 = this.myValue;
            if (value2 == null) {
                RecursionGuard.StackStamp stamp = ourGuard.markStack();
                value2 = this.compute();
                if (stamp.mayCacheNow()) {
                    this.myValue = value2;
                }
            }
        }
        T t = value2;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/AtomicNotNullLazyValue", "getValue"));
        }
        return t;
    }
}

