/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.relocated.gnu.trove.TObjectHashingStrategy;

class ConcurrentWeakKeyWeakValueHashMap<K, V>
extends ConcurrentWeakKeySoftValueHashMap<K, V> {
    ConcurrentWeakKeyWeakValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ConcurrentWeakKeyWeakValueHashMap", "<init>"));
        }
        super(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @Override
    @NotNull
    protected ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> createKeyReference(@NotNull K k, @NotNull V v) {
        if (k == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k", "com/intellij/util/containers/ConcurrentWeakKeyWeakValueHashMap", "createKeyReference"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "com/intellij/util/containers/ConcurrentWeakKeyWeakValueHashMap", "createKeyReference"));
        }
        ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> valueReference = this.createValueReference(v, this.myValueQueue);
        ConcurrentWeakKeySoftValueHashMap.WeakKey<K, V> keyReference = new ConcurrentWeakKeySoftValueHashMap.WeakKey<K, V>(k, valueReference, this.myHashingStrategy, this.myKeyQueue);
        if (valueReference instanceof WeakValue) {
            ((WeakValue)valueReference).myKeyReference = keyReference;
        }
        ConcurrentWeakKeySoftValueHashMap.WeakKey<K, V> weakKey = keyReference;
        if (weakKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentWeakKeyWeakValueHashMap", "createKeyReference"));
        }
        return weakKey;
    }

    @Override
    @NotNull
    protected ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> createValueReference(@NotNull V value2, @NotNull ReferenceQueue<V> queue) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentWeakKeyWeakValueHashMap", "createValueReference"));
        }
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/util/containers/ConcurrentWeakKeyWeakValueHashMap", "createValueReference"));
        }
        WeakValue weakValue = new WeakValue(value2, queue);
        if (weakValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentWeakKeyWeakValueHashMap", "createValueReference"));
        }
        return weakValue;
    }

    private static class WeakValue<K, V>
    extends WeakReference<V>
    implements ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> {
        @NotNull
        private volatile ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> myKeyReference;

        private WeakValue(@NotNull V value2, @NotNull ReferenceQueue<V> queue) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentWeakKeyWeakValueHashMap$WeakValue", "<init>"));
            }
            if (queue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/util/containers/ConcurrentWeakKeyWeakValueHashMap$WeakValue", "<init>"));
            }
            super(value2, queue);
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            Object v = this.get();
            Object thatV = ((ConcurrentWeakKeySoftValueHashMap.ValueReference)o).get();
            return v != null && thatV != null && v.equals(thatV);
        }

        @Override
        @NotNull
        public ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> getKeyReference() {
            ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> keyReference = this.myKeyReference;
            if (keyReference == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentWeakKeyWeakValueHashMap$WeakValue", "getKeyReference"));
            }
            return keyReference;
        }
    }
}

