/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.repl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.search.ProjectScope;
import java.io.File;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.DiagnosticMessageReporter;
import org.jetbrains.kotlin.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.config.ModuleNameKt;
import org.jetbrains.kotlin.cli.jvm.repl.DelegatePackageMemberDeclarationProvider;
import org.jetbrains.kotlin.cli.jvm.repl.EarlierLine;
import org.jetbrains.kotlin.cli.jvm.repl.ReplClassLoader;
import org.jetbrains.kotlin.cli.jvm.repl.di.ContainerForReplWithJava;
import org.jetbrains.kotlin.cli.jvm.repl.di.InjectionKt;
import org.jetbrains.kotlin.cli.jvm.repl.di.ReplLastLineScopeProvider;
import org.jetbrains.kotlin.cli.jvm.repl.messages.DiagnosticMessageHolder;
import org.jetbrains.kotlin.cli.jvm.repl.messages.ReplIdeDiagnosticMessageHolder;
import org.jetbrains.kotlin.cli.jvm.repl.messages.ReplSystemInWrapper;
import org.jetbrains.kotlin.cli.jvm.repl.messages.ReplTerminalDiagnosticMessageHolder;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.impl.CompositePackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.relocated.com.google.common.base.Throwables;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzerForTopLevel;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.jvm.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.CombinedPackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.org.objectweb.asm.Type;

public class ReplInterpreter {
    private int lineNumber;
    @Nullable
    private LexicalScope lastLineScope;
    private final List<EarlierLine> earlierLines;
    private final List<String> previousIncompleteLines;
    private final ReplClassLoader classLoader;
    private final PsiFileFactoryImpl psiFileFactory;
    private final BindingTraceContext trace;
    private final ModuleDescriptorImpl module;
    private final TopDownAnalysisContext topDownAnalysisContext;
    private final LazyTopDownAnalyzerForTopLevel topDownAnalyzer;
    private final ResolveSession resolveSession;
    private final ScriptMutableDeclarationProviderFactory scriptDeclarationFactory;
    private final boolean ideMode;
    private final ReplSystemInWrapper replReader;

    public ReplInterpreter(@NotNull Disposable disposable, @NotNull CompilerConfiguration configuration, boolean ideMode, @Nullable ReplSystemInWrapper replReader) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "<init>"));
        }
        this.lineNumber = 0;
        this.earlierLines = Lists.newArrayList();
        this.previousIncompleteLines = Lists.newArrayList();
        KotlinCoreEnvironment environment2 = KotlinCoreEnvironment.createForProduction(disposable, configuration, EnvironmentConfigFiles.JVM_CONFIG_FILES);
        Project project = environment2.getProject();
        this.psiFileFactory = (PsiFileFactoryImpl)PsiFileFactory.getInstance(project);
        this.trace = new CliLightClassGenerationSupport.NoScopeRecordCliBindingTrace();
        MutableModuleContext moduleContext = TopDownAnalyzerFacadeForJVM.createContextWithSealedModule(project, ModuleNameKt.getModuleName(environment2));
        this.module = moduleContext.getModule();
        this.scriptDeclarationFactory = new ScriptMutableDeclarationProviderFactory();
        ContainerForReplWithJava container = InjectionKt.createContainerForReplWithJava(moduleContext, this.trace, this.scriptDeclarationFactory, ProjectScope.getAllScope(project), new ReplLastLineScopeProvider(){

            @Override
            @Nullable
            public LexicalScope getLastLineScope() {
                return ReplInterpreter.this.lastLineScope;
            }
        }, new JvmPackagePartProvider(environment2));
        this.topDownAnalysisContext = new TopDownAnalysisContext(TopDownAnalysisMode.LocalDeclarations, DataFlowInfo.EMPTY, container.getResolveSession().getDeclarationScopeProvider());
        this.topDownAnalyzer = container.getLazyTopDownAnalyzerForTopLevel();
        this.resolveSession = container.getResolveSession();
        moduleContext.initializeModuleContents(new CompositePackageFragmentProvider(Arrays.asList(container.getResolveSession().getPackageFragmentProvider(), container.getJavaDescriptorResolver().getPackageFragmentProvider())));
        ArrayList<URL> classpath = Lists.newArrayList();
        for (File file : JvmContentRootsKt.getJvmClasspathRoots(configuration)) {
            try {
                classpath.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw ExceptionUtilsKt.rethrow(e);
            }
        }
        this.classLoader = new ReplClassLoader(new URLClassLoader(classpath.toArray(new URL[classpath.size()]), null));
        this.ideMode = ideMode;
        this.replReader = replReader;
    }

    private static void prepareForTheNextReplLine(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "prepareForTheNextReplLine"));
        }
        c.getScripts().clear();
    }

    @NotNull
    private DiagnosticMessageHolder createDiagnosticHolder() {
        DiagnosticMessageHolder diagnosticMessageHolder = this.ideMode ? new ReplIdeDiagnosticMessageHolder() : new ReplTerminalDiagnosticMessageHolder();
        if (diagnosticMessageHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "createDiagnosticHolder"));
        }
        return diagnosticMessageHolder;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public LineResult eval(@NotNull String line) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK], 5[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setReplScriptExecuting(boolean isExecuting) {
        if (this.replReader != null) {
            this.replReader.setReplScriptExecuting(isExecuting);
        }
    }

    @NotNull
    private static String renderStackTrace(@NotNull Throwable cause) {
        if (cause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cause", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "renderStackTrace"));
        }
        StackTraceElement[] oldTrace = cause.getStackTrace();
        ArrayList<StackTraceElement> newTrace = new ArrayList<StackTraceElement>();
        boolean skip2 = true;
        for (int i = oldTrace.length - 1; i >= 0; --i) {
            StackTraceElement element = oldTrace[i];
            if (element.getMethodName().equals("<init>")) {
                skip2 = false;
            }
            if (skip2) continue;
            newTrace.add(element);
        }
        Collections.reverse(newTrace);
        List resultingTrace = newTrace.subList(0, newTrace.size() - 1);
        cause.setStackTrace(resultingTrace.toArray(new StackTraceElement[resultingTrace.size()]));
        String string = Throwables.getStackTraceAsString(cause);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "renderStackTrace"));
        }
        return string;
    }

    @Nullable
    private ScriptDescriptor doAnalyze(@NotNull KtFile psiFile, @NotNull DiagnosticMessageReporter errorReporter) {
        boolean hasErrors;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "doAnalyze"));
        }
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorReporter", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "doAnalyze"));
        }
        this.scriptDeclarationFactory.setDelegateFactory(new FileBasedDeclarationProviderFactory(this.resolveSession.getStorageManager(), Collections.singletonList(psiFile)));
        TopDownAnalysisContext context = this.topDownAnalyzer.analyzeDeclarations(this.topDownAnalysisContext.getTopDownAnalysisMode(), Collections.singletonList(psiFile));
        if (this.trace.get(BindingContext.FILE_TO_PACKAGE_FRAGMENT, psiFile) == null) {
            this.trace.record(BindingContext.FILE_TO_PACKAGE_FRAGMENT, psiFile, this.resolveSession.getPackageFragment(FqName.ROOT));
        }
        if (hasErrors = AnalyzerWithCompilerReport.reportDiagnostics(this.trace.getBindingContext().getDiagnostics(), errorReporter, false)) {
            return null;
        }
        ScriptDescriptor scriptDescriptor = context.getScripts().get(psiFile.getScript());
        this.lastLineScope = this.trace.get(BindingContext.SCRIPT_SCOPE, scriptDescriptor);
        if (this.lastLineScope == null) {
            throw new IllegalStateException("last line scope is not initialized");
        }
        return scriptDescriptor;
    }

    public void dumpClasses(@NotNull PrintWriter out) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "dumpClasses"));
        }
        this.classLoader.dumpClasses(out);
    }

    private static void registerEarlierScripts(@NotNull GenerationState state, @NotNull List<Pair<ScriptDescriptor, Type>> earlierScripts) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "registerEarlierScripts"));
        }
        if (earlierScripts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "earlierScripts", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "registerEarlierScripts"));
        }
        ArrayList<ScriptDescriptor> earlierScriptDescriptors = new ArrayList<ScriptDescriptor>(earlierScripts.size());
        for (Pair<ScriptDescriptor, Type> pair : earlierScripts) {
            ScriptDescriptor earlierDescriptor = (ScriptDescriptor)pair.first;
            Type earlierClassType = (Type)pair.second;
            PsiElement jetScript = DescriptorToSourceUtils.descriptorToDeclaration(earlierDescriptor);
            if (jetScript == null) continue;
            CodegenBinding.registerClassNameForScript(state.getBindingTrace(), (KtScript)jetScript, earlierClassType, state.getFileClassesProvider());
            earlierScriptDescriptors.add(earlierDescriptor);
        }
        state.setEarlierScriptsForReplInterpreter(earlierScriptDescriptors);
    }

    public static void compileScript(@NotNull KtScript script, @NotNull Type classType, @NotNull List<Pair<ScriptDescriptor, Type>> earlierScripts, @NotNull GenerationState state, @NotNull CompilationErrorHandler errorHandler) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "compileScript"));
        }
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "compileScript"));
        }
        if (earlierScripts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "earlierScripts", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "compileScript"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "compileScript"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "compileScript"));
        }
        ReplInterpreter.registerEarlierScripts(state, earlierScripts);
        CodegenBinding.registerClassNameForScript(state.getBindingTrace(), script, classType, state.getFileClassesProvider());
        state.beforeCompile();
        KotlinCodegenFacade.generatePackage(state, script.getContainingKtFile().getPackageFqName(), Collections.singleton(script.getContainingKtFile()), errorHandler);
    }

    private static class ScriptMutableDeclarationProviderFactory
    implements DeclarationProviderFactory {
        private DeclarationProviderFactory delegateFactory;
        private AdaptablePackageMemberDeclarationProvider rootPackageProvider;

        private ScriptMutableDeclarationProviderFactory() {
        }

        public void setDelegateFactory(DeclarationProviderFactory delegateFactory) {
            this.delegateFactory = delegateFactory;
            PackageMemberDeclarationProvider provider = delegateFactory.getPackageMemberDeclarationProvider(FqName.ROOT);
            if (this.rootPackageProvider == null) {
                assert (provider != null);
                this.rootPackageProvider = new AdaptablePackageMemberDeclarationProvider(provider);
            } else {
                this.rootPackageProvider.addDelegateProvider(provider);
            }
        }

        @Override
        @NotNull
        public ClassMemberDeclarationProvider getClassMemberDeclarationProvider(@NotNull JetClassLikeInfo classLikeInfo) {
            if (classLikeInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classLikeInfo", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$ScriptMutableDeclarationProviderFactory", "getClassMemberDeclarationProvider"));
            }
            ClassMemberDeclarationProvider classMemberDeclarationProvider = this.delegateFactory.getClassMemberDeclarationProvider(classLikeInfo);
            if (classMemberDeclarationProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$ScriptMutableDeclarationProviderFactory", "getClassMemberDeclarationProvider"));
            }
            return classMemberDeclarationProvider;
        }

        @Override
        @Nullable
        public PackageMemberDeclarationProvider getPackageMemberDeclarationProvider(@NotNull FqName packageFqName) {
            if (packageFqName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$ScriptMutableDeclarationProviderFactory", "getPackageMemberDeclarationProvider"));
            }
            if (packageFqName.isRoot()) {
                return this.rootPackageProvider;
            }
            return this.delegateFactory.getPackageMemberDeclarationProvider(packageFqName);
        }

        public static class AdaptablePackageMemberDeclarationProvider
        extends DelegatePackageMemberDeclarationProvider {
            @NotNull
            private PackageMemberDeclarationProvider delegateProvider;

            public AdaptablePackageMemberDeclarationProvider(@NotNull PackageMemberDeclarationProvider delegateProvider) {
                if (delegateProvider == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateProvider", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$ScriptMutableDeclarationProviderFactory$AdaptablePackageMemberDeclarationProvider", "<init>"));
                }
                super(delegateProvider);
                this.delegateProvider = delegateProvider;
            }

            public void addDelegateProvider(PackageMemberDeclarationProvider provider) {
                this.delegateProvider = new CombinedPackageMemberDeclarationProvider(Lists.newArrayList(provider, this.delegateProvider));
                this.setDelegate(this.delegateProvider);
            }
        }
    }

    public static class LineResult {
        private final Object value;
        private final boolean unit;
        private final String errorText;
        private final LineResultType type;

        private LineResult(Object value2, boolean unit, String errorText, @NotNull LineResultType type2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResult", "<init>"));
            }
            this.value = value2;
            this.unit = unit;
            this.errorText = errorText;
            this.type = type2;
        }

        @NotNull
        public LineResultType getType() {
            LineResultType lineResultType = this.type;
            if (lineResultType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResult", "getType"));
            }
            return lineResultType;
        }

        private void checkSuccessful() {
            if (this.getType() != LineResultType.SUCCESS) {
                throw new IllegalStateException("it is error");
            }
        }

        public Object getValue() {
            this.checkSuccessful();
            return this.value;
        }

        public boolean isUnit() {
            this.checkSuccessful();
            return this.unit;
        }

        @NotNull
        public String getErrorText() {
            String string = this.errorText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResult", "getErrorText"));
            }
            return string;
        }

        @NotNull
        private static LineResult error(@NotNull String errorText, @NotNull LineResultType errorType) {
            if (errorText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorText", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResult", "error"));
            }
            if (errorType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorType", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResult", "error"));
            }
            if (errorText.isEmpty()) {
                errorText = "<unknown error>";
            } else if (!errorText.endsWith("\n")) {
                errorText = errorText + "\n";
            }
            LineResult lineResult = new LineResult(null, false, errorText, errorType);
            if (lineResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResult", "error"));
            }
            return lineResult;
        }

        @NotNull
        public static LineResult successful(Object value2, boolean unit) {
            LineResult lineResult = new LineResult(value2, unit, null, LineResultType.SUCCESS);
            if (lineResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResult", "successful"));
            }
            return lineResult;
        }

        @NotNull
        public static LineResult compileError(@NotNull String errorText) {
            if (errorText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorText", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResult", "compileError"));
            }
            LineResult lineResult = LineResult.error(errorText, LineResultType.COMPILE_ERROR);
            if (lineResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResult", "compileError"));
            }
            return lineResult;
        }

        @NotNull
        public static LineResult runtimeError(@NotNull String errorText) {
            if (errorText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorText", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResult", "runtimeError"));
            }
            LineResult lineResult = LineResult.error(errorText, LineResultType.RUNTIME_ERROR);
            if (lineResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResult", "runtimeError"));
            }
            return lineResult;
        }

        public static LineResult incomplete() {
            return new LineResult(null, false, null, LineResultType.INCOMPLETE);
        }
    }

    public static enum LineResultType {
        SUCCESS,
        COMPILE_ERROR,
        RUNTIME_ERROR,
        INCOMPLETE;

    }
}

