/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.org.apache.log4j.helpers;

import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Properties;
import org.jetbrains.kotlin.relocated.org.apache.log4j.Level;
import org.jetbrains.kotlin.relocated.org.apache.log4j.PropertyConfigurator;
import org.jetbrains.kotlin.relocated.org.apache.log4j.helpers.Loader;
import org.jetbrains.kotlin.relocated.org.apache.log4j.helpers.LogLog;
import org.jetbrains.kotlin.relocated.org.apache.log4j.spi.Configurator;
import org.jetbrains.kotlin.relocated.org.apache.log4j.spi.LoggerRepository;

public class OptionConverter {
    static String DELIM_START = "${";
    static char DELIM_STOP = (char)125;
    static int DELIM_START_LEN = 2;
    static int DELIM_STOP_LEN = 1;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$log4j$Level;
    static /* synthetic */ Class class$org$apache$log4j$spi$Configurator;

    public static String getSystemProperty(String key, String def) {
        try {
            return System.getProperty(key, def);
        }
        catch (Throwable e) {
            LogLog.debug(new StringBuffer().append("Was not allowed to read system property \"").append(key).append("\".").toString());
            return def;
        }
    }

    public static Object instantiateByKey(Properties props, String key, Class superClass, Object defaultValue) {
        String className = OptionConverter.findAndSubst(key, props);
        if (className == null) {
            LogLog.error(new StringBuffer().append("Could not find value for key ").append(key).toString());
            return defaultValue;
        }
        return OptionConverter.instantiateByClassName(className.trim(), superClass, defaultValue);
    }

    public static boolean toBoolean(String value2, boolean dEfault) {
        if (value2 == null) {
            return dEfault;
        }
        String trimmedVal = value2.trim();
        if ("true".equalsIgnoreCase(trimmedVal)) {
            return true;
        }
        if ("false".equalsIgnoreCase(trimmedVal)) {
            return false;
        }
        return dEfault;
    }

    public static Level toLevel(String value2, Level defaultValue) {
        if (value2 == null) {
            return defaultValue;
        }
        int hashIndex = (value2 = value2.trim()).indexOf(35);
        if (hashIndex == -1) {
            if ("NULL".equalsIgnoreCase(value2)) {
                return null;
            }
            return Level.toLevel(value2, defaultValue);
        }
        Level result2 = defaultValue;
        String clazz = value2.substring(hashIndex + 1);
        String levelName = value2.substring(0, hashIndex);
        if ("NULL".equalsIgnoreCase(levelName)) {
            return null;
        }
        LogLog.debug(new StringBuffer().append("toLevel:class=[").append(clazz).append("]").append(":pri=[").append(levelName).append("]").toString());
        try {
            Class customLevel = Loader.loadClass(clazz);
            Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = OptionConverter.class$("java.lang.String")) : class$java$lang$String, class$org$apache$log4j$Level == null ? (class$org$apache$log4j$Level = OptionConverter.class$("org.jetbrains.kotlin.relocated.org.apache.log4j.Level")) : class$org$apache$log4j$Level};
            Method toLevelMethod = customLevel.getMethod("toLevel", paramTypes);
            Object[] params = new Object[]{levelName, defaultValue};
            Object o = toLevelMethod.invoke(null, params);
            result2 = (Level)o;
        }
        catch (ClassNotFoundException e) {
            LogLog.warn(new StringBuffer().append("custom level class [").append(clazz).append("] not found.").toString());
        }
        catch (NoSuchMethodException e) {
            LogLog.warn(new StringBuffer().append("custom level class [").append(clazz).append("]").append(" does not have a class function toLevel(String, Level)").toString(), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof InterruptedException || e.getTargetException() instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            LogLog.warn(new StringBuffer().append("custom level class [").append(clazz).append("]").append(" could not be instantiated").toString(), e);
        }
        catch (ClassCastException e) {
            LogLog.warn(new StringBuffer().append("class [").append(clazz).append("] is not a subclass of org.apache.log4j.Level").toString(), e);
        }
        catch (IllegalAccessException e) {
            LogLog.warn(new StringBuffer().append("class [").append(clazz).append("] cannot be instantiated due to access restrictions").toString(), e);
        }
        catch (RuntimeException e) {
            LogLog.warn(new StringBuffer().append("class [").append(clazz).append("], level [").append(levelName).append("] conversion failed.").toString(), e);
        }
        return result2;
    }

    public static String findAndSubst(String key, Properties props) {
        String value2 = props.getProperty(key);
        if (value2 == null) {
            return null;
        }
        try {
            return OptionConverter.substVars(value2, props);
        }
        catch (IllegalArgumentException e) {
            LogLog.error(new StringBuffer().append("Bad option value [").append(value2).append("].").toString(), e);
            return value2;
        }
    }

    public static Object instantiateByClassName(String className, Class superClass, Object defaultValue) {
        if (className != null) {
            try {
                Class classObj = Loader.loadClass(className);
                if (!superClass.isAssignableFrom(classObj)) {
                    LogLog.error(new StringBuffer().append("A \"").append(className).append("\" object is not assignable to a \"").append(superClass.getName()).append("\" variable.").toString());
                    LogLog.error(new StringBuffer().append("The class \"").append(superClass.getName()).append("\" was loaded by ").toString());
                    LogLog.error(new StringBuffer().append("[").append(superClass.getClassLoader()).append("] whereas object of type ").toString());
                    LogLog.error(new StringBuffer().append("\"").append(classObj.getName()).append("\" was loaded by [").append(classObj.getClassLoader()).append("].").toString());
                    return defaultValue;
                }
                return classObj.newInstance();
            }
            catch (ClassNotFoundException e) {
                LogLog.error(new StringBuffer().append("Could not instantiate class [").append(className).append("].").toString(), e);
            }
            catch (IllegalAccessException e) {
                LogLog.error(new StringBuffer().append("Could not instantiate class [").append(className).append("].").toString(), e);
            }
            catch (InstantiationException e) {
                LogLog.error(new StringBuffer().append("Could not instantiate class [").append(className).append("].").toString(), e);
            }
            catch (RuntimeException e) {
                LogLog.error(new StringBuffer().append("Could not instantiate class [").append(className).append("].").toString(), e);
            }
        }
        return defaultValue;
    }

    public static String substVars(String val, Properties props) throws IllegalArgumentException {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (true) {
            int j;
            if ((j = val.indexOf(DELIM_START, i)) == -1) {
                if (i == 0) {
                    return val;
                }
                sbuf.append(val.substring(i, val.length()));
                return sbuf.toString();
            }
            sbuf.append(val.substring(i, j));
            int k = val.indexOf(DELIM_STOP, j);
            if (k == -1) {
                throw new IllegalArgumentException(new StringBuffer().append('\"').append(val).append("\" has no closing brace. Opening brace at position ").append(j).append('.').toString());
            }
            String key = val.substring(j += DELIM_START_LEN, k);
            String replacement = OptionConverter.getSystemProperty(key, null);
            if (replacement == null && props != null) {
                replacement = props.getProperty(key);
            }
            if (replacement != null) {
                String recursiveReplacement = OptionConverter.substVars(replacement, props);
                sbuf.append(recursiveReplacement);
            }
            i = k + DELIM_STOP_LEN;
        }
    }

    public static void selectAndConfigure(URL url, String clazz, LoggerRepository hierarchy) {
        Configurator configurator = null;
        String filename = url.getFile();
        if (clazz == null && filename != null && filename.endsWith(".xml")) {
            clazz = "org.jetbrains.kotlin.relocated.org.apache.log4j.xml.DOMConfigurator";
        }
        if (clazz != null) {
            LogLog.debug(new StringBuffer().append("Preferred configurator class: ").append(clazz).toString());
            configurator = (Configurator)OptionConverter.instantiateByClassName(clazz, class$org$apache$log4j$spi$Configurator == null ? (class$org$apache$log4j$spi$Configurator = OptionConverter.class$("org.jetbrains.kotlin.relocated.org.apache.log4j.spi.Configurator")) : class$org$apache$log4j$spi$Configurator, null);
            if (configurator == null) {
                LogLog.error(new StringBuffer().append("Could not instantiate configurator [").append(clazz).append("].").toString());
                return;
            }
        } else {
            configurator = new PropertyConfigurator();
        }
        configurator.doConfigure(url, hierarchy);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

