/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.relocated.gnu.trove.TObjectHashingStrategy;

public class FilePathHashingStrategy {
    @NotNull
    public static TObjectHashingStrategy<String> create() {
        TObjectHashingStrategy<String> tObjectHashingStrategy = FilePathHashingStrategy.create(SystemInfo.isFileSystemCaseSensitive);
        if (tObjectHashingStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/FilePathHashingStrategy", "create"));
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    public static TObjectHashingStrategy<String> create(boolean caseSensitive) {
        CaseInsensitiveStringHashingStrategy caseInsensitiveStringHashingStrategy = caseSensitive ? ContainerUtil.canonicalStrategy() : CaseInsensitiveStringHashingStrategy.INSTANCE;
        if (caseInsensitiveStringHashingStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/FilePathHashingStrategy", "create"));
        }
        return caseInsensitiveStringHashingStrategy;
    }
}

