/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.serialization;

import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import org.jetbrains.kotlin.codegen.serialization.JvmStringTable;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.load.java.lazy.types.RawTypeCapabilities;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.relocated.com.google.protobuf.MessageLite;
import org.jetbrains.kotlin.serialization.AnnotationSerializer;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializerExtension;
import org.jetbrains.kotlin.serialization.StringTable;
import org.jetbrains.kotlin.serialization.jvm.ClassMapperLite;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class JvmSerializerExtension
extends SerializerExtension {
    private final JvmSerializationBindings bindings;
    private final StringTable stringTable;
    private final AnnotationSerializer annotationSerializer;
    private final boolean useTypeTable;

    public JvmSerializerExtension(@NotNull JvmSerializationBindings bindings, @NotNull JetTypeMapper typeMapper, boolean useTypeTable) {
        if (bindings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindings", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "<init>"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "<init>"));
        }
        this.bindings = bindings;
        this.stringTable = new JvmStringTable(typeMapper);
        this.annotationSerializer = new AnnotationSerializer(this.stringTable);
        this.useTypeTable = useTypeTable;
    }

    @Override
    @NotNull
    public StringTable getStringTable() {
        StringTable stringTable = this.stringTable;
        if (stringTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "getStringTable"));
        }
        return stringTable;
    }

    @Override
    public boolean shouldUseTypeTable() {
        return this.useTypeTable;
    }

    @Override
    public void serializeValueParameter(@NotNull ValueParameterDescriptor descriptor2, @NotNull ProtoBuf.ValueParameter.Builder proto) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeValueParameter"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeValueParameter"));
        }
        Integer index2 = this.bindings.get(JvmSerializationBindings.INDEX_FOR_VALUE_PARAMETER, descriptor2);
        if (index2 != null) {
            proto.setExtension(JvmProtoBuf.index, index2);
        }
    }

    @Override
    public void serializeType(@NotNull KotlinType type2, @NotNull ProtoBuf.Type.Builder proto) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeType"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeType"));
        }
        for (AnnotationDescriptor annotation2 : type2.getAnnotations()) {
            proto.addExtension(JvmProtoBuf.typeAnnotation, this.annotationSerializer.serializeAnnotation(annotation2));
        }
        if (type2.getCapabilities() instanceof RawTypeCapabilities) {
            proto.setExtension(JvmProtoBuf.isRaw, true);
        }
    }

    @Override
    public void serializeTypeParameter(@NotNull TypeParameterDescriptor typeParameter, @NotNull ProtoBuf.TypeParameter.Builder proto) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeTypeParameter"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeTypeParameter"));
        }
        for (AnnotationDescriptor annotation2 : typeParameter.getAnnotations()) {
            proto.addExtension(JvmProtoBuf.typeParameterAnnotation, this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeConstructor(@NotNull ConstructorDescriptor descriptor2, @NotNull ProtoBuf.Constructor.Builder proto) {
        JvmProtoBuf.JvmMethodSignature signature;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeConstructor"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeConstructor"));
        }
        Method method = this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, descriptor2);
        if (method != null && (signature = new SignatureSerializer().methodSignature(descriptor2, method)) != null) {
            proto.setExtension(JvmProtoBuf.constructorSignature, signature);
        }
        this.saveImplClassName(descriptor2, proto);
    }

    @Override
    public void serializeFunction(@NotNull FunctionDescriptor descriptor2, @NotNull ProtoBuf.Function.Builder proto) {
        JvmProtoBuf.JvmMethodSignature signature;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeFunction"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeFunction"));
        }
        Method method = this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, descriptor2);
        if (method != null && (signature = new SignatureSerializer().methodSignature(descriptor2, method)) != null) {
            proto.setExtension(JvmProtoBuf.methodSignature, signature);
        }
        this.saveImplClassName(descriptor2, proto);
    }

    @Override
    public void serializeProperty(@NotNull PropertyDescriptor descriptor2, @NotNull ProtoBuf.Property.Builder proto) {
        boolean isStaticInOuter;
        String fieldDesc;
        String fieldName;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeProperty"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeProperty"));
        }
        SignatureSerializer signatureSerializer = new SignatureSerializer();
        PropertyGetterDescriptor getter2 = descriptor2.getGetter();
        PropertySetterDescriptor setter2 = descriptor2.getSetter();
        Method getterMethod = getter2 == null ? null : this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, getter2);
        Method setterMethod = setter2 == null ? null : this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, setter2);
        Pair<Type, String> field = this.bindings.get(JvmSerializationBindings.FIELD_FOR_PROPERTY, descriptor2);
        if (field != null) {
            fieldName = (String)field.second;
            fieldDesc = ((Type)field.first).getDescriptor();
            isStaticInOuter = this.bindings.get(JvmSerializationBindings.STATIC_FIELD_IN_OUTER_CLASS, descriptor2);
        } else {
            fieldName = null;
            fieldDesc = null;
            isStaticInOuter = false;
        }
        Method syntheticMethod = this.bindings.get(JvmSerializationBindings.SYNTHETIC_METHOD_FOR_PROPERTY, descriptor2);
        JvmProtoBuf.JvmPropertySignature signature = signatureSerializer.propertySignature(descriptor2, fieldName, fieldDesc, isStaticInOuter, syntheticMethod != null ? signatureSerializer.methodSignature(null, syntheticMethod) : null, getterMethod != null ? signatureSerializer.methodSignature(null, getterMethod) : null, setterMethod != null ? signatureSerializer.methodSignature(null, setterMethod) : null);
        proto.setExtension(JvmProtoBuf.propertySignature, signature);
        this.saveImplClassName(descriptor2, proto);
    }

    private void saveImplClassName(@NotNull CallableMemberDescriptor callable, @NotNull MessageLite.Builder proto) {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "saveImplClassName"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "saveImplClassName"));
        }
        String name = this.bindings.get(JvmSerializationBindings.IMPL_CLASS_NAME_FOR_CALLABLE, callable);
        if (name == null) {
            return;
        }
        int index2 = this.stringTable.getStringIndex(name);
        if (proto instanceof ProtoBuf.Function.Builder) {
            ((ProtoBuf.Function.Builder)proto).setExtension(JvmProtoBuf.methodImplClassName, index2);
        } else if (proto instanceof ProtoBuf.Property.Builder) {
            ((ProtoBuf.Property.Builder)proto).setExtension(JvmProtoBuf.propertyImplClassName, index2);
        }
    }

    private class SignatureSerializer {
        private SignatureSerializer() {
        }

        @Nullable
        public JvmProtoBuf.JvmMethodSignature methodSignature(@Nullable FunctionDescriptor descriptor2, @NotNull Method method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "methodSignature"));
            }
            JvmProtoBuf.JvmMethodSignature.Builder builder = JvmProtoBuf.JvmMethodSignature.newBuilder();
            if (descriptor2 == null || !descriptor2.getName().asString().equals(method.getName())) {
                builder.setName(JvmSerializerExtension.this.stringTable.getStringIndex(method.getName()));
            }
            if (descriptor2 == null || this.requiresSignature(descriptor2, method.getDescriptor())) {
                builder.setDesc(JvmSerializerExtension.this.stringTable.getStringIndex(method.getDescriptor()));
            }
            return builder.hasName() || builder.hasDesc() ? builder.build() : null;
        }

        private boolean requiresSignature(@NotNull FunctionDescriptor descriptor2, @NotNull String desc) {
            String returnTypeDesc;
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "requiresSignature"));
            }
            if (desc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "requiresSignature"));
            }
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
            if (receiverParameter != null) {
                String receiverDesc = this.mapTypeDefault(receiverParameter.getValue().getType());
                if (receiverDesc == null) {
                    return true;
                }
                sb.append(receiverDesc);
            }
            for (ValueParameterDescriptor valueParameter : descriptor2.getValueParameters()) {
                String paramDesc = this.mapTypeDefault(valueParameter.getType());
                if (paramDesc == null) {
                    return true;
                }
                sb.append(paramDesc);
            }
            sb.append(")");
            KotlinType returnType2 = descriptor2.getReturnType();
            String string = returnTypeDesc = returnType2 == null ? "V" : this.mapTypeDefault(returnType2);
            if (returnTypeDesc == null) {
                return true;
            }
            sb.append(returnTypeDesc);
            return !sb.toString().equals(desc);
        }

        private boolean requiresSignature(@NotNull PropertyDescriptor descriptor2, @NotNull String desc) {
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "requiresSignature"));
            }
            if (desc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "requiresSignature"));
            }
            return !desc.equals(this.mapTypeDefault(descriptor2.getType()));
        }

        @Nullable
        private String mapTypeDefault(@NotNull KotlinType type2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "mapTypeDefault"));
            }
            ClassifierDescriptor classifier2 = type2.getConstructor().getDeclarationDescriptor();
            if (!(classifier2 instanceof ClassDescriptor)) {
                return null;
            }
            ClassId classId = this.classId((ClassDescriptor)classifier2);
            return classId == null ? null : ClassMapperLite.mapClass(classId);
        }

        @Nullable
        private ClassId classId(@NotNull ClassDescriptor descriptor2) {
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "classId"));
            }
            DeclarationDescriptor container = descriptor2.getContainingDeclaration();
            if (container instanceof PackageFragmentDescriptor) {
                return ClassId.topLevel(((PackageFragmentDescriptor)container).getFqName().child(descriptor2.getName()));
            }
            if (container instanceof ClassDescriptor) {
                ClassId outerClassId = this.classId((ClassDescriptor)container);
                return outerClassId == null ? null : outerClassId.createNestedClassId(descriptor2.getName());
            }
            return null;
        }

        @NotNull
        public JvmProtoBuf.JvmPropertySignature propertySignature(@NotNull PropertyDescriptor descriptor2, @Nullable String fieldName, @Nullable String fieldDesc, boolean isStaticInOuter, @Nullable JvmProtoBuf.JvmMethodSignature syntheticMethod, @Nullable JvmProtoBuf.JvmMethodSignature getter2, @Nullable JvmProtoBuf.JvmMethodSignature setter2) {
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "propertySignature"));
            }
            JvmProtoBuf.JvmPropertySignature.Builder signature = JvmProtoBuf.JvmPropertySignature.newBuilder();
            if (fieldDesc != null) {
                assert (fieldName != null) : "Field name shouldn't be null when there's a field type: " + fieldDesc;
                signature.setField(this.fieldSignature(descriptor2, fieldName, fieldDesc, isStaticInOuter));
            }
            if (syntheticMethod != null) {
                signature.setSyntheticMethod(syntheticMethod);
            }
            if (getter2 != null) {
                signature.setGetter(getter2);
            }
            if (setter2 != null) {
                signature.setSetter(setter2);
            }
            JvmProtoBuf.JvmPropertySignature jvmPropertySignature = signature.build();
            if (jvmPropertySignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "propertySignature"));
            }
            return jvmPropertySignature;
        }

        @NotNull
        public JvmProtoBuf.JvmFieldSignature fieldSignature(@NotNull PropertyDescriptor descriptor2, @NotNull String name, @NotNull String desc, boolean isStaticInOuter) {
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "fieldSignature"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "fieldSignature"));
            }
            if (desc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "fieldSignature"));
            }
            JvmProtoBuf.JvmFieldSignature.Builder builder = JvmProtoBuf.JvmFieldSignature.newBuilder();
            if (!descriptor2.getName().asString().equals(name)) {
                builder.setName(JvmSerializerExtension.this.stringTable.getStringIndex(name));
            }
            if (this.requiresSignature(descriptor2, desc)) {
                builder.setDesc(JvmSerializerExtension.this.stringTable.getStringIndex(desc));
            }
            if (isStaticInOuter) {
                builder.setIsStaticInOuter(true);
            }
            JvmProtoBuf.JvmFieldSignature jvmFieldSignature = builder.build();
            if (jvmFieldSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "fieldSignature"));
            }
            return jvmFieldSignature;
        }
    }
}

