/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.CollectionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierKt;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtPlaceHolderStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"C\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0002\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001\u0001\u0004\u0001\u001a\t%\u0011\u0011\"\u0001\r\u00011\u0003\t{\u0001B\u0006\n\u0007!\tQ\"\u0001M\u0002#\u000e\t\u0001BAQ\u000b\t-Ia\u0001#\u0002\u000e\t%\u0011\u0011\"\u0001\r\u00011\r\t6!\u0001E\u0004K{!1\u0002\u0003\u0003\u000e\u000bA)QC\u0001G\u0001I\u0013!K!\u0005\u0002\u0005\u0001!%\u0011C\u0001C\u0001\u0011\u0017I\u0012\u0002\u0003\u0004\u000e\u000f%\u0011\u0011\"\u0001S\u0005\u0013\tI\u0011\u0001j\u0003\u0019\u000ee\u0019\u0001bB\u0007\u0002I\u0017\t6!\u0001E\bK!!1\u0002\u0003\u0005\u000e\u0003aE\u0011d\u0001\u0005\n\u001b\u0005A\n\"\n\u0005\u0005\u0017!MQ\"\u0001\r\u000b3\rA)\"D\u0001\u0019\u0017\u0015\"Aa\u0003E\f\u001b\u0005AB\"\n\u0003\u0005\u0003!eQ\"\u0001\r\u000eK!!1\u0002c\u0007\u000e\u0003aQ\u0011d\u0001E\u000b\u001b\u0005A2\u0002"}, strings={"Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "Lorg/jetbrains/kotlin/psi/KtConstructor;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinPlaceHolderStub;", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinPlaceHolderStub;)V", "accept", "R", "kotlin.jvm.PlatformType", "D", "visitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "addAnnotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "annotationEntry", "addModifier", "", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "getContainingClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getOrCreateConstructorKeyword", "Lcom/intellij/psi/PsiElement;", "removeModifier"}, moduleName="kotlin-compiler")
public final class KtPrimaryConstructor
extends KtConstructor<KtPrimaryConstructor> {
    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        return visitor2.visitPrimaryConstructor(this, data);
    }

    @Override
    @NotNull
    public KtClassOrObject getContainingClassOrObject() {
        PsiElement psiElement2 = this.getParent();
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
        }
        return (KtClassOrObject)psiElement2;
    }

    private final PsiElement getOrCreateConstructorKeyword() {
        PsiElement psiElement2 = this.getConstructorKeyword();
        if (psiElement2 == null) {
            PsiElement psiElement3 = KtPsiFactoryKt.KtPsiFactory(this).createConstructorKeyword();
            KtParameterList ktParameterList = this.getValueParameterList();
            if (ktParameterList == null) {
                Intrinsics.throwNpe();
            }
            PsiElement psiElement4 = this.addBefore(psiElement3, ktParameterList);
            psiElement2 = psiElement4;
            Intrinsics.checkExpressionValueIsNotNull(psiElement4, "addBefore(KtPsiFactory(t\u2026(), valueParameterList!!)");
        }
        return psiElement2;
    }

    @Override
    public void addModifier(@NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkParameterIsNotNull(modifier, "modifier");
        KtModifierList modifierList = this.getModifierList();
        if (modifierList != null) {
            AddRemoveModifierKt.addModifier(modifierList, modifier);
            if (this.getModifierList() == null) {
                Unit unit;
                PsiElement psiElement2 = this.getConstructorKeyword();
                if (psiElement2 != null) {
                    psiElement2.delete();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
        } else {
            if (Intrinsics.areEqual(modifier, KtTokens.PUBLIC_KEYWORD)) {
                return;
            }
            KtModifierList newModifierList = KtPsiFactoryKt.KtPsiFactory(this).createModifierList(modifier);
            this.addBefore(newModifierList, this.getOrCreateConstructorKeyword());
        }
    }

    @Override
    public void removeModifier(@NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkParameterIsNotNull(modifier, "modifier");
        super.removeModifier(modifier);
        if (this.getModifierList() == null) {
            Unit unit;
            PsiElement psiElement2 = this.getConstructorKeyword();
            if (psiElement2 != null) {
                psiElement2.delete();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
    }

    @Override
    @NotNull
    public KtAnnotationEntry addAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry) {
        KtAnnotationEntry ktAnnotationEntry;
        Intrinsics.checkParameterIsNotNull(annotationEntry, "annotationEntry");
        KtModifierList modifierList = this.getModifierList();
        if (modifierList != null) {
            PsiElement psiElement2 = modifierList.addBefore(annotationEntry, modifierList.getFirstChild());
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotationEntry");
            }
            ktAnnotationEntry = (KtAnnotationEntry)psiElement2;
        } else {
            KtParameterList ktParameterList = this.getValueParameterList();
            if (ktParameterList == null) {
                Intrinsics.throwNpe();
            }
            KtParameterList parameterList = ktParameterList;
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull(project, "getProject()");
            KtPsiFactory ktPsiFactory = new KtPsiFactory(project);
            String string = annotationEntry.getText();
            Intrinsics.checkExpressionValueIsNotNull(string, "annotationEntry.text");
            KtModifierList newModifierList = ktPsiFactory.createModifierList(string);
            PsiElement psiElement3 = this.addBefore(newModifierList, parameterList);
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtModifierList");
            }
            ktAnnotationEntry = CollectionsKt.first(((KtModifierList)psiElement3).getAnnotationEntries());
        }
        return ktAnnotationEntry;
    }

    public KtPrimaryConstructor(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        super(node);
    }

    public KtPrimaryConstructor(@NotNull KotlinPlaceHolderStub<KtPrimaryConstructor> stub) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        KtPlaceHolderStubElementType<KtPrimaryConstructor> ktPlaceHolderStubElementType = KtStubElementTypes.PRIMARY_CONSTRUCTOR;
        Intrinsics.checkExpressionValueIsNotNull(ktPlaceHolderStubElementType, "KtStubElementTypes.PRIMARY_CONSTRUCTOR");
        super(stub, ktPlaceHolderStubElementType);
    }
}

