/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.org.jdom.input;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.kotlin.relocated.org.jdom.DefaultJDOMFactory;
import org.jetbrains.kotlin.relocated.org.jdom.Document;
import org.jetbrains.kotlin.relocated.org.jdom.JDOMException;
import org.jetbrains.kotlin.relocated.org.jdom.JDOMFactory;
import org.jetbrains.kotlin.relocated.org.jdom.input.BuilderErrorHandler;
import org.jetbrains.kotlin.relocated.org.jdom.input.JDOMParseException;
import org.jetbrains.kotlin.relocated.org.jdom.input.SAXHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXBuilder {
    private boolean validate;
    private boolean expand = true;
    private String saxDriverClass;
    private ErrorHandler saxErrorHandler = null;
    private EntityResolver saxEntityResolver = null;
    private DTDHandler saxDTDHandler = null;
    private XMLFilter saxXMLFilter = null;
    private JDOMFactory factory = new DefaultJDOMFactory();
    private boolean ignoringWhite = false;
    private boolean ignoringBoundaryWhite = false;
    private HashMap features = new HashMap(5);
    private HashMap properties = new HashMap(5);
    private boolean fastReconfigure = false;
    private boolean skipNextLexicalReportingConfig = false;
    private boolean skipNextEntityExpandConfig = false;
    private boolean reuseParser = true;
    private XMLReader saxParser = null;

    public SAXBuilder() {
        this(false);
    }

    public SAXBuilder(boolean validate) {
        this.validate = validate;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.saxEntityResolver = entityResolver;
    }

    public Document build(InputSource in) throws JDOMException, IOException {
        SAXHandler contentHandler = null;
        try {
            Object root;
            contentHandler = this.createContentHandler();
            this.configureContentHandler(contentHandler);
            XMLReader parser = this.saxParser;
            if (parser == null) {
                parser = this.createParser();
                if (this.saxXMLFilter != null) {
                    root = this.saxXMLFilter;
                    while (root.getParent() instanceof XMLFilter) {
                        root = (XMLFilter)root.getParent();
                    }
                    root.setParent(parser);
                    parser = this.saxXMLFilter;
                }
                this.configureParser(parser, contentHandler);
                if (this.reuseParser) {
                    this.saxParser = parser;
                }
            } else {
                this.configureParser(parser, contentHandler);
            }
            parser.parse(in);
            root = contentHandler.getDocument();
            return root;
        }
        catch (SAXParseException e) {
            String systemId;
            Document doc = contentHandler.getDocument();
            if (!doc.hasRootElement()) {
                doc = null;
            }
            if ((systemId = e.getSystemId()) != null) {
                throw new JDOMParseException("Error on line " + e.getLineNumber() + " of document " + systemId, e, doc);
            }
            throw new JDOMParseException("Error on line " + e.getLineNumber(), e, doc);
        }
        catch (SAXException e) {
            throw new JDOMParseException("Error in building: " + e.getMessage(), e, contentHandler.getDocument());
        }
        finally {
            contentHandler = null;
        }
    }

    protected SAXHandler createContentHandler() {
        SAXHandler contentHandler = new SAXHandler(this.factory);
        return contentHandler;
    }

    protected void configureContentHandler(SAXHandler contentHandler) {
        contentHandler.setExpandEntities(this.expand);
        contentHandler.setIgnoringElementContentWhitespace(this.ignoringWhite);
        contentHandler.setIgnoringBoundaryWhitespace(this.ignoringBoundaryWhite);
    }

    protected XMLReader createParser() throws JDOMException {
        XMLReader parser = null;
        if (this.saxDriverClass != null) {
            try {
                parser = XMLReaderFactory.createXMLReader(this.saxDriverClass);
                this.setFeaturesAndProperties(parser, true);
            }
            catch (SAXException e) {
                throw new JDOMException("Could not load " + this.saxDriverClass, e);
            }
        }
        try {
            Class<?> factoryClass = Class.forName("org.jetbrains.kotlin.relocated.org.jdom.input.JAXPParserFactory");
            Method createParser = factoryClass.getMethod("createParser", Boolean.TYPE, Map.class, Map.class);
            parser = (XMLReader)createParser.invoke(null, this.validate ? Boolean.TRUE : Boolean.FALSE, this.features, this.properties);
            this.setFeaturesAndProperties(parser, false);
        }
        catch (JDOMException e) {
            throw e;
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        if (parser == null) {
            try {
                parser = XMLReaderFactory.createXMLReader("org.jetbrains.kotlin.relocated.org.apache.xerces.parsers.SAXParser");
                this.saxDriverClass = parser.getClass().getName();
                this.setFeaturesAndProperties(parser, true);
            }
            catch (SAXException e) {
                throw new JDOMException("Could not load default SAX parser: org.apache.xerces.parsers.SAXParser", e);
            }
        }
        return parser;
    }

    protected void configureParser(XMLReader parser, SAXHandler contentHandler) throws JDOMException {
        boolean success;
        parser.setContentHandler(contentHandler);
        if (this.saxEntityResolver != null) {
            parser.setEntityResolver(this.saxEntityResolver);
        }
        if (this.saxDTDHandler != null) {
            parser.setDTDHandler(this.saxDTDHandler);
        } else {
            parser.setDTDHandler(contentHandler);
        }
        if (this.saxErrorHandler != null) {
            parser.setErrorHandler(this.saxErrorHandler);
        } else {
            parser.setErrorHandler(new BuilderErrorHandler());
        }
        if (!this.skipNextLexicalReportingConfig) {
            success = false;
            try {
                parser.setProperty("http://xml.org/sax/handlers/LexicalHandler", contentHandler);
                success = true;
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
            if (!success) {
                try {
                    parser.setProperty("http://xml.org/sax/properties/lexical-handler", contentHandler);
                    success = true;
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    // empty catch block
                }
            }
            if (!success && this.fastReconfigure) {
                this.skipNextLexicalReportingConfig = true;
            }
        }
        if (!this.skipNextEntityExpandConfig) {
            success = false;
            if (!this.expand) {
                try {
                    parser.setProperty("http://xml.org/sax/properties/declaration-handler", contentHandler);
                    success = true;
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    // empty catch block
                }
            }
            if (!success && this.fastReconfigure) {
                this.skipNextEntityExpandConfig = true;
            }
        }
    }

    private void setFeaturesAndProperties(XMLReader parser, boolean coreFeatures) throws JDOMException {
        for (String name : this.features.keySet()) {
            Boolean value2 = (Boolean)this.features.get(name);
            this.internalSetFeature(parser, name, value2, name);
        }
        for (String name : this.properties.keySet()) {
            this.internalSetProperty(parser, name, this.properties.get(name), name);
        }
        if (coreFeatures) {
            block9: {
                try {
                    this.internalSetFeature(parser, "http://xml.org/sax/features/validation", this.validate, "Validation");
                }
                catch (JDOMException e) {
                    if (!this.validate) break block9;
                    throw e;
                }
            }
            this.internalSetFeature(parser, "http://xml.org/sax/features/namespaces", true, "Namespaces");
            this.internalSetFeature(parser, "http://xml.org/sax/features/namespace-prefixes", true, "Namespace prefixes");
        }
        try {
            if (parser.getFeature("http://xml.org/sax/features/external-general-entities") != this.expand) {
                parser.setFeature("http://xml.org/sax/features/external-general-entities", this.expand);
            }
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
    }

    private void internalSetFeature(XMLReader parser, String feature, boolean value2, String displayName) throws JDOMException {
        try {
            parser.setFeature(feature, value2);
        }
        catch (SAXNotSupportedException e) {
            throw new JDOMException(displayName + " feature not supported for SAX driver " + parser.getClass().getName());
        }
        catch (SAXNotRecognizedException e) {
            throw new JDOMException(displayName + " feature not recognized for SAX driver " + parser.getClass().getName());
        }
    }

    private void internalSetProperty(XMLReader parser, String property, Object value2, String displayName) throws JDOMException {
        try {
            parser.setProperty(property, value2);
        }
        catch (SAXNotSupportedException e) {
            throw new JDOMException(displayName + " property not supported for SAX driver " + parser.getClass().getName());
        }
        catch (SAXNotRecognizedException e) {
            throw new JDOMException(displayName + " property not recognized for SAX driver " + parser.getClass().getName());
        }
    }

    public Document build(Reader characterStream) throws JDOMException, IOException {
        return this.build(new InputSource(characterStream));
    }
}

